/*
 * Decompiled with CFR 0.152.
 */
package groovy.grape;

import groovy.grape.GrapeEngine;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grape {
    private static boolean enableGrapes = Boolean.valueOf(System.getProperties().getProperty("groovy.grape.enable", "true"));
    private static boolean enableAutoDownload = Boolean.valueOf(System.getProperties().getProperty("groovy.grape.autoDownload", "true"));
    protected static GrapeEngine instance;

    public static boolean getEnableGrapes() {
        return enableGrapes;
    }

    public static void setEnableGrapes(boolean enableGrapes) {
        Grape.enableGrapes = enableGrapes;
    }

    public static boolean getEnableAutoDownload() {
        return enableAutoDownload;
    }

    public static void setEnableAutoDownload(boolean enableAutoDownload) {
        Grape.enableAutoDownload = enableAutoDownload;
    }

    public static synchronized GrapeEngine getInstance() {
        if (instance == null) {
            try {
                instance = (GrapeEngine)Class.forName("groovy.grape.GrapeIvy").newInstance();
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return instance;
    }

    public static void grab(String endorsed) {
        GrapeEngine instance;
        if (enableGrapes && (instance = Grape.getInstance()) != null) {
            instance.grab(endorsed);
        }
    }

    public static void grab(Map dependency) {
        GrapeEngine instance;
        if (enableGrapes && (instance = Grape.getInstance()) != null) {
            if (!dependency.containsKey("autoDownload")) {
                dependency.put("autoDownload", enableAutoDownload);
            }
            instance.grab(dependency);
        }
    }

    public static void grab(Map args, Map ... dependencies) {
        GrapeEngine instance;
        if (enableGrapes && (instance = Grape.getInstance()) != null) {
            if (!args.containsKey("autoDoanload")) {
                args.put("autoDownload", enableAutoDownload);
            }
            instance.grab(args, dependencies);
        }
    }

    public static Map<String, Map<String, List<String>>> enumerateGrapes() {
        GrapeEngine instance;
        Map<String, Map<String, List<String>>> grapes = null;
        if (enableGrapes && (instance = Grape.getInstance()) != null) {
            grapes = instance.enumerateGrapes();
        }
        if (grapes == null) {
            return Collections.emptyMap();
        }
        return grapes;
    }

    public static URI[] resolve(Map args, Map ... dependencies) {
        GrapeEngine instance;
        URI[] uris = null;
        if (enableGrapes && (instance = Grape.getInstance()) != null) {
            if (!args.containsKey("autoDownload")) {
                args.put("autoDownload", enableAutoDownload);
            }
            uris = instance.resolve(args, dependencies);
        }
        if (uris == null) {
            return new URI[0];
        }
        return uris;
    }

    public static Map[] listDependencies(ClassLoader cl) {
        GrapeEngine instance;
        Map[] maps = null;
        if (enableGrapes && (instance = Grape.getInstance()) != null) {
            maps = instance.listDependencies(cl);
        }
        if (maps == null) {
            return new Map[0];
        }
        return maps;
    }
}

