/*
 * Decompiled with CFR 0.152.
 */
package groovy.servlet;

import groovy.lang.Binding;
import groovy.xml.MarkupBuilder;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletBinding
extends Binding {
    private boolean initialized;

    public ServletBinding(HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        super.setVariable("request", request);
        super.setVariable("response", response);
        super.setVariable("context", context);
        super.setVariable("application", context);
        super.setVariable("session", request.getSession(false));
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (super.getVariables().containsKey(name)) continue;
            String[] values = request.getParameterValues(name);
            if (values.length == 1) {
                params.put(name, values[0]);
                continue;
            }
            params.put(name, values);
        }
        super.setVariable("params", params);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        Enumeration names2 = request.getHeaderNames();
        while (names2.hasMoreElements()) {
            String headerName = (String)names2.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        super.setVariable("headers", headers);
    }

    public void setVariable(String name, Object value) {
        this.lazyInit();
        this.validateArgs(name, "Can't bind variable to");
        this.excludeReservedName(name, "out");
        this.excludeReservedName(name, "sout");
        this.excludeReservedName(name, "html");
        super.setVariable(name, value);
    }

    public Map getVariables() {
        this.lazyInit();
        return super.getVariables();
    }

    public Object getVariable(String name) {
        this.lazyInit();
        this.validateArgs(name, "No variable with");
        return super.getVariable(name);
    }

    private void lazyInit() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        HttpServletResponse response = (HttpServletResponse)super.getVariable("response");
        ServletContext context = (ServletContext)super.getVariable("context");
        try {
            super.setVariable("out", response.getWriter());
            super.setVariable("sout", response.getOutputStream());
            super.setVariable("html", new MarkupBuilder(response.getWriter()));
        }
        catch (IOException e) {
            String message = "Failed to get writer or output stream from response.";
            context.log(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    private void validateArgs(String name, String message) {
        if (name == null) {
            throw new IllegalArgumentException(message + " null key.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException(message + " blank key name. [length=0]");
        }
    }

    private void excludeReservedName(String name, String reservedName) {
        if (reservedName.equals(name)) {
            throw new IllegalArgumentException("Can't bind variable to key named '" + name + "'.");
        }
    }
}

