/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import java.text.BreakIterator;
import java.util.Locale;
import org.codehaus.groovy.antlr.parser.GroovyTokenTypes;
import org.codehaus.groovy.groovydoc.GroovyDoc;

public class SimpleGroovyDoc
implements GroovyDoc,
GroovyTokenTypes {
    private String name;
    private String commentText = "";
    private String rawCommentText = "";
    private String firstSentenceCommentText = "";
    private int definitionType;

    public SimpleGroovyDoc(String name) {
        this.name = name;
        this.definitionType = 13;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return "" + this.getClass() + "(" + this.name + ")";
    }

    protected void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    protected void setFirstSentenceCommentText(String firstSentenceCommentText) {
        this.firstSentenceCommentText = firstSentenceCommentText;
    }

    public String commentText() {
        return this.commentText;
    }

    public String getRawCommentText() {
        return this.rawCommentText;
    }

    public String firstSentenceCommentText() {
        return this.firstSentenceCommentText;
    }

    public void setRawCommentText(String rawCommentText) {
        this.rawCommentText = rawCommentText;
        this.setFirstSentenceCommentText(SimpleGroovyDoc.calculateFirstSentence(rawCommentText));
    }

    public static String calculateFirstSentence(String raw) {
        String text = raw.replaceAll("(?m)^\\s*\\*", "");
        BreakIterator boundary = BreakIterator.getSentenceInstance(Locale.getDefault());
        boundary.setText(text);
        int start = boundary.first();
        int end = boundary.next();
        if (start > -1 && end > -1) {
            text = text.substring(start, end);
        }
        return SimpleGroovyDoc.stripTags(text);
    }

    private static String stripTags(String text) {
        return text.replaceAll("(?m)@([a-z]+\\s*.*)$", "");
    }

    public boolean isClass() {
        return this.definitionType == 13;
    }

    public boolean isInterface() {
        return this.definitionType == 14;
    }

    public boolean isAnnotationType() {
        return this.definitionType == 63;
    }

    public boolean isEnum() {
        return this.definitionType == 60;
    }

    public String getTypeDescription() {
        if (this.isInterface()) {
            return "Interface";
        }
        if (this.isAnnotationType()) {
            return "Annotation Type";
        }
        if (this.isEnum()) {
            return "Enum";
        }
        return "Class";
    }

    public String getTypeSourceDescription() {
        if (this.isInterface()) {
            return "interface";
        }
        if (this.isAnnotationType()) {
            return "@interface";
        }
        if (this.isEnum()) {
            return "enum";
        }
        return "class";
    }

    public void setTokenType(int t) {
        this.definitionType = t;
    }

    public int tokenType() {
        return this.definitionType;
    }

    public int compareTo(Object that) {
        if (that instanceof SimpleGroovyDoc) {
            return this.name.compareTo(((SimpleGroovyDoc)that).name);
        }
        throw new ClassCastException();
    }

    public boolean isAnnotationTypeElement() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isEnumConstant() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public boolean isException() {
        return false;
    }

    public boolean isField() {
        return false;
    }

    public boolean isIncluded() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isOrdinaryClass() {
        return false;
    }
}

