/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandoMetaClassCreationHandle
extends MetaClassRegistry.MetaClassCreationHandle {
    public static final ExpandoMetaClassCreationHandle instance = new ExpandoMetaClassCreationHandle();

    @Override
    protected MetaClass createNormalMetaClass(Class theClass, MetaClassRegistry registry) {
        if (theClass != ExpandoMetaClass.class) {
            ExpandoMetaClass emc = new ExpandoMetaClass(theClass, false, true);
            Set modifiedSuperExpandos = this.retrieveModifiedSuperExpandos(emc);
            emc.refreshInheritedMethods(modifiedSuperExpandos);
            return emc;
        }
        return super.create(theClass, registry);
    }

    private Set retrieveModifiedSuperExpandos(ExpandoMetaClass child) {
        HashSet<MetaClass> modifiedSupers = new HashSet<MetaClass>();
        for (CachedClass c : child.getSuperClasses()) {
            Set<CachedClass> interfaces = c.getInterfaces();
            this.populateSupersFromInterfaces(modifiedSupers, interfaces);
            ClassInfo info = c.classInfo;
            ExpandoMetaClass expando = info.getModifiedExpando();
            if (expando == null) continue;
            modifiedSupers.add(expando);
        }
        Set<CachedClass> interfaces = child.getTheCachedClass().getDeclaredInterfaces();
        this.populateSupersFromInterfaces(modifiedSupers, interfaces);
        return modifiedSupers;
    }

    private void populateSupersFromInterfaces(Set<MetaClass> modifiedSupers, Set<CachedClass> interfaces) {
        for (CachedClass anInterface : interfaces) {
            Set<CachedClass> superInterfaces;
            ClassInfo info = anInterface.classInfo;
            ExpandoMetaClass expando = info.getModifiedExpando();
            if (expando != null) {
                modifiedSupers.add(expando);
            }
            if ((superInterfaces = anInterface.getDeclaredInterfaces()).size() <= 0) continue;
            this.populateSupersFromInterfaces(modifiedSupers, superInterfaces);
        }
    }

    public void registerModifiedMetaClass(ExpandoMetaClass emc) {
        Class klazz = emc.getJavaClass();
        emc.getClassInfo().setModifiedExpando(emc);
        GroovySystem.getMetaClassRegistry().setMetaClass(klazz, emc);
    }

    public boolean hasModifiedMetaClass(ExpandoMetaClass emc) {
        return emc.getClassInfo().getModifiedExpando() != null;
    }

    public static void enable() {
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        if (metaClassRegistry.getMetaClassCreationHandler() != instance) {
            ClassInfo.clearModifiedExpandos();
            metaClassRegistry.setMetaClassCreationHandle(instance);
        }
    }

    public static void disable() {
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        if (metaClassRegistry.getMetaClassCreationHandler() == instance) {
            ClassInfo.clearModifiedExpandos();
            metaClassRegistry.setMetaClassCreationHandle(new MetaClassRegistry.MetaClassCreationHandle());
        }
    }
}

