/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.GroovyClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class CompileUnit {
    private final List modules = new ArrayList();
    private Map classes = new HashMap();
    private CompilerConfiguration config;
    private GroovyClassLoader classLoader;
    private CodeSource codeSource;
    private Map classesToCompile = new HashMap();
    private Map classNameToSource = new HashMap();

    public CompileUnit(GroovyClassLoader classLoader, CompilerConfiguration config) {
        this(classLoader, null, config);
    }

    public CompileUnit(GroovyClassLoader classLoader, CodeSource codeSource, CompilerConfiguration config) {
        this.classLoader = classLoader;
        this.config = config;
        this.codeSource = codeSource;
    }

    public List getModules() {
        return this.modules;
    }

    public void addModule(ModuleNode node) {
        if (node == null) {
            return;
        }
        this.modules.add(node);
        node.setUnit(this);
        this.addClasses(node.getClasses());
    }

    public ClassNode getClass(String name) {
        ClassNode cn = (ClassNode)this.classes.get(name);
        if (cn != null) {
            return cn;
        }
        return (ClassNode)this.classesToCompile.get(name);
    }

    public List getClasses() {
        ArrayList answer = new ArrayList();
        for (ModuleNode module : this.modules) {
            answer.addAll(module.getClasses());
        }
        return answer;
    }

    public CompilerConfiguration getConfig() {
        return this.config;
    }

    public GroovyClassLoader getClassLoader() {
        return this.classLoader;
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    void addClasses(List classList) {
        Iterator iter = classList.iterator();
        while (iter.hasNext()) {
            this.addClass((ClassNode)iter.next());
        }
    }

    public void addClass(ClassNode node) {
        String name = (node = node.redirect()).getName();
        ClassNode stored = (ClassNode)this.classes.get(name);
        if (stored != null && stored != node) {
            SourceUnit nodeSource = node.getModule().getContext();
            SourceUnit storedSource = stored.getModule().getContext();
            String txt = "Invalid duplicate class definition of class " + node.getName() + " : ";
            if (nodeSource == storedSource) {
                txt = txt + "The source " + nodeSource.getName() + " contains at last two defintions of the class " + node.getName() + ".\n";
                if (node.isScriptBody() || stored.isScriptBody()) {
                    txt = txt + "One of the classes is a explicit generated class using the class statement, the other is a class generated from the script body based on the file name. Solutions are to change the file name or to change the class name.\n";
                }
            } else {
                txt = txt + "The sources " + nodeSource.getName() + " and " + storedSource.getName() + " are containing both a class of the name " + node.getName() + ".\n";
            }
            nodeSource.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(txt, node.getLineNumber(), node.getColumnNumber()), nodeSource));
        }
        this.classes.put(name, node);
        if (this.classesToCompile.containsKey(name)) {
            ClassNode cn = (ClassNode)this.classesToCompile.get(name);
            cn.setRedirect(node);
            this.classesToCompile.remove(name);
        }
    }

    public void addClassNodeToCompile(ClassNode node, SourceUnit location) {
        this.classesToCompile.put(node.getName(), node);
        this.classNameToSource.put(node.getName(), location);
    }

    public SourceUnit getScriptSourceLocation(String className) {
        return (SourceUnit)this.classNameToSource.get(className);
    }

    public boolean hasClassNodeToCompile() {
        return !this.classesToCompile.isEmpty();
    }

    public Iterator iterateClassNodeToCompile() {
        return this.classesToCompile.keySet().iterator();
    }
}

