/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.vmplugin.VMPluginFactory;

public class AnnotationVisitor {
    private SourceUnit source;
    private ErrorCollector errorCollector;
    private AnnotationNode annotation;
    private ClassNode reportClass;

    public AnnotationVisitor(SourceUnit source, ErrorCollector errorCollector) {
        this.source = source;
        this.errorCollector = errorCollector;
    }

    public void setReportClass(ClassNode cn) {
        this.reportClass = cn;
    }

    public AnnotationNode visit(AnnotationNode node) {
        this.annotation = node;
        this.reportClass = node.getClassNode();
        if (!this.isValidAnnotationClass(node.getClassNode())) {
            this.addError("class " + node.getClassNode().getName() + " is not an annotation");
            return node;
        }
        Map attributes = node.getMembers();
        for (Map.Entry entry : attributes.entrySet()) {
            String attrName = (String)entry.getKey();
            Expression attrExpr = (Expression)entry.getValue();
            ClassNode attrType = this.getAttributeType(node, attrName);
            this.visitExpression(attrName, attrExpr, attrType);
        }
        VMPluginFactory.getPlugin().configureAnnotation(node);
        return this.annotation;
    }

    private ClassNode getAttributeType(AnnotationNode node, String attrName) {
        List methods = node.getClassNode().getMethods(attrName);
        if (methods.size() == 0) {
            this.addError("'" + attrName + "'is not part of the annotation " + node.getClassNode(), node);
            return ClassHelper.OBJECT_TYPE;
        }
        MethodNode method = (MethodNode)methods.get(0);
        return method.getReturnType();
    }

    private boolean isValidAnnotationClass(ClassNode node) {
        return node.implementsInterface("java.lang.annotation.Annotation");
    }

    protected void visitExpression(String attrName, Expression attrExp, ClassNode attrType) {
        if (attrType.isArray()) {
            if (attrExp instanceof ListExpression) {
                ListExpression le = (ListExpression)attrExp;
                this.visitListExpression(attrName, (ListExpression)attrExp, attrType.getComponentType());
            } else if (attrExp instanceof ClosureExpression) {
                this.addError("Annotation list attributes must use Groovy notation [el1, el2]", attrExp);
            } else {
                ListExpression listExp = new ListExpression();
                listExp.addExpression(attrExp);
                if (this.annotation != null) {
                    this.annotation.setMember(attrName, listExp);
                }
                this.visitExpression(attrName, listExp, attrType);
            }
        } else if (ClassHelper.isPrimitiveType(attrType)) {
            this.visitConstantExpression(attrName, this.getConstantExpression(attrExp), ClassHelper.getWrapper(attrType));
        } else if (ClassHelper.STRING_TYPE.equals(attrType)) {
            this.visitConstantExpression(attrName, this.getConstantExpression(attrExp), ClassHelper.STRING_TYPE);
        } else if (ClassHelper.CLASS_Type.equals(attrType)) {
            if (!(attrExp instanceof ClassExpression)) {
                this.addError("Only classes can be used for attribute '" + attrName + "'", attrExp);
            }
        } else if (attrType.isDerivedFrom(ClassHelper.Enum_Type)) {
            if (attrExp instanceof PropertyExpression) {
                this.visitEnumExpression(attrName, (PropertyExpression)attrExp, attrType);
            } else {
                this.addError("Expected enum value for attribute " + attrName, attrExp);
            }
        } else if (this.isValidAnnotationClass(attrType)) {
            if (attrExp instanceof AnnotationConstantExpression) {
                this.visitAnnotationExpression(attrName, (AnnotationConstantExpression)attrExp, attrType);
            } else {
                this.addError("Expected annotation of type '" + attrType.getName() + "' for attribute " + attrName, attrExp);
            }
        } else {
            this.addError("Unexpected type " + attrType.getName(), attrExp);
        }
    }

    public void checkReturnType(ClassNode attrType, ASTNode node) {
        if (attrType.isArray()) {
            this.checkReturnType(attrType.getComponentType(), node);
        } else {
            if (ClassHelper.isPrimitiveType(attrType)) {
                return;
            }
            if (ClassHelper.STRING_TYPE.equals(attrType)) {
                return;
            }
            if (ClassHelper.CLASS_Type.equals(attrType)) {
                return;
            }
            if (attrType.isDerivedFrom(ClassHelper.Enum_Type)) {
                return;
            }
            if (this.isValidAnnotationClass(attrType)) {
                return;
            }
            this.addError("Unexpected return type " + attrType.getName(), node);
        }
    }

    private ConstantExpression getConstantExpression(Expression exp) {
        if (exp instanceof ConstantExpression) {
            return (ConstantExpression)exp;
        }
        this.addError("expected a constant", exp);
        return ConstantExpression.EMTPY_EXPRESSION;
    }

    protected void visitAnnotationExpression(String attrName, AnnotationConstantExpression expression, ClassNode attrType) {
        AnnotationNode annotationNode = (AnnotationNode)expression.getValue();
        AnnotationVisitor visitor = new AnnotationVisitor(this.source, this.errorCollector);
        visitor.visit(annotationNode);
    }

    protected void visitListExpression(String attrName, ListExpression listExpr, ClassNode elementType) {
        List expressions = listExpr.getExpressions();
        for (int i = 0; i < expressions.size(); ++i) {
            this.visitExpression(attrName, (Expression)expressions.get(i), elementType);
        }
    }

    protected void visitConstantExpression(String attrName, ConstantExpression constExpr, ClassNode attrType) {
        if (!constExpr.getType().isDerivedFrom(attrType)) {
            this.addError("Attribute '" + attrName + "' should have type '" + attrType.getName() + "'; " + "but found type '" + constExpr.getType().getName() + "'", constExpr);
        }
    }

    protected void visitEnumExpression(String attrName, PropertyExpression propExpr, ClassNode attrType) {
        if (!propExpr.getObjectExpression().getType().isDerivedFrom(attrType)) {
            this.addError("Attribute '" + attrName + "' should have type '" + attrType.getName() + "' (Enum), but found " + propExpr.getObjectExpression().getType().getName(), propExpr);
        }
    }

    protected void addError(String msg) {
        this.addError(msg, this.annotation);
    }

    protected void addError(String msg, ASTNode expr) {
        this.errorCollector.addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + " in @" + this.reportClass.getName() + '\n', expr.getLineNumber(), expr.getColumnNumber()), this.source));
    }

    public void checkcircularReference(ClassNode searchClass, ClassNode attrType, Expression startExp) {
        if (!this.isValidAnnotationClass(attrType)) {
            return;
        }
        AnnotationConstantExpression ace = (AnnotationConstantExpression)startExp;
        AnnotationNode annotationNode = (AnnotationNode)ace.getValue();
        if (annotationNode.getClassNode().equals(searchClass)) {
            this.addError("Cirecular reference discovered in " + searchClass.getName(), startExp);
            return;
        }
        ClassNode cn = annotationNode.getClassNode();
        List methods = cn.getMethods();
        for (MethodNode method : methods) {
            ReturnStatement code;
            if (method.getReturnType().equals(searchClass)) {
                this.addError("Cirecular reference discovered in " + cn.getName(), startExp);
            }
            if ((code = (ReturnStatement)method.getCode()) == null) continue;
            this.checkcircularReference(searchClass, method.getReturnType(), code.getExpression());
        }
    }
}

