/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaMethod;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.reflection.CachedConstructor;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.reflection.LazyReference;
import org.codehaus.groovy.reflection.LazySoftReference;
import org.codehaus.groovy.reflection.ReflectionCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedClass {
    private final Class cachedClass;
    public ClassInfo classInfo;
    public static boolean SunVM;
    private final LazySoftReference<CachedField[]> fields = new LazySoftReference<CachedField[]>(){

        @Override
        public CachedField[] initValue() {
            Field[] declaredFields = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AccessibleObject[] df = CachedClass.this.getTheClass().getDeclaredFields();
                    AccessibleObject.setAccessible(df, true);
                    return df;
                }
            });
            CachedField[] fields = new CachedField[declaredFields.length];
            for (int i = 0; i != fields.length; ++i) {
                fields[i] = new CachedField(declaredFields[i]);
            }
            return fields;
        }
    };
    private LazySoftReference<CachedConstructor[]> constructors = new LazySoftReference<CachedConstructor[]>(){

        @Override
        public CachedConstructor[] initValue() {
            Constructor[] declaredConstructors = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return CachedClass.this.getTheClass().getDeclaredConstructors();
                }
            });
            CachedConstructor[] constructors = new CachedConstructor[declaredConstructors.length];
            for (int i = 0; i != constructors.length; ++i) {
                constructors[i] = new CachedConstructor(CachedClass.this, declaredConstructors[i]);
            }
            return constructors;
        }
    };
    private LazySoftReference<CachedMethod[]> methods = new LazySoftReference<CachedMethod[]>(){

        @Override
        public CachedMethod[] initValue() {
            Method[] declaredMethods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AccessibleObject[] dm = CachedClass.this.getTheClass().getDeclaredMethods();
                    AccessibleObject.setAccessible(dm, true);
                    return dm;
                }
            });
            ArrayList<CachedMethod> methods = new ArrayList<CachedMethod>(declaredMethods.length);
            ArrayList<CachedMethod> mopMethods = new ArrayList<CachedMethod>(declaredMethods.length);
            for (int i = 0; i != declaredMethods.length; ++i) {
                CachedMethod cachedMethod = new CachedMethod(CachedClass.this, declaredMethods[i]);
                String name = cachedMethod.getName();
                if (name.indexOf(43) >= 0) continue;
                if (name.startsWith("this$") || name.startsWith("super$")) {
                    mopMethods.add(cachedMethod);
                    continue;
                }
                methods.add(cachedMethod);
            }
            Object[] resMethods = methods.toArray(new CachedMethod[methods.size()]);
            Arrays.sort(resMethods);
            CachedClass superClass = CachedClass.this.getCachedSuperClass();
            if (superClass != null) {
                superClass.getMethods();
                CachedMethod[] superMopMethods = superClass.mopMethods;
                for (int i = 0; i != superMopMethods.length; ++i) {
                    mopMethods.add(superMopMethods[i]);
                }
            }
            CachedClass.this.mopMethods = mopMethods.toArray(new CachedMethod[mopMethods.size()]);
            Arrays.sort(CachedClass.this.mopMethods, CachedMethodComparatorByName.INSTANCE);
            return resMethods;
        }
    };
    private LazyReference<CachedClass> cachedSuperClass = new LazyReference<CachedClass>(){

        @Override
        public CachedClass initValue() {
            if (!CachedClass.this.isArray) {
                return ReflectionCache.getCachedClass(CachedClass.this.getTheClass().getSuperclass());
            }
            if (CachedClass.this.cachedClass.getComponentType().isPrimitive() || CachedClass.this.cachedClass.getComponentType() == Object.class) {
                return ReflectionCache.OBJECT_CLASS;
            }
            return ReflectionCache.OBJECT_ARRAY_CLASS;
        }
    };
    static final MetaMethod[] EMPTY;
    int hashCode;
    public CachedMethod[] mopMethods;
    public static final CachedClass[] EMPTY_ARRAY;
    private final LazyReference<Set<CachedClass>> declaredInterfaces = new LazyReference<Set<CachedClass>>(){

        @Override
        public Set<CachedClass> initValue() {
            HashSet<CachedClass> res = new HashSet<CachedClass>(0);
            Class<?>[] classes = CachedClass.this.getTheClass().getInterfaces();
            for (int i = 0; i < classes.length; ++i) {
                res.add(ReflectionCache.getCachedClass(classes[i]));
            }
            return res;
        }
    };
    private final LazySoftReference<Set<CachedClass>> interfaces = new LazySoftReference<Set<CachedClass>>(){

        @Override
        public Set<CachedClass> initValue() {
            HashSet<CachedClass> res = new HashSet<CachedClass>(0);
            if (CachedClass.this.getTheClass().isInterface()) {
                res.add(CachedClass.this);
            }
            Class<?>[] classes = CachedClass.this.getTheClass().getInterfaces();
            for (int i = 0; i < classes.length; ++i) {
                CachedClass aClass = ReflectionCache.getCachedClass(classes[i]);
                if (res.contains(aClass)) continue;
                res.addAll(aClass.getInterfaces());
            }
            CachedClass superClass = CachedClass.this.getCachedSuperClass();
            if (superClass != null) {
                res.addAll(superClass.getInterfaces());
            }
            return res;
        }
    };
    public final boolean isArray;
    public final boolean isPrimitive;
    public final int modifiers;
    int distance = -1;
    public final boolean isInterface;
    public final boolean isNumber;

    public CachedClass(Class klazz, ClassInfo classInfo) {
        this.cachedClass = klazz;
        this.classInfo = classInfo;
        this.isArray = klazz.isArray();
        this.isPrimitive = klazz.isPrimitive();
        this.modifiers = klazz.getModifiers();
        this.isInterface = klazz.isInterface();
        this.isNumber = Number.class.isAssignableFrom(klazz);
        for (CachedClass inf : this.getInterfaces()) {
            ReflectionCache.isAssignableFrom(klazz, inf.cachedClass);
        }
        for (CachedClass cur = this; cur != null; cur = cur.getCachedSuperClass()) {
            ReflectionCache.setAssignableFrom(cur.cachedClass, klazz);
        }
    }

    public CachedClass getCachedSuperClass() {
        return this.cachedSuperClass.get();
    }

    public Set<CachedClass> getInterfaces() {
        return this.interfaces.get();
    }

    public Set<CachedClass> getDeclaredInterfaces() {
        return this.declaredInterfaces.get();
    }

    public CachedMethod[] getMethods() {
        return this.methods.get();
    }

    public CachedField[] getFields() {
        return this.fields.get();
    }

    public CachedConstructor[] getConstructors() {
        return this.constructors.get();
    }

    public CachedMethod searchMethods(String name, CachedClass[] parameterTypes) {
        CachedMethod[] methods = this.getMethods();
        CachedMethod res = null;
        for (int i = 0; i < methods.length; ++i) {
            CachedMethod m = methods[i];
            if (!m.getName().equals(name) || !ReflectionCache.arrayContentsEq(parameterTypes, m.getParameterTypes()) || res != null && !res.getReturnType().isAssignableFrom(m.getReturnType())) continue;
            res = m;
        }
        return res;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Object coerceArgument(Object argument) {
        return argument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuperClassDistance() {
        Class clazz = this.getTheClass();
        synchronized (clazz) {
            if (this.distance == -1) {
                int distance = 0;
                for (Class klazz = this.getTheClass(); klazz != null; klazz = klazz.getSuperclass()) {
                    ++distance;
                }
                this.distance = distance;
            }
            return this.distance;
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = super.hashCode();
            if (this.hashCode == 0) {
                this.hashCode = -889274690;
            }
        }
        return this.hashCode;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isVoid() {
        return this.getTheClass() == Void.TYPE;
    }

    public void box(BytecodeHelper helper) {
        helper.box(this.getTheClass());
    }

    public void unbox(BytecodeHelper helper) {
        helper.unbox(this.getTheClass());
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void doCast(BytecodeHelper helper) {
        helper.doCast(this.getTheClass());
    }

    public String getName() {
        return this.getTheClass().getName();
    }

    public String getTypeDescription() {
        return BytecodeHelper.getTypeDescription(this.getTheClass());
    }

    public final Class getTheClass() {
        return this.cachedClass;
    }

    public MetaMethod[] getNewMetaMethods() {
        return this.classInfo.newMetaMethods;
    }

    public void setNewMopMethods(List arr) {
        MetaClass metaClass = this.classInfo.getStrongMetaClass();
        if (metaClass != null) {
            if (metaClass.getClass() == MetaClassImpl.class) {
                this.classInfo.setStrongMetaClass(null);
                this.updateSetNewMopMethods(arr);
                this.classInfo.setStrongMetaClass(new MetaClassImpl(metaClass.getTheClass()));
                return;
            }
            if (metaClass.getClass() == ExpandoMetaClass.class) {
                this.classInfo.setStrongMetaClass(null);
                this.updateSetNewMopMethods(arr);
                ExpandoMetaClass newEmc = new ExpandoMetaClass(metaClass.getTheClass());
                newEmc.initialize();
                this.classInfo.setStrongMetaClass(newEmc);
                return;
            }
            throw new GroovyRuntimeException("Can't add methods to class " + this.getTheClass().getName() + ". Strong custom meta class already set.");
        }
        this.classInfo.setWeakMetaClass(null);
        this.updateSetNewMopMethods(arr);
    }

    private void updateSetNewMopMethods(List arr) {
        if (arr != null) {
            MetaMethod[] metaMethods = arr.toArray(new MetaMethod[arr.size()]);
            this.classInfo.dgmMetaMethods = metaMethods;
            this.classInfo.newMetaMethods = metaMethods;
        } else {
            this.classInfo.newMetaMethods = this.classInfo.dgmMetaMethods;
        }
    }

    public void addNewMopMethods(List arr) {
        MetaClass metaClass = this.classInfo.getStrongMetaClass();
        if (metaClass != null) {
            if (metaClass.getClass() == MetaClassImpl.class) {
                this.classInfo.setStrongMetaClass(null);
                this.updateAddNewMopMethods(arr);
                this.classInfo.setStrongMetaClass(new MetaClassImpl(metaClass.getTheClass()));
                return;
            }
            if (metaClass.getClass() == ExpandoMetaClass.class) {
                ExpandoMetaClass emc = (ExpandoMetaClass)metaClass;
                this.classInfo.setStrongMetaClass(null);
                this.updateAddNewMopMethods(arr);
                ExpandoMetaClass newEmc = new ExpandoMetaClass(metaClass.getTheClass());
                Iterator it = emc.getExpandoMethods().iterator();
                while (it.hasNext()) {
                    newEmc.registerInstanceMethod((MetaMethod)it.next());
                }
                newEmc.initialize();
                this.classInfo.setStrongMetaClass(newEmc);
                return;
            }
            throw new GroovyRuntimeException("Can't add methods to class " + this.getTheClass().getName() + ". Strong custom meta class already set.");
        }
        this.classInfo.setWeakMetaClass(null);
        this.updateAddNewMopMethods(arr);
    }

    private void updateAddNewMopMethods(List arr) {
        ArrayList<MetaMethod> res = new ArrayList<MetaMethod>();
        res.addAll(Arrays.asList(this.classInfo.newMetaMethods));
        res.addAll(arr);
        MetaMethod[] metaMethods = res.toArray(new MetaMethod[res.size()]);
        this.classInfo.newMetaMethods = metaMethods;
    }

    public boolean isAssignableFrom(Class argument) {
        return argument == null || ReflectionCache.isAssignableFrom(this.getTheClass(), argument);
    }

    public boolean isDirectlyAssignable(Object argument) {
        return ReflectionCache.isAssignableFrom(this.getTheClass(), argument.getClass());
    }

    public String toString() {
        return this.cachedClass.toString();
    }

    static {
        try {
            Class.forName("sun.misc.Unsafe");
            SunVM = true;
        }
        catch (ClassNotFoundException e) {
            SunVM = false;
        }
        EMPTY = new MetaMethod[0];
        EMPTY_ARRAY = new CachedClass[0];
    }

    public static class CachedMethodComparatorWithString
    implements Comparator {
        public static final Comparator INSTANCE = new CachedMethodComparatorWithString();

        public int compare(Object o1, Object o2) {
            if (o1 instanceof CachedMethod) {
                return ((CachedMethod)o1).getName().compareTo((String)o2);
            }
            return ((String)o1).compareTo(((CachedMethod)o2).getName());
        }
    }

    public static class CachedMethodComparatorByName
    implements Comparator {
        public static final Comparator INSTANCE = new CachedMethodComparatorByName();

        public int compare(Object o1, Object o2) {
            return ((CachedMethod)o1).getName().compareTo(((CachedMethod)o2).getName());
        }
    }
}

