/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.callsite;

import groovy.lang.MetaClassImpl;
import java.util.Map;
import org.codehaus.groovy.reflection.CachedConstructor;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.MetaClassSite;

public class ConstructorSite
extends MetaClassSite {
    final CachedConstructor constructor;
    final Class[] params;

    public ConstructorSite(CallSite site, MetaClassImpl metaClass, CachedConstructor constructor, Class[] params) {
        super(site, metaClass);
        this.constructor = constructor;
        this.params = params;
    }

    public Object invoke(Object receiver, Object[] args) {
        MetaClassHelper.unwrap(args);
        return this.constructor.doConstructorInvoke(args);
    }

    public final CallSite acceptConstructor(Object receiver, Object[] args) {
        if (receiver == this.metaClass.getTheClass() && MetaClassHelper.sameClasses(this.params, args)) {
            return this;
        }
        return this.createCallConstructorSite((Class)receiver, args);
    }

    public static ConstructorSite createConstructorSite(CallSite site, MetaClassImpl metaClass, CachedConstructor constructor, Class[] params, Object[] args) {
        if (constructor.correctArguments(args) == args && ConstructorSite.noWrappers(args)) {
            if (ConstructorSite.noCoerce(constructor, args)) {
                return new ConstructorSiteNoUnwrap(site, metaClass, constructor, params);
            }
            return new ConstructorSiteNoUnwrapNoCoerce(site, metaClass, constructor, params);
        }
        return new ConstructorSite(site, metaClass, constructor, params);
    }

    public static class NoParamSite
    extends ConstructorSiteNoUnwrapNoCoerce {
        private static final Object[] NO_ARGS = new Object[0];

        public NoParamSite(CallSite site, MetaClassImpl metaClass, CachedConstructor constructor, Class[] params) {
            super(site, metaClass, constructor, params);
        }

        public final Object invoke(Object receiver, Object[] args) {
            Object bean = this.constructor.invoke(NO_ARGS);
            ((MetaClassImpl)this.metaClass).setProperties(bean, (Map)args[0]);
            return bean;
        }
    }

    public static class ConstructorSiteNoUnwrapNoCoerce
    extends ConstructorSite {
        public ConstructorSiteNoUnwrapNoCoerce(CallSite site, MetaClassImpl metaClass, CachedConstructor constructor, Class[] params) {
            super(site, metaClass, constructor, params);
        }

        public Object invoke(Object receiver, Object[] args) {
            return this.constructor.invoke(args);
        }
    }

    public static class ConstructorSiteNoUnwrap
    extends ConstructorSite {
        public ConstructorSiteNoUnwrap(CallSite site, MetaClassImpl metaClass, CachedConstructor constructor, Class[] params) {
            super(site, metaClass, constructor, params);
        }

        public final Object invoke(Object receiver, Object[] args) {
            return this.constructor.doConstructorInvoke(args);
        }
    }
}

