/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.GroovyClassLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.ASTTransformationCollectorCodeVisitor;
import org.codehaus.groovy.transform.GroovyASTTransformation;

public class ASTTransformationVisitor
extends ClassCodeVisitorSupport {
    private CompilePhase phase;
    private SourceUnit source;
    private List<ASTNode[]> targetNodes;
    private Map<ASTNode, List<ASTTransformation>> transforms;

    private ASTTransformationVisitor(CompilePhase phase) {
        this.phase = phase;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public void visitClass(ClassNode classNode) {
        Map<ASTTransformation, ASTNode> baseTransforms = classNode.getTransforms(this.phase);
        if (!baseTransforms.isEmpty()) {
            this.transforms = new HashMap<ASTNode, List<ASTTransformation>>();
            for (Map.Entry<ASTTransformation, ASTNode> entry : baseTransforms.entrySet()) {
                List<ASTTransformation> list = this.transforms.get(entry.getValue());
                if (list == null) {
                    list = new ArrayList<ASTTransformation>();
                    this.transforms.put(entry.getValue(), list);
                }
                list.add(entry.getKey());
            }
            this.targetNodes = new LinkedList<ASTNode[]>();
            super.visitClass(classNode);
            for (ASTNode[] node : this.targetNodes) {
                for (ASTTransformation snt : this.transforms.get(node[0])) {
                    snt.visit(node, this.source);
                }
            }
        }
    }

    public void visitAnnotations(AnnotatedNode node) {
        super.visitAnnotations(node);
        for (AnnotationNode annotation : node.getAnnotations()) {
            if (!this.transforms.containsKey(annotation)) continue;
            this.targetNodes.add(new ASTNode[]{annotation, node});
        }
    }

    public static void addPhaseOperations(CompilationUnit compilationUnit) {
        ASTTransformationVisitor.addGlobalTransforms(compilationUnit);
        compilationUnit.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

            public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                ASTTransformationCollectorCodeVisitor collector = new ASTTransformationCollectorCodeVisitor(source);
                collector.visitClass(classNode);
            }
        }, 4);
        block3: for (CompilePhase phase : CompilePhase.values()) {
            final ASTTransformationVisitor visitor = new ASTTransformationVisitor(phase);
            switch (phase) {
                case INITIALIZATION: 
                case PARSING: 
                case CONVERSION: {
                    continue block3;
                }
                default: {
                    compilationUnit.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

                        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                            visitor.source = source;
                            visitor.visitClass(classNode);
                        }
                    }, phase.getPhaseNumber());
                }
            }
        }
    }

    public static void addGlobalTransforms(CompilationUnit compilationUnit) {
        try {
            GroovyClassLoader cuLoader = compilationUnit.getClassLoader();
            Enumeration<URL> globalServices = cuLoader.getResources("META-INF/services/org.codehaus.groovy.transform.ASTTransformation");
            while (globalServices.hasMoreElements()) {
                String className;
                URL service = globalServices.nextElement();
                BufferedReader svcIn = new BufferedReader(new InputStreamReader(service.openStream()));
                try {
                    className = svcIn.readLine();
                }
                catch (IOException ioe) {
                    compilationUnit.getErrorCollector().addError(new SimpleMessage("IOException reading the service definition at " + service.toExternalForm() + " because of exception " + ioe.toString(), null));
                    continue;
                }
                while (className != null) {
                    try {
                        if (!className.startsWith("#") && className.length() > 0) {
                            Class<?> gTransClass = cuLoader.loadClass(className);
                            GroovyASTTransformation transformAnnotation = gTransClass.getAnnotation(GroovyASTTransformation.class);
                            if (transformAnnotation == null) {
                                compilationUnit.getErrorCollector().addError(new SimpleMessage("Transform Class " + className + " is specified as a global transform in " + service.toExternalForm() + " but it is not annotated by " + GroovyASTTransformation.class.getName(), null));
                                continue;
                            }
                            if (ASTTransformation.class.isAssignableFrom(gTransClass)) {
                                final ASTTransformation instance = (ASTTransformation)gTransClass.newInstance();
                                compilationUnit.addPhaseOperation(new CompilationUnit.SourceUnitOperation(){

                                    public void call(SourceUnit source) throws CompilationFailedException {
                                        instance.visit(new ASTNode[]{source.getAST()}, source);
                                    }
                                }, transformAnnotation.phase().getPhaseNumber());
                            } else {
                                compilationUnit.getErrorCollector().addError(new SimpleMessage("Transform Class " + className + " specified at " + service.toExternalForm() + " is not an ASTTransformation.", null));
                            }
                        }
                    }
                    catch (Exception e) {
                        compilationUnit.getErrorCollector().addError(new SimpleMessage("Could not instantiate global transform class " + className + " specified at " + service.toExternalForm() + "  because of exception " + e.toString(), null));
                    }
                    try {
                        className = svcIn.readLine();
                    }
                    catch (IOException ioe) {
                        compilationUnit.getErrorCollector().addError(new SimpleMessage("IOException reading the service definition at " + service.toExternalForm() + " because of exception " + ioe.toString(), null));
                    }
                }
            }
        }
        catch (IOException e) {
            compilationUnit.getErrorCollector().addError(new SimpleMessage("IO Exception attempting to load global transforms:" + e.getMessage(), null));
        }
    }
}

