/*
 * Decompiled with CFR 0.152.
 */
package groovy.beans;

import groovy.beans.Bindable;
import groovy.beans.VetoableASTTransformation;
import groovyjarjarasm.asm.Opcodes;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class BindableASTTransformation
implements ASTTransformation,
Opcodes {
    protected FieldNode pcsField;
    protected static ClassNode boundClassNode = new ClassNode(Bindable.class);
    protected ClassNode pcsClassNode = new ClassNode(PropertyChangeSupport.class);

    public static boolean hasBindableAnnotation(AnnotatedNode node) {
        for (AnnotationNode annotation : node.getAnnotations()) {
            if (!boundClassNode.equals(annotation.getClassNode())) continue;
            return true;
        }
        return false;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (!(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        AnnotationNode node = (AnnotationNode)nodes[0];
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        if (VetoableASTTransformation.hasVetoableAnnotation(parent)) {
            return;
        }
        ClassNode declaringClass = parent.getDeclaringClass();
        if (parent instanceof FieldNode) {
            if (VetoableASTTransformation.hasVetoableAnnotation(parent.getDeclaringClass())) {
                return;
            }
            this.addListenerToProperty(source, node, declaringClass, (FieldNode)parent);
        } else if (parent instanceof ClassNode) {
            this.addListenerToClass(source, node, (ClassNode)parent);
        }
    }

    private void addListenerToProperty(SourceUnit source, AnnotationNode node, ClassNode declaringClass, FieldNode field) {
        String fieldName = field.getName();
        for (PropertyNode propertyNode : declaringClass.getProperties()) {
            if (!propertyNode.getName().equals(fieldName)) continue;
            if (field.isStatic()) {
                source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException("@groovy.beans.Bindable cannot annotate a static property.", node.getLineNumber(), node.getColumnNumber()), source));
            } else {
                if (this.needsPropertyChangeSupport(declaringClass)) {
                    this.addPropertyChangeSupport(declaringClass);
                }
                this.createListenerSetter(source, node, declaringClass, propertyNode);
            }
            return;
        }
        source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException("@groovy.beans.Bindable must be on a property, not a field.  Try removing the private, protected, or public modifier.", node.getLineNumber(), node.getColumnNumber()), source));
    }

    private void addListenerToClass(SourceUnit source, AnnotationNode node, ClassNode classNode) {
        if (this.needsPropertyChangeSupport(classNode)) {
            this.addPropertyChangeSupport(classNode);
        }
        for (PropertyNode propertyNode : classNode.getProperties()) {
            FieldNode field = propertyNode.getField();
            if (BindableASTTransformation.hasBindableAnnotation(field) || field.isStatic() || VetoableASTTransformation.hasVetoableAnnotation(field)) continue;
            this.createListenerSetter(source, node, classNode, propertyNode);
        }
    }

    private void createListenerSetter(SourceUnit source, AnnotationNode node, ClassNode classNode, PropertyNode propertyNode) {
        String setterName = "set" + MetaClassHelper.capitalize(propertyNode.getName());
        if (classNode.getMethods(setterName).isEmpty()) {
            FieldExpression fieldExpression = new FieldExpression(propertyNode.getField());
            Statement setterBlock = this.createBindableStatement(propertyNode, fieldExpression);
            this.createSetterMethod(classNode, propertyNode, setterName, setterBlock);
        } else {
            source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException("@groovy.beans.Bindable cannot handle user generated setters.", node.getLineNumber(), node.getColumnNumber()), source));
        }
    }

    protected Statement createBindableStatement(PropertyNode propertyNode, Expression fieldExpression) {
        return new ExpressionStatement(new MethodCallExpression((Expression)new FieldExpression(this.pcsField), "firePropertyChange", (Expression)new ArgumentListExpression(new Expression[]{new ConstantExpression(propertyNode.getName()), fieldExpression, new BinaryExpression(fieldExpression, Token.newSymbol(100, 0, 0), new VariableExpression("value"))})));
    }

    protected void createSetterMethod(ClassNode declaringClass, PropertyNode propertyNode, String setterName, Statement setterBlock) {
        Parameter[] setterParameterTypes = new Parameter[]{new Parameter(propertyNode.getType(), "value")};
        MethodNode setter = new MethodNode(setterName, propertyNode.getModifiers(), ClassHelper.VOID_TYPE, setterParameterTypes, ClassNode.EMPTY_ARRAY, setterBlock);
        setter.setSynthetic(true);
        declaringClass.addMethod(setter);
    }

    protected boolean needsPropertyChangeSupport(ClassNode declaringClass) {
        while (declaringClass != null) {
            for (FieldNode field : declaringClass.getFields()) {
                if (field.getType() == null || !this.pcsClassNode.equals(field.getType())) continue;
                this.pcsField = field;
                return false;
            }
            declaringClass = declaringClass.getSuperClass();
        }
        return true;
    }

    protected void addPropertyChangeSupport(ClassNode declaringClass) {
        ClassNode pcsClassNode = ClassHelper.make(PropertyChangeSupport.class);
        ClassNode pclClassNode = ClassHelper.make(PropertyChangeListener.class);
        this.pcsField = declaringClass.addField("this$propertyChangeSupport", 4116, pcsClassNode, new ConstructorCallExpression(pcsClassNode, new ArgumentListExpression(new Expression[]{new VariableExpression("this")})));
        declaringClass.addMethod(new MethodNode("addPropertyChangeListener", 4097, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(pclClassNode, "listener")}, ClassNode.EMPTY_ARRAY, new ExpressionStatement(new MethodCallExpression((Expression)new FieldExpression(this.pcsField), "addPropertyChangeListener", (Expression)new ArgumentListExpression(new Expression[]{new VariableExpression("listener")})))));
        declaringClass.addMethod(new MethodNode("addPropertyChangeListener", 4097, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(pclClassNode, "listener")}, ClassNode.EMPTY_ARRAY, new ExpressionStatement(new MethodCallExpression((Expression)new FieldExpression(this.pcsField), "addPropertyChangeListener", (Expression)new ArgumentListExpression(new Expression[]{new VariableExpression("name"), new VariableExpression("listener")})))));
        declaringClass.addMethod(new MethodNode("removePropertyChangeListener", 4097, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(pclClassNode, "listener")}, ClassNode.EMPTY_ARRAY, new ExpressionStatement(new MethodCallExpression((Expression)new FieldExpression(this.pcsField), "removePropertyChangeListener", (Expression)new ArgumentListExpression(new Expression[]{new VariableExpression("listener")})))));
        declaringClass.addMethod(new MethodNode("removePropertyChangeListener", 4097, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(pclClassNode, "listener")}, ClassNode.EMPTY_ARRAY, new ExpressionStatement(new MethodCallExpression((Expression)new FieldExpression(this.pcsField), "removePropertyChangeListener", (Expression)new ArgumentListExpression(new Expression[]{new VariableExpression("name"), new VariableExpression("listener")})))));
        declaringClass.addMethod(new MethodNode("getPropertyChangeListeners", 4097, pclClassNode.makeArray(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, new ReturnStatement(new ExpressionStatement(new MethodCallExpression((Expression)new FieldExpression(this.pcsField), "getPropertyChangeListeners", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)))));
    }
}

