/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;

public class ASTTransformationCollectorCodeVisitor
extends ClassCodeVisitorSupport {
    private SourceUnit source;
    private ClassNode classNode;

    public ASTTransformationCollectorCodeVisitor(SourceUnit source) {
        this.source = source;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public void visitClass(ClassNode klassNode) {
        ClassNode oldClass = this.classNode;
        this.classNode = klassNode;
        super.visitClass(this.classNode);
        this.classNode = oldClass;
    }

    public void visitAnnotations(AnnotatedNode node) {
        super.visitAnnotations(node);
        for (AnnotationNode annotation : node.getAnnotations()) {
            GroovyASTTransformationClass transformClassAnnotation;
            ClassNode annotationClassNode = annotation.getClassNode();
            if (!annotationClassNode.isResolved() || (transformClassAnnotation = annotation.getClassNode().getTypeClass().getAnnotation(GroovyASTTransformationClass.class)) == null) continue;
            for (String transformClass : transformClassAnnotation.value()) {
                try {
                    Class klass = this.source.getClassLoader().loadClass(transformClass, false, true, false);
                    if (ASTTransformation.class.isAssignableFrom(klass)) {
                        this.classNode.addTransform(klass, annotation);
                        continue;
                    }
                    this.source.getErrorCollector().addError(new SimpleMessage("Not an ASTTransformatnion: " + transformClass + " declared by " + annotation.getClassNode().getName(), this.source));
                }
                catch (ClassNotFoundException e) {
                    this.source.getErrorCollector().addError(new SimpleMessage("Could find class for Transformation Processor " + transformClass + " declared by " + annotation.getClassNode().getName(), this.source));
                }
            }
        }
    }
}

