/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovyjarjarasm.asm.Opcodes;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class DelegateASTTransformation
implements ASTTransformation,
Opcodes {
    private static final ClassNode DEPRECATED_TYPE = new ClassNode(Deprecated.class);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes));
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (parent instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)parent;
            ClassNode type = fieldNode.getType();
            Map<String, MethodNode> fieldMethods = type.getDeclaredMethodsMap();
            ClassNode owner = fieldNode.getOwner();
            Expression deprecatedElement = node.getMember("deprecated");
            boolean deprecated = deprecatedElement instanceof ConstantExpression && ((ConstantExpression)deprecatedElement).getValue().equals(true);
            Map<String, MethodNode> ownMethods = owner.getDeclaredMethodsMap();
            for (Map.Entry<String, MethodNode> e : fieldMethods.entrySet()) {
                this.addDelegateMethod(fieldNode, owner, ownMethods, e, deprecated);
            }
            for (PropertyNode prop : type.getProperties()) {
                if (prop.isStatic() || !prop.isPublic()) continue;
                String name = prop.getName();
                this.addGetterIfNeeded(fieldNode, owner, prop, name);
                this.addSetterIfNeeded(fieldNode, owner, prop, name);
            }
            Expression interfacesElement = node.getMember("interfaces");
            if (interfacesElement instanceof ConstantExpression && ((ConstantExpression)interfacesElement).getValue().equals(false)) {
                return;
            }
            Set<ClassNode> allInterfaces = type.getAllInterfaces();
            Set<ClassNode> ownerIfaces = owner.getAllInterfaces();
            for (ClassNode iface : allInterfaces) {
                if (!Modifier.isPublic(iface.getModifiers()) || ownerIfaces.contains(iface)) continue;
                ClassNode[] ifaces = owner.getInterfaces();
                ClassNode[] newIfaces = new ClassNode[ifaces.length + 1];
                System.arraycopy(ifaces, 0, newIfaces, 0, ifaces.length);
                newIfaces[ifaces.length] = iface;
                owner.setInterfaces(newIfaces);
            }
        }
    }

    private void addSetterIfNeeded(FieldNode fieldNode, ClassNode owner, PropertyNode prop, String name) {
        String setterName = "set" + Verifier.capitalize(name);
        if ((prop.getModifiers() & 0x10) == 0 && owner.getSetterMethod(setterName) == null) {
            owner.addMethod(setterName, 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(this.nonGeneric(prop.getType()), "value")}, null, new ExpressionStatement(new BinaryExpression(new PropertyExpression((Expression)new FieldExpression(fieldNode), name), Token.newSymbol(100, -1, -1), new VariableExpression("value"))));
        }
    }

    private void addGetterIfNeeded(FieldNode fieldNode, ClassNode owner, PropertyNode prop, String name) {
        String getterName = "get" + Verifier.capitalize(name);
        if (owner.getGetterMethod(getterName) == null) {
            owner.addMethod(getterName, 1, this.nonGeneric(prop.getType()), Parameter.EMPTY_ARRAY, null, new ReturnStatement(new PropertyExpression((Expression)new FieldExpression(fieldNode), name)));
        }
    }

    private void addDelegateMethod(FieldNode fieldNode, ClassNode owner, Map<String, MethodNode> ownMethods, Map.Entry<String, MethodNode> e, boolean deprecated) {
        MethodNode method = e.getValue();
        if (!method.isPublic() || method.isStatic() || 0 != (method.getModifiers() & 0x1000)) {
            return;
        }
        if (!method.getAnnotations(DEPRECATED_TYPE).isEmpty() && !deprecated) {
            return;
        }
        MethodNode existingNode = ownMethods.get(e.getKey());
        if (existingNode == null || existingNode.getCode() == null) {
            ArgumentListExpression args = new ArgumentListExpression();
            Parameter[] params = method.getParameters();
            Parameter[] newParams = new Parameter[params.length];
            for (int i = 0; i < newParams.length; ++i) {
                Parameter newParam;
                newParams[i] = newParam = new Parameter(this.nonGeneric(params[i].getType()), params[i].getName());
                args.addExpression(new VariableExpression(newParam));
            }
            owner.addMethod(method.getName(), method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF, this.nonGeneric(method.getReturnType()), newParams, method.getExceptions(), new ExpressionStatement(new MethodCallExpression((Expression)new FieldExpression(fieldNode), method.getName(), (Expression)args)));
        }
    }

    private ClassNode nonGeneric(ClassNode type) {
        if (type.isUsingGenerics()) {
            ClassNode nonGen = ClassHelper.makeWithoutCaching(type.getName());
            nonGen.setRedirect(type);
            nonGen.setGenericsTypes(null);
            nonGen.setUsingGenerics(false);
            return nonGen;
        }
        return type;
    }
}

