/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.syntax.Token;

public class DeclarationExpression
extends BinaryExpression {
    public DeclarationExpression(VariableExpression left, Token operation, Expression right) {
        super(left, operation, right);
    }

    public DeclarationExpression(Expression left, Token operation, Expression right) {
        super(left, operation, right);
        this.check(left, right);
    }

    private void check(Expression left, Expression right) {
        if (!(left instanceof VariableExpression)) {
            if (left instanceof TupleExpression) {
                TupleExpression tuple = (TupleExpression)left;
                if (tuple.getExpressions().size() == 0) {
                    throw new GroovyBugError("one element required for left side");
                }
            } else {
                throw new GroovyBugError("illegal left expression for declaration: " + left);
            }
        }
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitDeclarationExpression(this);
    }

    public VariableExpression getVariableExpression() {
        return (VariableExpression)this.getLeftExpression();
    }

    public void setLeftExpression(Expression leftExpression) {
        this.check(leftExpression, this.getRightExpression());
        super.setLeftExpression(leftExpression);
    }

    public void setRightExpression(Expression rightExpression) {
        this.check(this.getLeftExpression(), rightExpression);
        super.setRightExpression(rightExpression);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        DeclarationExpression ret = new DeclarationExpression(transformer.transform(this.getLeftExpression()), this.getOperation(), transformer.transform(this.getRightExpression()));
        ret.setSourcePosition(this);
        ret.addAnnotations(this.getAnnotations());
        ret.setDeclaringClass(this.getDeclaringClass());
        return ret;
    }

    public boolean isMultipleAssignmentDeclaration() {
        return this.getLeftExpression() instanceof ArgumentListExpression;
    }
}

