/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import java.util.Arrays;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class LogASTTransformation
implements ASTTransformation {
    public void visit(ASTNode[] nodes, final SourceUnit source) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            this.addError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes), nodes[0], source);
        }
        AnnotatedNode targetClass = (AnnotatedNode)nodes[1];
        AnnotationNode logAnnotation = (AnnotationNode)nodes[0];
        final LoggingStrategy loggingStrategy = LogASTTransformation.createLoggingStrategy(logAnnotation);
        final String logFieldName = this.lookupLogFieldName(logAnnotation);
        if (!(targetClass instanceof ClassNode)) {
            throw new GroovyBugError("Class annotation " + logAnnotation.getClassNode().getName() + " annotated no Class, this must not happen.");
        }
        ClassNode classNode = (ClassNode)targetClass;
        ClassCodeExpressionTransformer transformer = new ClassCodeExpressionTransformer(){
            private FieldNode logNode;

            protected SourceUnit getSourceUnit() {
                return source;
            }

            public Expression transform(Expression exp) {
                if (exp == null) {
                    return null;
                }
                if (exp instanceof MethodCallExpression) {
                    return this.transformMethodCallExpression(exp);
                }
                return super.transform(exp);
            }

            public void visitClass(ClassNode node) {
                FieldNode logField = node.getField(logFieldName);
                if (logField != null) {
                    this.addError("Class annotated with Log annotation cannot have log field declared", logField);
                } else {
                    this.logNode = loggingStrategy.addLoggerFieldToClass(node, logFieldName);
                }
                super.visitClass(node);
            }

            private Expression transformMethodCallExpression(Expression exp) {
                MethodCallExpression mce = (MethodCallExpression)exp;
                if (!(mce.getObjectExpression() instanceof VariableExpression)) {
                    return exp;
                }
                VariableExpression variableExpression = (VariableExpression)mce.getObjectExpression();
                if (!variableExpression.getName().equals(logFieldName) || !(variableExpression.getAccessedVariable() instanceof DynamicVariable)) {
                    return exp;
                }
                String methodName = mce.getMethodAsString();
                if (methodName == null) {
                    return exp;
                }
                if (this.usesSimpleMethodArgumentsOnly(mce)) {
                    return exp;
                }
                variableExpression.setAccessedVariable(this.logNode);
                if (!loggingStrategy.isLoggingMethod(methodName)) {
                    return exp;
                }
                return loggingStrategy.wrapLoggingMethodCall(variableExpression, methodName, exp);
            }

            private boolean usesSimpleMethodArgumentsOnly(MethodCallExpression mce) {
                Expression arguments = mce.getArguments();
                if (arguments instanceof TupleExpression) {
                    TupleExpression tuple = (TupleExpression)arguments;
                    for (Expression exp : tuple.getExpressions()) {
                        if (this.isSimpleExpression(exp)) continue;
                        return false;
                    }
                    return true;
                }
                return !this.isSimpleExpression(arguments);
            }

            private boolean isSimpleExpression(Expression exp) {
                if (exp instanceof ConstantExpression) {
                    return true;
                }
                return exp instanceof VariableExpression;
            }
        };
        transformer.visitClass(classNode);
    }

    private String lookupLogFieldName(AnnotationNode logAnnotation) {
        Expression member = logAnnotation.getMember("value");
        if (member != null && member.getText() != null) {
            return member.getText();
        }
        return "log";
    }

    public void addError(String msg, ASTNode expr, SourceUnit source) {
        int line = expr.getLineNumber();
        int col = expr.getColumnNumber();
        source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', line, col), source));
    }

    private static Expression commonMethodCallExpression(Expression variableExpression, String methodName, Expression exp) {
        MethodCallExpression condition = new MethodCallExpression(variableExpression, "is" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1, methodName.length()) + "Enabled", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
        return new TernaryExpression(new BooleanExpression(condition), exp, ConstantExpression.NULL);
    }

    private static LoggingStrategy createLoggingStrategy(AnnotationNode logAnnotation) {
        if ("groovy.util.logging.Log".equals(logAnnotation.getClassNode().getName())) {
            return new JavaUtilLoggingStrategy();
        }
        if ("groovy.util.logging.Slf4j".equals(logAnnotation.getClassNode().getName())) {
            return new Slf4jLoggingStrategy();
        }
        if ("groovy.util.logging.Log4j".equals(logAnnotation.getClassNode().getName())) {
            return new Log4jLoggingStrategy();
        }
        if ("groovy.util.logging.Commons".equals(logAnnotation.getClassNode().getName())) {
            return new CommonsLoggingStrategy();
        }
        throw new GroovyBugError("Class annotation " + logAnnotation.getClassNode().getName() + " must map to a logging strategy.");
    }

    private static class CommonsLoggingStrategy
    implements LoggingStrategy {
        private CommonsLoggingStrategy() {
        }

        public FieldNode addLoggerFieldToClass(ClassNode classNode, String logFieldName) {
            return classNode.addField(logFieldName, 154, new ClassNode("org.apache.commons.logging.Log", 1, new ClassNode(Object.class)), new MethodCallExpression((Expression)new ClassExpression(new ClassNode("org.apache.commons.logging.LogFactory", 1, new ClassNode(Object.class))), "getLog", (Expression)new ClassExpression(classNode)));
        }

        public boolean isLoggingMethod(String methodName) {
            return methodName.matches("fatal|error|warn|info|debug|trace");
        }

        public Expression wrapLoggingMethodCall(Expression logVariable, String methodName, Expression originalExpression) {
            return LogASTTransformation.commonMethodCallExpression(logVariable, methodName, originalExpression);
        }
    }

    private static class Log4jLoggingStrategy
    implements LoggingStrategy {
        private Log4jLoggingStrategy() {
        }

        public FieldNode addLoggerFieldToClass(ClassNode classNode, String logFieldName) {
            return classNode.addField(logFieldName, 154, new ClassNode("org.apache.log4j.Logger", 1, new ClassNode(Object.class)), new MethodCallExpression((Expression)new ClassExpression(new ClassNode("org.apache.log4j.Logger", 1, new ClassNode(Object.class))), "getLogger", (Expression)new ClassExpression(classNode)));
        }

        public boolean isLoggingMethod(String methodName) {
            return methodName.matches("fatal|error|warn|info|debug|trace");
        }

        public Expression wrapLoggingMethodCall(Expression logVariable, String methodName, Expression originalExpression) {
            MethodCallExpression condition;
            if (!"trace".equals(methodName)) {
                ClassNode levelClass = new ClassNode("org.apache.log4j.Priority", 0, ClassHelper.OBJECT_TYPE);
                AttributeExpression logLevelExpression = new AttributeExpression((Expression)new ClassExpression(levelClass), new ConstantExpression(methodName.toUpperCase()));
                ArgumentListExpression args = new ArgumentListExpression();
                args.addExpression(logLevelExpression);
                condition = new MethodCallExpression(logVariable, "isEnabledFor", (Expression)args);
            } else {
                condition = new MethodCallExpression(logVariable, "is" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1, methodName.length()) + "Enabled", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            }
            return new TernaryExpression(new BooleanExpression(condition), originalExpression, ConstantExpression.NULL);
        }
    }

    private static class Slf4jLoggingStrategy
    implements LoggingStrategy {
        private Slf4jLoggingStrategy() {
        }

        public FieldNode addLoggerFieldToClass(ClassNode classNode, String logFieldName) {
            return classNode.addField(logFieldName, 154, new ClassNode("org.slf4j.Logger", 1, new ClassNode(Object.class)), new MethodCallExpression((Expression)new ClassExpression(new ClassNode("org.slf4j.LoggerFactory", 1, new ClassNode(Object.class))), "getLogger", (Expression)new ClassExpression(classNode)));
        }

        public boolean isLoggingMethod(String methodName) {
            return methodName.matches("error|warn|info|debug|trace");
        }

        public Expression wrapLoggingMethodCall(Expression logVariable, String methodName, Expression originalExpression) {
            return LogASTTransformation.commonMethodCallExpression(logVariable, methodName, originalExpression);
        }
    }

    private static class JavaUtilLoggingStrategy
    implements LoggingStrategy {
        private JavaUtilLoggingStrategy() {
        }

        public FieldNode addLoggerFieldToClass(ClassNode classNode, String logFieldName) {
            return classNode.addField(logFieldName, 154, new ClassNode("java.util.logging.Logger", 1, new ClassNode(Object.class)), new MethodCallExpression((Expression)new ClassExpression(new ClassNode("java.util.logging.Logger", 1, new ClassNode(Object.class))), "getLogger", (Expression)new ConstantExpression(classNode.getName())));
        }

        public boolean isLoggingMethod(String methodName) {
            return methodName.matches("severe|warning|info|fine|finer|finest");
        }

        public Expression wrapLoggingMethodCall(Expression logVariable, String methodName, Expression originalExpression) {
            ClassNode levelClass = new ClassNode("java.util.logging.Level", 0, ClassHelper.OBJECT_TYPE);
            AttributeExpression logLevelExpression = new AttributeExpression((Expression)new ClassExpression(levelClass), new ConstantExpression(methodName.toUpperCase()));
            ArgumentListExpression args = new ArgumentListExpression();
            args.addExpression(logLevelExpression);
            MethodCallExpression condition = new MethodCallExpression(logVariable, "isLoggable", (Expression)args);
            return new TernaryExpression(new BooleanExpression(condition), originalExpression, ConstantExpression.NULL);
        }
    }

    private static interface LoggingStrategy {
        public FieldNode addLoggerFieldToClass(ClassNode var1, String var2);

        public boolean isLoggingMethod(String var1);

        public Expression wrapLoggingMethodCall(Expression var1, String var2, Expression var3);
    }
}

