/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm;

import groovyjarjarasm.asm.MethodVisitor;
import java.util.ArrayList;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.MethodCaller;
import org.codehaus.groovy.classgen.asm.MethodCallerMultiAdapter;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.OptimizingStatementWriter;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

public class InvocationWriter {
    private static final MethodCallerMultiAdapter invokeMethodOnCurrent = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeMethodOnCurrent", true, false);
    private static final MethodCallerMultiAdapter invokeMethodOnSuper = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeMethodOnSuper", true, false);
    private static final MethodCallerMultiAdapter invokeMethod = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeMethod", true, false);
    private static final MethodCallerMultiAdapter invokeStaticMethod = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeStaticMethod", true, true);
    private static final MethodCaller invokeClosureMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "invokeClosure");
    private WriterController controller;

    public InvocationWriter(WriterController wc) {
        this.controller = wc;
    }

    private void makeInvokeMethodCall(MethodCallExpression call, boolean useSuper, MethodCallerMultiAdapter adapter) {
        Expression objectExpression = call.getObjectExpression();
        CastExpression messageName = new CastExpression(ClassHelper.STRING_TYPE, call.getMethod());
        if (useSuper) {
            ClassNode classNode = this.controller.isInClosure() ? this.controller.getOutermostClass() : this.controller.getClassNode();
            ClassNode superClass = classNode.getSuperClass();
            this.makeCall(call, new ClassExpression(superClass), objectExpression, messageName, call.getArguments(), adapter, call.isSafe(), call.isSpreadSafe(), false);
        } else {
            this.makeCall(call, objectExpression, messageName, call.getArguments(), adapter, call.isSafe(), call.isSpreadSafe(), call.isImplicitThis());
        }
    }

    public void makeCall(Expression origin, Expression receiver, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe, boolean implicitThis) {
        ClassNode cn = this.controller.getClassNode();
        this.makeCall(origin, new ClassExpression(cn), receiver, message, arguments, adapter, safe, spreadSafe, implicitThis);
    }

    private void makeCall(Expression origin, ClassExpression sender, Expression receiver, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe, boolean implicitThis) {
        boolean containsSpreadExpression;
        int numberOfArguments;
        String methodName;
        if (adapter == invokeMethodOnCurrent && this.controller.optimizeForInt && this.controller.isFastPath() && (methodName = this.getMethodName(message)) != null) {
            TupleExpression args;
            ArrayList<Parameter> plist = new ArrayList<Parameter>(16);
            if (arguments instanceof TupleExpression) {
                args = (TupleExpression)arguments;
                for (Expression arg : args.getExpressions()) {
                    plist.add(new Parameter(arg.getType(), ""));
                }
            } else {
                args = new TupleExpression(receiver);
                plist.add(new Parameter(arguments.getType(), ""));
            }
            OptimizingStatementWriter.StatementMeta meta = null;
            if (origin != null) {
                meta = (OptimizingStatementWriter.StatementMeta)origin.getNodeMetaData(OptimizingStatementWriter.StatementMeta.class);
            }
            MethodNode mn = null;
            if (meta != null) {
                mn = meta.target;
            }
            if (mn != null) {
                MethodVisitor mv = this.controller.getMethodVisitor();
                int opcode = 182;
                if (mn.isStatic()) {
                    opcode = 184;
                } else if (mn.isPrivate()) {
                    opcode = 183;
                }
                if (opcode != 184) {
                    mv.visitIntInsn(25, 0);
                }
                for (Expression arg : args.getExpressions()) {
                    arg.visit(this.controller.getAcg());
                    ClassNode type = arg.getType();
                    if (ClassHelper.isPrimitiveType(type)) continue;
                    BytecodeHelper.doCast(mv, type);
                }
                String owner = BytecodeHelper.getClassInternalName(mn.getDeclaringClass());
                String desc = BytecodeHelper.getMethodDescriptor(mn.getReturnType(), mn.getParameters());
                mv.visitMethodInsn(opcode, owner, methodName, desc);
                ClassNode ret = mn.getReturnType().redirect();
                if (ret == ClassHelper.VOID_TYPE) {
                    ret = ClassHelper.OBJECT_TYPE;
                    mv.visitInsn(1);
                }
                this.controller.getOperandStack().replace(ret, args.getExpressions().size());
                return;
            }
        }
        if (!(adapter != invokeMethod && adapter != invokeMethodOnCurrent && adapter != invokeStaticMethod || spreadSafe || (methodName = this.getMethodName(message)) == null)) {
            this.controller.getCallSiteWriter().makeCallSite(receiver, methodName, arguments, safe, implicitThis, adapter == invokeMethodOnCurrent, adapter == invokeStaticMethod);
            return;
        }
        OperandStack operandStack = this.controller.getOperandStack();
        CompileStack compileStack = this.controller.getCompileStack();
        AsmClassGenerator acg = this.controller.getAcg();
        compileStack.pushLHS(false);
        if (adapter == AsmClassGenerator.setProperty) {
            ConstantExpression.NULL.visit(acg);
        } else {
            sender.visit(acg);
        }
        compileStack.pushImplicitThis(implicitThis);
        receiver.visit(acg);
        operandStack.box();
        compileStack.popImplicitThis();
        int operandsToRemove = 2;
        if (message != null) {
            message.visit(acg);
            operandStack.box();
            ++operandsToRemove;
        }
        int n = numberOfArguments = (containsSpreadExpression = AsmClassGenerator.containsSpreadExpression(arguments)) ? -1 : AsmClassGenerator.argumentSize(arguments);
        if (numberOfArguments > 0 || containsSpreadExpression) {
            ArgumentListExpression ae;
            if (arguments instanceof ArgumentListExpression) {
                ae = (ArgumentListExpression)arguments;
            } else if (arguments instanceof TupleExpression) {
                TupleExpression te = (TupleExpression)arguments;
                ae = new ArgumentListExpression(te.getExpressions());
            } else {
                ae = new ArgumentListExpression();
                ae.addExpression(arguments);
            }
            if (containsSpreadExpression) {
                acg.despreadList(ae.getExpressions(), true);
            } else {
                ae.visit(acg);
            }
        } else if (numberOfArguments > 0) {
            operandsToRemove += numberOfArguments;
            TupleExpression te = (TupleExpression)arguments;
            for (int i = 0; i < numberOfArguments; ++i) {
                Expression argument = te.getExpression(i);
                argument.visit(acg);
                operandStack.box();
                if (!(argument instanceof CastExpression)) continue;
                acg.loadWrapper(argument);
            }
        }
        adapter.call(this.controller.getMethodVisitor(), numberOfArguments, safe, spreadSafe);
        compileStack.popLHS();
        operandStack.replace(ClassHelper.OBJECT_TYPE, operandsToRemove);
    }

    private String getMethodName(Expression message) {
        Expression methodExpr;
        CastExpression msg;
        String methodName = null;
        if (message instanceof CastExpression && (msg = (CastExpression)message).getType() == ClassHelper.STRING_TYPE && (methodExpr = msg.getExpression()) instanceof ConstantExpression) {
            methodName = methodExpr.getText();
        }
        if (methodName == null && message instanceof ConstantExpression) {
            ConstantExpression constantExpression = (ConstantExpression)message;
            methodName = constantExpression.getText();
        }
        return methodName;
    }

    public void writeInvokeMethod(MethodCallExpression call) {
        if (this.isClosureCall(call)) {
            this.invokeClosure(call.getArguments(), call.getMethodAsString());
        } else {
            boolean isSuperMethodCall = InvocationWriter.usesSuper(call);
            MethodCallerMultiAdapter adapter = invokeMethod;
            if (AsmClassGenerator.isThisExpression(call.getObjectExpression())) {
                adapter = invokeMethodOnCurrent;
            }
            if (isSuperMethodCall) {
                adapter = invokeMethodOnSuper;
            }
            if (this.isStaticInvocation(call)) {
                adapter = invokeStaticMethod;
            }
            this.makeInvokeMethodCall(call, isSuperMethodCall, adapter);
        }
    }

    private boolean isClosureCall(MethodCallExpression call) {
        ClassNode classNode = this.controller.getClassNode();
        String methodName = call.getMethodAsString();
        if (methodName == null) {
            return false;
        }
        if (!call.isImplicitThis()) {
            return false;
        }
        if (!AsmClassGenerator.isThisExpression(call.getObjectExpression())) {
            return false;
        }
        FieldNode field = classNode.getDeclaredField(methodName);
        if (field == null) {
            return false;
        }
        if (this.isStaticInvocation(call) && !field.isStatic()) {
            return false;
        }
        Expression arguments = call.getArguments();
        return !classNode.hasPossibleMethod(methodName, arguments);
    }

    private void invokeClosure(Expression arguments, String methodName) {
        AsmClassGenerator acg = this.controller.getAcg();
        acg.visitVariableExpression(new VariableExpression(methodName));
        if (arguments instanceof TupleExpression) {
            arguments.visit(acg);
        } else {
            new TupleExpression(arguments).visit(acg);
        }
        invokeClosureMethod.call(this.controller.getMethodVisitor());
        this.controller.getOperandStack().replace(ClassHelper.OBJECT_TYPE);
    }

    private boolean isStaticInvocation(MethodCallExpression call) {
        if (!AsmClassGenerator.isThisExpression(call.getObjectExpression())) {
            return false;
        }
        if (this.controller.isStaticMethod()) {
            return true;
        }
        return this.controller.isStaticContext() && !call.isImplicitThis();
    }

    private static boolean usesSuper(MethodCallExpression call) {
        Expression expression = call.getObjectExpression();
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            String variable = varExp.getName();
            return variable.equals("super");
        }
        return false;
    }

    public void writeInvokeStaticMethod(StaticMethodCallExpression call) {
        this.makeCall(null, new ClassExpression(call.getOwnerType()), new ConstantExpression(call.getMethod()), call.getArguments(), invokeStaticMethod, false, false, false);
    }
}

