/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.asm.BinaryExpressionHelper;
import org.codehaus.groovy.classgen.asm.MethodCaller;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.OptimizingStatementWriter;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.runtime.BytecodeInterface8;

public class BinaryIntExpressionHelper
extends BinaryExpressionHelper {
    private static final MethodCaller intArrayGet = MethodCaller.newStatic(BytecodeInterface8.class, "intArrayGet");
    private static final MethodCaller intArraySet = MethodCaller.newStatic(BytecodeInterface8.class, "intArraySet");
    private WriterController controller;
    private static final int[] stdCompareCodes = new int[]{159, 160, 159, 160, 162, 163, 164, 161};
    private static final int[] stdOperations = new int[]{96, 100, 104, 0, 108, 112};
    private static final int[] bitOp = new int[]{128, 126, 130};
    public static final int LEFT_SHIFT = 280;
    public static final int RIGHT_SHIFT = 281;
    public static final int RIGHT_SHIFT_UNSIGNED = 282;
    private static final int[] shiftOp = new int[]{120, 122, 124};

    public BinaryIntExpressionHelper(WriterController wc) {
        super(wc);
        this.controller = wc;
    }

    protected static ClassNode getType(Expression exp, ClassNode current) {
        OptimizingStatementWriter.StatementMeta meta = (OptimizingStatementWriter.StatementMeta)exp.getNodeMetaData(OptimizingStatementWriter.StatementMeta.class);
        ClassNode type = null;
        if (meta != null) {
            type = meta.type;
        }
        if (type != null) {
            return type;
        }
        if (exp instanceof VariableExpression) {
            FieldNode fn;
            VariableExpression ve = (VariableExpression)exp;
            if (ve.isClosureSharedVariable()) {
                return ve.getType();
            }
            type = ve.getOriginType();
            if (ve.getAccessedVariable() instanceof FieldNode && !(fn = (FieldNode)ve.getAccessedVariable()).getDeclaringClass().equals(current)) {
                return ClassHelper.OBJECT_TYPE;
            }
        } else if (exp instanceof Variable) {
            Variable v = (Variable)((Object)exp);
            type = v.getOriginType();
        } else {
            type = exp.getType();
        }
        return type.redirect();
    }

    protected static boolean isIntOperand(Expression exp, ClassNode current) {
        return BinaryIntExpressionHelper.getType(exp, current) == ClassHelper.int_TYPE;
    }

    protected void evaluateCompareExpression(MethodCaller compareMethod, BinaryExpression binExp) {
        int type = binExp.getOperation().getType();
        Expression left = binExp.getLeftExpression();
        boolean leftIsInt = BinaryIntExpressionHelper.isIntOperand(left, this.controller.getClassNode());
        Expression right = binExp.getRightExpression();
        boolean rightIsInt = BinaryIntExpressionHelper.isIntOperand(right, this.controller.getClassNode());
        if (leftIsInt && rightIsInt && this.writeIntXInt(type, true)) {
            left.visit(this.controller.getAcg());
            right.visit(this.controller.getAcg());
            this.writeIntXInt(type, false);
        } else {
            super.evaluateCompareExpression(compareMethod, binExp);
        }
    }

    protected void evaluateBinaryExpression(String message, BinaryExpression binExp) {
        int type = binExp.getOperation().getType();
        Expression left = binExp.getLeftExpression();
        boolean leftIsInt = BinaryIntExpressionHelper.isIntOperand(left, this.controller.getClassNode());
        Expression right = binExp.getRightExpression();
        boolean rightIsInt = BinaryIntExpressionHelper.isIntOperand(right, this.controller.getClassNode());
        OperandStack operandStack = this.controller.getOperandStack();
        if (leftIsInt && rightIsInt && this.writeIntXInt(type, true)) {
            left.visit(this.controller.getAcg());
            operandStack.doGroovyCast(ClassHelper.int_TYPE);
            right.visit(this.controller.getAcg());
            operandStack.doGroovyCast(ClassHelper.int_TYPE);
            this.writeIntXInt(type, false);
            return;
        }
        if (rightIsInt && type == 30 && BinaryIntExpressionHelper.getType(left, this.controller.getClassNode()).getComponentType() == ClassHelper.int_TYPE) {
            left.visit(this.controller.getAcg());
            operandStack.doGroovyCast(BinaryIntExpressionHelper.getType(left, this.controller.getClassNode()));
            right.visit(this.controller.getAcg());
            operandStack.doGroovyCast(ClassHelper.int_TYPE);
            MethodVisitor mv = this.controller.getMethodVisitor();
            intArrayGet.call(mv);
            operandStack.replace(ClassHelper.int_TYPE, 2);
        } else {
            super.evaluateBinaryExpression(message, binExp);
        }
    }

    protected void assignToArray(Expression orig, Expression receiver, Expression index, Expression rhsValueLoader) {
        if (OptimizingStatementWriter.shouldOptimize(orig)) {
            OperandStack operandStack = this.controller.getOperandStack();
            MethodVisitor mv = this.controller.getMethodVisitor();
            receiver.visit(this.controller.getAcg());
            index.visit(this.controller.getAcg());
            operandStack.doGroovyCast(ClassHelper.int_TYPE);
            rhsValueLoader.visit(this.controller.getAcg());
            operandStack.doGroovyCast(ClassHelper.int_TYPE);
            intArraySet.call(mv);
            operandStack.remove(3);
            rhsValueLoader.visit(this.controller.getAcg());
        } else {
            super.assignToArray(orig, receiver, index, rhsValueLoader);
        }
    }

    private boolean writeStdCompare(int type, boolean simulate) {
        if ((type -= 120) < 0 || type > 7) {
            return false;
        }
        if (!simulate) {
            MethodVisitor mv = this.controller.getMethodVisitor();
            OperandStack operandStack = this.controller.getOperandStack();
            int bytecode = stdCompareCodes[type];
            Label l1 = new Label();
            mv.visitJumpInsn(bytecode, l1);
            mv.visitInsn(4);
            Label l2 = new Label();
            mv.visitJumpInsn(167, l2);
            mv.visitLabel(l1);
            mv.visitInsn(3);
            mv.visitLabel(l2);
            operandStack.replace(ClassHelper.boolean_TYPE, 2);
        }
        return true;
    }

    private boolean writeSpaceship(int type, boolean simulate) {
        if (type != 128) {
            return false;
        }
        if (!simulate) {
            MethodVisitor mv = this.controller.getMethodVisitor();
            mv.visitInsn(92);
            Label l1 = new Label();
            mv.visitJumpInsn(162, l1);
            mv.visitInsn(88);
            mv.visitInsn(2);
            Label l2 = new Label();
            mv.visitJumpInsn(167, l2);
            mv.visitLabel(l1);
            Label l3 = new Label();
            mv.visitJumpInsn(160, l3);
            mv.visitInsn(3);
            mv.visitJumpInsn(167, l2);
            mv.visitLabel(l3);
            mv.visitInsn(4);
            this.controller.getOperandStack().replace(ClassHelper.int_TYPE, 2);
        }
        return true;
    }

    private boolean writeStdOperators(int type, boolean simulate) {
        if ((type -= 200) < 0 || type > 5 || type == 3) {
            return false;
        }
        if (!simulate) {
            int bytecode = stdOperations[type];
            this.controller.getMethodVisitor().visitInsn(bytecode);
            this.controller.getOperandStack().replace(ClassHelper.int_TYPE, 2);
        }
        return true;
    }

    private boolean writeBitwiseOp(int type, boolean simulate) {
        if ((type -= 340) < 0 || type > 2) {
            return false;
        }
        if (!simulate) {
            int bytecode = bitOp[type];
            this.controller.getMethodVisitor().visitInsn(bytecode);
            this.controller.getOperandStack().replace(ClassHelper.int_TYPE, 2);
        }
        return true;
    }

    private boolean writeShiftOp(int type, boolean simulate) {
        if ((type -= 280) < 0 || type > 2) {
            return false;
        }
        if (!simulate) {
            int bytecode = shiftOp[type];
            this.controller.getMethodVisitor().visitInsn(bytecode);
            this.controller.getOperandStack().replace(ClassHelper.int_TYPE, 2);
        }
        return true;
    }

    private boolean writeIntXInt(int type, boolean simulate) {
        return this.writeStdCompare(type, simulate) || this.writeSpaceship(type, simulate) || this.writeStdOperators(type, simulate) || this.writeBitwiseOp(type, simulate) || this.writeShiftOp(type, simulate);
    }
}

