/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class StaticTypesTransformation
implements ASTTransformation {
    public void visit(ASTNode[] nodes, SourceUnit source) {
        AnnotatedNode node = (AnnotatedNode)nodes[1];
        Visitor visitor = new Visitor(source, (ClassNode)node);
        if (node instanceof ClassNode) {
            visitor.visitClass((ClassNode)node);
        } else {
            node.visit(visitor);
        }
    }

    private static String getOperationName(int op) {
        switch (op) {
            case 120: 
            case 123: {
                return "equals";
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                return "compareTo";
            }
            case 341: 
            case 351: {
                return "and";
            }
            case 340: 
            case 350: {
                return "or";
            }
            case 342: 
            case 352: {
                return "xor";
            }
            case 200: 
            case 210: {
                return "plus";
            }
            case 201: 
            case 211: {
                return "minus";
            }
            case 202: 
            case 212: {
                return "multiply";
            }
            case 203: 
            case 213: {
                return "div";
            }
            case 204: 
            case 214: {
                return "intdiv";
            }
            case 205: 
            case 215: {
                return "mod";
            }
            case 206: 
            case 216: {
                return "power";
            }
            case 280: 
            case 285: {
                return "leftShift";
            }
            case 281: 
            case 286: {
                return "rightShift";
            }
            case 282: 
            case 287: {
                return "rightShiftUnsigned";
            }
            case 573: {
                return "isCase";
            }
        }
        return null;
    }

    private static class Visitor
    extends ClassCodeVisitorSupport {
        private static final ClassNode Collection_TYPE = ClassHelper.makeWithoutCaching(Collection.class);
        private static final ClassNode Number_TYPE = ClassHelper.makeWithoutCaching(Number.class);
        private static final ClassNode Matcher_TYPE = ClassHelper.makeWithoutCaching(Matcher.class);
        private static final ClassNode ArrayList_TYPE = ClassHelper.makeWithoutCaching(ArrayList.class);
        private SourceUnit source;
        private ClassNode classNode;

        public Visitor(SourceUnit source, ClassNode cn) {
            this.source = source;
            this.classNode = cn;
        }

        protected SourceUnit getSourceUnit() {
            return this.source;
        }

        public void visitVariableExpression(VariableExpression vexp) {
            super.visitVariableExpression(vexp);
            if (vexp != VariableExpression.THIS_EXPRESSION && vexp != VariableExpression.SUPER_EXPRESSION) {
                if (vexp.getName().equals("this")) {
                    this.storeType(vexp, this.classNode);
                }
                if (vexp.getName().equals("super")) {
                    this.storeType(vexp, this.classNode.getSuperClass());
                }
            }
        }

        public void visitBinaryExpression(BinaryExpression expression) {
            super.visitBinaryExpression(expression);
            ClassNode lType = Visitor.getType(expression.getLeftExpression(), this.classNode);
            ClassNode rType = Visitor.getType(expression.getRightExpression(), this.classNode);
            int op = expression.getOperation().getType();
            ClassNode resultType = this.getResultType(lType, op, rType, expression);
            if (resultType == null) {
                this.addError("tbd...", expression);
                resultType = lType;
            }
            this.storeType(expression, resultType);
            if (!Visitor.isAssignment(op)) {
                return;
            }
            this.checkCompatibleAssignmenTypes(lType, resultType, expression);
        }

        public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
            ClassNode resultType;
            super.visitBitwiseNegationExpression(expression);
            ClassNode type = Visitor.getType(expression, this.classNode);
            ClassNode typeRe = type.redirect();
            if (WideningCategories.isBigIntCategory(typeRe)) {
                resultType = type;
            } else if (typeRe == ClassHelper.STRING_TYPE || typeRe == ClassHelper.GSTRING_TYPE) {
                resultType = ClassHelper.PATTERN_TYPE;
            } else if (typeRe == ArrayList_TYPE) {
                resultType = ArrayList_TYPE;
            } else {
                MethodNode mn = this.findMethodOrFail(expression, type, "bitwiseNegate", new ClassNode[0]);
                resultType = mn.getReturnType();
            }
            this.storeType(expression, resultType);
        }

        public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
            super.visitUnaryPlusExpression(expression);
            this.negativeOrPositiveUnary(expression, "positive");
        }

        public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
            super.visitUnaryMinusExpression(expression);
            this.negativeOrPositiveUnary(expression, "negative");
        }

        private void negativeOrPositiveUnary(Expression expression, String name) {
            ClassNode resultType;
            ClassNode type = Visitor.getType(expression, this.classNode);
            ClassNode typeRe = type.redirect();
            if (WideningCategories.isBigDecCategory(typeRe)) {
                resultType = type;
            } else if (typeRe == ArrayList_TYPE) {
                resultType = ArrayList_TYPE;
            } else {
                MethodNode mn = this.findMethodOrFail(expression, type, name, new ClassNode[0]);
                resultType = mn.getReturnType();
            }
            this.storeType(expression, resultType);
        }

        public void visitConstructorCallExpression(ConstructorCallExpression call) {
            super.visitConstructorCallExpression(call);
            ClassNode[] args = Visitor.getArgumentTypes(InvocationWriter.makeArgumentList(call.getArguments()), this.classNode);
            this.findMethodOrFail(call, this.classNode, "init", args);
        }

        private static ClassNode[] getArgumentTypes(ArgumentListExpression args, ClassNode current) {
            List<Expression> arglist = args.getExpressions();
            ClassNode[] ret = new ClassNode[arglist.size()];
            int i = 0;
            for (Expression exp : arglist) {
                ret[i] = Visitor.getType(exp, current);
                ++i;
            }
            return ret;
        }

        public void visitMethodCallExpression(MethodCallExpression call) {
            super.visitMethodCallExpression(call);
            if (call.getMethodAsString() == null) {
                this.addError("cannot resolve dynamic method name at compile time.", call.getMethod());
            } else {
                ClassNode[] args = Visitor.getArgumentTypes(InvocationWriter.makeArgumentList(call.getArguments()), this.classNode);
                MethodNode mn = this.findMethodOrFail(call, Visitor.getType(call.getObjectExpression(), this.classNode), call.getMethodAsString(), args);
                if (mn == null) {
                    return;
                }
                this.storeType(call, mn.getReturnType());
            }
        }

        private void storeType(Expression exp, ClassNode cn) {
            exp.setNodeMetaData(StaticTypesMarker.class, cn);
        }

        private ClassNode getResultType(ClassNode left, int op, ClassNode right, BinaryExpression expr) {
            String operationName;
            MethodNode method;
            ClassNode leftRedirect = left.redirect();
            ClassNode rightRedirect = right.redirect();
            if (op == 100) {
                this.checkCompatibleAssignmenTypes(leftRedirect, rightRedirect, expr);
                return left;
            }
            if (Visitor.isBoolIntrinsicOp(op)) {
                return ClassHelper.boolean_TYPE;
            }
            if (!Visitor.isArrayOp(op)) {
                if (op == 90) {
                    return Matcher_TYPE;
                }
                if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect)) {
                    if (Visitor.isOperationInGroup(op)) {
                        if (WideningCategories.isIntCategory(leftRedirect) && WideningCategories.isIntCategory(rightRedirect)) {
                            return ClassHelper.int_TYPE;
                        }
                        if (WideningCategories.isLongCategory(leftRedirect) && WideningCategories.isLongCategory(rightRedirect)) {
                            return ClassHelper.Long_TYPE;
                        }
                        if (WideningCategories.isBigIntCategory(leftRedirect) && WideningCategories.isBigIntCategory(rightRedirect)) {
                            return ClassHelper.BigInteger_TYPE;
                        }
                        if (WideningCategories.isBigDecCategory(leftRedirect) && WideningCategories.isBigDecCategory(rightRedirect)) {
                            return ClassHelper.BigDecimal_TYPE;
                        }
                        if (WideningCategories.isDoubleCategory(leftRedirect) && WideningCategories.isDoubleCategory(rightRedirect)) {
                            return ClassHelper.double_TYPE;
                        }
                    } else {
                        if (Visitor.isPowerOperator(op)) {
                            return Number_TYPE;
                        }
                        if (Visitor.isBitOperator(op)) {
                            if (WideningCategories.isIntCategory(leftRedirect) && WideningCategories.isIntCategory(rightRedirect)) {
                                return ClassHelper.int_TYPE;
                            }
                            if (WideningCategories.isLongCategory(leftRedirect) && WideningCategories.isLongCategory(rightRedirect)) {
                                return ClassHelper.Long_TYPE;
                            }
                            if (WideningCategories.isBigIntCategory(leftRedirect) && WideningCategories.isBigIntCategory(rightRedirect)) {
                                return ClassHelper.BigInteger_TYPE;
                            }
                        }
                    }
                }
            }
            if ((method = this.findMethodOrFail(expr, leftRedirect, operationName = StaticTypesTransformation.getOperationName(op), leftRedirect, rightRedirect)) != null) {
                if (Visitor.isCompareToBoolean(op)) {
                    return ClassHelper.boolean_TYPE;
                }
                if (op == 128) {
                    return ClassHelper.int_TYPE;
                }
                return method.getReturnType();
            }
            return null;
        }

        private MethodNode findMethodOrFail(Expression expr, ClassNode receiver, String name, ClassNode ... args) {
            List<MethodNode> methods = receiver.getMethods(name);
            for (MethodNode m : methods) {
                Parameter[] params = m.getParameters();
                if (params.length == args.length) {
                    if (!Visitor.allParametersAndArgumentsMatch(params, args) && !Visitor.lastArgMatchesVarg(params, args)) continue;
                    return m;
                }
                if (!Visitor.isVargs(params)) continue;
                if (params.length == args.length + 1) {
                    return m;
                }
                if (params.length >= args.length || !Visitor.excessArgumentsMatchesVargsParameter(params, args)) continue;
                return m;
            }
            this.addError("Cannot find matching method " + name, expr);
            return null;
        }

        private static boolean allParametersAndArgumentsMatch(Parameter[] params, ClassNode[] args) {
            for (int i = 0; i < params.length; ++i) {
                if (Visitor.isAssignableTo(params[i].getType(), args[i])) continue;
                return false;
            }
            return true;
        }

        private static boolean excessArgumentsMatchesVargsParameter(Parameter[] params, ClassNode[] args) {
            ClassNode vargsBase = params[params.length - 1].getType().getComponentType();
            for (int i = params.length; i < args.length; ++i) {
                if (Visitor.isAssignableTo(vargsBase, args[i])) continue;
                return false;
            }
            return true;
        }

        private static boolean lastArgMatchesVarg(Parameter[] params, ClassNode ... args) {
            if (!Visitor.isVargs(params)) {
                return false;
            }
            ClassNode ptype = params[params.length - 1].getType().getComponentType();
            ClassNode arg = args[args.length - 1];
            return Visitor.isAssignableTo(ptype, arg);
        }

        private static boolean isAssignableTo(ClassNode toBeAssignedTo, ClassNode type) {
            if (toBeAssignedTo.isDerivedFrom(type)) {
                return true;
            }
            if (toBeAssignedTo.redirect() == ClassHelper.STRING_TYPE && type.redirect() == ClassHelper.GSTRING_TYPE) {
                return true;
            }
            toBeAssignedTo = ClassHelper.getWrapper(toBeAssignedTo);
            type = ClassHelper.getWrapper(type);
            if (toBeAssignedTo.isDerivedFrom(Number_TYPE) && type.isDerivedFrom(Number_TYPE)) {
                return true;
            }
            return toBeAssignedTo.isInterface() && type.implementsInterface(toBeAssignedTo);
        }

        private static boolean isVargs(Parameter[] params) {
            if (params.length == 0) {
                return false;
            }
            return params[params.length - 1].getType().isArray();
        }

        private static boolean isCompareToBoolean(int op) {
            return op == 126 || op == 127 || op == 124 || op == 125;
        }

        private static boolean isArrayOp(int op) {
            return op == 30;
        }

        private static boolean isBoolIntrinsicOp(int op) {
            return op == 164 || op == 162 || op == 94 || op == 544;
        }

        private static boolean isPowerOperator(int op) {
            return op == 206 || op == 216;
        }

        private static boolean isOperationInGroup(int op) {
            switch (op) {
                case 200: 
                case 201: 
                case 202: 
                case 210: 
                case 211: 
                case 212: {
                    return true;
                }
            }
            return false;
        }

        private static boolean isBitOperator(int op) {
            switch (op) {
                case 340: 
                case 341: 
                case 342: 
                case 350: 
                case 351: 
                case 352: {
                    return true;
                }
            }
            return false;
        }

        private static boolean isAssignment(int op) {
            switch (op) {
                case 100: 
                case 166: 
                case 168: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 285: 
                case 286: 
                case 287: 
                case 350: 
                case 351: 
                case 352: {
                    return true;
                }
            }
            return false;
        }

        private static ClassNode getType(Expression exp, ClassNode current) {
            ClassNode cn = (ClassNode)exp.getNodeMetaData(StaticTypesMarker.class);
            if (cn != null) {
                return cn;
            }
            if (exp instanceof VariableExpression) {
                VariableExpression vexp = (VariableExpression)exp;
                if (vexp == VariableExpression.THIS_EXPRESSION) {
                    return current;
                }
                if (vexp == VariableExpression.SUPER_EXPRESSION) {
                    return current.getSuperClass();
                }
            }
            return exp.getType();
        }

        private void checkCompatibleAssignmenTypes(ClassNode left, ClassNode right, Expression expr) {
            ClassNode leftRedirect = left.redirect();
            ClassNode rightRedirect = right.redirect();
            if (leftRedirect == ClassHelper.OBJECT_TYPE || leftRedirect == ClassHelper.STRING_TYPE || leftRedirect == ClassHelper.boolean_TYPE || leftRedirect == ClassHelper.Boolean_TYPE || leftRedirect == ClassHelper.CLASS_Type) {
                return;
            }
            if (leftRedirect.isDerivedFrom(ClassHelper.Enum_Type) && (rightRedirect == ClassHelper.GSTRING_TYPE || rightRedirect == ClassHelper.STRING_TYPE)) {
                return;
            }
            if (rightRedirect.implementsInterface(ClassHelper.MAP_TYPE) || rightRedirect.implementsInterface(Collection_TYPE) || rightRedirect.isArray()) {
                return;
            }
            if (right.isDerivedFrom(left) || left.implementsInterface(right)) {
                return;
            }
            if (ClassHelper.isPrimitiveType(leftRedirect) && ClassHelper.isPrimitiveType(rightRedirect)) {
                return;
            }
            if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect)) {
                return;
            }
            this.addError("Cannot assign value of type " + right + " to variable of type " + left, expr);
        }
    }

    public static final class StaticTypesMarker {
    }
}

