/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsType
extends ASTNode {
    private final ClassNode[] upperBounds;
    private final ClassNode lowerBound;
    private ClassNode type;
    private String name;
    private boolean placeholder;
    private boolean resolved;
    private boolean wildcard;

    public GenericsType(ClassNode type, ClassNode[] upperBounds, ClassNode lowerBound) {
        this.type = type;
        this.name = type.isGenericsPlaceHolder() ? type.getUnresolvedName() : type.getName();
        this.upperBounds = upperBounds;
        this.lowerBound = lowerBound;
        this.placeholder = type.isGenericsPlaceHolder();
        this.resolved = false;
    }

    public GenericsType(ClassNode basicType) {
        this(basicType, null, null);
    }

    public ClassNode getType() {
        return this.type;
    }

    public void setType(ClassNode type) {
        this.type = type;
    }

    public String toString() {
        HashSet<String> visited = new HashSet<String>();
        return this.toString(visited);
    }

    private String toString(Set<String> visited) {
        String ret;
        if (this.placeholder) {
            visited.add(this.name);
        }
        String string = ret = this.type == null || this.placeholder || this.wildcard ? this.name : this.genericsBounds(this.type, visited);
        if (this.upperBounds != null) {
            ret = ret + " extends ";
            for (int i = 0; i < this.upperBounds.length; ++i) {
                ret = ret + this.genericsBounds(this.upperBounds[i], visited);
                if (i + 1 >= this.upperBounds.length) continue;
                ret = ret + " & ";
            }
        } else if (this.lowerBound != null) {
            ret = ret + " super " + this.genericsBounds(this.lowerBound, visited);
        }
        return ret;
    }

    private String genericsBounds(ClassNode theType, Set<String> visited) {
        String ret = theType.isArray() ? theType.getComponentType().getName() + "[]" : theType.getName();
        GenericsType[] genericsTypes = theType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length == 0) {
            return ret;
        }
        if (genericsTypes.length == 1 && genericsTypes[0].isPlaceholder() && theType.getName().equals("java.lang.Object")) {
            return genericsTypes[0].getName();
        }
        ret = ret + "<";
        for (int i = 0; i < genericsTypes.length; ++i) {
            GenericsType type;
            if (i != 0) {
                ret = ret + ", ";
            }
            ret = (type = genericsTypes[i]).isPlaceholder() && visited.contains(type.getName()) ? ret + type.getName() : ret + type.toString(visited);
        }
        ret = ret + ">";
        return ret;
    }

    public ClassNode[] getUpperBounds() {
        return this.upperBounds;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
        this.type.setGenericsPlaceHolder(placeholder);
    }

    public boolean isResolved() {
        return this.resolved || this.placeholder;
    }

    public void setResolved(boolean res) {
        this.resolved = res;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }

    public ClassNode getLowerBound() {
        return this.lowerBound;
    }

    public boolean isCompatibleWith(ClassNode classNode) {
        return new GenericsTypeMatcher().matches(classNode);
    }

    private class GenericsTypeMatcher {
        private GenericsTypeMatcher() {
        }

        public boolean implementsInterfaceOrIsSubclassOf(ClassNode type, ClassNode superOrInterface) {
            boolean result;
            boolean bl = result = type.equals(superOrInterface) || type.isDerivedFrom(superOrInterface) || type.implementsInterface(superOrInterface);
            if (result) {
                return true;
            }
            if (superOrInterface instanceof WideningCategories.LowestUpperBoundClassNode) {
                WideningCategories.LowestUpperBoundClassNode cn = (WideningCategories.LowestUpperBoundClassNode)superOrInterface;
                result = this.implementsInterfaceOrIsSubclassOf(type, cn.getSuperClass());
                if (result) {
                    ClassNode interfaceNode;
                    ClassNode[] arr$ = cn.getInterfaces();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (result = this.implementsInterfaceOrIsSubclassOf(type, interfaceNode = arr$[i$])); ++i$) {
                    }
                }
                if (result) {
                    return true;
                }
            }
            if (type.isArray() && superOrInterface.isArray()) {
                return this.implementsInterfaceOrIsSubclassOf(type.getComponentType(), superOrInterface.getComponentType());
            }
            return false;
        }

        public boolean matches(ClassNode classNode) {
            if (classNode.isGenericsPlaceHolder()) {
                GenericsType[] genericsTypes = classNode.getGenericsTypes();
                if (genericsTypes == null) {
                    return true;
                }
                if (GenericsType.this.isWildcard()) {
                    if (GenericsType.this.lowerBound != null) {
                        return genericsTypes[0].getName().equals(GenericsType.this.lowerBound.getUnresolvedName());
                    }
                    if (GenericsType.this.upperBounds != null) {
                        for (ClassNode upperBound : GenericsType.this.upperBounds) {
                            if (!genericsTypes[0].getName().equals(upperBound.getUnresolvedName())) continue;
                            return true;
                        }
                        return false;
                    }
                }
                return genericsTypes[0].getName().equals(GenericsType.this.name);
            }
            if (GenericsType.this.wildcard || GenericsType.this.placeholder) {
                if (GenericsType.this.upperBounds != null) {
                    boolean upIsOk = true;
                    int upperBoundsLength = GenericsType.this.upperBounds.length;
                    for (int i = 0; i < upperBoundsLength && upIsOk; ++i) {
                        ClassNode upperBound = GenericsType.this.upperBounds[i];
                        upIsOk = this.implementsInterfaceOrIsSubclassOf(classNode, upperBound);
                    }
                    upIsOk = upIsOk && this.checkGenerics(classNode);
                    return upIsOk;
                }
                if (GenericsType.this.lowerBound != null) {
                    return this.implementsInterfaceOrIsSubclassOf(GenericsType.this.lowerBound, classNode) && this.checkGenerics(classNode);
                }
            }
            if (GenericsType.this.type != null && !GenericsType.this.type.equals(classNode)) {
                return false;
            }
            return GenericsType.this.type == null || this.compareGenericsWithBound(classNode, GenericsType.this.type);
        }

        private boolean checkGenerics(ClassNode classNode) {
            if (GenericsType.this.upperBounds != null) {
                for (ClassNode upperBound : GenericsType.this.upperBounds) {
                    if (this.compareGenericsWithBound(classNode, upperBound)) continue;
                    return false;
                }
            }
            return GenericsType.this.lowerBound == null || GenericsType.this.lowerBound.redirect().isUsingGenerics() || this.compareGenericsWithBound(classNode, GenericsType.this.lowerBound);
        }

        private boolean compareGenericsWithBound(ClassNode classNode, ClassNode bound) {
            if (classNode == null) {
                return false;
            }
            if (!bound.isUsingGenerics()) {
                return true;
            }
            if (!classNode.equals(bound)) {
                if (bound.isInterface()) {
                    Set<ClassNode> interfaces = classNode.getAllInterfaces();
                    for (ClassNode anInterface : interfaces) {
                        if (!anInterface.equals(bound)) continue;
                        ClassNode node = GenericsUtils.parameterizeInterfaceGenerics(classNode, anInterface);
                        return this.compareGenericsWithBound(node, bound);
                    }
                }
                if (bound instanceof WideningCategories.LowestUpperBoundClassNode) {
                    boolean success = this.compareGenericsWithBound(classNode, bound.getSuperClass());
                    if (success) {
                        ClassNode[] interfaces;
                        for (ClassNode anInterface : interfaces = bound.getInterfaces()) {
                            success &= this.compareGenericsWithBound(classNode, anInterface);
                        }
                    }
                    if (success) {
                        return true;
                    }
                }
                return this.compareGenericsWithBound(classNode.getUnresolvedSuperClass(), bound);
            }
            GenericsType[] cnTypes = classNode.getGenericsTypes();
            if (cnTypes == null && classNode.isRedirectNode()) {
                cnTypes = classNode.redirect().getGenericsTypes();
            }
            if (cnTypes == null) {
                return true;
            }
            GenericsType[] redirectBoundGenericTypes = bound.redirect().getGenericsTypes();
            Map<String, GenericsType> classNodePlaceholders = GenericsUtils.extractPlaceholders(classNode);
            Map<String, GenericsType> boundPlaceHolders = GenericsUtils.extractPlaceholders(bound);
            boolean match = true;
            for (int i = 0; i < redirectBoundGenericTypes.length && match; ++i) {
                String name;
                GenericsType redirectBoundType = redirectBoundGenericTypes[i];
                GenericsType classNodeType = cnTypes[i];
                if (classNodeType.isPlaceholder()) {
                    if (redirectBoundType.isPlaceholder()) {
                        match = classNodeType.getName().equals(redirectBoundType.getName());
                        continue;
                    }
                    name = classNodeType.getName();
                    if (classNodePlaceholders.containsKey(name)) {
                        classNodeType = classNodePlaceholders.get(name);
                    }
                    match = classNodeType.isCompatibleWith(redirectBoundType.getType());
                    continue;
                }
                if (redirectBoundType.isPlaceholder()) {
                    if (classNodeType.isPlaceholder()) {
                        match = classNodeType.getName().equals(redirectBoundType.getName());
                        continue;
                    }
                    name = redirectBoundType.getName();
                    if (boundPlaceHolders.containsKey(name)) {
                        redirectBoundType = boundPlaceHolders.get(name);
                        boolean wildcard = redirectBoundType.isWildcard();
                        boolean placeholder = redirectBoundType.isPlaceholder();
                        if (placeholder || wildcard) {
                            if (wildcard) {
                                if (redirectBoundType.lowerBound != null) {
                                    GenericsType gt = new GenericsType(redirectBoundType.lowerBound);
                                    if (gt.isPlaceholder() && classNodePlaceholders.containsKey(gt.getName())) {
                                        gt = classNodePlaceholders.get(gt.getName());
                                    }
                                    match = this.implementsInterfaceOrIsSubclassOf(gt.getType(), classNodeType.getType());
                                }
                                if (match && redirectBoundType.upperBounds != null) {
                                    for (ClassNode upperBound : redirectBoundType.upperBounds) {
                                        GenericsType gt = new GenericsType(upperBound);
                                        if (gt.isPlaceholder() && classNodePlaceholders.containsKey(gt.getName())) {
                                            gt = classNodePlaceholders.get(gt.getName());
                                        }
                                        match = match && this.implementsInterfaceOrIsSubclassOf(classNodeType.getType(), gt.getType());
                                    }
                                }
                                return match;
                            }
                            redirectBoundType = classNodePlaceholders.get(name);
                        }
                    }
                    match = redirectBoundType.isCompatibleWith(classNodeType.getType());
                    continue;
                }
                match = classNodeType.isCompatibleWith(redirectBoundType.getType());
            }
            return match;
        }
    }
}

