/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.sc;

import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.CallSiteWriter;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.TypeChooser;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.classgen.asm.sc.StaticInvocationWriter;
import org.codehaus.groovy.classgen.asm.sc.StaticTypesWriterController;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class StaticTypesCallSiteWriter
extends CallSiteWriter
implements Opcodes {
    private static final MethodNode GROOVYOBJECT_GETPROPERTY_METHOD = ClassHelper.GROOVY_OBJECT_TYPE.getMethod("getProperty", new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "propertyName")});
    private static final ClassNode COLLECTION_TYPE = ClassHelper.make(Collection.class);
    private static final MethodNode COLLECTION_SIZE_METHOD = COLLECTION_TYPE.getMethod("size", Parameter.EMPTY_ARRAY);
    private WriterController controller;

    public StaticTypesCallSiteWriter(StaticTypesWriterController controller) {
        super(controller);
        this.controller = controller;
    }

    public void generateCallSiteArray() {
    }

    public void makeCallSite(Expression receiver, String message, Expression arguments, boolean safe, boolean implicitThis, boolean callCurrent, boolean callStatic) {
    }

    public void makeGetPropertySite(Expression receiver, String methodName, boolean safe, boolean implicitThis) {
        Variable variable;
        TypeChooser typeChooser = this.controller.getTypeChooser();
        ClassNode classNode = this.controller.getClassNode();
        ClassNode receiverType = typeChooser.resolveType(receiver, classNode);
        Object type = receiver.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (type == null && receiver instanceof VariableExpression && (variable = ((VariableExpression)receiver).getAccessedVariable()) instanceof Expression) {
            type = ((Expression)((Object)variable)).getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        }
        if (type != null) {
            receiverType = (ClassNode)type;
        }
        boolean isClassReceiver = false;
        if (receiverType.equals(ClassHelper.CLASS_Type) && receiverType.getGenericsTypes() != null && !receiverType.getGenericsTypes()[0].isPlaceholder()) {
            isClassReceiver = true;
            receiverType = receiverType.getGenericsTypes()[0].getType();
        }
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (receiverType.isArray() && methodName.equals("length")) {
            receiver.visit(this.controller.getAcg());
            mv.visitInsn(190);
            this.controller.getOperandStack().replace(ClassHelper.int_TYPE);
            return;
        }
        if (receiverType.implementsInterface(COLLECTION_TYPE) && ("size".equals(methodName) || "length".equals(methodName))) {
            MethodCallExpression expr = new MethodCallExpression(receiver, "size", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            expr.setMethodTarget(COLLECTION_SIZE_METHOD);
            expr.setImplicitThis(implicitThis);
            expr.visit(this.controller.getAcg());
            return;
        }
        if (this.makeGetField(receiver, receiverType, methodName, implicitThis, StaticTypesCallSiteWriter.samePackages(receiverType.getPackageName(), classNode.getPackageName()))) {
            return;
        }
        if (this.makeGetPropertyWithGetter(receiver, receiverType, methodName)) {
            return;
        }
        if (receiverType.isEnum()) {
            mv.visitFieldInsn(178, BytecodeHelper.getClassInternalName(receiverType), methodName, BytecodeHelper.getTypeDescription(receiverType));
            this.controller.getOperandStack().push(receiverType);
            return;
        }
        if (receiver instanceof ClassExpression) {
            if (this.makeGetField(receiver, receiver.getType(), methodName, implicitThis, StaticTypesCallSiteWriter.samePackages(receiver.getType().getPackageName(), classNode.getPackageName()))) {
                return;
            }
            if (this.makeGetPropertyWithGetter(receiver, receiver.getType(), methodName)) {
                return;
            }
        }
        if (isClassReceiver) {
            if (this.makeGetField(receiver, ClassHelper.CLASS_Type, methodName, false, true)) {
                return;
            }
            if (this.makeGetPropertyWithGetter(receiver, ClassHelper.CLASS_Type, methodName)) {
                return;
            }
        }
        if (this.makeGetPrivateFieldWithBridgeMethod(receiver, receiverType, methodName, implicitThis)) {
            return;
        }
        this.controller.getSourceUnit().addError(new SyntaxException("Access to " + (receiver instanceof ClassExpression ? receiver.getType() : receiverType).toString(false) + "#" + methodName + " is forbidden", receiver.getLineNumber(), receiver.getColumnNumber()));
        this.controller.getMethodVisitor().visitInsn(1);
        this.controller.getOperandStack().push(ClassHelper.OBJECT_TYPE);
    }

    private boolean makeGetPrivateFieldWithBridgeMethod(Expression receiver, ClassNode receiverType, String fieldName, boolean implicitThis) {
        MethodNode methodNode;
        Map accessors;
        FieldNode field = receiverType.getField(fieldName);
        ClassNode classNode = this.controller.getClassNode();
        if (field != null && Modifier.isPrivate(field.getModifiers()) && (StaticInvocationWriter.isPrivateBridgeMethodsCallAllowed(receiverType, classNode) || StaticInvocationWriter.isPrivateBridgeMethodsCallAllowed(classNode, receiverType)) && !receiverType.equals(classNode) && (accessors = (Map)receiverType.redirect().getNodeMetaData((Object)StaticCompilationMetadataKeys.PRIVATE_FIELDS_ACCESSORS)) != null && (methodNode = (MethodNode)accessors.get(fieldName)) != null) {
            MethodCallExpression mce = new MethodCallExpression(receiver, methodNode.getName(), (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            mce.setMethodTarget(methodNode);
            mce.setImplicitThis(implicitThis);
            mce.visit(this.controller.getAcg());
            return true;
        }
        return false;
    }

    public void makeGroovyObjectGetPropertySite(Expression receiver, String methodName, boolean safe, boolean implicitThis) {
        TypeChooser typeChooser = this.controller.getTypeChooser();
        ClassNode classNode = this.controller.getClassNode();
        ClassNode receiverType = typeChooser.resolveType(receiver, classNode);
        if (receiver instanceof VariableExpression && ((VariableExpression)receiver).isThisExpression() && !this.controller.isInClosure()) {
            receiverType = classNode;
        }
        String property = methodName;
        if (classNode.getNodeMetaData((Object)StaticCompilationMetadataKeys.WITH_CLOSURE) != null && "owner".equals(property)) {
            property = "delegate";
        }
        if (this.makeGetField(receiver, receiverType, property, implicitThis, StaticTypesCallSiteWriter.samePackages(receiverType.getPackageName(), classNode.getPackageName()))) {
            return;
        }
        if (this.makeGetPropertyWithGetter(receiver, receiverType, property)) {
            return;
        }
        MethodCallExpression call = new MethodCallExpression(receiver, "getProperty", (Expression)new ArgumentListExpression(new ConstantExpression(property)));
        call.setMethodTarget(GROOVYOBJECT_GETPROPERTY_METHOD);
        call.visit(this.controller.getAcg());
    }

    public void makeCallSiteArrayInitializer() {
    }

    private boolean makeGetPropertyWithGetter(Expression receiver, ClassNode receiverType, String methodName) {
        String getterName = "get" + MetaClassHelper.capitalize(methodName);
        MethodNode getterNode = receiverType.getGetterMethod(getterName);
        if (getterNode == null) {
            getterName = "is" + MetaClassHelper.capitalize(methodName);
            getterNode = receiverType.getGetterMethod(getterName);
        }
        if (getterNode != null) {
            MethodCallExpression call = new MethodCallExpression(receiver, getterName, (Expression)new ArgumentListExpression());
            call.setMethodTarget(getterNode);
            call.setImplicitThis(false);
            call.visit(this.controller.getAcg());
            return true;
        }
        ClassNode superClass = receiverType.getSuperClass();
        if (superClass != null) {
            return this.makeGetPropertyWithGetter(receiver, superClass, methodName);
        }
        return false;
    }

    private boolean makeGetField(Expression receiver, ClassNode receiverType, String fieldName, boolean implicitThis, boolean samePackage) {
        FieldNode field = receiverType.getField(fieldName);
        if (field != null && (field.isPublic() || samePackage && field.isProtected() || Modifier.isPrivate(field.getModifiers()) && field.getOwner().redirect() == this.controller.getClassNode().redirect())) {
            CompileStack compileStack = this.controller.getCompileStack();
            MethodVisitor mv = this.controller.getMethodVisitor();
            if (field.isStatic()) {
                mv.visitFieldInsn(178, BytecodeHelper.getClassInternalName(field.getOwner()), fieldName, BytecodeHelper.getTypeDescription(field.getOriginType()));
                this.controller.getOperandStack().push(field.getOriginType());
            } else {
                if (implicitThis) {
                    compileStack.pushImplicitThis(implicitThis);
                }
                receiver.visit(this.controller.getAcg());
                if (implicitThis) {
                    compileStack.popImplicitThis();
                }
                mv.visitFieldInsn(180, BytecodeHelper.getClassInternalName(field.getOwner()), fieldName, BytecodeHelper.getTypeDescription(field.getOriginType()));
            }
            this.controller.getOperandStack().replace(field.getOriginType());
            return true;
        }
        ClassNode superClass = receiverType.getSuperClass();
        if (superClass != null) {
            return this.makeGetField(receiver, superClass, fieldName, implicitThis, false);
        }
        return false;
    }

    private static boolean samePackages(String pkg1, String pkg2) {
        return pkg1 == null && pkg2 == null || pkg1 != null && pkg1.equals(pkg2);
    }

    public void makeSiteEntry() {
    }

    public void prepareCallSite(String message) {
    }

    public void makeSingleArgumentCall(Expression receiver, String message, Expression arguments) {
        TypeChooser typeChooser = this.controller.getTypeChooser();
        ClassNode classNode = this.controller.getClassNode();
        ClassNode rType = typeChooser.resolveType(receiver, classNode);
        ClassNode aType = typeChooser.resolveType(arguments, classNode);
        if (ClassHelper.getWrapper(rType).isDerivedFrom(ClassHelper.Number_TYPE) && ClassHelper.getWrapper(aType).isDerivedFrom(ClassHelper.Number_TYPE)) {
            if ("plus".equals(message) || "minus".equals(message) || "multiply".equals(message) || "div".equals(message)) {
                this.writeNumberNumberCall(receiver, message, arguments);
                return;
            }
            if ("power".equals(message)) {
                this.writePowerCall(receiver, arguments, rType, aType);
                return;
            }
        } else {
            if (ClassHelper.STRING_TYPE.equals(rType) && "plus".equals(message)) {
                this.writeStringPlusCall(receiver, message, arguments);
                return;
            }
            if (rType.isArray() && "getAt".equals(message)) {
                this.writeArrayGet(receiver, arguments, rType, aType);
                return;
            }
        }
        ClassNode[] args = new ClassNode[]{aType};
        boolean acceptAnyMethod = ClassHelper.MAP_TYPE.equals(rType) || rType.implementsInterface(ClassHelper.MAP_TYPE) || ClassHelper.LIST_TYPE.equals(rType) || rType.implementsInterface(ClassHelper.LIST_TYPE);
        List<MethodNode> nodes = StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(rType, message, args);
        if ((nodes = StaticTypeCheckingSupport.chooseBestMethod(rType, nodes, args)).size() == 1 || nodes.size() > 1 && acceptAnyMethod) {
            MethodNode methodNode = nodes.get(0);
            MethodCallExpression call = new MethodCallExpression(receiver, message, arguments);
            call.setMethodTarget(methodNode);
            call.visit(this.controller.getAcg());
            return;
        }
        throw new GroovyBugError("At line " + receiver.getLineNumber() + " column " + receiver.getColumnNumber() + "\n" + "On receiver: " + receiver.getText() + " with message: " + message + " and arguments: " + arguments.getText() + "\n" + "This method should not have been called. Please try to create a simple example reproducing this error and file" + "a bug report at http://jira.codehaus.org/browse/GROOVY");
    }

    private void writeArrayGet(Expression receiver, Expression arguments, ClassNode rType, ClassNode aType) {
        OperandStack operandStack = this.controller.getOperandStack();
        int m1 = operandStack.getStackLength();
        receiver.visit(this.controller.getAcg());
        arguments.visit(this.controller.getAcg());
        operandStack.doGroovyCast(ClassHelper.int_TYPE);
        int m2 = operandStack.getStackLength();
        this.controller.getMethodVisitor().visitInsn(50);
        operandStack.replace(rType.getComponentType(), m2 - m1);
    }

    private void writePowerCall(Expression receiver, Expression arguments, ClassNode rType, ClassNode aType) {
        OperandStack operandStack = this.controller.getOperandStack();
        int m1 = operandStack.getStackLength();
        this.prepareSiteAndReceiver(receiver, "power", false, this.controller.getCompileStack().isLHS());
        this.visitBoxedArgument(arguments);
        int m2 = operandStack.getStackLength();
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (ClassHelper.BigDecimal_TYPE.equals(rType) && ClassHelper.Integer_TYPE.equals(ClassHelper.getWrapper(aType))) {
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "power", "(Ljava/math/BigDecimal;Ljava/lang/Integer;)Ljava/lang/Number;");
        } else if (ClassHelper.BigInteger_TYPE.equals(rType) && ClassHelper.Integer_TYPE.equals(ClassHelper.getWrapper(aType))) {
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "power", "(Ljava/math/BigInteger;Ljava/lang/Integer;)Ljava/lang/Number;");
        } else if (ClassHelper.Long_TYPE.equals(ClassHelper.getWrapper(rType)) && ClassHelper.Integer_TYPE.equals(ClassHelper.getWrapper(aType))) {
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "power", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/Number;");
        } else if (ClassHelper.Integer_TYPE.equals(ClassHelper.getWrapper(rType)) && ClassHelper.Integer_TYPE.equals(ClassHelper.getWrapper(aType))) {
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "power", "(Ljava/lang/Long;Ljava/lang/Integer;)Ljava/lang/Number;");
        } else {
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "power", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
        }
        this.controller.getOperandStack().replace(ClassHelper.Number_TYPE, m2 - m1);
    }

    private void writeStringPlusCall(Expression receiver, String message, Expression arguments) {
        OperandStack operandStack = this.controller.getOperandStack();
        int m1 = operandStack.getStackLength();
        this.prepareSiteAndReceiver(receiver, message, false, this.controller.getCompileStack().isLHS());
        this.visitBoxedArgument(arguments);
        int m2 = operandStack.getStackLength();
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "plus", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        this.controller.getOperandStack().replace(ClassHelper.STRING_TYPE, m2 - m1);
    }

    private void writeNumberNumberCall(Expression receiver, String message, Expression arguments) {
        OperandStack operandStack = this.controller.getOperandStack();
        int m1 = operandStack.getStackLength();
        this.prepareSiteAndReceiver(receiver, message, false, this.controller.getCompileStack().isLHS());
        this.controller.getOperandStack().doGroovyCast(ClassHelper.Number_TYPE);
        this.visitBoxedArgument(arguments);
        int m2 = operandStack.getStackLength();
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/dgmimpl/NumberNumber" + MetaClassHelper.capitalize(message), message, "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
        this.controller.getOperandStack().replace(ClassHelper.Number_TYPE, m2 - m1);
    }
}

