/*
 * Decompiled with CFR 0.152.
 */
package groovy.util.logging;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;
import org.codehaus.groovy.transform.LogASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Documented
@Retention(value=RetentionPolicy.SOURCE)
@Target(value={ElementType.TYPE})
@GroovyASTTransformationClass(value={"org.codehaus.groovy.transform.LogASTTransformation"})
public @interface Commons {
    public String value() default "log";

    public Class<? extends LogASTTransformation.LoggingStrategy> loggingStrategy() default CommonsLoggingStrategy.class;

    public static class CommonsLoggingStrategy
    implements LogASTTransformation.LoggingStrategy {
        private static final ClassNode LOGGER_CLASSNODE;
        private static final ClassNode LOGGERFACTORY_CLASSNODE;

        public FieldNode addLoggerFieldToClass(ClassNode classNode, String logFieldName) {
            return classNode.addField(logFieldName, 154, LOGGER_CLASSNODE, new MethodCallExpression((Expression)new ClassExpression(LOGGERFACTORY_CLASSNODE), "getLog", (Expression)new ClassExpression(classNode)));
        }

        public boolean isLoggingMethod(String methodName) {
            return methodName.matches("fatal|error|warn|info|debug|trace");
        }

        public Expression wrapLoggingMethodCall(Expression logVariable, String methodName, Expression originalExpression) {
            MethodCallExpression condition = new MethodCallExpression(logVariable, "is" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1, methodName.length()) + "Enabled", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            return new TernaryExpression(new BooleanExpression(condition), originalExpression, ConstantExpression.NULL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            ClassNode tmp1 = null;
            ClassNode tmp2 = null;
            try {
                tmp1 = ClassHelper.make(Class.forName("org.apache.commons.logging.Log"));
                tmp2 = ClassHelper.make(Class.forName("org.apache.commons.logging.LogFactory"));
            }
            catch (ClassNotFoundException e) {
                tmp1 = ClassHelper.make("org.apache.commons.logging.Log");
                tmp2 = ClassHelper.make("org.apache.commons.logging.LogFactory");
            }
            finally {
                LOGGER_CLASSNODE = tmp1;
                LOGGERFACTORY_CLASSNODE = tmp2;
            }
        }
    }
}

