/*
 * Decompiled with CFR 0.152.
 */
package groovy.util.logging;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;
import org.codehaus.groovy.transform.LogASTTransformation;

@Documented
@Retention(value=RetentionPolicy.SOURCE)
@Target(value={ElementType.TYPE})
@GroovyASTTransformationClass(value={"org.codehaus.groovy.transform.LogASTTransformation"})
public @interface Slf4j {
    public String value() default "log";

    public Class<? extends LogASTTransformation.LoggingStrategy> loggingStrategy() default Slf4jLoggingStrategy.class;

    public static class Slf4jLoggingStrategy
    implements LogASTTransformation.LoggingStrategy {
        private static final ClassNode LOGGER_CLASSNODE;
        private static final ClassNode FACTORY_CLASSNODE;

        @Override
        public FieldNode addLoggerFieldToClass(ClassNode classNode, String logFieldName) {
            return classNode.addField(logFieldName, 154, LOGGER_CLASSNODE, new MethodCallExpression((Expression)new ClassExpression(FACTORY_CLASSNODE), "getLogger", (Expression)new ClassExpression(classNode)));
        }

        @Override
        public boolean isLoggingMethod(String methodName) {
            return methodName.matches("error|warn|info|debug|trace");
        }

        @Override
        public Expression wrapLoggingMethodCall(Expression logVariable, String methodName, Expression originalExpression) {
            MethodCallExpression condition = new MethodCallExpression(logVariable, "is" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1, methodName.length()) + "Enabled", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            return new TernaryExpression(new BooleanExpression(condition), originalExpression, ConstantExpression.NULL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            ClassNode tmp1 = null;
            ClassNode tmp2 = null;
            try {
                tmp1 = ClassHelper.make(Class.forName("org.slf4j.Logger"));
                tmp2 = ClassHelper.make(Class.forName("org.slf4j.LoggerFactory"));
            }
            catch (ClassNotFoundException e) {
                tmp1 = ClassHelper.make("org.slf4j.Logger");
                tmp2 = ClassHelper.make("org.slf4j.LoggerFactory");
            }
            finally {
                LOGGER_CLASSNODE = tmp1;
                FACTORY_CLASSNODE = tmp2;
            }
        }
    }
}

