/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import java.util.Collections;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.stc.TypeCheckerPluginFactory;

@GroovyASTTransformation(phase=CompilePhase.INSTRUCTION_SELECTION)
public class StaticTypesTransformation
implements ASTTransformation {
    public static final String STATIC_ERROR_PREFIX = "[Static type checking] - ";

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        Expression exp;
        AnnotationNode annotationInformation = (AnnotationNode)nodes[0];
        Map<String, Expression> members = annotationInformation.getMembers();
        TypeCheckerPluginFactory pluginFactory = null;
        if (members != null && (exp = members.get("pluginFactory")) instanceof ClassExpression) {
            ClassNode type = exp.getType();
            Class clazz = type.getTypeClass();
            if (TypeCheckerPluginFactory.class.isAssignableFrom(TypeCheckerPluginFactory.class)) {
                try {
                    pluginFactory = (TypeCheckerPluginFactory)clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new GroovyBugError(e);
                }
                catch (IllegalAccessException e) {
                    throw new GroovyBugError(e);
                }
            }
        }
        AnnotatedNode node = (AnnotatedNode)nodes[1];
        StaticTypeCheckingVisitor visitor = null;
        if (node instanceof ClassNode) {
            ClassNode classNode = (ClassNode)node;
            visitor = this.newVisitor(source, classNode, pluginFactory);
            visitor.visitClass(classNode);
        } else if (node instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)node;
            visitor = this.newVisitor(source, methodNode.getDeclaringClass(), pluginFactory);
            visitor.setMethodsToBeVisited(Collections.singleton(methodNode));
            visitor.visitMethod(methodNode);
        } else {
            source.addError(new SyntaxException("[Static type checking] - Unimplemented node type", node.getLineNumber(), node.getColumnNumber()));
        }
        if (visitor != null) {
            visitor.performSecondPass();
        }
    }

    protected StaticTypeCheckingVisitor newVisitor(SourceUnit unit, ClassNode node, TypeCheckerPluginFactory pluginFactory) {
        return new StaticTypeCheckingVisitor(unit, node, pluginFactory);
    }
}

