/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.WriterController;

public class CompareIdentityExpression
extends Expression
implements Opcodes {
    private final Expression leftExpression;
    private final Expression rightExpression;

    public CompareIdentityExpression(Expression leftExpression, Expression rightExpression) {
        this.leftExpression = leftExpression;
        this.rightExpression = rightExpression;
    }

    @Override
    public Expression transformExpression(ExpressionTransformer transformer) {
        return this;
    }

    @Override
    public void visit(GroovyCodeVisitor visitor) {
        if (visitor instanceof AsmClassGenerator) {
            AsmClassGenerator acg = (AsmClassGenerator)visitor;
            WriterController controller = acg.getController();
            ClassNode leftType = controller.getTypeChooser().resolveType(this.leftExpression, controller.getClassNode());
            ClassNode rightType = controller.getTypeChooser().resolveType(this.rightExpression, controller.getClassNode());
            if (ClassHelper.isPrimitiveType(leftType) || ClassHelper.isPrimitiveType(rightType)) {
                throw new IllegalArgumentException("Both operands of a CompareIdentityExpression must be objects");
            }
            MethodVisitor mv = controller.getMethodVisitor();
            this.leftExpression.visit(acg);
            this.rightExpression.visit(acg);
            Label l1 = new Label();
            mv.visitJumpInsn(166, l1);
            mv.visitInsn(4);
            Label l2 = new Label();
            mv.visitJumpInsn(167, l2);
            mv.visitLabel(l1);
            mv.visitInsn(3);
            mv.visitLabel(l2);
            controller.getOperandStack().replace(ClassHelper.boolean_TYPE, 2);
        }
    }
}

