/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyResourceLoader;
import groovy.lang.Script;
import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.ClassNodeResolver;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.tools.gse.DependencyTracker;
import org.codehaus.groovy.tools.gse.StringSetMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScriptEngine
implements ResourceConnector {
    private static final ClassLoader CL_STUB = new ClassLoader(){};
    private static WeakReference<ThreadLocal<StringSetMap>> dependencyCache = new WeakReference<Object>(null);
    private static WeakReference<ThreadLocal<CompilationUnit>> localCu = new WeakReference<Object>(null);
    private URL[] roots;
    private ResourceConnector rc;
    private final ClassLoader parentLoader;
    private final GroovyClassLoader groovyLoader;
    private final Map<String, ScriptCacheEntry> scriptCache = new ConcurrentHashMap<String, ScriptCacheEntry>();
    private CompilerConfiguration config = new CompilerConfiguration(CompilerConfiguration.DEFAULT);

    private static synchronized ThreadLocal<StringSetMap> getDepCache() {
        ThreadLocal local = (ThreadLocal)dependencyCache.get();
        if (local != null) {
            return local;
        }
        local = new ThreadLocal<StringSetMap>(){

            @Override
            protected StringSetMap initialValue() {
                return new StringSetMap();
            }
        };
        dependencyCache = new WeakReference<ThreadLocal>(local);
        return local;
    }

    private static synchronized ThreadLocal<CompilationUnit> getLocalCompilationUnit() {
        ThreadLocal<CompilationUnit> local = (ThreadLocal<CompilationUnit>)localCu.get();
        if (local != null) {
            return local;
        }
        local = new ThreadLocal<CompilationUnit>();
        localCu = new WeakReference(local);
        return local;
    }

    public static void main(String[] urls) throws Exception {
        GroovyScriptEngine gse = new GroovyScriptEngine(urls);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("groovy> ");
            String line = br.readLine();
            if (line == null || line.equals("quit")) break;
            try {
                System.out.println(gse.run(line, new Binding()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private GroovyClassLoader initGroovyLoader() {
        return (GroovyClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (GroovyScriptEngine.this.parentLoader instanceof GroovyClassLoader) {
                    return new ScriptClassLoader((GroovyClassLoader)GroovyScriptEngine.this.parentLoader);
                }
                return new ScriptClassLoader(GroovyScriptEngine.this.parentLoader);
            }
        });
    }

    @Override
    public URLConnection getResourceConnection(String resourceName) throws ResourceException {
        URLConnection groovyScriptConn = null;
        ResourceException se = null;
        for (URL root : this.roots) {
            String message;
            URL scriptURL = null;
            try {
                scriptURL = new URL(root, resourceName);
                groovyScriptConn = scriptURL.openConnection();
                groovyScriptConn.getInputStream();
                break;
            }
            catch (MalformedURLException e) {
                message = "Malformed URL: " + root + ", " + resourceName;
                if (se == null) {
                    se = new ResourceException(message);
                    continue;
                }
                se = new ResourceException(message, se);
            }
            catch (IOException e1) {
                groovyScriptConn = null;
                message = "Cannot open URL: " + root + resourceName;
                groovyScriptConn = null;
                se = se == null ? new ResourceException(message) : new ResourceException(message, se);
            }
        }
        if (se == null) {
            se = new ResourceException("No resource for " + resourceName + " was found");
        }
        if (groovyScriptConn == null) {
            throw se;
        }
        return groovyScriptConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceClose(URLConnection urlConnection) {
        if (urlConnection != null) {
            InputStream in = null;
            try {
                in = urlConnection.getInputStream();
            }
            catch (Exception e) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private GroovyScriptEngine(URL[] roots, ClassLoader parent, ResourceConnector rc) {
        if (roots == null) {
            roots = new URL[]{};
        }
        this.roots = roots;
        if (rc == null) {
            rc = this;
        }
        this.rc = rc;
        if (parent == CL_STUB) {
            parent = this.getClass().getClassLoader();
        }
        this.parentLoader = parent;
        this.groovyLoader = this.initGroovyLoader();
        for (URL root : roots) {
            this.groovyLoader.addURL(root);
        }
    }

    public GroovyScriptEngine(URL[] roots) {
        this(roots, CL_STUB, null);
    }

    public GroovyScriptEngine(URL[] roots, ClassLoader parentClassLoader) {
        this(roots, parentClassLoader, null);
    }

    public GroovyScriptEngine(String[] urls) throws IOException {
        this(GroovyScriptEngine.createRoots(urls), CL_STUB, null);
    }

    private static URL[] createRoots(String[] urls) throws MalformedURLException {
        if (urls == null) {
            return null;
        }
        URL[] roots = new URL[urls.length];
        for (int i = 0; i < roots.length; ++i) {
            roots[i] = urls[i].indexOf("://") != -1 ? new URL(urls[i]) : new File(urls[i]).toURI().toURL();
        }
        return roots;
    }

    public GroovyScriptEngine(String[] urls, ClassLoader parentClassLoader) throws IOException {
        this(GroovyScriptEngine.createRoots(urls), parentClassLoader, null);
    }

    public GroovyScriptEngine(String url) throws IOException {
        this(new String[]{url});
    }

    public GroovyScriptEngine(String url, ClassLoader parentClassLoader) throws IOException {
        this(new String[]{url}, parentClassLoader);
    }

    public GroovyScriptEngine(ResourceConnector rc) {
        this(null, CL_STUB, rc);
    }

    public GroovyScriptEngine(ResourceConnector rc, ClassLoader parentClassLoader) {
        this(null, parentClassLoader, rc);
    }

    public ClassLoader getParentClassLoader() {
        return this.parentLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadScriptByName(String scriptName) throws ResourceException, ScriptException {
        Class clazz;
        block6: {
            URLConnection conn = this.rc.getResourceConnection(scriptName);
            String path = conn.getURL().toExternalForm();
            ScriptCacheEntry entry = this.scriptCache.get(path);
            clazz = null;
            if (entry != null) {
                clazz = entry.scriptClass;
            }
            try {
                if (!this.isSourceNewer(entry)) break block6;
                try {
                    String encoding = conn.getContentEncoding() != null ? conn.getContentEncoding() : "UTF-8";
                    clazz = this.groovyLoader.parseClass(IOGroovyMethods.getText(conn.getInputStream(), encoding), path);
                }
                catch (IOException e) {
                    throw new ResourceException(e);
                }
            }
            finally {
                this.forceClose(conn);
            }
        }
        return clazz;
    }

    public String run(String scriptName, String argument) throws ResourceException, ScriptException {
        Binding binding = new Binding();
        binding.setVariable("arg", argument);
        Object result = this.run(scriptName, binding);
        return result == null ? "" : result.toString();
    }

    public Object run(String scriptName, Binding binding) throws ResourceException, ScriptException {
        return this.createScript(scriptName, binding).run();
    }

    public Script createScript(String scriptName, Binding binding) throws ResourceException, ScriptException {
        return InvokerHelper.createScript(this.loadScriptByName(scriptName), binding);
    }

    protected boolean isSourceNewer(ScriptCacheEntry entry) throws ResourceException {
        if (entry == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        for (String scriptName : entry.dependencies) {
            ScriptCacheEntry depEntry = this.scriptCache.get(scriptName);
            long nextPossibleRecompilationTime = Math.max(depEntry.lastModified, depEntry.lastCheckedForModification) + (long)this.config.getMinimumRecompilationInterval();
            if (nextPossibleRecompilationTime > now) {
                depEntry.lastCheckedForModification = now;
                continue;
            }
            URLConnection conn = this.rc.getResourceConnection(scriptName);
            long lastMod = (conn.getLastModified() / 1000L + 1L) * 1000L - 1L;
            this.forceClose(conn);
            if (depEntry.lastModified < lastMod) {
                ScriptCacheEntry newEntry = new ScriptCacheEntry(depEntry.scriptClass, lastMod, depEntry.dependencies);
                this.scriptCache.put(scriptName, newEntry);
                return true;
            }
            depEntry.lastCheckedForModification = now;
        }
        return false;
    }

    public GroovyClassLoader getGroovyClassLoader() {
        return this.groovyLoader;
    }

    public CompilerConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(CompilerConfiguration config) {
        if (config == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.config = config;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScriptClassLoader
    extends GroovyClassLoader {
        public ScriptClassLoader(GroovyClassLoader loader) {
            super(loader);
            this.setResLoader();
        }

        public ScriptClassLoader(ClassLoader loader) {
            super(loader);
            this.setResLoader();
        }

        private void setResLoader() {
            final GroovyResourceLoader rl = this.getResourceLoader();
            this.setResourceLoader(new GroovyResourceLoader(){

                public URL loadGroovySource(String className) throws MalformedURLException {
                    for (String extension : GroovyScriptEngine.this.getConfig().getScriptExtensions()) {
                        String filename = className.replace('.', File.separatorChar) + "." + extension;
                        try {
                            URLConnection dependentScriptConn = GroovyScriptEngine.this.rc.getResourceConnection(filename);
                            return dependentScriptConn.getURL();
                        }
                        catch (ResourceException e) {
                        }
                    }
                    return rl.loadGroovySource(className);
                }
            });
        }

        @Override
        protected CompilationUnit createCompilationUnit(CompilerConfiguration configuration, CodeSource source) {
            CompilationUnit cu = super.createCompilationUnit(configuration, source);
            GroovyScriptEngine.getLocalCompilationUnit().set(cu);
            final StringSetMap cache = (StringSetMap)GroovyScriptEngine.getDepCache().get();
            Iterator i$ = cache.get(".").iterator();
            while (i$.hasNext()) {
                String depSourcePath = (String)i$.next();
                try {
                    cu.addSource(GroovyScriptEngine.this.getResourceConnection(depSourcePath).getURL());
                }
                catch (ResourceException e) {}
            }
            cache.clear();
            cu.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

                public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                    if (classNode instanceof InnerClassNode) {
                        return;
                    }
                    DependencyTracker dt = new DependencyTracker(source, cache);
                    dt.visitClass(classNode);
                }
            }, 7);
            cu.setClassNodeResolver(new ClassNodeResolver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public ClassNodeResolver.LookupResult findClassNode(String origName, CompilationUnit compilationUnit) {
                    CompilerConfiguration cc = compilationUnit.getConfiguration();
                    String name = origName.replace('.', '/');
                    Iterator<String> i$ = cc.getScriptExtensions().iterator();
                    while (i$.hasNext()) {
                        String ext = i$.next();
                        try {
                            String finalName = name + "." + ext;
                            URLConnection conn = GroovyScriptEngine.this.rc.getResourceConnection(finalName);
                            URL url = conn.getURL();
                            String path = url.toExternalForm();
                            ScriptCacheEntry entry = (ScriptCacheEntry)GroovyScriptEngine.this.scriptCache.get(path);
                            Class clazz = null;
                            if (entry != null) {
                                clazz = entry.scriptClass;
                            }
                            try {
                                if (GroovyScriptEngine.this.isSourceNewer(entry)) {
                                    SourceUnit su = compilationUnit.addSource(url);
                                    ClassNodeResolver.LookupResult lookupResult = new ClassNodeResolver.LookupResult(su, null);
                                    return lookupResult;
                                }
                            }
                            finally {
                                GroovyScriptEngine.this.forceClose(conn);
                            }
                            if (clazz == null) continue;
                            ClassNode cn = new ClassNode(clazz);
                            return new ClassNodeResolver.LookupResult(null, cn);
                        }
                        catch (ResourceException re) {
                        }
                    }
                    return super.findClassNode(origName, compilationUnit);
                }
            });
            List<CompilationCustomizer> customizers = GroovyScriptEngine.this.config.getCompilationCustomizers();
            if (customizers != null) {
                for (CompilationCustomizer customizer : customizers) {
                    cu.addPhaseOperation(customizer, customizer.getPhase().getPhaseNumber());
                }
            }
            return cu;
        }

        @Override
        public Class parseClass(GroovyCodeSource codeSource, boolean shouldCacheSource) throws CompilationFailedException {
            ThreadLocal localCu = GroovyScriptEngine.getLocalCompilationUnit();
            ThreadLocal localCache = GroovyScriptEngine.getDepCache();
            ScriptCacheEntry origEntry = (ScriptCacheEntry)GroovyScriptEngine.this.scriptCache.get(codeSource.getName());
            Set origDep = null;
            if (origEntry != null) {
                origDep = origEntry.dependencies;
            }
            if (origDep != null) {
                ((StringSetMap)localCache.get()).put(".", origDep);
            }
            Class answer = super.parseClass(codeSource, false);
            StringSetMap cache = (StringSetMap)localCache.get();
            cache.makeTransitiveHull();
            long now = System.currentTimeMillis();
            HashSet<String> entryNames = new HashSet<String>();
            for (Map.Entry entry : cache.entrySet()) {
                String entryName;
                String className = (String)entry.getKey();
                Class clazz = this.getClassCacheEntry(className);
                if (clazz == null || entryNames.contains(entryName = this.getPath(clazz))) continue;
                entryNames.add(entryName);
                Set<String> value = this.convertToPaths((Set)entry.getValue());
                ScriptCacheEntry cacheEntry = new ScriptCacheEntry(clazz, now, value);
                GroovyScriptEngine.this.scriptCache.put(entryName, cacheEntry);
            }
            cache.clear();
            localCu.set(null);
            return answer;
        }

        private String getPath(Class clazz) {
            ThreadLocal localCu = GroovyScriptEngine.getLocalCompilationUnit();
            String name = clazz.getName();
            ClassNode classNode = ((CompilationUnit)localCu.get()).getClassNode(name);
            return classNode.getModule().getContext().getName();
        }

        private Set<String> convertToPaths(Set<String> orig) {
            HashSet<String> ret = new HashSet<String>();
            for (String className : orig) {
                Class clazz = this.getClassCacheEntry(className);
                if (clazz == null) continue;
                ret.add(this.getPath(clazz));
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptCacheEntry {
        private final Class scriptClass;
        private final long lastModified;
        private long lastCheckedForModification;
        private final Set<String> dependencies;

        public ScriptCacheEntry(Class clazz, long modified, Set<String> depend) {
            this.scriptClass = clazz;
            this.lastModified = modified;
            this.lastCheckedForModification = modified;
            this.dependencies = depend;
        }
    }
}

