/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.EqualsAndHashCode;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.AbstractASTTransformUtil;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.CanonicalASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.util.HashCodeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class EqualsAndHashCodeASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = EqualsAndHashCode.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode HASHUTIL_TYPE = ClassHelper.make(HashCodeHelper.class);
    private static final Token ASSIGN = Token.newSymbol(100, -1, -1);
    private static final Token LOGICAL_OR = Token.newSymbol(162, -1, -1);
    private static final Token LOGICAL_AND = Token.newSymbol(164, -1, -1);
    private static final ClassNode OBJECT_TYPE = ClassHelper.make(Object.class);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            boolean useCanEqual;
            ClassNode cNode = (ClassNode)parent;
            this.checkNotInterface(cNode, MY_TYPE_NAME);
            boolean callSuper = this.memberHasValue(anno, "callSuper", true);
            boolean cacheHashCode = this.memberHasValue(anno, "cache", true);
            boolean bl = useCanEqual = !this.memberHasValue(anno, "useCanEqual", false);
            if (callSuper && cNode.getSuperClass().getName().equals("java.lang.Object")) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: callSuper=true but '" + cNode.getName() + "' has no super class.", anno);
            }
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            List<String> excludes = this.getMemberList(anno, "excludes");
            List<String> includes = this.getMemberList(anno, "includes");
            if (this.hasAnnotation(cNode, CanonicalASTTransformation.MY_TYPE)) {
                AnnotationNode canonical = cNode.getAnnotations(CanonicalASTTransformation.MY_TYPE).get(0);
                if (excludes == null || excludes.isEmpty()) {
                    excludes = this.getMemberList(canonical, "excludes");
                }
                if (includes == null || includes.isEmpty()) {
                    includes = this.getMemberList(canonical, "includes");
                }
            }
            if (includes != null && !includes.isEmpty() && excludes != null && !excludes.isEmpty()) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: Only one of 'includes' and 'excludes' should be supplied not both.", anno);
            }
            EqualsAndHashCodeASTTransformation.createHashCode(cNode, cacheHashCode, includeFields, callSuper, excludes, includes);
            EqualsAndHashCodeASTTransformation.createEquals(cNode, includeFields, callSuper, useCanEqual, excludes, includes);
        }
    }

    public static void createHashCode(ClassNode cNode, boolean cacheResult, boolean includeFields, boolean callSuper, List<String> excludes, List<String> includes) {
        boolean hasExistingHashCode = AbstractASTTransformUtil.hasDeclaredMethod(cNode, "hashCode", 0);
        if (hasExistingHashCode && AbstractASTTransformUtil.hasDeclaredMethod(cNode, "_hashCode", 0)) {
            return;
        }
        BlockStatement body = new BlockStatement();
        if (cacheResult) {
            FieldNode hashField = cNode.addField("$hash$code", 4098, ClassHelper.int_TYPE, null);
            VariableExpression hash = new VariableExpression(hashField);
            body.addStatement(new IfStatement(AbstractASTTransformUtil.isZeroExpr(hash), EqualsAndHashCodeASTTransformation.calculateHashStatements(cNode, hash, includeFields, callSuper, excludes, includes), EmptyStatement.INSTANCE));
            body.addStatement(new ReturnStatement(hash));
        } else {
            body.addStatement(EqualsAndHashCodeASTTransformation.calculateHashStatements(cNode, null, includeFields, callSuper, excludes, includes));
        }
        cNode.addMethod(new MethodNode(hasExistingHashCode ? "_hashCode" : "hashCode", hasExistingHashCode ? 2 : 1, ClassHelper.int_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body));
    }

    private static Statement calculateHashStatements(ClassNode cNode, Expression hash, boolean includeFields, boolean callSuper, List<String> excludes, List<String> includes) {
        List<PropertyNode> pList = AbstractASTTransformUtil.getInstanceProperties(cNode);
        ArrayList<FieldNode> fList = new ArrayList<FieldNode>();
        if (includeFields) {
            fList.addAll(AbstractASTTransformUtil.getInstanceNonPropertyFields(cNode));
        }
        BlockStatement body = new BlockStatement();
        VariableExpression result = new VariableExpression("_result");
        StaticMethodCallExpression init = new StaticMethodCallExpression(HASHUTIL_TYPE, "initHash", MethodCallExpression.NO_ARGUMENTS);
        body.addStatement(new ExpressionStatement(new DeclarationExpression((Expression)result, ASSIGN, (Expression)init)));
        for (PropertyNode pNode : pList) {
            if (EqualsAndHashCodeASTTransformation.shouldSkip(pNode.getName(), excludes, includes)) continue;
            String getterName = "get" + Verifier.capitalize(pNode.getName());
            MethodCallExpression getter = new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, getterName, MethodCallExpression.NO_ARGUMENTS);
            TupleExpression args = new TupleExpression(result, getter);
            StaticMethodCallExpression current = new StaticMethodCallExpression(HASHUTIL_TYPE, "updateHash", args);
            body.addStatement(new IfStatement(AbstractASTTransformUtil.identicalExpr(getter, new VariableExpression("this")), EmptyStatement.INSTANCE, AbstractASTTransformUtil.assignStatement(result, current)));
        }
        for (FieldNode fNode : fList) {
            if (EqualsAndHashCodeASTTransformation.shouldSkip(fNode.getName(), excludes, includes)) continue;
            VariableExpression fieldExpr = new VariableExpression(fNode);
            TupleExpression args = new TupleExpression(result, fieldExpr);
            StaticMethodCallExpression current = new StaticMethodCallExpression(HASHUTIL_TYPE, "updateHash", args);
            body.addStatement(new IfStatement(AbstractASTTransformUtil.identicalExpr(fieldExpr, new VariableExpression("this")), EmptyStatement.INSTANCE, AbstractASTTransformUtil.assignStatement(result, current)));
        }
        if (callSuper) {
            TupleExpression args = new TupleExpression(result, new MethodCallExpression((Expression)VariableExpression.SUPER_EXPRESSION, "hashCode", MethodCallExpression.NO_ARGUMENTS));
            StaticMethodCallExpression current = new StaticMethodCallExpression(HASHUTIL_TYPE, "updateHash", args);
            body.addStatement(AbstractASTTransformUtil.assignStatement(result, current));
        }
        if (hash != null) {
            body.addStatement(AbstractASTTransformUtil.assignStatement(hash, result));
        } else {
            body.addStatement(new ReturnStatement(result));
        }
        return body;
    }

    private static void createCanEqual(ClassNode cNode) {
        boolean hasExistingCanEqual = AbstractASTTransformUtil.hasDeclaredMethod(cNode, "canEqual", 1);
        if (hasExistingCanEqual && AbstractASTTransformUtil.hasDeclaredMethod(cNode, "_canEqual", 1)) {
            return;
        }
        BlockStatement body = new BlockStatement();
        VariableExpression other = new VariableExpression("other");
        body.addStatement(new ReturnStatement(AbstractASTTransformUtil.isInstanceof(cNode, other)));
        Parameter[] params = new Parameter[]{new Parameter(OBJECT_TYPE, other.getName())};
        cNode.addMethod(new MethodNode(hasExistingCanEqual ? "_canEqual" : "canEqual", hasExistingCanEqual ? 2 : 1, ClassHelper.boolean_TYPE, params, ClassNode.EMPTY_ARRAY, body));
    }

    public static void createEquals(ClassNode cNode, boolean includeFields, boolean callSuper, boolean useCanEqual, List<String> excludes, List<String> includes) {
        boolean hasExistingEquals;
        if (useCanEqual) {
            EqualsAndHashCodeASTTransformation.createCanEqual(cNode);
        }
        if ((hasExistingEquals = AbstractASTTransformUtil.hasDeclaredMethod(cNode, "equals", 1)) && AbstractASTTransformUtil.hasDeclaredMethod(cNode, "_equals", 1)) {
            return;
        }
        BlockStatement body = new BlockStatement();
        VariableExpression other = new VariableExpression("other");
        body.addStatement(AbstractASTTransformUtil.returnFalseIfNull(other));
        body.addStatement(AbstractASTTransformUtil.returnTrueIfIdentical(VariableExpression.THIS_EXPRESSION, other));
        if (useCanEqual) {
            body.addStatement(AbstractASTTransformUtil.returnFalseIfNotInstanceof(cNode, other));
            body.addStatement(new IfStatement(new BooleanExpression(new MethodCallExpression((Expression)other, "canEqual", (Expression)VariableExpression.THIS_EXPRESSION)), EmptyStatement.INSTANCE, new ReturnStatement(ConstantExpression.FALSE)));
        } else {
            body.addStatement(AbstractASTTransformUtil.returnFalseIfWrongType(cNode, other));
        }
        VariableExpression otherTyped = new VariableExpression("otherTyped");
        body.addStatement(new ExpressionStatement(new DeclarationExpression(otherTyped, ASSIGN, (Expression)new CastExpression(cNode, other))));
        List<PropertyNode> pList = AbstractASTTransformUtil.getInstanceProperties(cNode);
        for (PropertyNode pNode : pList) {
            if (EqualsAndHashCodeASTTransformation.shouldSkip(pNode.getName(), excludes, includes)) continue;
            body.addStatement(new IfStatement(AbstractASTTransformUtil.differentPropertyExpr(pNode, otherTyped), new IfStatement(EqualsAndHashCodeASTTransformation.differentSelfRecursivePropertyExpr(pNode, otherTyped), new ReturnStatement(ConstantExpression.FALSE), new IfStatement(EqualsAndHashCodeASTTransformation.bothSelfRecursivePropertyExpr(pNode, otherTyped), EmptyStatement.INSTANCE, AbstractASTTransformUtil.returnFalseIfPropertyNotEqual(pNode, (Expression)otherTyped))), EmptyStatement.INSTANCE));
        }
        ArrayList<FieldNode> fList = new ArrayList<FieldNode>();
        if (includeFields) {
            fList.addAll(AbstractASTTransformUtil.getInstanceNonPropertyFields(cNode));
        }
        for (FieldNode fNode : fList) {
            if (EqualsAndHashCodeASTTransformation.shouldSkip(fNode.getName(), excludes, includes)) continue;
            body.addStatement(new IfStatement(AbstractASTTransformUtil.differentFieldExpr(fNode, otherTyped), new IfStatement(EqualsAndHashCodeASTTransformation.differentSelfRecursiveFieldExpr(fNode, otherTyped), new ReturnStatement(ConstantExpression.FALSE), new IfStatement(EqualsAndHashCodeASTTransformation.bothSelfRecursiveFieldExpr(fNode, otherTyped), EmptyStatement.INSTANCE, AbstractASTTransformUtil.returnFalseIfFieldNotEqual(fNode, otherTyped))), EmptyStatement.INSTANCE));
        }
        if (callSuper) {
            body.addStatement(new IfStatement(AbstractASTTransformUtil.isTrueExpr(new MethodCallExpression((Expression)VariableExpression.SUPER_EXPRESSION, "equals", (Expression)other)), EmptyStatement.INSTANCE, new ReturnStatement(ConstantExpression.FALSE)));
        }
        body.addStatement(new ReturnStatement(ConstantExpression.TRUE));
        Parameter[] params = new Parameter[]{new Parameter(OBJECT_TYPE, other.getName())};
        cNode.addMethod(new MethodNode(hasExistingEquals ? "_equals" : "equals", hasExistingEquals ? 2 : 1, ClassHelper.boolean_TYPE, params, ClassNode.EMPTY_ARRAY, body));
    }

    private static BooleanExpression differentSelfRecursivePropertyExpr(PropertyNode pNode, Expression other) {
        String getterName = "get" + Verifier.capitalize(pNode.getName());
        MethodCallExpression selfGetter = new MethodCallExpression((Expression)new VariableExpression("this"), getterName, MethodCallExpression.NO_ARGUMENTS);
        MethodCallExpression otherGetter = new MethodCallExpression(other, getterName, MethodCallExpression.NO_ARGUMENTS);
        return new BooleanExpression(new BinaryExpression(new BinaryExpression(AbstractASTTransformUtil.identicalExpr(selfGetter, new VariableExpression("this")), LOGICAL_AND, AbstractASTTransformUtil.differentExpr(otherGetter, other)), LOGICAL_OR, new BinaryExpression(AbstractASTTransformUtil.differentExpr(selfGetter, new VariableExpression("this")), LOGICAL_AND, AbstractASTTransformUtil.identicalExpr(otherGetter, other))));
    }

    private static BooleanExpression bothSelfRecursivePropertyExpr(PropertyNode pNode, Expression other) {
        String getterName = "get" + Verifier.capitalize(pNode.getName());
        MethodCallExpression selfGetter = new MethodCallExpression((Expression)new VariableExpression("this"), getterName, MethodCallExpression.NO_ARGUMENTS);
        MethodCallExpression otherGetter = new MethodCallExpression(other, getterName, MethodCallExpression.NO_ARGUMENTS);
        return new BooleanExpression(new BinaryExpression(AbstractASTTransformUtil.identicalExpr(selfGetter, new VariableExpression("this")), LOGICAL_AND, AbstractASTTransformUtil.identicalExpr(otherGetter, other)));
    }

    private static BooleanExpression differentSelfRecursiveFieldExpr(FieldNode fNode, Expression other) {
        VariableExpression fieldExpr = new VariableExpression(fNode);
        PropertyExpression otherExpr = new PropertyExpression(other, fNode.getName());
        return new BooleanExpression(new BinaryExpression(new BinaryExpression(AbstractASTTransformUtil.identicalExpr(fieldExpr, new VariableExpression("this")), LOGICAL_AND, AbstractASTTransformUtil.differentExpr(otherExpr, other)), LOGICAL_OR, new BinaryExpression(AbstractASTTransformUtil.differentExpr(fieldExpr, new VariableExpression("this")), LOGICAL_AND, AbstractASTTransformUtil.identicalExpr(otherExpr, other))));
    }

    private static BooleanExpression bothSelfRecursiveFieldExpr(FieldNode fNode, Expression other) {
        VariableExpression fieldExpr = new VariableExpression(fNode);
        PropertyExpression otherExpr = new PropertyExpression(other, fNode.getName());
        return new BooleanExpression(new BinaryExpression(AbstractASTTransformUtil.identicalExpr(fieldExpr, new VariableExpression("this")), LOGICAL_AND, AbstractASTTransformUtil.identicalExpr(otherExpr, other)));
    }
}

