/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovyjarjarasm.asm.Opcodes;
import java.lang.annotation.Retention;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractASTTransformation
implements Opcodes,
ASTTransformation {
    public static final ClassNode RETENTION_CLASSNODE = ClassHelper.makeWithoutCaching(Retention.class);
    private SourceUnit sourceUnit;

    protected void init(ASTNode[] nodes, SourceUnit sourceUnit) {
        if (nodes == null || nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new GroovyBugError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + (nodes == null ? null : Arrays.asList(nodes)));
        }
        this.sourceUnit = sourceUnit;
    }

    protected boolean memberHasValue(AnnotationNode node, String name, Object value) {
        Expression member = node.getMember(name);
        return member != null && member instanceof ConstantExpression && ((ConstantExpression)member).getValue().equals(value);
    }

    protected Object getMemberValue(AnnotationNode node, String name) {
        Expression member = node.getMember(name);
        if (member != null && member instanceof ConstantExpression) {
            return ((ConstantExpression)member).getValue();
        }
        return null;
    }

    protected String getMemberStringValue(AnnotationNode node, String name, String defaultValue) {
        Object result;
        Expression member = node.getMember(name);
        if (member != null && member instanceof ConstantExpression && (result = ((ConstantExpression)member).getValue()) != null) {
            return result.toString();
        }
        return defaultValue;
    }

    protected String getMemberStringValue(AnnotationNode node, String name) {
        return this.getMemberStringValue(node, name, null);
    }

    protected int getMemberIntValue(AnnotationNode node, String name) {
        Object value = this.getMemberValue(node, name);
        if (value != null && value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    protected List<String> getMemberList(AnnotationNode anno, String name) {
        ArrayList<String> list;
        Expression expr = anno.getMember(name);
        if (expr != null && expr instanceof ListExpression) {
            list = new ArrayList();
            ListExpression listExpression = (ListExpression)expr;
            for (Expression itemExpr : listExpression.getExpressions()) {
                Object value;
                if (itemExpr == null || !(itemExpr instanceof ConstantExpression) || (value = ((ConstantExpression)itemExpr).getValue()) == null) continue;
                list.add(value.toString());
            }
        } else {
            list = this.tokenize(this.getMemberStringValue(anno, name));
        }
        return list;
    }

    protected List<ClassNode> getClassList(AnnotationNode anno, String name) {
        ClassNode cn;
        ArrayList<ClassNode> list = new ArrayList<ClassNode>();
        Expression expr = anno.getMember(name);
        if (expr != null && expr instanceof ListExpression) {
            ListExpression listExpression = (ListExpression)expr;
            for (Expression itemExpr : listExpression.getExpressions()) {
                ClassNode cn2;
                if (itemExpr == null || !(itemExpr instanceof ClassExpression) || (cn2 = itemExpr.getType()) == null) continue;
                list.add(cn2);
            }
        } else if (expr != null && expr instanceof ClassExpression && (cn = expr.getType()) != null) {
            list.add(cn);
        }
        return list;
    }

    protected void addError(String msg, ASTNode expr) {
        this.sourceUnit.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', expr.getLineNumber(), expr.getColumnNumber(), expr.getLastLineNumber(), expr.getLastColumnNumber()), this.sourceUnit));
    }

    protected void checkNotInterface(ClassNode cNode, String annotationName) {
        if (cNode.isInterface()) {
            this.addError("Error processing interface '" + cNode.getName() + "'. " + annotationName + " not allowed for interfaces.", cNode);
        }
    }

    protected boolean hasAnnotation(ClassNode cNode, ClassNode annotation) {
        List<AnnotationNode> annots = cNode.getAnnotations(annotation);
        return annots != null && annots.size() > 0;
    }

    protected List<String> tokenize(String rawExcludes) {
        return rawExcludes == null ? new ArrayList() : StringGroovyMethods.tokenize(rawExcludes, ", ");
    }

    public static boolean deemedInternalName(String name) {
        return name.contains("$");
    }

    public static boolean shouldSkip(String name, List<String> excludes, List<String> includes) {
        return excludes != null && excludes.contains(name) || AbstractASTTransformation.deemedInternalName(name) || includes != null && !includes.isEmpty() && !includes.contains(name);
    }

    public static boolean shouldSkipOnDescriptor(Map genericsSpec, String descriptor, List<ClassNode> excludeTypes, List<ClassNode> includeTypes) {
        String md;
        ClassNode next;
        Map updatedGenericsSpec;
        LinkedList<ClassNode> remaining;
        for (ClassNode cn : excludeTypes) {
            remaining = new LinkedList<ClassNode>();
            remaining.add(cn);
            updatedGenericsSpec = new HashMap(genericsSpec);
            while (!remaining.isEmpty()) {
                next = (ClassNode)remaining.remove(0);
                if (next.equals(ClassHelper.OBJECT_TYPE)) continue;
                updatedGenericsSpec = GenericsUtils.createGenericsSpec(next, updatedGenericsSpec);
                for (MethodNode mn : next.getMethods()) {
                    md = GenericsUtils.correctToGenericsSpec(updatedGenericsSpec, mn).getTypeDescriptor();
                    if (!md.equals(descriptor)) continue;
                    return true;
                }
                remaining.addAll(Arrays.asList(next.getInterfaces()));
            }
        }
        if (includeTypes.isEmpty()) {
            return false;
        }
        for (ClassNode cn : includeTypes) {
            remaining = new LinkedList();
            remaining.add(cn);
            updatedGenericsSpec = new HashMap(genericsSpec);
            while (!remaining.isEmpty()) {
                next = (ClassNode)remaining.remove(0);
                if (next.equals(ClassHelper.OBJECT_TYPE)) continue;
                updatedGenericsSpec = GenericsUtils.createGenericsSpec(next, updatedGenericsSpec);
                for (MethodNode mn : next.getMethods()) {
                    md = GenericsUtils.correctToGenericsSpec(updatedGenericsSpec, mn).getTypeDescriptor();
                    if (!md.equals(descriptor)) continue;
                    return false;
                }
                remaining.addAll(Arrays.asList(next.getInterfaces()));
            }
        }
        return true;
    }

    protected void checkIncludeExclude(AnnotationNode node, List<String> excludes, List<String> includes, String typeName) {
        if (includes != null && !includes.isEmpty() && excludes != null && !excludes.isEmpty()) {
            this.addError("Error during " + typeName + " processing: Only one of 'includes' and 'excludes' should be supplied not both.", node);
        }
    }

    protected void checkIncludeExclude(AnnotationNode node, List<String> excludes, List<String> includes, List<ClassNode> excludeTypes, List<ClassNode> includeTypes, String typeName) {
        int found = 0;
        if (includes != null && !includes.isEmpty()) {
            ++found;
        }
        if (excludes != null && !excludes.isEmpty()) {
            ++found;
        }
        if (includeTypes != null && !includeTypes.isEmpty()) {
            ++found;
        }
        if (excludeTypes != null && !excludeTypes.isEmpty()) {
            ++found;
        }
        if (found > 1) {
            this.addError("Error during " + typeName + " processing: Only one of 'includes', 'excludes', 'includeTypes' and 'excludeTypes' should be supplied.", node);
        }
    }

    @Deprecated
    public static ClassNode nonGeneric(ClassNode type) {
        return GenericsUtils.nonGeneric(type);
    }

    public static ClassNode newClass(ClassNode type) {
        return type.getPlainNodeReference();
    }

    public static ClassNode makeClassSafe0(ClassNode type, GenericsType ... genericTypes) {
        ClassNode plainNodeReference = AbstractASTTransformation.newClass(type);
        if (genericTypes != null && genericTypes.length > 0) {
            plainNodeReference.setGenericsTypes(genericTypes);
        }
        return plainNodeReference;
    }

    public static ClassNode makeClassSafeWithGenerics(ClassNode type, GenericsType ... genericTypes) {
        if (type.isArray()) {
            return AbstractASTTransformation.makeClassSafeWithGenerics(type.getComponentType(), genericTypes).makeArray();
        }
        GenericsType[] gtypes = new GenericsType[]{};
        if (genericTypes != null) {
            gtypes = new GenericsType[genericTypes.length];
            System.arraycopy(genericTypes, 0, gtypes, 0, gtypes.length);
        }
        return AbstractASTTransformation.makeClassSafe0(type, gtypes);
    }

    public static MethodNode correctToGenericsSpec(Map genericsSpec, MethodNode mn) {
        ClassNode correctedType = AbstractASTTransformation.correctToGenericsSpecRecurse(genericsSpec, mn.getReturnType());
        Parameter[] origParameters = mn.getParameters();
        Parameter[] newParameters = new Parameter[origParameters.length];
        for (int i = 0; i < origParameters.length; ++i) {
            Parameter origParameter = origParameters[i];
            newParameters[i] = new Parameter(AbstractASTTransformation.correctToGenericsSpecRecurse(genericsSpec, origParameter.getType()), origParameter.getName(), origParameter.getInitialExpression());
        }
        return new MethodNode(mn.getName(), mn.getModifiers(), correctedType, newParameters, mn.getExceptions(), mn.getCode());
    }

    public static ClassNode correctToGenericsSpecRecurse(Map genericsSpec, ClassNode type) {
        if (type.isGenericsPlaceHolder()) {
            String name = type.getGenericsTypes()[0].getName();
            type = (ClassNode)genericsSpec.get(name);
        }
        if (type == null) {
            type = ClassHelper.OBJECT_TYPE;
        }
        GenericsType[] oldgTypes = type.getGenericsTypes();
        GenericsType[] newgTypes = new GenericsType[]{};
        if (oldgTypes != null) {
            newgTypes = new GenericsType[oldgTypes.length];
            for (int i = 0; i < newgTypes.length; ++i) {
                GenericsType oldgType = oldgTypes[i];
                if (oldgType.isPlaceholder()) {
                    if (genericsSpec.get(oldgType.getName()) != null) {
                        newgTypes[i] = new GenericsType((ClassNode)genericsSpec.get(oldgType.getName()));
                        continue;
                    }
                    newgTypes[i] = new GenericsType(ClassHelper.OBJECT_TYPE);
                    continue;
                }
                if (oldgType.isWildcard()) {
                    ClassNode oldLower = oldgType.getLowerBound();
                    ClassNode lower = oldLower != null ? AbstractASTTransformation.correctToGenericsSpecRecurse(genericsSpec, oldLower) : null;
                    ClassNode[] oldUpper = oldgType.getUpperBounds();
                    ClassNode[] upper = null;
                    if (oldUpper != null) {
                        upper = new ClassNode[oldUpper.length];
                        for (int j = 0; j < oldUpper.length; ++j) {
                            upper[j] = AbstractASTTransformation.correctToGenericsSpecRecurse(genericsSpec, oldUpper[j]);
                        }
                    }
                    GenericsType fixed = new GenericsType(oldgType.getType(), upper, lower);
                    fixed.setWildcard(true);
                    newgTypes[i] = fixed;
                    continue;
                }
                newgTypes[i] = new GenericsType(GenericsUtils.correctToGenericsSpec(genericsSpec, oldgType));
            }
        }
        return AbstractASTTransformation.makeClassSafeWithGenerics(type, newgTypes);
    }

    public static void copyAnnotatedNodeAnnotations(AnnotatedNode annotatedNode, List<AnnotationNode> copied, List<AnnotationNode> notCopied) {
        List<AnnotationNode> annotationList = annotatedNode.getAnnotations();
        for (AnnotationNode annotation : annotationList) {
            PropertyExpression propertyExpression;
            boolean processAnnotation;
            List<AnnotationNode> annotations = annotation.getClassNode().getAnnotations(RETENTION_CLASSNODE);
            if (annotations.isEmpty()) continue;
            if (AbstractASTTransformation.hasClosureMember(annotation)) {
                notCopied.add(annotation);
                continue;
            }
            AnnotationNode retentionPolicyAnnotation = annotations.get(0);
            Expression valueExpression = retentionPolicyAnnotation.getMember("value");
            if (!(valueExpression instanceof PropertyExpression) || !(processAnnotation = (propertyExpression = (PropertyExpression)valueExpression).getProperty() instanceof ConstantExpression && ("RUNTIME".equals(((ConstantExpression)propertyExpression.getProperty()).getValue()) || "CLASS".equals(((ConstantExpression)propertyExpression.getProperty()).getValue())))) continue;
            AnnotationNode newAnnotation = new AnnotationNode(annotation.getClassNode());
            for (Map.Entry<String, Expression> member : annotation.getMembers().entrySet()) {
                newAnnotation.addMember(member.getKey(), member.getValue());
            }
            newAnnotation.setSourcePosition(annotatedNode);
            copied.add(newAnnotation);
        }
    }

    private static boolean hasClosureMember(AnnotationNode annotation) {
        Map<String, Expression> members = annotation.getMembers();
        for (Map.Entry<String, Expression> member : members.entrySet()) {
            ClassExpression classExpression;
            Class typeClass;
            if (member.getValue() instanceof ClosureExpression) {
                return true;
            }
            if (!(member.getValue() instanceof ClassExpression) || (typeClass = (classExpression = (ClassExpression)member.getValue()).getType().isResolved() ? classExpression.getType().redirect().getTypeClass() : null) == null || !GeneratedClosure.class.isAssignableFrom(typeClass)) continue;
            return true;
        }
        return false;
    }
}

