/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.InheritConstructors;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class InheritConstructorsASTTransformation
extends AbstractASTTransformation {
    private static final Class MY_CLASS = InheritConstructors.class;
    private static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(node.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            this.processClass((ClassNode)parent, source);
        }
    }

    private void processClass(ClassNode cNode, SourceUnit source) {
        if (cNode.isInterface()) {
            this.addError("Error processing interface '" + cNode.getName() + "'. " + MY_TYPE_NAME + " only allowed for classes.", cNode);
            return;
        }
        ClassNode sNode = cNode.getSuperClass();
        List<AnnotationNode> superAnnotations = sNode.getAnnotations(MY_TYPE);
        if (superAnnotations.size() == 1) {
            this.processClass(sNode, source);
        }
        for (ConstructorNode cn : sNode.getDeclaredConstructors()) {
            this.addConstructorUnlessAlreadyExisting(cNode, cn);
        }
    }

    private void addConstructorUnlessAlreadyExisting(ClassNode classNode, ConstructorNode consNode) {
        Parameter[] origParams = consNode.getParameters();
        if (consNode.isPrivate()) {
            return;
        }
        Parameter[] params = new Parameter[origParams.length];
        ArrayList<Expression> theArgs = new ArrayList<Expression>();
        for (int i = 0; i < origParams.length; ++i) {
            Parameter p = origParams[i];
            params[i] = p.hasInitialExpression() ? new Parameter(p.getType(), p.getName(), p.getInitialExpression()) : new Parameter(p.getType(), p.getName());
            theArgs.add(GeneralUtils.varX(p.getName(), p.getType()));
        }
        if (this.isExisting(classNode, params)) {
            return;
        }
        BlockStatement body = new BlockStatement();
        body.addStatement(GeneralUtils.stmt(GeneralUtils.ctorX(ClassNode.SUPER, GeneralUtils.args(theArgs))));
        classNode.addConstructor(consNode.getModifiers(), params, consNode.getExceptions(), body);
    }

    private boolean isExisting(ClassNode classNode, Parameter[] params) {
        for (ConstructorNode consNode : classNode.getDeclaredConstructors()) {
            if (!this.matchingTypes(params, consNode.getParameters())) continue;
            return true;
        }
        return false;
    }

    private boolean matchingTypes(Parameter[] params, Parameter[] existingParams) {
        if (params.length != existingParams.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getType().equals(existingParams[i].getType())) continue;
            return false;
        }
        return true;
    }
}

