/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.trait;

import groovy.transform.CompileStatic;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.ASTTransformationCollectorCodeVisitor;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.trait.SuperCallTraitTransformer;
import org.codehaus.groovy.transform.trait.TraitHelpersTuple;
import org.codehaus.groovy.transform.trait.Traits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TraitComposer {
    private static final Comparator<MethodNode> GETTER_FIRST_COMPARATOR = new Comparator<MethodNode>(){

        @Override
        public int compare(MethodNode o1, MethodNode o2) {
            if (o1.getName().endsWith("$get")) {
                return -1;
            }
            return 1;
        }
    };

    public static void doExtendTraits(ClassNode cNode, SourceUnit unit, CompilationUnit cu) {
        if (cNode.isInterface()) {
            return;
        }
        boolean isItselfTrait = Traits.isTrait(cNode);
        SuperCallTraitTransformer superCallTransformer = new SuperCallTraitTransformer(unit);
        if (isItselfTrait) {
            TraitComposer.checkTraitAllowed(cNode, unit);
            return;
        }
        if (!cNode.getNameWithoutPackage().endsWith("$Trait$Helper")) {
            List<ClassNode> traits = TraitComposer.findTraits(cNode);
            for (ClassNode trait : traits) {
                TraitHelpersTuple helpers = Traits.findHelpers(trait);
                TraitComposer.applyTrait(trait, cNode, helpers);
                superCallTransformer.visitClass(cNode);
                if (unit == null) continue;
                ASTTransformationCollectorCodeVisitor collector = new ASTTransformationCollectorCodeVisitor(unit, cu.getTransformLoader());
                collector.visitClass(cNode);
            }
        }
    }

    private static void collectAllInterfacesReverseOrder(ClassNode cNode, LinkedHashSet<ClassNode> interfaces) {
        if (cNode.isInterface()) {
            interfaces.add(cNode);
        }
        ClassNode[] directInterfaces = cNode.getInterfaces();
        for (int i = directInterfaces.length - 1; i >= 0; --i) {
            ClassNode anInterface = directInterfaces[i];
            interfaces.add(anInterface);
            TraitComposer.collectAllInterfacesReverseOrder(anInterface, interfaces);
        }
    }

    private static List<ClassNode> findTraits(ClassNode cNode) {
        LinkedHashSet<ClassNode> interfaces = new LinkedHashSet<ClassNode>();
        TraitComposer.collectAllInterfacesReverseOrder(cNode, interfaces);
        LinkedList<ClassNode> traits = new LinkedList<ClassNode>();
        for (ClassNode candidate : interfaces) {
            if (!Traits.isAnnotatedWithTrait(candidate)) continue;
            traits.add(candidate);
        }
        return traits;
    }

    private static void checkTraitAllowed(ClassNode bottomTrait, SourceUnit unit) {
        ClassNode superClass = bottomTrait.getSuperClass();
        if (superClass == null || ClassHelper.OBJECT_TYPE.equals(superClass)) {
            return;
        }
        if (!Traits.isTrait(superClass)) {
            unit.addError(new SyntaxException("A trait can only inherit from another trait", superClass.getLineNumber(), superClass.getColumnNumber()));
        }
    }

    private static void applyTrait(ClassNode trait, ClassNode cNode, TraitHelpersTuple helpers) {
        ClassNode returnType;
        boolean isTraitForceOverride = !trait.getAnnotations(Traits.FORCEOVERRIDE_CLASSNODE).isEmpty();
        ClassNode helperClassNode = helpers.getHelper();
        ClassNode fieldHelperClassNode = helpers.getFieldHelper();
        Map genericsSpec = GenericsUtils.createGenericsSpec(cNode, new HashMap());
        genericsSpec = GenericsUtils.createGenericsSpec(trait, genericsSpec);
        for (MethodNode methodNode : helperClassNode.getAllDeclaredMethods()) {
            Expression forwardExpression;
            boolean isForceOverride = isTraitForceOverride || Traits.isForceOverride(methodNode);
            String name = methodNode.getName();
            int access = methodNode.getModifiers();
            Parameter[] argumentTypes = methodNode.getParameters();
            ClassNode[] exceptions = methodNode.getExceptions();
            returnType = methodNode.getReturnType();
            boolean isAbstract = methodNode.isAbstract();
            if (isAbstract || argumentTypes.length <= 0 || (access & 8) != 8 || name.contains("$")) continue;
            ArgumentListExpression argList = new ArgumentListExpression();
            argList.addExpression(new VariableExpression("this"));
            Parameter[] params = new Parameter[argumentTypes.length - 1];
            for (int i = 1; i < argumentTypes.length; ++i) {
                Parameter parameter = argumentTypes[i];
                ClassNode originType = parameter.getOriginType();
                ClassNode fixedType = AbstractASTTransformation.correctToGenericsSpecRecurse(genericsSpec, originType);
                Parameter newParam = new Parameter(fixedType, "arg" + i);
                LinkedList<AnnotationNode> copied = new LinkedList<AnnotationNode>();
                LinkedList<AnnotationNode> notCopied = new LinkedList<AnnotationNode>();
                AbstractASTTransformation.copyAnnotatedNodeAnnotations(parameter, copied, notCopied);
                newParam.addAnnotations(copied);
                params[i - 1] = newParam;
                argList.addExpression(new VariableExpression(params[i - 1]));
            }
            MethodNode existingMethod = cNode.getMethod(name, params);
            if (existingMethod == null) {
                existingMethod = TraitComposer.findDefaultMethodFromInterface(cNode, name, params);
            }
            if (!isForceOverride && (existingMethod != null || TraitComposer.isExistingProperty(name, cNode, params)) || isForceOverride && cNode.getDeclaredMethod(name, params) != null) continue;
            ClassNode[] exceptionNodes = new ClassNode[exceptions == null ? 0 : exceptions.length];
            System.arraycopy(exceptions, 0, exceptionNodes, 0, exceptionNodes.length);
            MethodCallExpression mce = new MethodCallExpression((Expression)new ClassExpression(helperClassNode), name, (Expression)argList);
            mce.setImplicitThis(false);
            ClassNode fixedReturnType = AbstractASTTransformation.correctToGenericsSpecRecurse(genericsSpec, returnType);
            Expression expression = forwardExpression = genericsSpec.isEmpty() ? mce : new CastExpression(fixedReturnType, mce);
            if (!argumentTypes[0].getOriginType().equals(ClassHelper.CLASS_Type)) {
                access ^= 8;
            }
            MethodNode forwarder = new MethodNode(name, access, fixedReturnType, params, exceptionNodes, new ExpressionStatement(forwardExpression));
            LinkedList<AnnotationNode> copied = new LinkedList<AnnotationNode>();
            List<AnnotationNode> notCopied = Collections.emptyList();
            AbstractASTTransformation.copyAnnotatedNodeAnnotations(methodNode, copied, notCopied);
            if (!copied.isEmpty()) {
                forwarder.addAnnotations(copied);
            }
            cNode.addMethod(forwarder);
        }
        cNode.addObjectInitializerStatements(new ExpressionStatement(new MethodCallExpression((Expression)new ClassExpression(helperClassNode), "$init$", (Expression)new ArgumentListExpression(new VariableExpression("this")))));
        cNode.addStaticInitializerStatements(Collections.singletonList(new ExpressionStatement(new MethodCallExpression((Expression)new ClassExpression(helperClassNode), "$static$init$", (Expression)new ArgumentListExpression(new VariableExpression("this"))))), false);
        if (fieldHelperClassNode != null) {
            cNode.addInterface(fieldHelperClassNode);
            List<MethodNode> declaredMethods = fieldHelperClassNode.getAllDeclaredMethods();
            Collections.sort(declaredMethods, GETTER_FIRST_COMPARATOR);
            for (MethodNode methodNode : declaredMethods) {
                Parameter[] newParams;
                String fieldName = methodNode.getName();
                if (!fieldName.endsWith("$get") && !fieldName.endsWith("$set")) continue;
                int suffixIdx = fieldName.lastIndexOf("$");
                fieldName = fieldName.substring(0, suffixIdx);
                String operation = methodNode.getName().substring(suffixIdx + 1);
                boolean getter = "get".equals(operation);
                returnType = AbstractASTTransformation.correctToGenericsSpecRecurse(genericsSpec, methodNode.getReturnType());
                int isStatic = 0;
                FieldNode helperField = fieldHelperClassNode.getField(fieldName);
                if (helperField == null) {
                    helperField = fieldHelperClassNode.getField("$static" + fieldName);
                    isStatic = 8;
                }
                if (getter && helperField != null) {
                    LinkedList<AnnotationNode> copied = new LinkedList<AnnotationNode>();
                    LinkedList<AnnotationNode> notCopied = new LinkedList<AnnotationNode>();
                    AbstractASTTransformation.copyAnnotatedNodeAnnotations(helperField, copied, notCopied);
                    FieldNode fieldNode = cNode.addField(fieldName, 2 | isStatic, returnType, null);
                    fieldNode.addAnnotations(copied);
                }
                if (getter) {
                    newParams = Parameter.EMPTY_ARRAY;
                } else {
                    ClassNode originType = methodNode.getParameters()[0].getOriginType();
                    ClassNode fixedType = originType.isGenericsPlaceHolder() ? ClassHelper.OBJECT_TYPE : AbstractASTTransformation.correctToGenericsSpecRecurse(genericsSpec, originType);
                    newParams = new Parameter[]{new Parameter(fixedType, "val")};
                }
                VariableExpression fieldExpr = new VariableExpression(cNode.getField(fieldName));
                Statement body = getter ? new ReturnStatement(fieldExpr) : new ExpressionStatement(new BinaryExpression(fieldExpr, Token.newSymbol(100, 0, 0), new VariableExpression(newParams[0])));
                MethodNode impl = new MethodNode(methodNode.getName(), 1 | isStatic, returnType, newParams, ClassNode.EMPTY_ARRAY, body);
                impl.addAnnotation(new AnnotationNode(ClassHelper.make(CompileStatic.class)));
                cNode.addMethod(impl);
            }
        }
    }

    private static MethodNode findDefaultMethodFromInterface(ClassNode cNode, String name, Parameter[] params) {
        ClassNode[] interfaces;
        MethodNode method;
        if (cNode == null) {
            return null;
        }
        if (cNode.isInterface() && (method = cNode.getMethod(name, params)) != null && !method.isAbstract()) {
            return method;
        }
        for (ClassNode anInterface : interfaces = cNode.getInterfaces()) {
            MethodNode res = TraitComposer.findDefaultMethodFromInterface(anInterface, name, params);
            if (res == null) continue;
            return res;
        }
        return TraitComposer.findDefaultMethodFromInterface(cNode.getSuperClass(), name, params);
    }

    private static boolean isExistingProperty(String methodName, ClassNode cNode, Parameter[] params) {
        String propertyName = methodName;
        boolean getter = false;
        if (methodName.startsWith("get")) {
            propertyName = propertyName.substring(3);
            getter = true;
        } else if (methodName.startsWith("is")) {
            propertyName = propertyName.substring(2);
            getter = true;
        } else if (methodName.startsWith("set")) {
            propertyName = propertyName.substring(3);
        } else {
            return false;
        }
        if (getter && params.length > 0) {
            return false;
        }
        if (!getter && params.length != 1) {
            return false;
        }
        if (propertyName.length() == 0) {
            return false;
        }
        PropertyNode pNode = cNode.getProperty(propertyName = MetaClassHelper.convertPropertyName(propertyName));
        return pNode != null;
    }
}

