/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.tools;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;

public class GenericsUtils {
    public static final GenericsType[] EMPTY_GENERICS_ARRAY = new GenericsType[0];

    @Deprecated
    public static GenericsType[] alignGenericTypes(GenericsType[] redirectGenericTypes, GenericsType[] parameterizedTypes, GenericsType[] alignmentTarget) {
        if (alignmentTarget == null) {
            return EMPTY_GENERICS_ARRAY;
        }
        if (parameterizedTypes == null || parameterizedTypes.length == 0) {
            return alignmentTarget;
        }
        GenericsType[] generics = new GenericsType[alignmentTarget.length];
        for (GenericsType currentTarget : alignmentTarget) {
            GenericsType match = null;
            if (redirectGenericTypes != null) {
                for (int j = 0; j < redirectGenericTypes.length && match == null; ++j) {
                    ClassNode[] upper;
                    GenericsType redirectGenericType = redirectGenericTypes[j];
                    if (!redirectGenericType.isCompatibleWith(currentTarget.getType())) continue;
                    if (currentTarget.isPlaceholder() && redirectGenericType.isPlaceholder() && !currentTarget.getName().equals(redirectGenericType.getName())) {
                        boolean skip = false;
                        for (int k = j + 1; k < redirectGenericTypes.length && !skip; ++k) {
                            GenericsType ogt = redirectGenericTypes[k];
                            if (!ogt.isPlaceholder() || !ogt.isCompatibleWith(currentTarget.getType()) || !ogt.getName().equals(currentTarget.getName())) continue;
                            skip = true;
                        }
                        if (skip) continue;
                    }
                    match = parameterizedTypes[j];
                    if (!currentTarget.isWildcard()) continue;
                    ClassNode lower = currentTarget.getLowerBound() != null ? match.getType() : null;
                    ClassNode[] currentUpper = currentTarget.getUpperBounds();
                    ClassNode[] classNodeArray = upper = currentUpper != null ? new ClassNode[currentUpper.length] : null;
                    if (upper != null) {
                        for (int k = 0; k < upper.length; ++k) {
                            upper[k] = currentUpper[k].isGenericsPlaceHolder() ? match.getType() : currentUpper[k];
                        }
                    }
                    match = new GenericsType(ClassHelper.makeWithoutCaching("?"), upper, lower);
                    match.setWildcard(true);
                }
            }
            if (match == null) {
                match = currentTarget;
            }
            generics[i] = match;
        }
        return generics;
    }

    public static GenericsType buildWildcardType(ClassNode ... types) {
        ClassNode base = ClassHelper.makeWithoutCaching("?");
        GenericsType gt = new GenericsType(base, types, null);
        gt.setWildcard(true);
        return gt;
    }

    public static Map<String, GenericsType> extractPlaceholders(ClassNode cn) {
        HashMap<String, GenericsType> ret = new HashMap<String, GenericsType>();
        GenericsUtils.extractPlaceholders(cn, ret);
        return ret;
    }

    public static void extractPlaceholders(ClassNode node, Map<String, GenericsType> map) {
        if (node == null) {
            return;
        }
        if (node.isArray()) {
            GenericsUtils.extractPlaceholders(node.getComponentType(), map);
            return;
        }
        if (!node.isUsingGenerics() || !node.isRedirectNode()) {
            return;
        }
        GenericsType[] parameterized = node.getGenericsTypes();
        if (parameterized == null || parameterized.length == 0) {
            return;
        }
        GenericsType[] redirectGenericsTypes = node.redirect().getGenericsTypes();
        if (redirectGenericsTypes == null) {
            redirectGenericsTypes = parameterized;
        }
        for (int i = 0; i < redirectGenericsTypes.length; ++i) {
            String name;
            GenericsType redirectType = redirectGenericsTypes[i];
            if (!redirectType.isPlaceholder() || map.containsKey(name = redirectType.getName())) continue;
            GenericsType value = parameterized[i];
            map.put(name, value);
            if (value.isWildcard()) {
                ClassNode[] upperBounds;
                ClassNode lowerBound = value.getLowerBound();
                if (lowerBound != null) {
                    GenericsUtils.extractPlaceholders(lowerBound, map);
                }
                if ((upperBounds = value.getUpperBounds()) == null) continue;
                for (ClassNode upperBound : upperBounds) {
                    GenericsUtils.extractPlaceholders(upperBound, map);
                }
                continue;
            }
            if (value.isPlaceholder()) continue;
            GenericsUtils.extractPlaceholders(value.getType(), map);
        }
    }

    public static ClassNode parameterizeInterfaceGenerics(ClassNode hint, ClassNode target) {
        return GenericsUtils.parameterizeType(hint, target);
    }

    public static ClassNode parameterizeType(ClassNode hint, ClassNode target) {
        if (hint.isArray() && target.isArray()) {
            return GenericsUtils.parameterizeType(hint.getComponentType(), target.getComponentType()).makeArray();
        }
        ClassNode interfaceFromClassNode = null;
        if (hint.equals(target)) {
            interfaceFromClassNode = hint;
        }
        if (ClassHelper.OBJECT_TYPE.equals(target) && target.isUsingGenerics() && target.getGenericsTypes() != null && target.getGenericsTypes()[0].isPlaceholder()) {
            return ClassHelper.getWrapper(hint);
        }
        if (interfaceFromClassNode == null) {
            ClassNode[] interfaces;
            for (ClassNode node : interfaces = hint.getInterfaces()) {
                if (node.equals(target)) {
                    interfaceFromClassNode = node;
                    break;
                }
                if (!node.implementsInterface(target)) continue;
                return GenericsUtils.parameterizeType(GenericsUtils.parameterizeType(hint, node), target);
            }
        }
        if (interfaceFromClassNode == null && hint.getUnresolvedSuperClass() != null) {
            return GenericsUtils.parameterizeType(hint.getUnresolvedSuperClass(), target);
        }
        if (interfaceFromClassNode == null) {
            interfaceFromClassNode = hint;
        }
        HashMap<String, GenericsType> parameters = new HashMap<String, GenericsType>();
        GenericsUtils.extractPlaceholders(hint, parameters);
        ClassNode node = target.getPlainNodeReference();
        GenericsType[] interfaceGTs = interfaceFromClassNode.getGenericsTypes();
        if (interfaceGTs == null) {
            return target;
        }
        GenericsType[] types = new GenericsType[interfaceGTs.length];
        for (int i = 0; i < interfaceGTs.length; ++i) {
            String name;
            GenericsType interfaceGT;
            types[i] = interfaceGT = interfaceGTs[i];
            if (!interfaceGT.isPlaceholder() || !parameters.containsKey(name = interfaceGT.getName())) continue;
            types[i] = (GenericsType)parameters.get(name);
        }
        node.setGenericsTypes(types);
        return node;
    }

    public static ClassNode nonGeneric(ClassNode type) {
        if (type.isUsingGenerics()) {
            ClassNode nonGen = ClassHelper.makeWithoutCaching(type.getName());
            nonGen.setRedirect(type);
            nonGen.setGenericsTypes(null);
            nonGen.setUsingGenerics(false);
            return nonGen;
        }
        if (type.isArray() && type.getComponentType().isUsingGenerics()) {
            return type.getComponentType().getPlainNodeReference().makeArray();
        }
        return type;
    }

    public static ClassNode newClass(ClassNode type) {
        return type.getPlainNodeReference();
    }

    public static ClassNode makeClassSafe(Class klass) {
        return GenericsUtils.makeClassSafeWithGenerics(ClassHelper.make(klass), new GenericsType[0]);
    }

    public static ClassNode makeClassSafe0(ClassNode type, GenericsType ... genericTypes) {
        ClassNode plainNodeReference = GenericsUtils.newClass(type);
        if (genericTypes != null && genericTypes.length > 0) {
            plainNodeReference.setGenericsTypes(genericTypes);
        }
        return plainNodeReference;
    }

    public static ClassNode makeClassSafeWithGenerics(ClassNode type, GenericsType ... genericTypes) {
        if (type.isArray()) {
            return GenericsUtils.makeClassSafeWithGenerics(type.getComponentType(), genericTypes).makeArray();
        }
        GenericsType[] gtypes = new GenericsType[]{};
        if (genericTypes != null) {
            gtypes = new GenericsType[genericTypes.length];
            System.arraycopy(genericTypes, 0, gtypes, 0, gtypes.length);
        }
        return GenericsUtils.makeClassSafe0(type, gtypes);
    }

    public static MethodNode correctToGenericsSpec(Map<String, ClassNode> genericsSpec, MethodNode mn) {
        ClassNode correctedType = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, mn.getReturnType());
        Parameter[] origParameters = mn.getParameters();
        Parameter[] newParameters = new Parameter[origParameters.length];
        for (int i = 0; i < origParameters.length; ++i) {
            Parameter origParameter = origParameters[i];
            newParameters[i] = new Parameter(GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, origParameter.getType()), origParameter.getName(), origParameter.getInitialExpression());
        }
        return new MethodNode(mn.getName(), mn.getModifiers(), correctedType, newParameters, mn.getExceptions(), mn.getCode());
    }

    public static ClassNode correctToGenericsSpecRecurse(Map<String, ClassNode> genericsSpec, ClassNode type) {
        if (type.isGenericsPlaceHolder()) {
            String name = type.getGenericsTypes()[0].getName();
            type = genericsSpec.get(name);
        }
        if (type == null) {
            type = ClassHelper.OBJECT_TYPE;
        }
        GenericsType[] oldgTypes = type.getGenericsTypes();
        GenericsType[] newgTypes = new GenericsType[]{};
        if (oldgTypes != null) {
            newgTypes = new GenericsType[oldgTypes.length];
            for (int i = 0; i < newgTypes.length; ++i) {
                GenericsType oldgType = oldgTypes[i];
                if (oldgType.isPlaceholder()) {
                    if (genericsSpec.get(oldgType.getName()) != null) {
                        newgTypes[i] = new GenericsType(genericsSpec.get(oldgType.getName()));
                        continue;
                    }
                    newgTypes[i] = new GenericsType(ClassHelper.OBJECT_TYPE);
                    continue;
                }
                if (oldgType.isWildcard()) {
                    ClassNode oldLower = oldgType.getLowerBound();
                    ClassNode lower = oldLower != null ? GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, oldLower) : null;
                    ClassNode[] oldUpper = oldgType.getUpperBounds();
                    ClassNode[] upper = null;
                    if (oldUpper != null) {
                        upper = new ClassNode[oldUpper.length];
                        for (int j = 0; j < oldUpper.length; ++j) {
                            upper[j] = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, oldUpper[j]);
                        }
                    }
                    GenericsType fixed = new GenericsType(oldgType.getType(), upper, lower);
                    fixed.setWildcard(true);
                    newgTypes[i] = fixed;
                    continue;
                }
                newgTypes[i] = new GenericsType(GenericsUtils.correctToGenericsSpec(genericsSpec, oldgType));
            }
        }
        return GenericsUtils.makeClassSafeWithGenerics(type, newgTypes);
    }

    public static ClassNode correctToGenericsSpec(Map<String, ClassNode> genericsSpec, GenericsType type) {
        ClassNode ret = null;
        if (type.isPlaceholder()) {
            String name = type.getName();
            ret = genericsSpec.get(name);
        }
        if (ret == null) {
            ret = type.getType();
        }
        return ret;
    }

    public static ClassNode correctToGenericsSpec(Map<String, ClassNode> genericsSpec, ClassNode type) {
        if (type.isGenericsPlaceHolder()) {
            String name = type.getGenericsTypes()[0].getName();
            type = genericsSpec.get(name);
        }
        if (type == null) {
            type = ClassHelper.OBJECT_TYPE;
        }
        return type;
    }

    public static Map<String, ClassNode> createGenericsSpec(ClassNode current, Map<String, ClassNode> oldSpec) {
        HashMap<String, ClassNode> ret = new HashMap<String, ClassNode>(oldSpec);
        GenericsType[] sgts = current.getGenericsTypes();
        if (sgts != null) {
            ClassNode[] spec = new ClassNode[sgts.length];
            for (int i = 0; i < spec.length; ++i) {
                spec[i] = GenericsUtils.correctToGenericsSpec(ret, sgts[i]);
            }
            GenericsType[] newGts = current.redirect().getGenericsTypes();
            if (newGts == null) {
                return ret;
            }
            ret.clear();
            for (int i = 0; i < spec.length; ++i) {
                ret.put(newGts[i].getName(), spec[i]);
            }
        }
        return ret;
    }
}

