/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.trait;

import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.trait.Traits;

class TraitReceiverTransformer
extends ClassCodeExpressionTransformer {
    private final VariableExpression weaved;
    private final SourceUnit unit;
    private final ClassNode traitClass;
    private final ClassNode fieldHelper;
    private final Collection<String> knownFields;

    public TraitReceiverTransformer(VariableExpression thisObject, SourceUnit unit, ClassNode traitClass, ClassNode fieldHelper, Collection<String> knownFields) {
        this.weaved = thisObject;
        this.unit = unit;
        this.traitClass = traitClass;
        this.fieldHelper = fieldHelper;
        this.knownFields = knownFields;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.unit;
    }

    @Override
    public Expression transform(Expression exp) {
        ClassNode weavedType = this.weaved.getOriginType();
        if (exp instanceof BinaryExpression) {
            Expression leftExpression = ((BinaryExpression)exp).getLeftExpression();
            Expression rightExpression = ((BinaryExpression)exp).getRightExpression();
            Token operation = ((BinaryExpression)exp).getOperation();
            if (operation.getText().equals("=")) {
                String leftFieldName = null;
                if (leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).getAccessedVariable() instanceof FieldNode) {
                    leftFieldName = ((VariableExpression)leftExpression).getAccessedVariable().getName();
                } else if (leftExpression instanceof FieldExpression) {
                    leftFieldName = ((FieldExpression)leftExpression).getFieldName();
                } else if (leftExpression instanceof PropertyExpression && (((PropertyExpression)leftExpression).isImplicitThis() || "this".equals(((PropertyExpression)leftExpression).getObjectExpression().getText()))) {
                    leftFieldName = ((PropertyExpression)leftExpression).getPropertyAsString();
                }
                if (leftFieldName != null) {
                    FieldNode fn = weavedType.getDeclaredField(leftFieldName);
                    if (fn == null) {
                        fn = new FieldNode(leftFieldName, 0, ClassHelper.OBJECT_TYPE, weavedType, null);
                    }
                    Expression receiver = this.createFieldHelperReceiver();
                    if (fn.isStatic()) {
                        receiver = new PropertyExpression(receiver, "class");
                    }
                    String method = Traits.helperSetterName(fn);
                    MethodCallExpression mce = new MethodCallExpression(receiver, method, (Expression)new ArgumentListExpression(super.transform(rightExpression)));
                    mce.setSourcePosition(exp);
                    mce.setImplicitThis(false);
                    return mce;
                }
            }
            Expression leftTransform = this.transform(leftExpression);
            Expression rightTransform = this.transform(rightExpression);
            BinaryExpression ret = exp instanceof DeclarationExpression ? new DeclarationExpression(leftTransform, operation, rightTransform) : new BinaryExpression(leftTransform, operation, rightTransform);
            ret.setSourcePosition(exp);
            ret.copyNodeMetaData(exp);
            return ret;
        }
        if (exp instanceof StaticMethodCallExpression) {
            StaticMethodCallExpression call = (StaticMethodCallExpression)exp;
            ClassNode ownerType = call.getOwnerType();
            if (this.traitClass.equals(ownerType)) {
                MethodCallExpression result = new MethodCallExpression((Expression)new VariableExpression(this.weaved), call.getMethod(), this.transform(call.getArguments()));
                result.setSafe(false);
                result.setImplicitThis(false);
                result.setSpreadSafe(false);
                result.setSourcePosition(call);
                return result;
            }
        } else if (exp instanceof MethodCallExpression) {
            MethodCallExpression call = (MethodCallExpression)exp;
            Expression obj = call.getObjectExpression();
            if (call.isImplicitThis() || "this".equals(obj.getText())) {
                return this.transformMethodCallOnThis(call);
            }
            if ("super".equals(obj.getText())) {
                return this.transformSuperMethodCall(call);
            }
        } else {
            if (exp instanceof FieldExpression) {
                FieldNode field = ((FieldExpression)exp).getField();
                MethodCallExpression mce = new MethodCallExpression(this.createFieldHelperReceiver(), Traits.helperGetterName(field), (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
                mce.setSourcePosition(exp);
                mce.setImplicitThis(false);
                return mce;
            }
            if (exp instanceof VariableExpression) {
                VariableExpression vexp = (VariableExpression)exp;
                Variable accessedVariable = vexp.getAccessedVariable();
                if (accessedVariable instanceof FieldNode) {
                    FieldNode fn = (FieldNode)accessedVariable;
                    Expression receiver = this.createFieldHelperReceiver();
                    if (fn.isStatic()) {
                        receiver = new PropertyExpression(this.createFieldHelperReceiver(), "class");
                    }
                    MethodCallExpression mce = new MethodCallExpression(receiver, Traits.helperGetterName((FieldNode)accessedVariable), (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
                    mce.setSourcePosition(exp);
                    mce.setImplicitThis(false);
                    return mce;
                }
                if (accessedVariable instanceof PropertyNode) {
                    String propName = accessedVariable.getName();
                    if (this.knownFields.contains(propName)) {
                        String method = Traits.helperGetterName(new FieldNode(propName, 0, ClassHelper.OBJECT_TYPE, weavedType, null));
                        MethodCallExpression mce = new MethodCallExpression(this.createFieldHelperReceiver(), method, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
                        mce.setSourcePosition(exp);
                        mce.setImplicitThis(false);
                        return mce;
                    }
                    return new PropertyExpression((Expression)new VariableExpression(this.weaved), accessedVariable.getName());
                }
                if (accessedVariable instanceof DynamicVariable) {
                    return new PropertyExpression((Expression)new VariableExpression(this.weaved), accessedVariable.getName());
                }
                if (vexp.isThisExpression()) {
                    VariableExpression res = new VariableExpression(this.weaved);
                    res.setSourcePosition(exp);
                    return res;
                }
                if (vexp.isSuperExpression()) {
                    this.throwSuperError(vexp);
                }
            } else if (exp instanceof PropertyExpression) {
                String propName;
                PropertyExpression pexp = (PropertyExpression)exp;
                Expression object = pexp.getObjectExpression();
                if ((pexp.isImplicitThis() || "this".equals(object.getText())) && this.knownFields.contains(propName = pexp.getPropertyAsString())) {
                    String method = Traits.helperGetterName(new FieldNode(propName, 0, ClassHelper.OBJECT_TYPE, weavedType, null));
                    MethodCallExpression mce = new MethodCallExpression(this.createFieldHelperReceiver(), method, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
                    mce.setSourcePosition(exp);
                    mce.setImplicitThis(false);
                    return mce;
                }
            } else if (exp instanceof ClosureExpression) {
                MethodCallExpression mce = new MethodCallExpression(exp, "rehydrate", (Expression)new ArgumentListExpression(new VariableExpression(this.weaved), new VariableExpression(this.weaved), new VariableExpression(this.weaved)));
                mce.setImplicitThis(false);
                mce.setSourcePosition(exp);
                return mce;
            }
        }
        return super.transform(exp);
    }

    private void throwSuperError(ASTNode node) {
        this.unit.addError(new SyntaxException("Call to super is not allowed in a trait", node.getLineNumber(), node.getColumnNumber()));
    }

    private Expression transformSuperMethodCall(MethodCallExpression call) {
        String method = call.getMethodAsString();
        if (method == null) {
            this.throwSuperError(call);
        }
        Expression arguments = this.transform(call.getArguments());
        ArgumentListExpression superCallArgs = new ArgumentListExpression();
        superCallArgs.addExpression(new ClassExpression(this.traitClass));
        if (arguments instanceof ArgumentListExpression) {
            ArgumentListExpression list = (ArgumentListExpression)arguments;
            for (Expression expression : list) {
                superCallArgs.addExpression(expression);
            }
        } else {
            superCallArgs.addExpression(arguments);
        }
        MethodCallExpression transformed = new MethodCallExpression((Expression)this.weaved, "trait$super$" + method, (Expression)superCallArgs);
        transformed.setSourcePosition(call);
        transformed.setSafe(call.isSafe());
        transformed.setSpreadSafe(call.isSpreadSafe());
        transformed.setImplicitThis(false);
        return transformed;
    }

    private Expression transformMethodCallOnThis(MethodCallExpression call) {
        Expression method = call.getMethod();
        Expression arguments = call.getArguments();
        if (method instanceof ConstantExpression) {
            String methodName = method.getText();
            List<MethodNode> methods = this.traitClass.getMethods(methodName);
            for (MethodNode methodNode : methods) {
                if (!methodName.equals(methodNode.getName()) || !methodNode.isPrivate()) continue;
                return this.transformPrivateMethodCall(call, arguments, methodName);
            }
        }
        MethodCallExpression transformed = new MethodCallExpression((Expression)this.weaved, method, this.transform(arguments));
        transformed.setSourcePosition(call);
        transformed.setSafe(call.isSafe());
        transformed.setSpreadSafe(call.isSpreadSafe());
        transformed.setImplicitThis(false);
        return transformed;
    }

    private Expression transformPrivateMethodCall(MethodCallExpression call, Expression arguments, String methodName) {
        ArgumentListExpression newArgs = this.createArgumentList(arguments);
        MethodCallExpression transformed = new MethodCallExpression((Expression)new VariableExpression("this"), methodName, (Expression)newArgs);
        transformed.setSourcePosition(call);
        transformed.setSafe(call.isSafe());
        transformed.setSpreadSafe(call.isSpreadSafe());
        transformed.setImplicitThis(true);
        return transformed;
    }

    private Expression createFieldHelperReceiver() {
        return ClassHelper.CLASS_Type.equals(this.weaved.getOriginType()) ? this.weaved : new CastExpression(this.fieldHelper, this.weaved);
    }

    private ArgumentListExpression createArgumentList(Expression origCallArgs) {
        ArgumentListExpression newArgs = new ArgumentListExpression();
        newArgs.addExpression(new VariableExpression(this.weaved));
        if (origCallArgs instanceof ArgumentListExpression) {
            List<Expression> expressions = ((ArgumentListExpression)origCallArgs).getExpressions();
            for (Expression expression : expressions) {
                newArgs.addExpression(this.transform(expression));
            }
        } else {
            newArgs.addExpression(origCallArgs);
        }
        return newArgs;
    }
}

