/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbeans;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import org.apache.harmony.beans.internal.nls.Messages;

class CustomizedObjectInputStream
extends ObjectInputStream {
    private ClassLoader cls;

    public CustomizedObjectInputStream(InputStream in, ClassLoader cls) throws IOException {
        super(in);
        this.cls = cls;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String className = desc.getName();
        if (className.startsWith("[")) {
            int idx = className.lastIndexOf("[");
            String prefix = className.substring(0, idx + 1);
            int[] dimensions = new int[prefix.length()];
            int i = 0;
            while (i < dimensions.length) {
                dimensions[i] = 0;
                ++i;
            }
            String postfix = className.substring(idx + 1);
            Class<Comparable<Boolean>> componentType = null;
            if (postfix.equals("Z")) {
                componentType = Boolean.TYPE;
            } else if (postfix.equals("B")) {
                componentType = Byte.TYPE;
            } else if (postfix.equals("C")) {
                componentType = Character.TYPE;
            } else if (postfix.equals("D")) {
                componentType = Double.TYPE;
            } else if (postfix.equals("F")) {
                componentType = Float.TYPE;
            } else if (postfix.equals("I")) {
                componentType = Integer.TYPE;
            } else if (postfix.equals("L")) {
                componentType = Long.TYPE;
            } else if (postfix.equals("S")) {
                componentType = Short.TYPE;
            } else if (!postfix.equals("V")) {
                if (postfix.startsWith("L")) {
                    componentType = this.cls.loadClass(postfix.substring(1, postfix.length() - 1));
                } else {
                    throw new IllegalArgumentException(Messages.getString("beans.1E", className));
                }
            }
            return Array.newInstance(componentType, dimensions).getClass();
        }
        return Class.forName(className, true, this.cls);
    }
}

