/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbeans;

import com.googlecode.openbeans.BeanInfo;
import com.googlecode.openbeans.IntrospectionException;
import com.googlecode.openbeans.Introspector;
import com.googlecode.openbeans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import org.apache.harmony.beans.BeansUtils;
import org.apache.harmony.beans.internal.nls.Messages;

public class EventHandler
implements InvocationHandler {
    private Object target;
    private String action;
    private String eventPropertyName;
    private String listenerMethodName;
    private final AccessControlContext context;

    public EventHandler(Object target, String action, String eventPropertyName, String listenerMethodName) {
        if (target == null || action == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.action = action;
        this.eventPropertyName = eventPropertyName;
        this.listenerMethodName = listenerMethodName;
        this.context = AccessController.getContext();
    }

    @Override
    public Object invoke(final Object proxy, final Method method, final Object[] arguments) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return EventHandler.this.invokeImpl(proxy, method, arguments);
            }
        }, this.context);
    }

    private Object invokeImpl(Object proxy, Method method, Object[] arguments) {
        Class<?> proxyClass = proxy.getClass();
        Object[] theArguments = arguments == null ? new Object[]{} : arguments;
        Object result = null;
        if (Proxy.isProxyClass(proxyClass)) {
            InvocationHandler handler = Proxy.getInvocationHandler(proxy);
            if (handler instanceof EventHandler) {
                String methodName = method.getName();
                if (method.getDeclaringClass() == Object.class) {
                    if (theArguments.length == 0) {
                        if ("hashCode".equals(methodName)) {
                            result = this.hashCode();
                        } else if ("toString".equals(methodName)) {
                            result = String.valueOf(proxy.getClass().getSimpleName()) + this.toString().substring(this.getClass().getName().length());
                        }
                    } else if (theArguments.length == 1 && theArguments[0] != null && "equals".equals(methodName)) {
                        result = proxy == theArguments[0];
                    }
                } else if (this.isValidInvocation(method, theArguments)) {
                    try {
                        Object[] args = this.getArgs(theArguments);
                        Method m = this.getMethod(proxy, method, theArguments, args);
                        result = m.invoke(this.target, args);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                } else if (this.listenerMethodName.equals(methodName)) {
                    throw new IllegalArgumentException(Messages.getString("beans.4D"));
                }
            }
        } else if (method == null) {
            throw new NullPointerException(Messages.getString("beans.55"));
        }
        return result;
    }

    public String getListenerMethodName() {
        return this.listenerMethodName;
    }

    public String getEventPropertyName() {
        return this.eventPropertyName;
    }

    public String getAction() {
        return this.action;
    }

    public Object getTarget() {
        return this.target;
    }

    public static <T> T create(Class<T> listenerInterface, Object target, String action, String eventPropertyName, String listenerMethodName) {
        if (action == null || target == null || listenerInterface == null) {
            throw new NullPointerException();
        }
        return (T)Proxy.newProxyInstance(target.getClass().getClassLoader(), new Class[]{listenerInterface}, (InvocationHandler)new EventHandler(target, action, eventPropertyName, listenerMethodName));
    }

    public static <T> T create(Class<T> listenerInterface, Object target, String action, String eventPropertyName) {
        return EventHandler.create(listenerInterface, target, action, eventPropertyName, null);
    }

    public static <T> T create(Class<T> listenerInterface, Object target, String action) {
        return EventHandler.create(listenerInterface, target, action, null, null);
    }

    private boolean isValidInvocation(Method method, Object[] arguments) {
        if (this.listenerMethodName == null) {
            return true;
        }
        if (this.listenerMethodName.equals(method.getName())) {
            if (this.eventPropertyName == null && (arguments == null || arguments.length == 0)) {
                return true;
            }
            if (arguments != null && arguments.length == 1) {
                return true;
            }
        }
        return false;
    }

    private Object[] getArgs(Object[] arguments) throws Exception {
        if (this.eventPropertyName == null) {
            return new Object[0];
        }
        if (arguments == null || arguments.length == 0) {
            return arguments;
        }
        Object arg = arguments[0];
        StringTokenizer st = new StringTokenizer(this.eventPropertyName, ".");
        while (st.hasMoreTokens()) {
            String propertyName = st.nextToken();
            PropertyDescriptor pd = this.findPropertyDescriptor(arg.getClass(), propertyName);
            Method getMethod = null;
            if (pd != null) {
                getMethod = pd.getReadMethod();
                if (getMethod != null) {
                    arg = getMethod.invoke(arg, new Object[0]);
                    continue;
                }
                throw new IntrospectionException(Messages.getString("beans.11", propertyName));
            }
            getMethod = this.findStaticGetter(arg.getClass(), propertyName);
            if (getMethod != null) {
                arg = getMethod.invoke(null, new Object[0]);
                continue;
            }
            throw new NullPointerException(Messages.getString("beans.12", propertyName));
        }
        return new Object[]{arg};
    }

    private Method getMethod(Object proxy, Method method, Object[] arguments, Object[] args) throws Exception {
        boolean found = false;
        if (this.listenerMethodName == null) {
            Class<?>[] proxyInterfaces;
            Class<?>[] classArray = proxyInterfaces = proxy.getClass().getInterfaces();
            int n = proxyInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Method[] interfaceMethods;
                Class<?> proxyInstance = classArray[n2];
                Method[] methodArray = interfaceMethods = proxyInstance.getMethods();
                int n3 = interfaceMethods.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method listenerMethod = methodArray[n4];
                    if (EventHandler.equalNames(listenerMethod, method) && EventHandler.canInvokeWithArguments(listenerMethod, arguments)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else if (this.listenerMethodName.equals(method.getName())) {
            found = true;
        }
        if (!found) {
            return null;
        }
        try {
            Method result = this.findMethod(this.target.getClass(), args);
            if (result == null) {
                PropertyDescriptor pd = this.findPropertyDescriptor(this.target.getClass(), this.action);
                if (pd != null) {
                    result = pd.getWriteMethod();
                    if (result == null) {
                        throw new NoSuchMethodException(Messages.getString("beans.13", this.action));
                    }
                } else {
                    throw new IndexOutOfBoundsException(Messages.getString("beans.14"));
                }
            }
            return result;
        }
        catch (IntrospectionException ie) {
            throw new IndexOutOfBoundsException(Messages.getString("beans.14"));
        }
    }

    private PropertyDescriptor findPropertyDescriptor(Class<?> theClass, String propertyName) throws IntrospectionException {
        PropertyDescriptor[] pds;
        BeanInfo beanInfo = Introspector.getBeanInfo(theClass);
        PropertyDescriptor[] propertyDescriptorArray = pds = beanInfo.getPropertyDescriptors();
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (pd.getName().equals(propertyName)) {
                return pd;
            }
            ++n2;
        }
        return null;
    }

    private Method findStaticGetter(Class<?> theClass, String propertyName) {
        Method[] methods;
        Method[] methodArray = methods = theClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                String postfix;
                Method method;
                block7: {
                    String methodName;
                    block6: {
                        method = methodArray[n2];
                        int modifiers = method.getModifiers();
                        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) break block5;
                        methodName = method.getName();
                        postfix = null;
                        if (!methodName.startsWith("get")) break block6;
                        postfix = methodName.substring(3);
                        break block7;
                    }
                    if (!methodName.startsWith("is")) break block5;
                    postfix = methodName.substring(2);
                }
                if (method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE && (postfix = Introspector.decapitalize(postfix)).equals(propertyName)) {
                    return method;
                }
            }
            ++n2;
        }
        return null;
    }

    private Method findMethod(Class<?> type, Object[] args) {
        Method[] methods;
        Method[] methodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (this.action.equals(method.getName()) && EventHandler.canInvokeWithArguments(method, args)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static boolean canInvokeWithArguments(Method method, Object[] arguments) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != arguments.length) {
            return false;
        }
        int index = 0;
        while (index < arguments.length) {
            Class<?> argumentType;
            Class<?> clazz = argumentType = arguments[index] == null ? null : arguments[index].getClass();
            if (argumentType != null && !BeansUtils.isPrimitiveWrapper(argumentType, parameterTypes[index]) && !argumentType.isAssignableFrom(parameterTypes[index])) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static boolean equalNames(Method m1, Method m2) {
        return m1.getName().equals(m2.getName());
    }
}

