/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.beans;

import com.googlecode.openbeans.BeanInfo;
import com.googlecode.openbeans.Expression;
import com.googlecode.openbeans.IndexedPropertyDescriptor;
import com.googlecode.openbeans.IntrospectionException;
import com.googlecode.openbeans.Introspector;
import com.googlecode.openbeans.PropertyDescriptor;
import com.googlecode.openbeans.Statement;
import com.googlecode.openbeans.XMLDecoder;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.harmony.beans.Argument;
import org.apache.harmony.beans.internal.nls.Messages;
import org.xml.sax.Attributes;

public class Command {
    private static final int INITIALIZED = 0;
    private static final int CHILDREN_FILTERED = 1;
    private static final int COMMAND_EXECUTED = 2;
    private static final int CHILDREN_PROCESSED = 3;
    private String tagName;
    private Map<String, String> attrs;
    private String data;
    private Vector<Command> commands = new Vector();
    private Vector<Command> arguments = new Vector();
    private Vector<Command> operations = new Vector();
    private Vector<Argument> auxArguments = new Vector();
    private Argument result;
    private Object target;
    private String methodName;
    private Command ctx;
    private int status;
    private XMLDecoder decoder;
    private static final String[] objectAttrNames = new String[]{"id", "idref", "class", "field", "method", "property", "index"};
    private static final String[] voidAttrNames = new String[]{"id", "class", "method", "property", "index"};
    private static final String[] arrayAttrNames = new String[]{"id", "class", "length"};
    private static final String[] javaAttrNames = new String[]{"version", "class"};

    public Command(String tagName, Map<String, String> attrs) {
        this.tagName = tagName;
        this.attrs = attrs;
        this.status = Command.initializeStatus(tagName);
    }

    public Command(XMLDecoder decoder, String tagName, Map<String, String> attrs) {
        this.decoder = decoder;
        this.tagName = tagName;
        this.attrs = attrs;
        this.status = Command.initializeStatus(tagName);
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setContext(Command ctx) {
        this.ctx = ctx;
    }

    public void addChild(Command cmd) {
        if (cmd != null) {
            cmd.setContext(this);
            this.commands.add(cmd);
        }
    }

    public void removeChild(Command cmd) {
        if (cmd != null && this.commands.remove(cmd)) {
            cmd.setContext(null);
        }
    }

    public int getStatus() {
        return this.status;
    }

    private boolean isResolved() {
        if (this.getStatus() < 3) {
            return false;
        }
        int i = 0;
        while (i < this.arguments.size()) {
            Command arg = this.arguments.elementAt(i);
            if (!arg.isResolved()) {
                return false;
            }
            ++i;
        }
        int j = 0;
        while (j < this.operations.size()) {
            Command opr = this.operations.elementAt(j);
            if (!opr.isResolved()) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public int exec(Map<String, Command> references) throws Exception {
        if (this.status < 3) {
            if (this.status < 2) {
                if (this.status < 1) {
                    this.status = this.doBeforeRun(references);
                }
                if (this.status == 1) {
                    this.status = this.doRun(references);
                }
            }
            if (this.status == 2) {
                this.status = this.doAfterRun(references);
            }
        }
        return this.status;
    }

    public boolean backtrack(Map<String, Command> references) throws Exception {
        int i = 0;
        while (i < this.arguments.size()) {
            Command arg = this.arguments.elementAt(i);
            arg.backtrack(references);
            ++i;
        }
        i = 0;
        while (i < this.operations.size()) {
            Command opr = this.operations.elementAt(i);
            opr.backtrack(references);
            ++i;
        }
        if (this.status == 1) {
            this.status = this.doRun(references);
        }
        if (this.status == 2) {
            this.status = this.doAfterRun(references);
            return this.getStatus() == 3;
        }
        return false;
    }

    private int doBeforeRun(Map<String, Command> references) throws Exception {
        if (this.status == 0) {
            int i = 0;
            while (i < this.commands.size()) {
                Command cmd = this.commands.elementAt(i);
                if (cmd.isExecutable()) {
                    this.arguments.add(cmd);
                } else {
                    this.operations.add(cmd);
                }
                ++i;
            }
            return 1;
        }
        return this.status;
    }

    private int doRun(Map<String, Command> references) throws Exception {
        if (this.status == 1) {
            if (this.isRoot()) {
                this.result = new Argument(this.decoder);
                return 2;
            }
            if (this.isNull()) {
                this.result = new Argument(null);
                return 2;
            }
            if (this.ctx != null && this.ctx.isArray() && this.ctx.getResultValue() == null && !this.isExecutable()) {
                return this.status;
            }
            Object target = this.getTarget(references);
            if (target == null) {
                return this.status;
            }
            if (this.isReference()) {
                this.result = this.getReferencedArgument(references);
            } else {
                String methodName = this.getMethodName(references);
                Argument[] arguments = this.getArguments();
                if (arguments == null) {
                    return this.status;
                }
                Expression expr = new Expression(target, methodName, this.getArgumentsValues());
                this.result = new Argument(expr.getValue());
                if (Command.isPrimitiveClassName(this.getTagName())) {
                    this.result.setType(Command.getPrimitiveClass(this.tagName));
                }
            }
            return 2;
        }
        return this.status;
    }

    private int doAfterRun(Map<String, Command> references) throws Exception {
        if (this.status == 2) {
            Vector<Command> toBeRemoved = new Vector<Command>();
            try {
                try {
                    Statement[] statements = null;
                    int i = 0;
                    while (i < this.operations.size()) {
                        Command cmd = this.operations.elementAt(i);
                        if (cmd.isArrayElement()) {
                            if (!cmd.isResolved()) break;
                            if (statements == null) {
                                statements = new Statement[this.operations.size()];
                            }
                            statements[i] = new Statement(this.getResultValue(), "set", new Object[]{i, cmd.getResultValue()});
                            if (i + 1 == this.operations.size()) {
                                int j = 0;
                                while (j < this.operations.size()) {
                                    statements[j].execute();
                                    ++j;
                                }
                                toBeRemoved.addAll(this.operations);
                            }
                        } else {
                            if (!this.isArray()) {
                                cmd.setTarget(this.getResultValue());
                            }
                            cmd.exec(references);
                            if (!cmd.isResolved()) break;
                            toBeRemoved.add(cmd);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            finally {
                this.operations.removeAll(toBeRemoved);
            }
            return this.operations.size() == 0 ? 3 : this.status;
        }
        return this.status;
    }

    public Argument getResult() {
        return this.result;
    }

    public Object getResultValue() {
        return this.result != null ? this.result.getValue() : null;
    }

    public Class<?> getResultType() throws ClassNotFoundException {
        return this.result != null ? this.result.getType() : null;
    }

    public boolean hasAttr(String name) {
        return this.attrs.get(name) != null;
    }

    public String getAttr(String name) {
        return this.attrs.get(name);
    }

    public boolean isTag(String name) {
        return this.tagName.equals(name);
    }

    public boolean hasAttr(String name, String value) {
        return value.equals(this.attrs.get(name));
    }

    public String getTagName() {
        return this.tagName;
    }

    private boolean isPrimitive() {
        return Command.isPrimitiveClassName(this.tagName);
    }

    private boolean isConstructor() {
        return this.isPrimitive() || !this.isStaticMethod() && !this.isMethod() && !this.isProperty() && !this.isField() && !this.isArray() && !this.isReference();
    }

    private boolean isStaticMethod() {
        return this.isTag("object") && this.hasAttr("method") || this.isTag("class");
    }

    private boolean isMethod() {
        return this.isTag("void") && (this.hasAttr("method") || this.hasAttr("index"));
    }

    private boolean isProperty() {
        return this.isTag("void") && this.hasAttr("property");
    }

    private boolean isField() {
        return this.isTag("object") && this.hasAttr("field");
    }

    private boolean isArray() {
        return this.isTag("array");
    }

    private boolean isArrayElement() {
        return this.ctx != null && this.ctx.isArray() && this.isExecutable();
    }

    private boolean isReference() {
        return this.hasAttr("idref");
    }

    private boolean isRoot() {
        return this.isTag("java");
    }

    private boolean isNull() {
        return this.isTag("null");
    }

    public boolean isExecutable() {
        boolean result = this.isTag("object") || this.isTag("void") && this.hasAttr("class") && this.hasAttr("method") || this.isTag("array") || this.isPrimitive() || this.isTag("class") || this.isTag("null");
        return result;
    }

    private Argument getReferencedArgument(Map<String, Command> references) {
        return references.get(this.getAttr("idref")).getResult();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getTarget(Map<String, Command> references) throws Exception {
        if (this.target != null) return this.target;
        if (this.isReference()) {
            Command cmd = references.get(this.getAttr("idref"));
            this.target = cmd != null ? cmd.getResultValue() : null;
            return this.target;
        }
        if (this.isExecutable()) {
            String className = null;
            if (this.isPrimitive()) {
                className = this.getPrimitiveClassName(this.tagName);
            } else if (this.isTag("class")) {
                className = this.getPrimitiveClassName(this.tagName);
            } else if (this.isConstructor() || this.isStaticMethod() || this.isField()) {
                className = this.getAttr("class");
            } else if (this.isArray()) {
                className = this.getAttr("class");
                Class<?> componentType = Command.isPrimitiveClassName(className) ? Command.getPrimitiveClass(className) : Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                className = Array.newInstance(componentType, 0).getClass().getName();
            }
            if (className == null) throw new Exception(Messages.getString("beans.42", className));
            try {
                this.target = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                this.target = Class.forName(className);
            }
            if (!this.isField()) return this.target;
            String fieldName = this.getAttr("field");
            this.target = ((Class)this.target).getField(fieldName);
            return this.target;
        }
        if (!this.ctx.isArray()) return this.target;
        this.target = Class.forName("java.lang.reflect.Array");
        return this.target;
    }

    private void setTarget(Object target) {
        this.target = target;
    }

    private String getMethodName(Map<String, Command> references) throws NoSuchMethodException, IntrospectionException, Exception {
        if (this.methodName == null) {
            String methodValue = null;
            if (this.isTag("class")) {
                this.addArgument(new Argument(String.class, this.data), 0);
                methodValue = "forName";
            } else if (this.isPrimitive()) {
                if (this.isTag("char")) {
                    if (this.data.length() != 1) {
                        throw new IntrospectionException(Messages.getString("beans.43", this.data));
                    }
                    this.addArgument(new Argument(Character.TYPE, Character.valueOf(this.data.charAt(0))), 0);
                } else {
                    this.addArgument(new Argument(String.class, this.data), 0);
                }
                methodValue = "new";
            } else if (this.isConstructor() || this.hasAttr("method", "new")) {
                methodValue = "new";
            } else if (this.isArray()) {
                methodValue = "new";
                int length = this.hasAttr("length") ? Integer.parseInt(this.getAttr("length")) : this.getArgumentsNumber();
                this.copyArgumentsToCommands();
                this.addArgument(new Argument(Integer.TYPE, length), 0);
            } else if (this.hasAttr("property")) {
                String propertyValue = this.getAttr("property");
                if (this.hasAttr("index")) {
                    this.addArgument(new Argument(Integer.TYPE, new Integer(this.getAttr("index"))), 0);
                }
                BeanInfo beanInfo = Introspector.getBeanInfo(this.getTarget(references).getClass());
                PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
                boolean methodFound = false;
                Method method = null;
                PropertyDescriptor[] propertyDescriptorArray = pds;
                int n = pds.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor pd = propertyDescriptorArray[n2];
                    if (propertyValue.equals(pd.getName())) {
                        IndexedPropertyDescriptor ipd;
                        int argsNum = this.getArgumentsNumber();
                        if (this.hasAttr("index")) {
                            ipd = (IndexedPropertyDescriptor)pd;
                            if (argsNum == 1) {
                                method = ipd.getIndexedReadMethod();
                            } else if (argsNum == 0) {
                                method = ipd.getReadMethod();
                            }
                        } else {
                            method = pd.getReadMethod();
                        }
                        if (method != null) {
                            methodFound = this.matchMethodParams(method, references);
                        }
                        if (!methodFound) {
                            if (this.hasAttr("index")) {
                                ipd = (IndexedPropertyDescriptor)pd;
                                if (argsNum == 2) {
                                    method = ipd.getIndexedWriteMethod();
                                } else if (argsNum == 1) {
                                    method = ipd.getWriteMethod();
                                }
                            } else {
                                method = pd.getWriteMethod();
                            }
                        }
                        if (method != null) {
                            methodFound = this.matchMethodParams(method, references);
                        }
                    }
                    ++n2;
                }
                if (method == null) {
                    throw new NoSuchMethodException(Messages.getString("beans.44", propertyValue));
                }
                methodValue = method.getName();
            } else if (this.hasAttr("method")) {
                if (this.hasAttr("index")) {
                    this.addArgument(new Argument(Integer.TYPE, Integer.valueOf(this.getAttr("index"))), 0);
                }
                methodValue = this.getAttr("method");
            } else if (this.hasAttr("index")) {
                this.addArgument(new Argument(Integer.TYPE, Integer.valueOf(this.getAttr("index"))), 0);
                String string = methodValue = this.getArgumentsNumber() > 1 ? "set" : "get";
                if (this.ctx.isArray()) {
                    this.addArgument(this.ctx.getResult(), 0);
                }
            } else if (this.hasAttr("field")) {
                this.addArgument(new Argument(Class.forName(this.getAttr("class"), true, Thread.currentThread().getContextClassLoader())), 0);
                methodValue = "get";
            } else {
                throw new Exception(Messages.getString("beans.45"));
            }
            this.methodName = methodValue;
        }
        return this.methodName;
    }

    private Argument[] getArguments() {
        Argument[] args = new Argument[this.auxArguments.size() + this.arguments.size()];
        int i = 0;
        while (i < this.auxArguments.size()) {
            args[i] = this.auxArguments.elementAt(i);
            ++i;
        }
        int j = 0;
        while (j < this.arguments.size()) {
            Command cmd = this.arguments.elementAt(j);
            if (cmd.getStatus() < 2) {
                args = null;
                break;
            }
            args[this.auxArguments.size() + j] = cmd.getResult();
            ++j;
        }
        return args;
    }

    private Object[] getArgumentsValues() {
        Argument[] args = this.getArguments();
        Object[] result = new Object[args.length];
        int i = 0;
        while (i < args.length) {
            result[i] = args[i].getValue();
            ++i;
        }
        return result;
    }

    private void copyArgumentsToCommands() {
        for (Command cmd : this.arguments) {
            cmd.status = 1;
            this.operations.add(cmd);
        }
        this.arguments.clear();
    }

    private int getArgumentsNumber() {
        return this.auxArguments.size() + this.arguments.size();
    }

    private void addArgument(Argument argument, int idx) {
        this.auxArguments.insertElementAt(argument, idx);
    }

    public static boolean isPrimitiveClassName(String className) {
        return className.equalsIgnoreCase("boolean") || className.equalsIgnoreCase("byte") || className.equalsIgnoreCase("char") || className.equalsIgnoreCase("short") || className.equalsIgnoreCase("int") || className.equalsIgnoreCase("long") || className.equalsIgnoreCase("float") || className.equalsIgnoreCase("double") || className.equalsIgnoreCase("string");
    }

    private String getPrimitiveClassName(String data) {
        String shortClassName = null;
        shortClassName = data.equals("int") ? "Integer" : (data.equals("char") ? "Character" : String.valueOf(data.substring(0, 1).toUpperCase()) + data.substring(1, data.length()));
        return "java.lang." + shortClassName;
    }

    public static Class<?> getPrimitiveClass(String className) {
        Class<Object> result = null;
        if (className.equals("boolean")) {
            result = Boolean.TYPE;
        } else if (className.equals("byte")) {
            result = Byte.TYPE;
        } else if (className.equals("char")) {
            result = Character.TYPE;
        } else if (className.equals("short")) {
            result = Short.TYPE;
        } else if (className.equals("int")) {
            result = Integer.TYPE;
        } else if (className.equals("long")) {
            result = Long.TYPE;
        } else if (className.equals("float")) {
            result = Float.TYPE;
        } else if (className.equals("double")) {
            result = Double.TYPE;
        } else if (className.equals("string")) {
            result = String.class;
        }
        return result;
    }

    private boolean matchMethodParams(Method method, Map<String, Command> references) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Argument[] args = this.getArguments();
        if (args == null) {
            return false;
        }
        boolean result = true;
        if (paramTypes.length == args.length) {
            int j = 0;
            while (j < paramTypes.length) {
                boolean isAssignable;
                boolean bl = args[j].getType() == null ? !paramTypes[j].isPrimitive() : (isAssignable = paramTypes[j].isAssignableFrom(args[j].getType()));
                if (!isAssignable) {
                    result = false;
                    break;
                }
                ++j;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static Map<String, String> parseAttrs(String tagName, Attributes attrs) {
        HashMap<String, String> result;
        block9: {
            block11: {
                block10: {
                    block8: {
                        result = new HashMap<String, String>();
                        if (!tagName.equals("object")) break block8;
                        String[] stringArray = objectAttrNames;
                        int n = objectAttrNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            String value = attrs.getValue(name);
                            if (value != null) {
                                result.put(name, value);
                            }
                            ++n2;
                        }
                        break block9;
                    }
                    if (!tagName.equals("void")) break block10;
                    String[] stringArray = voidAttrNames;
                    int n = voidAttrNames.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String name = stringArray[n3];
                        String value = attrs.getValue(name);
                        if (value != null) {
                            result.put(name, value);
                        }
                        ++n3;
                    }
                    break block9;
                }
                if (!tagName.equals("array")) break block11;
                String[] stringArray = arrayAttrNames;
                int n = arrayAttrNames.length;
                int n4 = 0;
                while (n4 < n) {
                    String name = stringArray[n4];
                    String value = attrs.getValue(name);
                    if (value != null) {
                        result.put(name, value);
                    }
                    ++n4;
                }
                break block9;
            }
            if (!tagName.equals("java")) break block9;
            String[] stringArray = javaAttrNames;
            int n = javaAttrNames.length;
            int n5 = 0;
            while (n5 < n) {
                String name = stringArray[n5];
                String value = attrs.getValue(name);
                if (value != null) {
                    result.put(name, value);
                }
                ++n5;
            }
        }
        return result;
    }

    public static void pr(String msg) {
    }

    public static void pr(int tabCount, String msg) {
        String result = "";
        int i = 0;
        while (i < tabCount) {
            result = String.valueOf(result) + '\t';
            ++i;
        }
        result = String.valueOf(result) + msg;
    }

    public static void prn(String msg) {
    }

    public static void prn(int tabCount, String msg) {
        String result = "";
        int i = 0;
        while (i < tabCount) {
            result = String.valueOf(result) + '\t';
            ++i;
        }
        result = String.valueOf(result) + msg;
    }

    public static void printAttrs(int tabCount, String tagName, Attributes attrs) {
        Command.pr(tabCount, String.valueOf(tabCount) + ">in <" + tagName);
        int i = 0;
        while (i < attrs.getLength()) {
            String attrName = attrs.getQName(i);
            String attrValue = attrs.getValue(i);
            Command.pr(" " + attrName + "=" + attrValue);
            ++i;
        }
        Command.prn(">");
    }

    private static int initializeStatus(String tagName) {
        return 0;
    }
}

