/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.beans.editors;

import com.googlecode.openbeans.PropertyChangeEvent;
import com.googlecode.openbeans.PropertyChangeListener;
import com.googlecode.openbeans.PropertyEditor;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class FontEditor
extends Panel
implements PropertyEditor {
    List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private Font value;
    private Object source;

    public FontEditor(Object source) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
    }

    public FontEditor() {
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public String getJavaInitializationString() {
        if (this.value != null) {
            StringBuilder sb = new StringBuilder("new Font(");
            sb.append(this.value.getName());
            sb.append(',');
            sb.append(this.value.getStyle());
            sb.append(',');
            sb.append(String.valueOf(this.value.getSize()) + ")");
            return sb.toString();
        }
        return null;
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void setValue(Object newValue) {
        PropertyChangeListener[] copy;
        Font oldValue = this.value;
        this.value = (Font)newValue;
        PropertyChangeEvent changeAllEvent = new PropertyChangeEvent(this, "value", oldValue, this.value);
        PropertyChangeListener[] propertyChangeListenerArray = copy = this.listeners.toArray(new PropertyChangeListener[0]);
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener listener = propertyChangeListenerArray[n2];
            listener.propertyChange(changeAllEvent);
            ++n2;
        }
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        Font font = (Font)this.getValue();
        if (font != null) {
            gfx.setFont(font);
            gfx.drawBytes("Hello".getBytes(), box.x, box.y, box.x + box.width, box.y + box.height);
        }
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text == null ? text : this.value.toString());
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ArrayList<PropertyChangeListener> copy = new ArrayList<PropertyChangeListener>(this.listeners.size());
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            copy.addAll(this.listeners);
        }
        PropertyChangeEvent changeAllEvent = new PropertyChangeEvent(this.source, null, null, null);
        for (PropertyChangeListener listna : copy) {
            listna.propertyChange(changeAllEvent);
        }
    }
}

