/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.macro.transform;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.macro.runtime.MacroContext;
import org.codehaus.groovy.macro.runtime.MacroStub;
import org.codehaus.groovy.macro.transform.MacroMethodsCache;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;

class MacroCallTransformingVisitor
extends ClassCodeVisitorSupport {
    private static final ClassNode MACRO_CONTEXT_CLASS_NODE = ClassHelper.make(MacroContext.class);
    private static final ClassNode MACRO_STUB_CLASS_NODE = ClassHelper.make(MacroStub.class);
    private static final PropertyExpression MACRO_STUB_INSTANCE = new PropertyExpression((Expression)new ClassExpression(MACRO_STUB_CLASS_NODE), "INSTANCE");
    private static final String MACRO_STUB_METHOD_NAME = "macroMethod";
    private final SourceUnit sourceUnit;
    private final CompilationUnit unit;
    private final ClassLoader classLoader;

    public MacroCallTransformingVisitor(SourceUnit sourceUnit, CompilationUnit unit) {
        this.sourceUnit = sourceUnit;
        this.unit = unit;
        this.classLoader = unit.getTransformLoader();
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression call) {
        super.visitMethodCallExpression(call);
        List<Expression> callArguments = call.getArguments() instanceof TupleExpression ? ((TupleExpression)call.getArguments()).getExpressions() : Collections.singletonList(call.getArguments());
        List<MethodNode> macroMethods = this.findMacroMethods(call.getMethodAsString(), callArguments);
        if (macroMethods.isEmpty()) {
            return;
        }
        MacroContext macroContext = new MacroContext(this.unit, this.sourceUnit, call);
        Object[] macroArguments = new Object[callArguments.size() + 1];
        macroArguments[0] = macroContext;
        System.arraycopy(callArguments.toArray(), 0, macroArguments, 1, callArguments.size());
        for (MethodNode macroMethodNode : macroMethods) {
            if (!(macroMethodNode instanceof ExtensionMethodNode)) {
                throw new IllegalStateException(macroMethodNode + " is not an instance of ExtensionMethodNode");
            }
            if (!this.tryMacroMethod(call, (ExtensionMethodNode)macroMethodNode, macroArguments)) continue;
            break;
        }
    }

    private List<MethodNode> findMacroMethods(String methodName, List<Expression> callArguments) {
        List<MethodNode> methods = MacroMethodsCache.get(this.classLoader).get(methodName);
        if (methods == null) {
            return Collections.emptyList();
        }
        ClassNode[] argumentsList = new ClassNode[callArguments.size()];
        for (int i = 0; i < callArguments.size(); ++i) {
            argumentsList[i] = ClassHelper.make(callArguments.get(i).getClass());
        }
        return StaticTypeCheckingSupport.chooseBestMethod(MACRO_CONTEXT_CLASS_NODE, methods, argumentsList);
    }

    private boolean tryMacroMethod(MethodCallExpression call, ExtensionMethodNode macroMethod, Object[] macroArguments) {
        Expression result = (Expression)InvokerHelper.invokeStaticMethod(macroMethod.getExtensionMethodNode().getDeclaringClass().getTypeClass(), macroMethod.getName(), (Object)macroArguments);
        if (result == null) {
            return false;
        }
        call.setObjectExpression(MACRO_STUB_INSTANCE);
        call.setMethod(new ConstantExpression(MACRO_STUB_METHOD_NAME));
        call.setSpreadSafe(false);
        call.setSafe(false);
        call.setImplicitThis(false);
        call.setArguments(result);
        call.setGenericsTypes(new GenericsType[0]);
        return true;
    }
}

