/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.Collections;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.NodeMetaDataHandler;
import org.codehaus.groovy.util.ListHashMap;

public class NodeMetaDataHandlerHelper {
    private NodeMetaDataHandler delegate;

    public NodeMetaDataHandlerHelper(NodeMetaDataHandler delegate) {
        this.delegate = delegate;
    }

    public <T> T getNodeMetaData(Object key) {
        Map<?, ?> metaDataMap = this.delegate.getMetaDataMap();
        if (metaDataMap == null) {
            return null;
        }
        return (T)metaDataMap.get(key);
    }

    public void copyNodeMetaData(NodeMetaDataHandler other) {
        Map<?, ?> otherMetaDataMap = other.getMetaDataMap();
        if (otherMetaDataMap == null) {
            return;
        }
        Map<?, ?> metaDataMap = this.delegate.getMetaDataMap();
        if (metaDataMap == null) {
            metaDataMap = new ListHashMap();
            this.delegate.setMetaDataMap(metaDataMap);
        }
        metaDataMap.putAll(otherMetaDataMap);
    }

    public void setNodeMetaData(Object key, Object value) {
        Object old;
        if (key == null) {
            throw new GroovyBugError("Tried to set meta data with null key on " + this + ".");
        }
        Map<?, ?> metaDataMap = this.delegate.getMetaDataMap();
        if (metaDataMap == null) {
            metaDataMap = new ListHashMap();
            this.delegate.setMetaDataMap(metaDataMap);
        }
        if ((old = metaDataMap.put(key, value)) != null) {
            throw new GroovyBugError("Tried to overwrite existing meta data " + this + ".");
        }
    }

    public Object putNodeMetaData(Object key, Object value) {
        if (key == null) {
            throw new GroovyBugError("Tried to set meta data with null key on " + this + ".");
        }
        Map<?, ?> metaDataMap = this.delegate.getMetaDataMap();
        if (metaDataMap == null) {
            metaDataMap = new ListHashMap();
            this.delegate.setMetaDataMap(metaDataMap);
        }
        return metaDataMap.put(key, value);
    }

    public void removeNodeMetaData(Object key) {
        if (key == null) {
            throw new GroovyBugError("Tried to remove meta data with null key " + this + ".");
        }
        Map<?, ?> metaDataMap = this.delegate.getMetaDataMap();
        if (metaDataMap == null) {
            return;
        }
        metaDataMap.remove(key);
    }

    public Map<?, ?> getNodeMetaData() {
        Map<?, ?> metaDataMap = this.delegate.getMetaDataMap();
        if (metaDataMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(metaDataMap);
    }
}

