/*
 * Decompiled with CFR 0.152.
 */
package groovy.ui;

import groovy.lang.Binding;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.GroovySystem;
import groovy.lang.MissingMethodException;
import groovy.lang.Script;
import groovy.ui.GroovySocketServer;
import groovyjarjarcommonscli.CommandLine;
import groovyjarjarcommonscli.DefaultParser;
import groovyjarjarcommonscli.HelpFormatter;
import groovyjarjarcommonscli.Option;
import groovyjarjarcommonscli.Options;
import groovyjarjarcommonscli.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.codehaus.groovy.runtime.StringGroovyMethods;

public class GroovyMain {
    private List args;
    private boolean isScriptFile;
    private String script;
    private boolean processFiles;
    private boolean editFiles;
    private boolean autoOutput;
    private boolean autoSplit;
    private String splitPattern = " ";
    private boolean processSockets;
    private int port;
    private String backupExtension;
    private boolean debug = false;
    private CompilerConfiguration conf = new CompilerConfiguration(System.getProperties());
    private static final Pattern URI_PATTERN = Pattern.compile("\\p{Alpha}[-+.\\p{Alnum}]*:[^\\\\]*");

    public static void main(String[] args) {
        GroovyMain.processArgs(args, System.out);
    }

    static void processArgs(String[] args, PrintStream out) {
        Options options = GroovyMain.buildOptions();
        try {
            CommandLine cmd = GroovyMain.parseCommandLine(options, args);
            if (cmd.hasOption('h')) {
                GroovyMain.printHelp(out, options);
            } else if (cmd.hasOption('v')) {
                String version = GroovySystem.getVersion();
                out.println("Groovy Version: " + version + " JVM: " + System.getProperty("java.version") + " Vendor: " + System.getProperty("java.vm.vendor") + " OS: " + System.getProperty("os.name"));
            } else if (!GroovyMain.process(cmd)) {
                System.exit(1);
            }
        }
        catch (ParseException pe) {
            out.println("error: " + pe.getMessage());
            GroovyMain.printHelp(out, options);
        }
        catch (IOException ioe) {
            out.println("error: " + ioe.getMessage());
        }
    }

    private static void printHelp(PrintStream out, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(out);
        formatter.printHelp(pw, 80, "groovy [options] [filename] [args]", "The Groovy command line processor.\nOptions:", options, 2, 4, null, false);
        pw.flush();
    }

    private static CommandLine parseCommandLine(Options options, String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        return parser.parse(options, args, true);
    }

    private static Options buildOptions() {
        return new Options().addOption(Option.builder("classpath").hasArg().argName("path").desc("Specify where to find the class files - must be first argument").build()).addOption(Option.builder("cp").longOpt("classpath").hasArg().argName("path").desc("Aliases for '-classpath'").build()).addOption(Option.builder("D").longOpt("define").desc("Define a system property").numberOfArgs(2).valueSeparator().argName("name=value").build()).addOption(Option.builder().longOpt("disableopt").desc("Disables one or all optimization elements; optlist can be a comma separated list with the elements: all (disables all optimizations), int (disable any int based optimizations)").hasArg().argName("optlist").build()).addOption(Option.builder("h").hasArg(false).desc("Usage information").longOpt("help").build()).addOption(Option.builder("d").hasArg(false).desc("Debug mode will print out full stack traces").longOpt("debug").build()).addOption(Option.builder("v").hasArg(false).desc("Display the Groovy and JVM versions").longOpt("version").build()).addOption(Option.builder("c").argName("charset").hasArg().desc("Specify the encoding of the files").longOpt("encoding").build()).addOption(Option.builder("e").argName("script").hasArg().desc("Specify a command line script").build()).addOption(Option.builder("i").argName("extension").optionalArg(true).desc("Modify files in place; create backup if extension is given (e.g. '.bak')").build()).addOption(Option.builder("n").hasArg(false).desc("Process files line by line using implicit 'line' variable").build()).addOption(Option.builder("p").hasArg(false).desc("Process files line by line and print result (see also -n)").build()).addOption(Option.builder("pa").hasArg(false).desc("Generate metadata for reflection on method parameter names (jdk8+ only)").longOpt("parameters").build()).addOption(Option.builder("l").argName("port").optionalArg(true).desc("Listen on a port and process inbound lines (default: 1960)").build()).addOption(Option.builder("a").argName("splitPattern").optionalArg(true).desc("Split lines using splitPattern (default '\\s') using implicit 'split' variable").longOpt("autosplit").build()).addOption(Option.builder().longOpt("indy").desc("Enables compilation using invokedynamic").build()).addOption(Option.builder().longOpt("configscript").hasArg().desc("A script for tweaking the configuration options").build()).addOption(Option.builder("b").longOpt("basescript").hasArg().argName("class").desc("Base class name for scripts (must derive from Script)").build());
    }

    private static boolean process(CommandLine line) throws ParseException, IOException {
        String[] deopts;
        List<String> args = line.getArgList();
        if (line.hasOption('D')) {
            Properties optionProperties = line.getOptionProperties("D");
            Enumeration<?> propertyNames = optionProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String nextName = (String)propertyNames.nextElement();
                System.setProperty(nextName, optionProperties.getProperty(nextName));
            }
        }
        GroovyMain main = new GroovyMain();
        main.conf.setSourceEncoding(line.getOptionValue('c', main.conf.getSourceEncoding()));
        main.isScriptFile = !line.hasOption('e');
        main.debug = line.hasOption('d');
        main.conf.setDebug(main.debug);
        main.conf.setParameters(line.hasOption("pa"));
        main.processFiles = line.hasOption('p') || line.hasOption('n');
        main.autoOutput = line.hasOption('p');
        main.editFiles = line.hasOption('i');
        if (main.editFiles) {
            main.backupExtension = line.getOptionValue('i');
        }
        main.autoSplit = line.hasOption('a');
        String sp = line.getOptionValue('a');
        if (sp != null) {
            main.splitPattern = sp;
        }
        if (main.isScriptFile) {
            if (args.isEmpty()) {
                throw new ParseException("neither -e or filename provided");
            }
            main.script = args.remove(0);
            if (main.script.endsWith(".java")) {
                throw new ParseException("error: cannot compile file with .java extension: " + main.script);
            }
        } else {
            main.script = line.getOptionValue('e');
        }
        main.processSockets = line.hasOption('l');
        if (main.processSockets) {
            String p = line.getOptionValue('l', "1960");
            main.port = Integer.parseInt(p);
        }
        String disabled = line.getOptionValue("disableopt", ",");
        for (String deopt_i : deopts = disabled.split(",")) {
            main.conf.getOptimizationOptions().put(deopt_i, false);
        }
        if (line.hasOption("indy")) {
            CompilerConfiguration.DEFAULT.getOptimizationOptions().put("indy", true);
            main.conf.getOptimizationOptions().put("indy", true);
        }
        if (line.hasOption("basescript")) {
            main.conf.setScriptBaseClass(line.getOptionValue("basescript"));
        }
        String configScripts = System.getProperty("groovy.starter.configscripts", null);
        if (line.hasOption("configscript") || configScripts != null && !configScripts.isEmpty()) {
            ArrayList<String> scripts = new ArrayList<String>();
            if (line.hasOption("configscript")) {
                scripts.add(line.getOptionValue("configscript"));
            }
            if (configScripts != null) {
                scripts.addAll(StringGroovyMethods.tokenize((CharSequence)configScripts, Character.valueOf(',')));
            }
            GroovyMain.processConfigScripts(scripts, main.conf);
        }
        main.args = args;
        return main.run();
    }

    public static void processConfigScripts(List<String> scripts, CompilerConfiguration conf) throws IOException {
        if (scripts.isEmpty()) {
            return;
        }
        Binding binding = new Binding();
        binding.setVariable("configuration", conf);
        CompilerConfiguration configuratorConfig = new CompilerConfiguration();
        ImportCustomizer customizer = new ImportCustomizer();
        customizer.addStaticStars("org.codehaus.groovy.control.customizers.builder.CompilerCustomizationBuilder");
        configuratorConfig.addCompilationCustomizers(customizer);
        GroovyShell shell = new GroovyShell(binding, configuratorConfig);
        for (String script : scripts) {
            shell.evaluate(new File(script));
        }
    }

    private boolean run() {
        try {
            if (this.processSockets) {
                this.processSockets();
            } else if (this.processFiles) {
                this.processFiles();
            } else {
                this.processOnce();
            }
            return true;
        }
        catch (CompilationFailedException e) {
            System.err.println(e);
            return false;
        }
        catch (Throwable e) {
            if (e instanceof InvokerInvocationException) {
                InvokerInvocationException iie = (InvokerInvocationException)e;
                e = iie.getCause();
            }
            System.err.println("Caught: " + e);
            if (!this.debug) {
                StackTraceUtils.deepSanitize(e);
            }
            e.printStackTrace();
            return false;
        }
    }

    private void processSockets() throws CompilationFailedException, IOException, URISyntaxException {
        GroovyShell groovy = new GroovyShell(this.conf);
        new GroovySocketServer(groovy, this.getScriptSource(this.isScriptFile, this.script), this.autoOutput, this.port);
    }

    @Deprecated
    public String getText(String uriOrFilename) throws IOException {
        if (URI_PATTERN.matcher(uriOrFilename).matches()) {
            try {
                return ResourceGroovyMethods.getText(new URL(uriOrFilename));
            }
            catch (Exception e) {
                throw new GroovyRuntimeException("Unable to get script from URL: ", e);
            }
        }
        return ResourceGroovyMethods.getText(this.huntForTheScriptFile(uriOrFilename));
    }

    protected GroovyCodeSource getScriptSource(boolean isScriptFile, String script) throws IOException, URISyntaxException {
        if (isScriptFile) {
            File scriptFile = this.huntForTheScriptFile(script);
            if (!scriptFile.exists() && URI_PATTERN.matcher(script).matches()) {
                return new GroovyCodeSource(new URI(script));
            }
            return new GroovyCodeSource(scriptFile);
        }
        return new GroovyCodeSource(script, "script_from_command_line", "/groovy/shell");
    }

    public static File searchForGroovyScriptFile(String input) {
        String scriptFileName = input.trim();
        File scriptFile = new File(scriptFileName);
        String[] standardExtensions = new String[]{".groovy", ".gvy", ".gy", ".gsh"};
        for (int i = 0; i < standardExtensions.length && !scriptFile.exists(); ++i) {
            scriptFile = new File(scriptFileName + standardExtensions[i]);
        }
        if (!scriptFile.exists()) {
            scriptFile = new File(scriptFileName);
        }
        return scriptFile;
    }

    public File huntForTheScriptFile(String input) {
        return GroovyMain.searchForGroovyScriptFile(input);
    }

    private static void setupContextClassLoader(GroovyShell shell) {
        Thread current = Thread.currentThread();
        class DoSetContext
        implements PrivilegedAction {
            ClassLoader classLoader;
            final /* synthetic */ Thread val$current;

            public DoSetContext(ClassLoader classLoader) {
                this.val$current = classLoader;
                this.classLoader = loader;
            }

            public Object run() {
                this.val$current.setContextClassLoader(this.classLoader);
                return null;
            }
        }
        AccessController.doPrivileged(new DoSetContext((ClassLoader)shell.getClassLoader(), current));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFiles() throws CompilationFailedException, IOException, URISyntaxException {
        GroovyShell groovy = new GroovyShell(this.conf);
        GroovyMain.setupContextClassLoader(groovy);
        Script s = groovy.parse(this.getScriptSource(this.isScriptFile, this.script));
        if (this.args.isEmpty()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            PrintWriter writer = new PrintWriter(System.out);
            try {
                this.processReader(s, reader, writer);
            }
            finally {
                reader.close();
                writer.close();
            }
        } else {
            for (String filename : this.args) {
                File file = this.huntForTheScriptFile(filename);
                this.processFile(s, file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(Script s, File file) throws IOException {
        File backup;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName());
        }
        if (!this.editFiles) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                PrintWriter writer = new PrintWriter(System.out);
                this.processReader(s, reader, writer);
                writer.flush();
            }
        }
        if (this.backupExtension == null) {
            backup = File.createTempFile("groovy_", ".tmp");
            backup.deleteOnExit();
        } else {
            backup = new File(file.getPath() + this.backupExtension);
        }
        backup.delete();
        if (!file.renameTo(backup)) {
            throw new IOException("unable to rename " + file + " to " + backup);
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(backup));
             PrintWriter writer = new PrintWriter(new FileWriter(file));){
            this.processReader(s, reader, writer);
        }
    }

    private void processReader(Script s, BufferedReader reader, PrintWriter pw) throws IOException {
        String line;
        String lineCountName = "count";
        s.setProperty(lineCountName, BigInteger.ZERO);
        String autoSplitName = "split";
        s.setProperty("out", pw);
        try {
            InvokerHelper.invokeMethod(s, "begin", null);
        }
        catch (MissingMethodException missingMethodException) {
            // empty catch block
        }
        while ((line = reader.readLine()) != null) {
            s.setProperty("line", line);
            s.setProperty(lineCountName, ((BigInteger)s.getProperty(lineCountName)).add(BigInteger.ONE));
            if (this.autoSplit) {
                s.setProperty(autoSplitName, line.split(this.splitPattern));
            }
            Object o = s.run();
            if (!this.autoOutput || o == null) continue;
            pw.println(o);
        }
        try {
            InvokerHelper.invokeMethod(s, "end", null);
        }
        catch (MissingMethodException missingMethodException) {
            // empty catch block
        }
    }

    private void processOnce() throws CompilationFailedException, IOException, URISyntaxException {
        GroovyShell groovy = new GroovyShell(this.conf);
        GroovyMain.setupContextClassLoader(groovy);
        groovy.run(this.getScriptSource(this.isScriptFile, this.script), this.args);
    }
}

