/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.parser.antlr4.internal;

import groovyjarjarantlr4.v4.runtime.atn.ATN;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.groovy.parser.antlr4.GroovyLangLexer;
import org.apache.groovy.parser.antlr4.GroovyLangParser;
import org.apache.groovy.util.Maps;

public class AtnManager {
    public static final ReentrantReadWriteLock RRWL = new ReentrantReadWriteLock(true);
    private static final String DFA_CACHE_THRESHOLD_OPT = "groovy.antlr4.cache.threshold";
    private static final int DEFAULT_DFA_CACHE_THRESHOLD = 64;
    private static final int MIN_DFA_CACHE_THRESHOLD = 32;
    private static final int DFA_CACHE_THRESHOLD;
    private final Class ownerClass;
    private final ATN atn;
    private static final Map<Class, AtnWrapper> ATN_MAP;

    public AtnManager(GroovyLangLexer lexer) {
        this.ownerClass = lexer.getClass();
        this.atn = GroovyLangLexer._ATN;
    }

    public AtnManager(GroovyLangParser parser) {
        this.ownerClass = parser.getClass();
        this.atn = this.getAtnWrapper(this.ownerClass).checkAndClear();
    }

    public ATN getATN() {
        return this.atn;
    }

    private AtnWrapper getAtnWrapper(Class ownerClass) {
        return ATN_MAP.get(ownerClass);
    }

    static {
        ATN_MAP = Maps.of(GroovyLangLexer.class, new AtnWrapper(GroovyLangLexer._ATN), GroovyLangParser.class, new AtnWrapper(GroovyLangParser._ATN));
        int t = 64;
        try {
            t = Integer.parseInt(System.getProperty(DFA_CACHE_THRESHOLD_OPT));
            t = t < 32 ? 32 : t;
        }
        catch (Exception exception) {
            // empty catch block
        }
        DFA_CACHE_THRESHOLD = t;
    }

    private static class AtnWrapper {
        private final ATN atn;
        private final AtomicLong counter = new AtomicLong(0L);

        public AtnWrapper(ATN atn) {
            this.atn = atn;
        }

        public ATN checkAndClear() {
            if (0L != this.counter.incrementAndGet() % (long)DFA_CACHE_THRESHOLD) {
                return this.atn;
            }
            RRWL.writeLock().lock();
            try {
                this.atn.clearDFA();
            }
            finally {
                RRWL.writeLock().unlock();
            }
            return this.atn;
        }
    }
}

