/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.tools;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;

public class BeanUtils {
    static final String GET_PREFIX = "get";
    static final String IS_PREFIX = "is";

    public static List<PropertyNode> getAllProperties(ClassNode type, boolean includeSuperProperties, boolean includeStatic, boolean includePseudoGetters) {
        ArrayList<PropertyNode> result = new ArrayList<PropertyNode>();
        HashSet<String> names = new HashSet<String>();
        for (ClassNode node = type; node != null; node = node.getSuperClass()) {
            BeanUtils.addExplicitProperties(node, result, names, includeStatic);
            if (!includeSuperProperties) break;
        }
        BeanUtils.addPseudoProperties(type, result, names, includeStatic, includePseudoGetters, includeSuperProperties);
        return result;
    }

    private static void addExplicitProperties(ClassNode cNode, List<PropertyNode> result, Set<String> names, boolean includeStatic) {
        for (PropertyNode pNode : cNode.getProperties()) {
            if (!includeStatic && pNode.isStatic() || names.contains(pNode.getName())) continue;
            result.add(pNode);
            names.add(pNode.getName());
        }
    }

    private static void addPseudoProperties(ClassNode cNode, List<PropertyNode> result, Set<String> names, boolean includeStatic, boolean includePseudoGetters, boolean includeSuperProperties) {
        if (!includePseudoGetters) {
            return;
        }
        List<MethodNode> methods = cNode.getAllDeclaredMethods();
        if (includeSuperProperties) {
            for (ClassNode node = cNode.getSuperClass(); node != null; node = node.getSuperClass()) {
                for (MethodNode next : node.getAllDeclaredMethods()) {
                    if (next.isPrivate()) continue;
                    methods.add(next);
                }
            }
        }
        for (MethodNode mNode : methods) {
            String propName;
            String name;
            if (!includeStatic && mNode.isStatic() || (name = mNode.getName()).length() <= 3 && !name.startsWith(IS_PREFIX) || name.equals("getClass") || name.equals("getMetaClass") || name.equals("getDeclaringClass") || mNode.getDeclaringClass() != cNode && mNode.isPrivate()) continue;
            int paramCount = mNode.getParameters().length;
            ClassNode returnType = mNode.getReturnType();
            if (paramCount != 0) continue;
            if (name.startsWith(GET_PREFIX)) {
                propName = Introspector.decapitalize(name.substring(3));
                if (names.contains(propName)) continue;
                result.add(new PropertyNode(propName, mNode.getModifiers(), returnType, cNode, null, mNode.getCode(), null));
                names.add(propName);
                continue;
            }
            if (!name.startsWith(IS_PREFIX) || !returnType.equals(ClassHelper.boolean_TYPE) || names.contains(propName = Introspector.decapitalize(name.substring(2)))) continue;
            names.add(propName);
            result.add(new PropertyNode(propName, mNode.getModifiers(), returnType, cNode, null, mNode.getCode(), null));
        }
    }
}

