/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import groovy.lang.GroovyResourceLoader;
import groovy.lang.GroovySystem;
import groovy.ui.GroovyMain;
import groovyjarjarcommonscli.CommandLine;
import groovyjarjarcommonscli.DefaultParser;
import groovyjarjarcommonscli.HelpFormatter;
import groovyjarjarcommonscli.Option;
import groovyjarjarcommonscli.Options;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ConfigurationException;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.tools.ErrorReporter;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;

public class FileSystemCompiler {
    private final CompilationUnit unit;
    private static boolean displayStackTraceOnError = false;

    public FileSystemCompiler(CompilerConfiguration configuration) throws ConfigurationException {
        this(configuration, null);
    }

    public FileSystemCompiler(CompilerConfiguration configuration, CompilationUnit cu) throws ConfigurationException {
        this.unit = cu != null ? cu : (configuration.getJointCompilationOptions() != null ? new JavaAwareCompilationUnit(configuration) : new CompilationUnit(configuration));
    }

    public void compile(String[] paths) throws Exception {
        this.unit.addSources(paths);
        this.unit.compile();
    }

    public void compile(File[] files) throws Exception {
        this.unit.addSources(files);
        this.unit.compile();
    }

    public static void displayHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(80, "groovyc [options] <source-files>", "options:", options, "");
    }

    public static void displayVersion() {
        String version = GroovySystem.getVersion();
        System.err.println("Groovy compiler version " + version);
        System.err.println("Copyright 2003-2017 The Apache Software Foundation. http://groovy-lang.org/");
        System.err.println("");
    }

    public static int checkFiles(String[] filenames) {
        int errors = 0;
        for (String filename : filenames) {
            File file = new File(filename);
            if (!file.exists()) {
                System.err.println("error: file not found: " + file);
                ++errors;
                continue;
            }
            if (file.canRead()) continue;
            System.err.println("error: file not readable: " + file);
            ++errors;
        }
        return errors;
    }

    public static boolean validateFiles(String[] filenames) {
        return FileSystemCompiler.checkFiles(filenames) == 0;
    }

    public static void commandLineCompile(String[] args) throws Exception {
        FileSystemCompiler.commandLineCompile(args, true);
    }

    public static void commandLineCompile(String[] args, boolean lookupUnnamedFiles) throws Exception {
        boolean fileNameErrors;
        DefaultParser cliParser = new DefaultParser();
        Options options = FileSystemCompiler.createCompilationOptions();
        CommandLine cli = cliParser.parse(options, args);
        if (cli.hasOption('h')) {
            FileSystemCompiler.displayHelp(options);
            return;
        }
        if (cli.hasOption('v')) {
            FileSystemCompiler.displayVersion();
            return;
        }
        displayStackTraceOnError = cli.hasOption('e');
        CompilerConfiguration configuration = FileSystemCompiler.generateCompilerConfigurationFromOptions(cli);
        String[] filenames = FileSystemCompiler.generateFileNamesFromOptions(cli);
        boolean bl = fileNameErrors = filenames == null;
        if (!fileNameErrors && filenames.length == 0) {
            FileSystemCompiler.displayHelp(options);
            return;
        }
        boolean bl2 = fileNameErrors = fileNameErrors && !FileSystemCompiler.validateFiles(filenames);
        if (!fileNameErrors) {
            FileSystemCompiler.doCompilation(configuration, null, filenames, lookupUnnamedFiles);
        }
    }

    public static void main(String[] args) {
        FileSystemCompiler.commandLineCompileWithErrorHandling(args, true);
    }

    public static void commandLineCompileWithErrorHandling(String[] args, boolean lookupUnnamedFiles) {
        try {
            FileSystemCompiler.commandLineCompile(args, lookupUnnamedFiles);
        }
        catch (Throwable e) {
            new ErrorReporter(e, displayStackTraceOnError).write(System.err);
            System.exit(1);
        }
    }

    public static void doCompilation(CompilerConfiguration configuration, CompilationUnit unit, String[] filenames) throws Exception {
        FileSystemCompiler.doCompilation(configuration, unit, filenames, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doCompilation(CompilerConfiguration configuration, CompilationUnit unit, String[] filenames, boolean lookupUnnamedFiles) throws Exception {
        File tmpDir = null;
        try {
            if (configuration.getJointCompilationOptions() != null && !configuration.getJointCompilationOptions().containsKey("stubDir")) {
                tmpDir = DefaultGroovyStaticMethods.createTempDir(null, "groovy-generated-", "-java-source");
                configuration.getJointCompilationOptions().put("stubDir", tmpDir);
            }
            FileSystemCompiler compiler = new FileSystemCompiler(configuration, unit);
            if (lookupUnnamedFiles) {
                for (String filename : filenames) {
                    File file = new File(filename);
                    if (!file.isFile()) continue;
                    URL url = file.getAbsoluteFile().getParentFile().toURI().toURL();
                    compiler.unit.getClassLoader().addURL(url);
                }
            } else {
                compiler.unit.getClassLoader().setResourceLoader(new GroovyResourceLoader(){

                    @Override
                    public URL loadGroovySource(String filename) throws MalformedURLException {
                        return null;
                    }
                });
            }
            compiler.compile(filenames);
        }
        catch (Throwable throwable) {
            try {
                if (tmpDir != null) {
                    FileSystemCompiler.deleteRecursive(tmpDir);
                }
            }
            catch (Throwable t) {
                System.err.println("error: could not delete temp files - " + tmpDir.getPath());
            }
            throw throwable;
        }
        try {
            if (tmpDir != null) {
                FileSystemCompiler.deleteRecursive(tmpDir);
            }
        }
        catch (Throwable t) {
            System.err.println("error: could not delete temp files - " + tmpDir.getPath());
        }
    }

    public static String[] generateFileNamesFromOptions(CommandLine cli) {
        String[] filenames = cli.getArgs();
        ArrayList<String> fileList = new ArrayList<String>(filenames.length);
        boolean errors = false;
        for (String filename : filenames) {
            if (filename.startsWith("@")) {
                try {
                    String file;
                    BufferedReader br = new BufferedReader(new FileReader(filename.substring(1)));
                    while ((file = br.readLine()) != null) {
                        fileList.add(file);
                    }
                    continue;
                }
                catch (IOException ioe) {
                    System.err.println("error: file not readable: " + filename.substring(1));
                    errors = true;
                    continue;
                }
            }
            fileList.add(filename);
        }
        if (errors) {
            return null;
        }
        return fileList.toArray(new String[fileList.size()]);
    }

    public static CompilerConfiguration generateCompilerConfigurationFromOptions(CommandLine cli) throws IOException {
        CompilerConfiguration configuration = new CompilerConfiguration();
        if (cli.hasOption("classpath")) {
            configuration.setClasspath(cli.getOptionValue("classpath"));
        }
        if (cli.hasOption('d')) {
            configuration.setTargetDirectory(cli.getOptionValue('d'));
        }
        configuration.setParameters(cli.hasOption("pa"));
        if (cli.hasOption("encoding")) {
            configuration.setSourceEncoding(cli.getOptionValue("encoding"));
        }
        if (cli.hasOption("basescript")) {
            configuration.setScriptBaseClass(cli.getOptionValue("basescript"));
        }
        if (cli.hasOption('j')) {
            HashMap<String, Object> compilerOptions = new HashMap<String, Object>();
            String[] namedValues = cli.getOptionValues("J");
            compilerOptions.put("namedValues", namedValues);
            String[] flags = cli.getOptionValues("F");
            if (flags != null && cli.hasOption("pa")) {
                flags = Arrays.copyOf(flags, flags.length + 1);
                flags[flags.length - 1] = "parameters";
            }
            compilerOptions.put("flags", flags);
            configuration.setJointCompilationOptions(compilerOptions);
        }
        if (cli.hasOption("indy")) {
            configuration.getOptimizationOptions().put("int", false);
            configuration.getOptimizationOptions().put("indy", true);
        }
        String configScripts = System.getProperty("groovy.starter.configscripts", null);
        if (cli.hasOption("configscript") || configScripts != null && !configScripts.isEmpty()) {
            ArrayList<String> scripts = new ArrayList<String>();
            if (cli.hasOption("configscript")) {
                scripts.add(cli.getOptionValue("configscript"));
            }
            if (configScripts != null) {
                scripts.addAll(StringGroovyMethods.tokenize((CharSequence)configScripts, Character.valueOf(',')));
            }
            GroovyMain.processConfigScripts(scripts, configuration);
        }
        return configuration;
    }

    public static Options createCompilationOptions() {
        Options options = new Options();
        options.addOption(Option.builder("classpath").hasArg().argName("path").desc("Specify where to find the class files - must be first argument").build());
        options.addOption(Option.builder("cp").longOpt("classpath").hasArg().argName("path").desc("Aliases for '-classpath'").build());
        options.addOption(Option.builder().longOpt("sourcepath").hasArg().argName("path").desc("Specify where to find the source files").build());
        options.addOption(Option.builder().longOpt("temp").hasArg().argName("temp").desc("Specify temporary directory").build());
        options.addOption(Option.builder().longOpt("encoding").hasArg().argName("encoding").desc("Specify the encoding of the user class files").build());
        options.addOption(Option.builder("d").hasArg().desc("Specify where to place generated class files").build());
        options.addOption(Option.builder("h").longOpt("help").desc("Print a synopsis of standard options").build());
        options.addOption(Option.builder("v").longOpt("version").desc("Print the version").build());
        options.addOption(Option.builder("e").longOpt("exception").desc("Print stack trace on error").build());
        options.addOption(Option.builder("pa").longOpt("parameters").desc("Generate metadata for reflection on method parameter names (jdk8+ only)").build());
        options.addOption(Option.builder("j").longOpt("jointCompilation").desc("Attach javac compiler to compile .java files").build());
        options.addOption(Option.builder("b").longOpt("basescript").hasArg().argName("class").desc("Base class name for scripts (must derive from Script)").build());
        options.addOption(Option.builder("J").argName("property=value").valueSeparator().numberOfArgs(2).desc("Name-value pairs to pass to javac").build());
        options.addOption(Option.builder("F").argName("flag").hasArg().desc("Passed to javac for joint compilation").build());
        options.addOption(Option.builder().longOpt("indy").desc("Enables compilation using invokedynamic").build());
        options.addOption(Option.builder().longOpt("configscript").hasArg().desc("A script for tweaking the configuration options").build());
        return options;
    }

    @Deprecated
    public static File createTempDir() throws IOException {
        return DefaultGroovyStaticMethods.createTempDir(null);
    }

    public static void deleteRecursive(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileSystemCompiler.deleteRecursive(files[i]);
            }
            file.delete();
        }
    }
}

