/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package org.apache.groovy.parser.antlr4;

import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.apache.groovy.parser.antlr4.internal.atnmanager.ParserAtnManager;
import org.apache.groovy.util.SystemUtil;

/**
 * The parser for Groovy programming language, which is based on the parser generated by Antlr4
 */
public class GroovyLangParser extends GroovyParser {
    private static final boolean GROOVY_PARSER_PROFILING_ENABLED = SystemUtil.getBooleanSafe("groovy.antlr4.profile");

    public GroovyLangParser(TokenStream input) {
        super(input);

        this.setInterpreter(new ParserATNSimulator(this, ParserAtnManager.INSTANCE.getATN()));

        if (GROOVY_PARSER_PROFILING_ENABLED) {
            this.setProfile(true);
        }
    }

}
