/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.CompositeResolveHelper;
import org.eclipse.osgi.internal.module.CompositeResolveHelperRegistry;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.GroupingChecker;
import org.eclipse.osgi.internal.module.MappedList;
import org.eclipse.osgi.internal.module.PermissionChecker;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionHashMap;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class ResolverImpl
implements Resolver {
    private static final String RESOLVER = "org.eclipse.osgi/resolver";
    private static final String OPTION_DEBUG = "org.eclipse.osgi/resolver/debug";
    private static final String OPTION_WIRING = "org.eclipse.osgi/resolver/wiring";
    private static final String OPTION_IMPORTS = "org.eclipse.osgi/resolver/imports";
    private static final String OPTION_REQUIRES = "org.eclipse.osgi/resolver/requires";
    private static final String OPTION_GENERICS = "org.eclipse.osgi/resolver/generics";
    private static final String OPTION_USES = "org.eclipse.osgi/resolver/uses";
    private static final String OPTION_CYCLES = "org.eclipse.osgi/resolver/cycles";
    public static boolean DEBUG = false;
    public static boolean DEBUG_WIRING = false;
    public static boolean DEBUG_IMPORTS = false;
    public static boolean DEBUG_REQUIRES = false;
    public static boolean DEBUG_GENERICS = false;
    public static boolean DEBUG_USES = false;
    public static boolean DEBUG_CYCLES = false;
    private static int MAX_MULTIPLE_SUPPLIERS_MERGE = 10;
    private static int MAX_USES_TIME_BASE = 30000;
    private static int MAX_USES_TIME_LIMIT = 90000;
    static final SecureAction secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
    private String[][] CURRENT_EES;
    private State state;
    private final PermissionChecker permissionChecker;
    private MappedList removalPending = new MappedList();
    private boolean initialized = false;
    private VersionHashMap resolverExports = null;
    private VersionHashMap resolverBundles = null;
    private VersionHashMap resolverGenerics = null;
    private HashSet unresolvedBundles = null;
    private HashMap bundleMapping = null;
    private GroupingChecker groupingChecker;
    private Comparator selectionPolicy;
    private boolean developmentMode = false;
    private boolean usesCalculationTimeout = false;
    private volatile CompositeResolveHelperRegistry compositeHelpers;

    public ResolverImpl(BundleContext context, boolean checkPermissions) {
        this.permissionChecker = new PermissionChecker(context, checkPermissions, this);
    }

    PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    private void initialize() {
        this.resolverExports = new VersionHashMap(this);
        this.resolverBundles = new VersionHashMap(this);
        this.resolverGenerics = new VersionHashMap(this);
        this.unresolvedBundles = new HashSet();
        this.bundleMapping = new HashMap();
        BundleDescription[] bundles = this.state.getBundles();
        this.groupingChecker = new GroupingChecker();
        ArrayList fragmentBundles = new ArrayList();
        int i = 0;
        while (i < bundles.length) {
            this.initResolverBundle(bundles[i], fragmentBundles, false);
            ++i;
        }
        Object[] removedBundles = this.removalPending.getAllValues();
        int i2 = 0;
        while (i2 < removedBundles.length) {
            this.initResolverBundle((BundleDescription)removedBundles[i2], fragmentBundles, true);
            ++i2;
        }
        Iterator iter = fragmentBundles.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            BundleDescription[] hosts = ((HostSpecification)fragment.getHost().getVersionConstraint()).getHosts();
            int i3 = 0;
            while (i3 < hosts.length) {
                ResolverBundle host = (ResolverBundle)this.bundleMapping.get(hosts[i3]);
                if (host != null) {
                    host.attachFragment(fragment, false);
                }
                ++i3;
            }
        }
        this.rewireBundles();
        this.setDebugOptions();
        this.initialized = true;
    }

    private void initResolverBundle(BundleDescription bundleDesc, ArrayList fragmentBundles, boolean pending) {
        ResolverBundle bundle = new ResolverBundle(bundleDesc, this);
        this.bundleMapping.put(bundleDesc, bundle);
        if (!pending || bundleDesc.isResolved()) {
            this.resolverExports.put(bundle.getExportPackages());
            this.resolverBundles.put(bundle.getName(), bundle);
            this.resolverGenerics.put(bundle.getGenericCapabilities());
        }
        if (bundleDesc.isResolved()) {
            bundle.setState(2);
            if (bundleDesc.getHost() != null) {
                fragmentBundles.add(bundle);
            }
        } else if (!pending) {
            this.unresolvedBundles.add(bundle);
        }
    }

    private void rewireBundles() {
        ArrayList visited = new ArrayList(this.bundleMapping.size());
        Iterator iter = this.bundleMapping.values().iterator();
        while (iter.hasNext()) {
            ResolverBundle rb = (ResolverBundle)iter.next();
            if (!rb.getBundle().isResolved() || rb.isFragment()) continue;
            this.rewireBundle(rb, visited);
        }
    }

    private void rewireBundle(ResolverBundle rb, ArrayList visited) {
        if (visited.contains(rb)) {
            return;
        }
        visited.add(rb);
        BundleConstraint[] requires = rb.getRequires();
        int i = 0;
        while (i < requires.length) {
            this.rewireRequire(requires[i], visited);
            ++i;
        }
        ResolverImport[] imports = rb.getImportPackages();
        int i2 = 0;
        while (i2 < imports.length) {
            this.rewireImport(imports[i2], visited);
            ++i2;
        }
        GenericConstraint[] genericRequires = rb.getGenericRequires();
        int i3 = 0;
        while (i3 < genericRequires.length) {
            this.rewireGeneric(genericRequires[i3], visited);
            ++i3;
        }
    }

    private void rewireGeneric(GenericConstraint constraint, ArrayList visited) {
        if (constraint.getMatchingCapabilities() != null) {
            return;
        }
        GenericDescription[] suppliers = ((GenericSpecification)constraint.getVersionConstraint()).getSuppliers();
        if (suppliers == null) {
            return;
        }
        Object[] matches = this.resolverGenerics.get(constraint.getName());
        int i = 0;
        while (i < matches.length) {
            GenericCapability match = (GenericCapability)matches[i];
            int j = 0;
            while (j < suppliers.length) {
                if (match.getBaseDescription() == suppliers[j]) {
                    constraint.setMatchingCapability(match);
                }
                ++j;
            }
            ++i;
        }
        GenericCapability[] matchingCapabilities = constraint.getMatchingCapabilities();
        if (matchingCapabilities != null) {
            int i2 = 0;
            while (i2 < matchingCapabilities.length) {
                this.rewireBundle(matchingCapabilities[i2].getResolverBundle(), visited);
                ++i2;
            }
        }
    }

    private void rewireRequire(BundleConstraint req, ArrayList visited) {
        if (req.getSelectedSupplier() != null) {
            return;
        }
        ResolverBundle matchingBundle = (ResolverBundle)this.bundleMapping.get(req.getVersionConstraint().getSupplier());
        req.addPossibleSupplier(matchingBundle);
        if (matchingBundle == null && !req.isOptional()) {
            System.err.println("Could not find matching bundle for " + req.getVersionConstraint());
        }
        if (matchingBundle != null) {
            this.rewireBundle(matchingBundle, visited);
        }
    }

    private void rewireImport(ResolverImport imp, ArrayList visited) {
        if (imp.isDynamic() || imp.getSelectedSupplier() != null) {
            return;
        }
        ResolverExport matchingExport = null;
        ExportPackageDescription importSupplier = (ExportPackageDescription)imp.getVersionConstraint().getSupplier();
        ResolverBundle exporter = importSupplier == null ? null : (ResolverBundle)this.bundleMapping.get(importSupplier.getExporter());
        Object[] matches = this.resolverExports.get(imp.getName());
        int j = 0;
        while (j < matches.length) {
            ResolverExport export = (ResolverExport)matches[j];
            if (export.getExporter() == exporter && importSupplier == export.getExportPackageDescription()) {
                matchingExport = export;
                break;
            }
            ++j;
        }
        imp.addPossibleSupplier(matchingExport);
        if (imp.getSelectedSupplier() == null && !imp.isOptional()) {
            System.err.println("Could not find matching export for " + imp.getVersionConstraint());
        }
        if (imp.getSelectedSupplier() != null) {
            this.rewireBundle(((ResolverExport)imp.getSelectedSupplier()).getExporter(), visited);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isResolvable(BundleDescription bundle, Dictionary[] platformProperties, ArrayList rejectedSingletons) {
        String platformFilter;
        int i;
        String[] ees;
        boolean matchedEE;
        Object[] sameName;
        if (rejectedSingletons.contains(bundle)) {
            return false;
        }
        DisabledInfo[] disabledInfos = this.state.getDisabledInfos(bundle);
        if (disabledInfos.length > 0) {
            StringBuffer message = new StringBuffer();
            int i2 = 0;
            while (i2 < disabledInfos.length) {
                if (i2 > 0) {
                    message.append(' ');
                }
                message.append('\"').append(disabledInfos[i2].getPolicyName()).append(':').append(disabledInfos[i2].getMessage()).append('\"');
                ++i2;
            }
            this.state.addResolverError(bundle, 262144, message.toString(), null);
            return false;
        }
        if (bundle.isSingleton() && (sameName = this.resolverBundles.get(bundle.getName())).length > 1) {
            int i3 = 0;
            while (i3 < sameName.length) {
                if (sameName[i3] != bundle && ((ResolverBundle)sameName[i3]).getBundle().isSingleton() && ((ResolverBundle)sameName[i3]).getBundle().isResolved()) {
                    rejectedSingletons.add(bundle);
                    return false;
                }
                ++i3;
            }
        }
        boolean bl = matchedEE = (ees = bundle.getExecutionEnvironments()).length == 0;
        if (!matchedEE) {
            int i4 = 0;
            while (i4 < ees.length && !matchedEE) {
                int j = 0;
                while (j < this.CURRENT_EES.length && !matchedEE) {
                    int k = 0;
                    while (k < this.CURRENT_EES[j].length && !matchedEE) {
                        if (this.CURRENT_EES[j][k].equals(ees[i4])) {
                            ((BundleDescriptionImpl)bundle).setEquinoxEE(j);
                            matchedEE = true;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i4;
            }
        }
        if (!matchedEE) {
            StringBuffer bundleEE = new StringBuffer("Bundle-RequiredExecutionEnvironment".length() + 20);
            bundleEE.append("Bundle-RequiredExecutionEnvironment").append(": ");
            int i5 = 0;
            while (i5 < ees.length) {
                if (i5 > 0) {
                    bundleEE.append(",");
                }
                bundleEE.append(ees[i5]);
                ++i5;
            }
            this.state.addResolverError(bundle, 16384, bundleEE.toString(), null);
            return false;
        }
        NativeCodeSpecification nativeCode = bundle.getNativeCodeSpecification();
        if (nativeCode != null) {
            NativeCodeDescription[] nativeCodeSuppliers = nativeCode.getPossibleSuppliers();
            NativeCodeDescription highestRanked = null;
            i = 0;
            while (i < nativeCodeSuppliers.length) {
                if (nativeCode.isSatisfiedBy(nativeCodeSuppliers[i]) && (highestRanked == null || highestRanked.compareTo(nativeCodeSuppliers[i]) < 0)) {
                    highestRanked = nativeCodeSuppliers[i];
                }
                ++i;
            }
            if (highestRanked == null) {
                if (!nativeCode.isOptional()) {
                    this.state.addResolverError(bundle, 65536, nativeCode.toString(), nativeCode);
                    return false;
                }
            } else if (highestRanked.hasInvalidNativePaths()) {
                this.state.addResolverError(bundle, 131072, highestRanked.toString(), nativeCode);
                return false;
            }
            this.state.resolveConstraint(nativeCode, highestRanked);
        }
        if ((platformFilter = bundle.getPlatformFilter()) == null) {
            return true;
        }
        if (platformProperties == null) {
            return false;
        }
        try {
            FilterImpl filter = FilterImpl.newInstance(platformFilter);
            i = 0;
            while (i < platformProperties.length) {
                if (filter.matchCase(platformProperties[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.state.addResolverError(bundle, 8192, platformFilter, null);
        return false;
    }

    private void attachFragment(ResolverBundle bundle, ArrayList rejectedSingletons, Collection processedFragments) {
        if (processedFragments.contains(bundle.getName())) {
            return;
        }
        processedFragments.add(bundle.getName());
        Object[] fragments = this.resolverBundles.get(bundle.getName());
        int i = 0;
        while (i < fragments.length) {
            ResolverBundle fragment = (ResolverBundle)fragments[i];
            if (!fragment.isResolved()) {
                this.attachFragment0(fragment, rejectedSingletons);
            }
            ++i;
        }
    }

    private void attachFragment0(ResolverBundle bundle, ArrayList rejectedSingletons) {
        if (!bundle.isFragment() || !bundle.isResolvable() || rejectedSingletons.contains(bundle.getBundle())) {
            return;
        }
        boolean foundMatch = false;
        BundleConstraint hostConstraint = bundle.getHost();
        Object[] hosts = this.resolverBundles.get(hostConstraint.getVersionConstraint().getName());
        int i = 0;
        while (i < hosts.length) {
            if (((ResolverBundle)hosts[i]).isResolvable() && hostConstraint.isSatisfiedBy((ResolverBundle)hosts[i])) {
                foundMatch = true;
                this.resolverExports.put(((ResolverBundle)hosts[i]).attachFragment(bundle, true));
            }
            ++i;
        }
        if (!foundMatch) {
            this.state.addResolverError(bundle.getBundle(), 4, bundle.getHost().getVersionConstraint().toString(), bundle.getHost().getVersionConstraint());
        }
    }

    public synchronized void resolve(BundleDescription[] reRefresh, Dictionary[] platformProperties) {
        if (DEBUG) {
            ResolverImpl.log("*** BEGIN RESOLUTION ***");
        }
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        this.developmentMode = platformProperties.length == 0 ? false : "development".equals(platformProperties[0].get("osgi.resolverMode"));
        if ((reRefresh = this.addDevConstraints(reRefresh)) != null) {
            int i = 0;
            while (i < reRefresh.length) {
                ResolverBundle rb = (ResolverBundle)this.bundleMapping.get(reRefresh[i]);
                if (rb != null) {
                    this.unresolveBundle(rb, false);
                }
                ++i;
            }
        }
        this.resolverExports.reorder();
        this.resolverBundles.reorder();
        this.resolverGenerics.reorder();
        this.getCurrentEEs(platformProperties);
        ArrayList rejectedSingletons = new ArrayList();
        boolean resolveOptional = platformProperties.length == 0 ? false : "true".equals(platformProperties[0].get("osgi.resolveOptional"));
        ResolverBundle[] currentlyResolved = null;
        if (resolveOptional) {
            BundleDescription[] resolvedBundles = this.state.getResolvedBundles();
            currentlyResolved = new ResolverBundle[resolvedBundles.length];
            int i = 0;
            while (i < resolvedBundles.length) {
                currentlyResolved[i] = (ResolverBundle)this.bundleMapping.get(resolvedBundles[i]);
                ++i;
            }
        }
        ResolverBundle[] bundles = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
        this.usesCalculationTimeout = false;
        this.resolveBundles(bundles, platformProperties, rejectedSingletons);
        if (this.selectSingletons(bundles, rejectedSingletons)) {
            bundles = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            this.resolveBundles(bundles, platformProperties, rejectedSingletons);
        }
        Iterator rejected = rejectedSingletons.iterator();
        while (rejected.hasNext()) {
            BundleDescription reject = (BundleDescription)rejected.next();
            BundleDescription[] sameNames = this.state.getBundles(reject.getSymbolicName());
            BundleDescription sameName = reject;
            int i = 0;
            while (i < sameNames.length) {
                if (sameNames[i] != reject && sameNames[i].isSingleton() && !rejectedSingletons.contains(sameNames[i])) {
                    sameName = sameNames[i];
                    break;
                }
                ++i;
            }
            this.state.addResolverError(reject, 8, sameName.toString(), null);
        }
        if (resolveOptional) {
            this.resolveOptionalConstraints(currentlyResolved);
        }
        if (DEBUG) {
            ResolverImpl.log("*** END RESOLUTION ***");
        }
    }

    private BundleDescription[] addDevConstraints(BundleDescription[] reRefresh) {
        if (!this.developmentMode) {
            return reRefresh;
        }
        HashSet<BundleDescription> additionalRefresh = new HashSet<BundleDescription>();
        ResolverBundle[] unresolved = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
        int i = 0;
        while (i < unresolved.length) {
            this.addUnresolvedWithDependents(unresolved[i], additionalRefresh);
            this.addHostsFromFragmentConstraints(unresolved[i], additionalRefresh);
            ++i;
        }
        if (additionalRefresh.size() == 0) {
            return reRefresh;
        }
        if (reRefresh != null) {
            i = 0;
            while (i < reRefresh.length) {
                additionalRefresh.add(reRefresh[i]);
                ++i;
            }
        }
        return additionalRefresh.toArray(new BundleDescription[additionalRefresh.size()]);
    }

    private void addUnresolvedWithDependents(ResolverBundle unresolved, HashSet additionalRefresh) {
        BundleDescription[] dependents = unresolved.getBundle().getDependents();
        if (dependents.length > 0) {
            additionalRefresh.add(unresolved.getBundle());
        }
    }

    private void addHostsFromFragmentConstraints(ResolverBundle unresolved, Set additionalRefresh) {
        if (!unresolved.isFragment()) {
            return;
        }
        ImportPackageSpecification[] newImports = unresolved.getBundle().getImportPackages();
        BundleSpecification[] newRequires = unresolved.getBundle().getRequiredBundles();
        if (newImports.length == 0 && newRequires.length == 0) {
            return;
        }
        BundleConstraint hostConstraint = unresolved.getHost();
        Object[] hosts = this.resolverBundles.get(hostConstraint.getVersionConstraint().getName());
        int j = 0;
        while (j < hosts.length) {
            if (hostConstraint.isSatisfiedBy((ResolverBundle)hosts[j]) && ((ResolverBundle)hosts[j]).isResolved()) {
                additionalRefresh.add(((ResolverBundle)hosts[j]).getBundle());
            }
            ++j;
        }
    }

    private void resolveOptionalConstraints(ResolverBundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i] != null) {
                this.resolveOptionalConstraints(bundles[i]);
            }
            ++i;
        }
    }

    private void resolveOptionalConstraints(ResolverBundle bundle) {
        BundleConstraint[] requires = bundle.getRequires();
        ArrayList cycle = new ArrayList();
        boolean resolvedOptional = false;
        int i = 0;
        while (i < requires.length) {
            if (requires[i].isOptional() && requires[i].getSelectedSupplier() == null) {
                cycle.clear();
                this.resolveRequire(requires[i], cycle);
                if (requires[i].getSelectedSupplier() != null) {
                    resolvedOptional = true;
                }
            }
            ++i;
        }
        ResolverImport[] imports = bundle.getImportPackages();
        int i2 = 0;
        while (i2 < imports.length) {
            if (imports[i2].isOptional() && imports[i2].getSelectedSupplier() == null) {
                cycle.clear();
                this.resolveImport(imports[i2], cycle);
                if (imports[i2].getSelectedSupplier() != null) {
                    resolvedOptional = true;
                }
            }
            ++i2;
        }
        if (resolvedOptional) {
            this.state.resolveBundle(bundle.getBundle(), false, null, null, null, null, null);
            this.stateResolveConstraints(bundle);
            this.stateResolveBundle(bundle);
        }
    }

    private void getCurrentEEs(Dictionary[] platformProperties) {
        this.CURRENT_EES = new String[platformProperties.length][];
        int i = 0;
        while (i < platformProperties.length) {
            String eeSpecs = (String)platformProperties[i].get("org.osgi.framework.executionenvironment");
            this.CURRENT_EES[i] = ManifestElement.getArrayFromList(eeSpecs, ",");
            ++i;
        }
    }

    private void resolveBundles(ResolverBundle[] bundles, Dictionary[] platformProperties, ArrayList rejectedSingletons) {
        int i = 0;
        while (i < bundles.length) {
            this.state.removeResolverErrors(bundles[i].getBundle());
            bundles[i].setResolvable(this.isResolvable(bundles[i].getBundle(), platformProperties, rejectedSingletons) || this.developmentMode);
            bundles[i].clearRefs();
            ++i;
        }
        this.resolveBundles0(bundles, platformProperties, rejectedSingletons);
        if (DEBUG_WIRING) {
            this.printWirings();
        }
        this.stateResolveBundles(bundles);
    }

    private void resolveBundles0(ResolverBundle[] bundles, Dictionary[] platformProperties, ArrayList rejectedSingletons) {
        if (this.developmentMode) {
            Arrays.sort(bundles);
        }
        HashSet processedFragments = new HashSet(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            this.attachFragment(bundles[i], rejectedSingletons, processedFragments);
            ++i;
        }
        ArrayList cycle = new ArrayList(1);
        int i2 = 0;
        while (i2 < bundles.length) {
            if (DEBUG) {
                ResolverImpl.log("** RESOLVING " + bundles[i2] + " **");
            }
            cycle.clear();
            this.resolveBundle(bundles[i2], cycle);
            this.checkCycle(cycle);
            ++i2;
        }
        if (this.unresolvedBundles.size() > 0) {
            ResolverBundle[] unresolved = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            int i3 = 0;
            while (i3 < unresolved.length) {
                this.resolveFragment(unresolved[i3]);
                ++i3;
            }
        }
        this.checkUsesConstraints(bundles, platformProperties, rejectedSingletons);
        this.checkComposites(bundles, platformProperties, rejectedSingletons);
    }

    private void checkComposites(ResolverBundle[] bundles, Dictionary[] platformProperties, ArrayList rejectedSingletons) {
        CompositeResolveHelperRegistry helpers = this.getCompositeHelpers();
        if (helpers == null) {
            return;
        }
        HashSet<ResolverBundle> exclude = null;
        int i = 0;
        while (i < bundles.length) {
            CompositeResolveHelper helper = helpers.getCompositeResolveHelper(bundles[i].getBundle());
            if (helper != null && bundles[i].isResolved() && !helper.giveExports(ResolverImpl.getExportsWiredTo(bundles[i]))) {
                this.state.addResolverError(bundles[i].getBundle(), 262144, null, null);
                bundles[i].setResolvable(false);
                bundles[i].clearRefs();
                this.setBundleUnresolved(bundles[i], false, false);
                if (exclude == null) {
                    exclude = new HashSet<ResolverBundle>(1);
                }
                exclude.add(bundles[i]);
            }
            ++i;
        }
        this.reResolveBundles(exclude, bundles, platformProperties, rejectedSingletons);
    }

    private void checkUsesConstraints(ResolverBundle[] bundles, Dictionary[] platformProperties, ArrayList rejectedSingletons) {
        ArrayList conflictingConstraints = this.findBestCombination(bundles, platformProperties);
        if (conflictingConstraints == null) {
            return;
        }
        HashSet<ResolverBundle> conflictedBundles = null;
        Iterator conflicts = conflictingConstraints.iterator();
        while (conflicts.hasNext()) {
            ResolverBundle conflictedBundle;
            ResolverConstraint conflict = (ResolverConstraint)conflicts.next();
            if (conflict.isOptional()) {
                conflict.clearPossibleSuppliers();
                continue;
            }
            if (conflictedBundles == null) {
                conflictedBundles = new HashSet<ResolverBundle>(conflictingConstraints.size());
            }
            if ((conflictedBundle = conflict.isFromFragment() ? (ResolverBundle)this.bundleMapping.get(conflict.getVersionConstraint().getBundle()) : conflict.getBundle()) == null) continue;
            if (DEBUG_USES) {
                System.out.println("Found conflicting constraint: " + conflict + " in bundle " + conflictedBundle);
            }
            conflictedBundles.add(conflictedBundle);
            int type = conflict instanceof ResolverImport ? 32 : 64;
            this.state.addResolverError(conflictedBundle.getBundle(), type, conflict.getVersionConstraint().toString(), conflict.getVersionConstraint());
            conflictedBundle.setResolvable(false);
            conflictedBundle.clearRefs();
            this.setBundleUnresolved(conflictedBundle, false, false);
        }
        this.reResolveBundles(conflictedBundles, bundles, platformProperties, rejectedSingletons);
    }

    private void reResolveBundles(Set exclude, ResolverBundle[] bundles, Dictionary[] platformProperties, ArrayList rejectedSingletons) {
        if (exclude == null || exclude.size() == 0) {
            return;
        }
        ArrayList<ResolverBundle> remainingUnresolved = new ArrayList<ResolverBundle>();
        int i = 0;
        while (i < bundles.length) {
            if (!exclude.contains(bundles[i])) {
                this.setBundleUnresolved(bundles[i], false, false);
                remainingUnresolved.add(bundles[i]);
            }
            ++i;
        }
        this.resolveBundles0(remainingUnresolved.toArray(new ResolverBundle[remainingUnresolved.size()]), platformProperties, rejectedSingletons);
    }

    private ArrayList findBestCombination(ResolverBundle[] bundles, Dictionary[] platformProperties) {
        String usesMode;
        String string = usesMode = platformProperties.length == 0 ? null : (String)platformProperties[0].get("osgi.resolver.usesMode");
        if (usesMode == null) {
            usesMode = secureAction.getProperty("osgi.resolver.usesMode");
        }
        if ("ignore".equals(usesMode) || this.developmentMode) {
            return null;
        }
        HashSet packageConstraints = new HashSet();
        HashSet bundleConstraints = new HashSet();
        ArrayList initialConflicts = this.getConflicts(bundles, packageConstraints, bundleConstraints);
        if (initialConflicts == null || "tryFirst".equals(usesMode) || this.usesCalculationTimeout) {
            this.groupingChecker.clear();
            return initialConflicts;
        }
        ResolverConstraint[][] multipleSuppliers = this.getMultipleSuppliers(bundles, packageConstraints, bundleConstraints);
        ArrayList conflicts = null;
        int[] bestCombination = new int[multipleSuppliers.length];
        conflicts = this.findBestCombination(bundles, multipleSuppliers, bestCombination, initialConflicts);
        if (DEBUG_USES) {
            System.out.print("Best combination found: ");
            this.printCombination(bestCombination);
        }
        int i = 0;
        while (i < bestCombination.length) {
            int j = 0;
            while (j < multipleSuppliers[i].length) {
                multipleSuppliers[i][j].setSelectedSupplier(bestCombination[i]);
                ++j;
            }
            ++i;
        }
        this.groupingChecker.clear();
        return conflicts;
    }

    private int[] getCombination(ResolverConstraint[][] multipleSuppliers, int[] combination) {
        int i = 0;
        while (i < combination.length) {
            combination[i] = multipleSuppliers[i][0].getSelectedSupplierIndex();
            ++i;
        }
        return combination;
    }

    private ArrayList findBestCombination(ResolverBundle[] bundles, ResolverConstraint[][] multipleSuppliers, int[] bestCombination, ArrayList bestConflicts) {
        long initialTime = System.currentTimeMillis();
        long timeLimit = Math.min(MAX_USES_TIME_BASE + bundles.length * 30, MAX_USES_TIME_LIMIT);
        int bestConflictCount = this.getConflictCount(bestConflicts);
        ResolverBundle[] bestConflictBundles = this.getConflictedBundles(bestConflicts);
        while (bestConflictCount != 0 && this.getNextCombination(multipleSuppliers)) {
            ArrayList conflicts;
            int conflictCount;
            if (System.currentTimeMillis() - initialTime > timeLimit) {
                if (DEBUG_USES) {
                    System.out.println("Uses constraint check has timedout.  Using the best solution found so far.");
                }
                this.usesCalculationTimeout = true;
                break;
            }
            if (DEBUG_USES) {
                this.printCombination(this.getCombination(multipleSuppliers, new int[multipleSuppliers.length]));
            }
            if ((conflictCount = this.getConflictCount(conflicts = this.getConflicts(bestConflictBundles, null, null))) >= bestConflictCount) {
                if (!DEBUG_USES) continue;
                System.out.println("Combination is not better that current best: " + conflictCount + ">=" + bestConflictCount);
                continue;
            }
            conflicts = this.getConflicts(bundles, null, null);
            conflictCount = this.getConflictCount(conflicts);
            if (conflictCount < bestConflictCount) {
                bestConflictCount = conflictCount;
                bestConflicts = conflicts;
                this.getCombination(multipleSuppliers, bestCombination);
                bestConflictBundles = this.getConflictedBundles(bestConflicts);
                if (!DEBUG_USES) continue;
                System.out.println("Combination selected as current best: number of conflicts: " + bestConflictCount);
                continue;
            }
            if (!DEBUG_USES) continue;
            System.out.println("Combination is not better that current best: " + conflictCount + ">=" + bestConflictCount);
        }
        return bestConflicts;
    }

    private void printCombination(int[] curCombination) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        int i = 0;
        while (i < curCombination.length) {
            sb.append(curCombination[i]);
            if (i < curCombination.length - 1) {
                sb.append(',');
            }
            ++i;
        }
        sb.append(']');
        System.out.println(sb.toString());
    }

    private ResolverBundle[] getConflictedBundles(ArrayList bestConflicts) {
        if (bestConflicts == null) {
            return new ResolverBundle[0];
        }
        ArrayList<ResolverBundle> conflictedBundles = new ArrayList<ResolverBundle>(bestConflicts.size());
        Iterator iConflicts = bestConflicts.iterator();
        while (iConflicts.hasNext()) {
            ResolverConstraint constraint = (ResolverConstraint)iConflicts.next();
            if (conflictedBundles.contains(constraint.getBundle())) continue;
            conflictedBundles.add(constraint.getBundle());
        }
        return conflictedBundles.toArray(new ResolverBundle[conflictedBundles.size()]);
    }

    private boolean getNextCombination(ResolverConstraint[][] multipleSuppliers) {
        int current = 0;
        while (current < multipleSuppliers.length) {
            int i;
            if (multipleSuppliers[current][0].selectNextSupplier()) {
                i = 1;
                while (i < multipleSuppliers[current].length) {
                    multipleSuppliers[current][i].selectNextSupplier();
                    ++i;
                }
                return true;
            }
            i = 0;
            while (i < multipleSuppliers[current].length) {
                multipleSuppliers[current][i].setSelectedSupplier(0);
                ++i;
            }
            ++current;
        }
        return false;
    }

    private int getConflictCount(ArrayList conflicts) {
        if (conflicts == null || conflicts.size() == 0) {
            return 0;
        }
        int result = 0;
        Iterator iConflicts = conflicts.iterator();
        while (iConflicts.hasNext()) {
            if (((ResolverConstraint)iConflicts.next()).isOptional()) continue;
            ++result;
        }
        return result;
    }

    private ArrayList getConflicts(ResolverBundle[] bundles, HashSet packageConstraints, HashSet bundleConstraints) {
        this.groupingChecker.clear();
        ArrayList conflicts = null;
        int i = 0;
        while (i < bundles.length) {
            conflicts = this.addConflicts(bundles[i], packageConstraints, bundleConstraints, conflicts);
            ++i;
        }
        return conflicts;
    }

    private ArrayList addConflicts(ResolverBundle bundle, HashSet packageConstraints, HashSet bundleConstraints, ArrayList conflicts) {
        boolean foundConflict = false;
        BundleConstraint[] requires = bundle.getRequires();
        int i = 0;
        while (i < requires.length) {
            GroupingChecker.PackageRoots[][] conflict;
            ResolverBundle selectedSupplier = (ResolverBundle)requires[i].getSelectedSupplier();
            GroupingChecker.PackageRoots[][] packageRootsArray = conflict = selectedSupplier == null ? null : this.groupingChecker.isConsistent(bundle, selectedSupplier);
            if (conflict != null) {
                this.addConflictNames(conflict, packageConstraints, bundleConstraints);
                if (!foundConflict) {
                    if (conflicts == null) {
                        conflicts = new ArrayList<BundleConstraint>(1);
                    }
                    conflicts.add(requires[i]);
                    foundConflict = !requires[i].isOptional();
                }
            }
            ++i;
        }
        ResolverImport[] imports = bundle.getImportPackages();
        int i2 = 0;
        while (i2 < imports.length) {
            GroupingChecker.PackageRoots[][] conflict;
            ResolverExport selectedSupplier = (ResolverExport)imports[i2].getSelectedSupplier();
            GroupingChecker.PackageRoots[][] packageRootsArray = conflict = selectedSupplier == null ? null : this.groupingChecker.isConsistent(bundle, selectedSupplier);
            if (conflict != null) {
                this.addConflictNames(conflict, packageConstraints, bundleConstraints);
                if (!foundConflict) {
                    if (conflicts == null) {
                        conflicts = new ArrayList(1);
                    }
                    conflicts.add((BundleConstraint)((Object)imports[i2]));
                    foundConflict = !imports[i2].isOptional();
                }
            }
            ++i2;
        }
        return conflicts;
    }

    private void addConflictNames(GroupingChecker.PackageRoots[][] conflict, HashSet packageConstraints, HashSet bundleConstraints) {
        if (packageConstraints == null || bundleConstraints == null) {
            return;
        }
        int i = 0;
        while (i < conflict.length) {
            ResolverExport[] exports1;
            packageConstraints.add(conflict[i][0].getName());
            packageConstraints.add(conflict[i][1].getName());
            ResolverExport[] exports0 = conflict[i][0].getRoots();
            if (exports0 != null) {
                int j = 0;
                while (j < exports0.length) {
                    ResolverBundle exporter = exports0[j].getExporter();
                    if (exporter != null && exporter.getName() != null) {
                        bundleConstraints.add(exporter.getName());
                    }
                    ++j;
                }
            }
            if ((exports1 = conflict[i][1].getRoots()) != null) {
                int j = 0;
                while (j < exports1.length) {
                    ResolverBundle exporter = exports1[j].getExporter();
                    if (exporter != null && exporter.getName() != null) {
                        bundleConstraints.add(exporter.getName());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private ResolverConstraint[][] getMultipleSuppliers(ResolverBundle[] bundles, HashSet packageConstraints, HashSet bundleConstraints) {
        ArrayList<ResolverConstraint[]> results;
        block16: {
            ArrayList<BundleConstraint> multipleRequireSupplierList;
            ArrayList<ResolverImport> multipleImportSupplierList;
            block15: {
                multipleImportSupplierList = new ArrayList<ResolverImport>(1);
                multipleRequireSupplierList = new ArrayList<BundleConstraint>(1);
                int i = 0;
                while (i < bundles.length) {
                    BundleConstraint[] requires = bundles[i].getRequires();
                    int j = 0;
                    while (j < requires.length) {
                        if (requires[j].getNumPossibleSuppliers() > 1) {
                            multipleRequireSupplierList.add(requires[j]);
                        }
                        ++j;
                    }
                    ResolverImport[] imports = bundles[i].getImportPackages();
                    int j2 = 0;
                    while (j2 < imports.length) {
                        if (imports[j2].getNumPossibleSuppliers() > 1) {
                            Integer eeProfile = (Integer)((ResolverExport)imports[j2].getSelectedSupplier()).getExportPackageDescription().getDirective("x-equinox-ee");
                            if (eeProfile < 0) {
                                multipleImportSupplierList.add(imports[j2]);
                            } else {
                                VersionSupplier[] suppliers = imports[j2].getPossibleSuppliers();
                                int suppliersIndex = 1;
                                while (suppliersIndex < suppliers.length) {
                                    Integer ee = (Integer)((ResolverExport)suppliers[suppliersIndex]).getExportPackageDescription().getDirective("x-equinox-ee");
                                    if (ee < 0 && ((ResolverExport)suppliers[suppliersIndex]).getExporter().getRequire(this.getSystemBundle()) == null && ((ResolverExport)suppliers[suppliersIndex]).getExporter().getRequire("system.bundle") == null) {
                                        multipleImportSupplierList.add(imports[j2]);
                                        break;
                                    }
                                    ++suppliersIndex;
                                }
                            }
                        }
                        ++j2;
                    }
                    ++i;
                }
                results = new ArrayList<ResolverConstraint[]>();
                if (multipleImportSupplierList.size() + multipleRequireSupplierList.size() <= MAX_MULTIPLE_SUPPLIERS_MERGE) break block15;
                HashMap multipleImportSupplierMaps = new HashMap(1);
                Iterator iMultipleImportSuppliers = multipleImportSupplierList.iterator();
                while (iMultipleImportSuppliers.hasNext()) {
                    this.addMutipleSupplierConstraint(multipleImportSupplierMaps, (ResolverConstraint)iMultipleImportSuppliers.next());
                }
                HashMap multipleRequireSupplierMaps = new HashMap(1);
                Iterator iMultipleRequireSuppliers = multipleRequireSupplierList.iterator();
                while (iMultipleRequireSuppliers.hasNext()) {
                    this.addMutipleSupplierConstraint(multipleRequireSupplierMaps, (ResolverConstraint)iMultipleRequireSuppliers.next());
                }
                this.addMergedSuppliers(results, multipleImportSupplierMaps);
                this.addMergedSuppliers(results, multipleRequireSupplierMaps);
                if (results.size() <= MAX_MULTIPLE_SUPPLIERS_MERGE || packageConstraints == null || bundleConstraints == null) break block16;
                Iterator iResults = results.iterator();
                results = new ArrayList();
                while (iResults.hasNext()) {
                    ResolverConstraint constraint;
                    ResolverConstraint[] constraints = (ResolverConstraint[])iResults.next();
                    ResolverConstraint resolverConstraint = constraint = constraints.length > 0 ? constraints[0] : null;
                    if (constraint instanceof ResolverImport) {
                        if (!packageConstraints.contains(constraint.getName())) continue;
                        results.add(constraints);
                        continue;
                    }
                    if (!(constraint instanceof BundleConstraint) || !bundleConstraints.contains(constraint.getName())) continue;
                    results.add(constraints);
                }
                break block16;
            }
            Iterator iMultipleImportSuppliers = multipleImportSupplierList.iterator();
            while (iMultipleImportSuppliers.hasNext()) {
                results.add(new ResolverConstraint[]{(ResolverConstraint)iMultipleImportSuppliers.next()});
            }
            Iterator iMultipleRequireSuppliers = multipleRequireSupplierList.iterator();
            while (iMultipleRequireSuppliers.hasNext()) {
                results.add(new ResolverConstraint[]{(ResolverConstraint)iMultipleRequireSuppliers.next()});
            }
        }
        return (ResolverConstraint[][])results.toArray((T[])new ResolverConstraint[results.size()][]);
    }

    String getSystemBundle() {
        Dictionary[] platformProperties = this.state.getPlatformProperties();
        String systemBundle = platformProperties.length == 0 ? null : platformProperties[0].get("osgi.system.bundle");
        if (systemBundle == null) {
            systemBundle = Constants.getInternalSymbolicName();
        }
        return systemBundle;
    }

    private void addMergedSuppliers(ArrayList mergedSuppliers, HashMap constraints) {
        Iterator iConstraints = constraints.values().iterator();
        while (iConstraints.hasNext()) {
            ArrayList mergedConstraintLists = (ArrayList)iConstraints.next();
            Iterator mergedLists = mergedConstraintLists.iterator();
            while (mergedLists.hasNext()) {
                ArrayList constraintList = (ArrayList)mergedLists.next();
                mergedSuppliers.add(constraintList.toArray(new ResolverConstraint[constraintList.size()]));
            }
        }
    }

    private void addMutipleSupplierConstraint(HashMap constraints, ResolverConstraint constraint) {
        ArrayList mergedConstraintLists = (ArrayList)constraints.get(constraint.getName());
        if (mergedConstraintLists == null) {
            mergedConstraintLists = new ArrayList(1);
            ArrayList<ResolverConstraint> constraintList = new ArrayList<ResolverConstraint>(1);
            constraintList.add(constraint);
            mergedConstraintLists.add(constraintList);
            constraints.put(constraint.getName(), mergedConstraintLists);
            return;
        }
        Iterator mergedLists = mergedConstraintLists.iterator();
        while (mergedLists.hasNext()) {
            VersionSupplier[] suppliers2;
            ArrayList constraintList = (ArrayList)mergedLists.next();
            ResolverConstraint mergedConstraint = (ResolverConstraint)constraintList.get(0);
            VersionSupplier[] suppliers1 = constraint.getPossibleSuppliers();
            if (suppliers1.length != (suppliers2 = mergedConstraint.getPossibleSuppliers()).length) continue;
            int i = 0;
            while (i < suppliers1.length) {
                if (suppliers1[i] != suppliers2[i]) {
                    // empty if block
                }
                ++i;
            }
            constraintList.add(constraint);
            return;
        }
        ArrayList<ResolverConstraint> constraintList = new ArrayList<ResolverConstraint>(1);
        constraintList.add(constraint);
        mergedConstraintLists.add(constraintList);
    }

    /*
     * Unable to fully structure code
     */
    private void checkCycle(ArrayList cycle) {
        cycleSize = cycle.size();
        if (cycleSize == 0) {
            return;
        }
        iCycle = cycle.iterator();
        while (iCycle.hasNext()) {
            block12: {
                cycleBundle = (ResolverBundle)iCycle.next();
                if (!cycleBundle.isResolvable()) {
                    iCycle.remove();
                    continue;
                }
                imports = cycleBundle.getImportPackages();
                j = 0;
                break block12;
                while ((importSupplier = (ResolverExport)imports[j].getSelectedSupplier()).getSubstitute() != null) {
                    imports[j].selectNextSupplier();
lbl16:
                    // 2 sources

                    ** while (imports[j].getSelectedSupplier() == null)
lbl17:
                    // 1 sources

                }
lbl18:
                // 2 sources

                if (!imports[j].isDynamic() && !imports[j].isOptional() && imports[j].getSelectedSupplier() == null) {
                    cycleBundle.setResolvable(false);
                    cycleBundle.clearRefs();
                    this.state.addResolverError(imports[j].getVersionConstraint().getBundle(), 1, imports[j].getVersionConstraint().toString(), imports[j].getVersionConstraint());
                    iCycle.remove();
                    continue;
                }
                ++j;
            }
            if (j < imports.length) ** GOTO lbl16
        }
        if (cycle.size() != cycleSize) {
            i = 0;
            while (i < cycle.size()) {
                cycleBundle = (ResolverBundle)cycle.get(i);
                cycleBundle.clearWires();
                cycleBundle.clearRefs();
                ++i;
            }
            innerCycle = new ArrayList<E>(cycle.size());
            i = 0;
            while (i < cycle.size()) {
                this.resolveBundle((ResolverBundle)cycle.get(i), innerCycle);
                ++i;
            }
            this.checkCycle(innerCycle);
        } else {
            i = 0;
            while (i < cycle.size()) {
                if (ResolverImpl.DEBUG || ResolverImpl.DEBUG_CYCLES) {
                    ResolverImpl.log("Pushing " + cycle.get(i) + " to RESOLVED");
                }
                this.setBundleResolved((ResolverBundle)cycle.get(i));
                ++i;
            }
        }
    }

    private boolean selectSingletons(ResolverBundle[] bundles, ArrayList rejectedSingletons) {
        if (this.developmentMode) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < bundles.length) {
            Object[] sameName;
            BundleDescription bundleDesc = bundles[i].getBundle();
            if (bundleDesc.isSingleton() && bundleDesc.isResolved() && !rejectedSingletons.contains(bundleDesc) && (sameName = this.resolverBundles.get(bundleDesc.getName())).length > 1) {
                int j = 0;
                while (j < sameName.length) {
                    BundleDescription sameNameDesc = ((VersionSupplier)sameName[j]).getBundle();
                    ResolverBundle sameNameBundle = (ResolverBundle)sameName[j];
                    if (sameName[j] != bundles[i] && sameNameDesc.isSingleton() && sameNameDesc.isResolved() && !rejectedSingletons.contains(sameNameDesc)) {
                        result = true;
                        boolean rejectedPolicy = this.selectionPolicy != null ? this.selectionPolicy.compare(sameNameDesc, bundleDesc) < 0 : sameNameDesc.getVersion().compareTo(bundleDesc.getVersion()) > 0;
                        int sameNameRefs = sameNameBundle.getRefs();
                        int curRefs = bundles[i].getRefs();
                        if (sameNameRefs == curRefs && rejectedPolicy || sameNameRefs > curRefs) {
                            if (rejectedSingletons.contains(bundles[i].getBundle())) break;
                            rejectedSingletons.add(bundles[i].getBundle());
                            break;
                        }
                        if (!rejectedSingletons.contains(sameNameDesc)) {
                            rejectedSingletons.add(sameNameDesc);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < bundles.length) {
            bundles[i].clearRefs();
            ++i;
        }
        Iterator rejects = rejectedSingletons.iterator();
        while (rejects.hasNext()) {
            this.unresolveBundle((ResolverBundle)this.bundleMapping.get(rejects.next()), false);
        }
        this.resolverExports.reorder();
        this.resolverBundles.reorder();
        this.resolverGenerics.reorder();
        return result;
    }

    private void resolveFragment(ResolverBundle fragment) {
        if (!fragment.isFragment()) {
            return;
        }
        if (!(fragment.getHost().getNumPossibleSuppliers() <= 0 || this.developmentMode && this.state.getResolverErrors(fragment.getBundle()).length != 0)) {
            this.setBundleResolved(fragment);
        }
    }

    private boolean resolveBundle(ResolverBundle bundle, ArrayList cycle) {
        int i;
        if (bundle.isFragment()) {
            return false;
        }
        if (!bundle.isResolvable()) {
            if (DEBUG) {
                ResolverImpl.log("  - " + bundle + " is unresolvable");
            }
            return false;
        }
        switch (bundle.getState()) {
            case 2: {
                if (DEBUG) {
                    ResolverImpl.log("  - " + bundle + " already resolved");
                }
                return true;
            }
            case 0: {
                bundle.clearWires();
                this.setBundleResolving(bundle);
                break;
            }
            case 1: {
                if (!cycle.contains(bundle)) break;
                return true;
            }
        }
        boolean failed = false;
        if (!failed) {
            GenericConstraint[] genericRequires = bundle.getGenericRequires();
            i = 0;
            while (i < genericRequires.length) {
                if (!this.resolveGenericReq(genericRequires[i], cycle)) {
                    if (DEBUG || DEBUG_GENERICS) {
                        ResolverImpl.log("** GENERICS " + genericRequires[i].getVersionConstraint().getName() + "[" + genericRequires[i].getBundleDescription() + "] failed to resolve");
                    }
                    this.state.addResolverError(genericRequires[i].getVersionConstraint().getBundle(), 32768, genericRequires[i].getVersionConstraint().toString(), genericRequires[i].getVersionConstraint());
                    if (genericRequires[i].isFromFragment()) {
                        if (!this.developmentMode) {
                            this.resolverExports.remove(bundle.detachFragment((ResolverBundle)this.bundleMapping.get(genericRequires[i].getVersionConstraint().getBundle()), null));
                        }
                    } else if (!this.developmentMode) {
                        failed = true;
                        break;
                    }
                }
                ++i;
            }
        }
        if (!failed) {
            BundleConstraint[] requires = bundle.getRequires();
            i = 0;
            while (i < requires.length) {
                if (!this.resolveRequire(requires[i], cycle)) {
                    if (DEBUG || DEBUG_REQUIRES) {
                        ResolverImpl.log("** REQUIRE " + requires[i].getVersionConstraint().getName() + "[" + requires[i].getBundleDescription() + "] failed to resolve");
                    }
                    this.state.addResolverError(requires[i].getVersionConstraint().getBundle(), 2, requires[i].getVersionConstraint().toString(), requires[i].getVersionConstraint());
                    if (requires[i].isFromFragment()) {
                        if (!this.developmentMode) {
                            this.resolverExports.remove(bundle.detachFragment((ResolverBundle)this.bundleMapping.get(requires[i].getVersionConstraint().getBundle()), requires[i]));
                        }
                    } else if (!this.developmentMode) {
                        failed = true;
                        break;
                    }
                }
                ++i;
            }
        }
        if (!failed) {
            ResolverImport[] imports = bundle.getImportPackages();
            i = 0;
            while (i < imports.length) {
                if (!imports[i].isDynamic() && !this.resolveImport(imports[i], cycle)) {
                    if (DEBUG || DEBUG_IMPORTS) {
                        ResolverImpl.log("** IMPORT " + imports[i].getName() + "[" + imports[i].getBundleDescription() + "] failed to resolve");
                    }
                    this.state.addResolverError(imports[i].getVersionConstraint().getBundle(), 1, imports[i].getVersionConstraint().toString(), imports[i].getVersionConstraint());
                    if (imports[i].isFromFragment()) {
                        if (!this.developmentMode) {
                            this.resolverExports.remove(bundle.detachFragment((ResolverBundle)this.bundleMapping.get(imports[i].getVersionConstraint().getBundle()), imports[i]));
                        }
                    } else if (!this.developmentMode) {
                        failed = true;
                        break;
                    }
                }
                ++i;
            }
        }
        this.checkFragmentConstraints(bundle);
        if (this.developmentMode && !failed && this.state.getResolverErrors(bundle.getBundle()).length > 0) {
            failed = true;
        }
        if (failed) {
            this.setBundleUnresolved(bundle, false, this.developmentMode);
            if (DEBUG) {
                ResolverImpl.log(bundle + " NOT RESOLVED");
            }
        } else if (!cycle.contains(bundle)) {
            this.setBundleResolved(bundle);
            if (DEBUG) {
                ResolverImpl.log(bundle + " RESOLVED");
            }
        }
        if (bundle.getState() == 0) {
            bundle.setResolvable(false);
        }
        return bundle.getState() != 0;
    }

    private void checkFragmentConstraints(ResolverBundle bundle) {
        ResolverBundle[] fragments = bundle.getFragments();
        int i = 0;
        while (i < fragments.length) {
            BundleDescription fragment = fragments[i].getBundle();
            if (bundle.constraintsConflict(fragment, fragment.getImportPackages(), fragment.getRequiredBundles(), fragment.getGenericRequires()) && !this.developmentMode) {
                this.resolverExports.remove(bundle.detachFragment(fragments[i], null));
            }
            ++i;
        }
    }

    private boolean resolveGenericReq(GenericConstraint constraint, ArrayList cycle) {
        GenericCapability[] matchingCapabilities;
        if (DEBUG_REQUIRES) {
            ResolverImpl.log("Trying to resolve: " + constraint.getBundle() + ", " + constraint.getVersionConstraint());
        }
        if ((matchingCapabilities = constraint.getMatchingCapabilities()) != null) {
            int i = 0;
            while (i < matchingCapabilities.length) {
                if (matchingCapabilities[i].getResolverBundle().getState() == 1 && !cycle.contains(constraint.getBundle())) {
                    cycle.add(constraint.getBundle());
                }
                ++i;
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        Object[] capabilities = this.resolverGenerics.get(constraint.getVersionConstraint().getName());
        boolean result = false;
        int i = 0;
        while (i < capabilities.length) {
            GenericCapability capability = (GenericCapability)capabilities[i];
            if (DEBUG_GENERICS) {
                ResolverImpl.log("CHECKING GENERICS: " + capability.getBaseDescription());
            }
            if (constraint.isSatisfiedBy(capability)) {
                capability.getResolverBundle().addRef(constraint.getBundle());
                if (!result || (((GenericSpecification)constraint.getVersionConstraint()).getResolution() & 2) != 0) {
                    constraint.setMatchingCapability(capability);
                    if (constraint.getBundle() == capability.getResolverBundle()) {
                        result = true;
                    } else {
                        VersionSupplier[] versionSupplierArray;
                        if (capability.isFromFragment()) {
                            versionSupplierArray = capability.getResolverBundle().getHost().getPossibleSuppliers();
                        } else {
                            ResolverBundle[] resolverBundleArray = new ResolverBundle[1];
                            versionSupplierArray = resolverBundleArray;
                            resolverBundleArray[0] = capability.getResolverBundle();
                        }
                        VersionSupplier[] capabilityHosts = versionSupplierArray;
                        boolean foundResolvedMatch = false;
                        int j = 0;
                        while (capabilityHosts != null && j < capabilityHosts.length) {
                            ResolverBundle capabilitySupplier = (ResolverBundle)capabilityHosts[j];
                            if (capabilitySupplier == constraint.getBundle()) {
                                foundResolvedMatch = true;
                            } else if (capabilitySupplier.getState() == 2 || this.resolveBundle(capabilitySupplier, cycle) || this.developmentMode) {
                                foundResolvedMatch |= !capability.isFromFragment() ? true : capability.getResolverBundle().getHost().getPossibleSuppliers() != null;
                                if (capabilitySupplier.getState() == 1 && !cycle.contains(capabilitySupplier)) {
                                    cycle.add(capabilitySupplier);
                                }
                            }
                            ++j;
                        }
                        if (!foundResolvedMatch) {
                            constraint.removeMatchingCapability(capability);
                        } else {
                            if (DEBUG_GENERICS) {
                                ResolverImpl.log("Found match: " + capability.getBaseDescription() + ". Wiring");
                            }
                            result = true;
                        }
                    }
                }
            }
            ++i;
        }
        return result ? true : (((GenericSpecification)constraint.getVersionConstraint()).getResolution() & 1) != 0;
    }

    private boolean resolveRequire(BundleConstraint req, ArrayList cycle) {
        if (DEBUG_REQUIRES) {
            ResolverImpl.log("Trying to resolve: " + req.getBundle() + ", " + req.getVersionConstraint());
        }
        if (req.getSelectedSupplier() != null) {
            if (!cycle.contains(req.getBundle())) {
                cycle.add(req.getBundle());
                if (DEBUG_CYCLES) {
                    ResolverImpl.log("require-bundle cycle: " + req.getBundle() + " -> " + req.getSelectedSupplier());
                }
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        Object[] bundles = this.resolverBundles.get(req.getVersionConstraint().getName());
        boolean result = false;
        int i = 0;
        while (i < bundles.length) {
            ResolverBundle bundle = (ResolverBundle)bundles[i];
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("CHECKING: " + bundle.getBundle());
            }
            if (req.isSatisfiedBy(bundle)) {
                bundle.addRef(req.getBundle());
                req.addPossibleSupplier(bundle);
                if (req.getBundle() != bundle && bundle.getState() != 2 && !this.resolveBundle(bundle, cycle) && !this.developmentMode) {
                    req.removePossibleSupplier(bundle);
                } else {
                    if (req.getBundle() != bundle && bundle.getState() == 1 && !cycle.contains(req.getBundle())) {
                        cycle.add(req.getBundle());
                        if (DEBUG_CYCLES) {
                            ResolverImpl.log("require-bundle cycle: " + req.getBundle() + " -> " + req.getSelectedSupplier());
                        }
                    }
                    if (DEBUG_REQUIRES) {
                        ResolverImpl.log("Found match: " + bundle.getBundle() + ". Wiring");
                    }
                    result = true;
                }
            }
            ++i;
        }
        return result || req.isOptional();
    }

    private boolean resolveImport(ResolverImport imp, ArrayList cycle) {
        if (DEBUG_IMPORTS) {
            ResolverImpl.log("Trying to resolve: " + imp.getBundle() + ", " + imp.getName());
        }
        if (imp.getSelectedSupplier() != null) {
            if (!cycle.contains(imp.getBundle())) {
                cycle.add(imp.getBundle());
                if (DEBUG_CYCLES) {
                    ResolverImpl.log("import-package cycle: " + imp.getBundle() + " -> " + imp.getSelectedSupplier() + " from " + imp.getSelectedSupplier().getBundle());
                }
            }
            if (DEBUG_IMPORTS) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        boolean result = false;
        ResolverExport[] substitutableExps = imp.getBundle().getExports(imp.getName());
        Object[] exports = this.resolverExports.get(imp.getName());
        int i = 0;
        while (i < exports.length) {
            block21: {
                ResolverExport export;
                block23: {
                    block22: {
                        export = (ResolverExport)exports[i];
                        if (DEBUG_IMPORTS) {
                            ResolverImpl.log("CHECKING: " + export.getExporter().getBundle() + ", " + export.getName());
                        }
                        if (!imp.isSatisfiedBy(export)) break block21;
                        int originalState = export.getExporter().getState();
                        if (imp.isDynamic() && originalState != 2) break block21;
                        if (imp.getSelectedSupplier() != null && ((ResolverExport)imp.getSelectedSupplier()).getExporter() == imp.getBundle()) break;
                        export.getExporter().addRef(imp.getBundle());
                        imp.addPossibleSupplier(export);
                        if (imp.getBundle() == export.getExporter()) break block22;
                        int j = 0;
                        while (j < substitutableExps.length) {
                            if (substitutableExps[j].getSubstitute() == null) {
                                substitutableExps[j].setSubstitute(export);
                            }
                            ++j;
                        }
                        if ((originalState == 2 || this.resolveBundle(export.getExporter(), cycle) || this.developmentMode) && export.getSubstitute() == null) break block23;
                        imp.removePossibleSupplier(export);
                        if (imp.getSelectedSupplier() == null) {
                            j = 0;
                            while (j < substitutableExps.length) {
                                if (substitutableExps[j].getSubstitute() == export) {
                                    substitutableExps[j].setSubstitute(null);
                                }
                                ++j;
                            }
                        }
                        break block21;
                    }
                    if (export.getSubstitute() != null) break block21;
                }
                if (imp.getBundle() != export.getExporter() && export.getExporter().getState() == 1 && !cycle.contains(imp.getBundle())) {
                    cycle.add(imp.getBundle());
                    if (DEBUG_CYCLES) {
                        ResolverImpl.log("import-package cycle: " + imp.getBundle() + " -> " + imp.getSelectedSupplier() + " from " + imp.getSelectedSupplier().getBundle());
                    }
                }
                if (DEBUG_IMPORTS) {
                    ResolverImpl.log("Found match: " + export.getExporter() + ". Wiring " + imp.getBundle() + ":" + imp.getName());
                }
                result = true;
            }
            ++i;
        }
        if (result) {
            return true;
        }
        if (imp.isOptional()) {
            return true;
        }
        return substitutableExps.length > 0 && substitutableExps[0].getSubstitute() == null;
    }

    private void setBundleUnresolved(ResolverBundle bundle, boolean removed, boolean keepFragsAttached) {
        if (bundle.getState() == 0 && !this.developmentMode) {
            return;
        }
        if (removed || !keepFragsAttached) {
            this.resolverExports.remove(bundle.getExportPackages());
            this.resolverGenerics.remove(bundle.getGenericCapabilities());
            bundle.detachAllFragments();
            bundle.initialize(false);
            if (!removed) {
                this.resolverExports.put(bundle.getExportPackages());
                this.resolverGenerics.put(bundle.getGenericCapabilities());
            }
        }
        if (!(removed || this.developmentMode && this.unresolvedBundles.contains(bundle))) {
            this.unresolvedBundles.add(bundle);
        }
        bundle.setState(0);
    }

    private void setBundleResolved(ResolverBundle bundle) {
        if (bundle.getState() == 2) {
            return;
        }
        this.unresolvedBundles.remove(bundle);
        bundle.setState(2);
    }

    private void setBundleResolving(ResolverBundle bundle) {
        if (bundle.getState() == 1) {
            return;
        }
        this.unresolvedBundles.remove(bundle);
        bundle.setState(1);
    }

    private void stateResolveBundles(ResolverBundle[] resolvedBundles) {
        int i = 0;
        while (i < resolvedBundles.length) {
            if (!resolvedBundles[i].getBundle().isResolved()) {
                this.stateResolveBundle(resolvedBundles[i]);
            }
            ++i;
        }
    }

    private void stateResolveConstraints(ResolverBundle rb) {
        ResolverImport[] imports = rb.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            ResolverExport export = (ResolverExport)imports[i].getSelectedSupplier();
            ExportPackageDescription supplier = export == null ? null : export.getExportPackageDescription();
            this.state.resolveConstraint(imports[i].getVersionConstraint(), supplier);
            ++i;
        }
        BundleConstraint[] requires = rb.getRequires();
        int i2 = 0;
        while (i2 < requires.length) {
            ResolverBundle bundle = (ResolverBundle)requires[i2].getSelectedSupplier();
            BundleDescription supplier = bundle == null ? null : bundle.getBundle();
            this.state.resolveConstraint(requires[i2].getVersionConstraint(), supplier);
            ++i2;
        }
        GenericConstraint[] genericRequires = rb.getGenericRequires();
        int i3 = 0;
        while (i3 < genericRequires.length) {
            GenericCapability[] matchingCapabilities = genericRequires[i3].getMatchingCapabilities();
            if (matchingCapabilities == null) {
                this.state.resolveConstraint(genericRequires[i3].getVersionConstraint(), null);
            } else {
                int j = 0;
                while (j < matchingCapabilities.length) {
                    this.state.resolveConstraint(genericRequires[i3].getVersionConstraint(), matchingCapabilities[j].getBaseDescription());
                    ++j;
                }
            }
            ++i3;
        }
    }

    private void stateResolveFragConstraints(ResolverBundle rb) {
        ResolverBundle host = (ResolverBundle)rb.getHost().getSelectedSupplier();
        ImportPackageSpecification[] imports = rb.getBundle().getImportPackages();
        int i = 0;
        while (i < imports.length) {
            ResolverImport hostImport = host == null ? null : host.getImport(imports[i].getName());
            ResolverExport export = (ResolverExport)(hostImport == null ? null : hostImport.getSelectedSupplier());
            ExportPackageDescription supplier = export == null ? null : export.getExportPackageDescription();
            this.state.resolveConstraint(imports[i], supplier);
            ++i;
        }
        BundleSpecification[] requires = rb.getBundle().getRequiredBundles();
        int i2 = 0;
        while (i2 < requires.length) {
            BundleConstraint hostRequire = host == null ? null : host.getRequire(requires[i2].getName());
            ResolverBundle bundle = (ResolverBundle)(hostRequire == null ? null : hostRequire.getSelectedSupplier());
            BundleDescription supplier = bundle == null ? null : bundle.getBundle();
            this.state.resolveConstraint(requires[i2], supplier);
            ++i2;
        }
    }

    private void stateResolveBundle(ResolverBundle rb) {
        VersionSupplier[] matchingBundles;
        if (!rb.isResolved() && !this.developmentMode) {
            return;
        }
        if (rb.isFragment()) {
            this.stateResolveFragConstraints(rb);
        } else {
            this.stateResolveConstraints(rb);
        }
        ResolverExport[] exports = rb.getSelectedExports();
        ArrayList<ExportPackageDescription> selectedExports = new ArrayList<ExportPackageDescription>(exports.length);
        int i = 0;
        while (i < exports.length) {
            if (this.permissionChecker.checkPackagePermission(exports[i].getExportPackageDescription())) {
                selectedExports.add(exports[i].getExportPackageDescription());
            }
            ++i;
        }
        ExportPackageDescription[] selectedExportsArray = selectedExports.toArray(new ExportPackageDescription[selectedExports.size()]);
        ResolverExport[] substituted = rb.getSubstitutedExports();
        ArrayList<ExportPackageDescription> substitutedExports = new ArrayList<ExportPackageDescription>(substituted.length);
        int i2 = 0;
        while (i2 < substituted.length) {
            substitutedExports.add(substituted[i2].getExportPackageDescription());
            ++i2;
        }
        ExportPackageDescription[] substitutedExportsArray = substitutedExports.toArray(new ExportPackageDescription[substitutedExports.size()]);
        ExportPackageDescription[] exportsWiredToArray = ResolverImpl.getExportsWiredTo(rb);
        BundleConstraint[] requires = rb.getRequires();
        ArrayList<BaseDescription> bundlesWiredTo = new ArrayList<BaseDescription>(requires.length);
        int i3 = 0;
        while (i3 < requires.length) {
            if (requires[i3].getSelectedSupplier() != null) {
                bundlesWiredTo.add(requires[i3].getSelectedSupplier().getBaseDescription());
            }
            ++i3;
        }
        BundleDescription[] bundlesWiredToArray = bundlesWiredTo.toArray(new BundleDescription[bundlesWiredTo.size()]);
        BundleDescription[] hostBundles = null;
        if (rb.isFragment() && (matchingBundles = rb.getHost().getPossibleSuppliers()) != null && matchingBundles.length > 0) {
            hostBundles = new BundleDescription[matchingBundles.length];
            int i4 = 0;
            while (i4 < matchingBundles.length) {
                hostBundles[i4] = matchingBundles[i4].getBundle();
                if (rb.isNewFragmentExports() && hostBundles[i4].isResolved()) {
                    ResolverExport[] hostExports = ((ResolverBundle)matchingBundles[i4]).getSelectedExports();
                    ExportPackageDescription[] hostExportsArray = new ExportPackageDescription[hostExports.length];
                    int j = 0;
                    while (j < hostExports.length) {
                        hostExportsArray[j] = hostExports[j].getExportPackageDescription();
                        ++j;
                    }
                    this.state.resolveBundle(hostBundles[i4], true, null, hostExportsArray, hostBundles[i4].getSubstitutedExports(), hostBundles[i4].getResolvedRequires(), hostBundles[i4].getResolvedImports());
                }
                ++i4;
            }
        }
        this.state.resolveBundle(rb.getBundle(), rb.isResolved(), hostBundles, selectedExportsArray, substitutedExportsArray, bundlesWiredToArray, exportsWiredToArray);
    }

    private static ExportPackageDescription[] getExportsWiredTo(ResolverBundle rb) {
        ResolverImport[] imports = rb.getImportPackages();
        ArrayList<BaseDescription> exportsWiredTo = new ArrayList<BaseDescription>(imports.length);
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getSelectedSupplier() != null) {
                exportsWiredTo.add(imports[i].getSelectedSupplier().getBaseDescription());
            }
            ++i;
        }
        return exportsWiredTo.toArray(new ExportPackageDescription[exportsWiredTo.size()]);
    }

    public synchronized ExportPackageDescription resolveDynamicImport(BundleDescription importingBundle, String requestedPackage) {
        ResolverBundle rb;
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        if ((rb = (ResolverBundle)this.bundleMapping.get(importingBundle)).getExport(requestedPackage) != null) {
            return null;
        }
        ResolverImport[] resolverImports = rb.getImportPackages();
        boolean found = false;
        int j = 0;
        while (j < resolverImports.length) {
            if (resolverImports[j].isDynamic()) {
                String importName = resolverImports[j].getName();
                if (importName.equals("*") || importName.endsWith(".*") && requestedPackage.startsWith(importName.substring(0, importName.length() - 1))) {
                    resolverImports[j].setName(requestedPackage);
                }
                if (requestedPackage.equals(resolverImports[j].getName())) {
                    found = true;
                    this.groupingChecker.populateRoots(resolverImports[j].getBundle());
                    if (this.resolveImport(resolverImports[j], new ArrayList())) {
                        found = false;
                        while (!found && resolverImports[j].getSelectedSupplier() != null) {
                            if (this.groupingChecker.isDynamicConsistent(resolverImports[j].getBundle(), (ResolverExport)resolverImports[j].getSelectedSupplier()) != null) {
                                resolverImports[j].selectNextSupplier();
                                continue;
                            }
                            found = true;
                        }
                        resolverImports[j].setName(null);
                        if (!found) {
                            resolverImports[j].clearPossibleSuppliers();
                            return null;
                        }
                        if (DEBUG_IMPORTS) {
                            ResolverImpl.log("Resolved dynamic import: " + rb + ":" + resolverImports[j].getName() + " -> " + ((ResolverExport)resolverImports[j].getSelectedSupplier()).getExporter() + ":" + requestedPackage);
                        }
                        ExportPackageDescription matchingExport = ((ResolverExport)resolverImports[j].getSelectedSupplier()).getExportPackageDescription();
                        if (importName.endsWith("*")) {
                            resolverImports[j].clearPossibleSuppliers();
                        }
                        return matchingExport;
                    }
                }
                resolverImports[j].setName(null);
            }
            ++j;
        }
        if (!found) {
            HashMap<String, String> directives = new HashMap<String, String>(1);
            directives.put("resolution", "dynamic");
            ImportPackageSpecification packageSpec = this.state.getFactory().createImportPackageSpecification(requestedPackage, null, null, null, directives, null, importingBundle);
            ResolverImport newImport = new ResolverImport(rb, packageSpec);
            if (this.resolveImport(newImport, new ArrayList())) {
                while (newImport.getSelectedSupplier() != null) {
                    if (this.groupingChecker.isDynamicConsistent(rb, (ResolverExport)newImport.getSelectedSupplier()) == null) break;
                    newImport.selectNextSupplier();
                }
                return ((ResolverExport)newImport.getSelectedSupplier()).getExportPackageDescription();
            }
        }
        if (DEBUG || DEBUG_IMPORTS) {
            ResolverImpl.log("Failed to resolve dynamic import: " + requestedPackage);
        }
        return null;
    }

    public void bundleAdded(BundleDescription bundle) {
        if (!this.initialized) {
            return;
        }
        if (this.bundleMapping.get(bundle) != null) {
            return;
        }
        ResolverBundle rb = new ResolverBundle(bundle, this);
        this.bundleMapping.put(bundle, rb);
        this.unresolvedBundles.add(rb);
        this.resolverExports.put(rb.getExportPackages());
        this.resolverBundles.put(rb.getName(), rb);
        this.resolverGenerics.put(rb.getGenericCapabilities());
    }

    public void bundleRemoved(BundleDescription bundle, boolean pending) {
        ResolverBundle rb;
        ResolverBundle resolverBundle = rb = this.initialized ? (ResolverBundle)this.bundleMapping.get(bundle) : null;
        if (rb != null) {
            rb.setUninstalled();
        }
        this.internalBundleRemoved(bundle, pending);
    }

    private void internalBundleRemoved(BundleDescription bundle, boolean pending) {
        if (pending) {
            this.removalPending.put(new Long(bundle.getBundleId()), bundle);
        }
        if (!this.initialized) {
            return;
        }
        ResolverBundle rb = (ResolverBundle)this.bundleMapping.get(bundle);
        if (rb == null) {
            return;
        }
        if (!pending) {
            this.bundleMapping.remove(bundle);
            this.groupingChecker.clear(rb);
        }
        if (!pending || !bundle.isResolved()) {
            this.resolverExports.remove(rb.getExportPackages());
            this.resolverBundles.remove(rb);
            this.resolverGenerics.remove(rb.getGenericCapabilities());
        }
        this.unresolvedBundles.remove(rb);
    }

    private void unresolveBundle(ResolverBundle bundle, boolean removed) {
        CompositeResolveHelper helper;
        if (bundle == null) {
            return;
        }
        Object[] removedBundles = this.removalPending.remove(new Long(bundle.getBundle().getBundleId()));
        int i = 0;
        while (i < removedBundles.length) {
            ResolverBundle re = (ResolverBundle)this.bundleMapping.get(removedBundles[i]);
            this.unresolveBundle(re, true);
            this.state.removeBundleComplete((BundleDescription)removedBundles[i]);
            this.resolverExports.remove(re.getExportPackages());
            this.resolverBundles.remove(re);
            this.resolverGenerics.remove(re.getGenericCapabilities());
            this.bundleMapping.remove(removedBundles[i]);
            this.groupingChecker.clear(re);
            if (removedBundles[i] == bundle.getBundle()) {
                removed = true;
            }
            ++i;
        }
        if (!bundle.getBundle().isResolved() && !this.developmentMode) {
            return;
        }
        CompositeResolveHelperRegistry currentLinks = this.compositeHelpers;
        if (currentLinks != null && (helper = currentLinks.getCompositeResolveHelper(bundle.getBundle())) != null) {
            helper.giveExports(null);
        }
        this.setBundleUnresolved(bundle, removed, false);
        BundleDescription[] dependents = bundle.getBundle().getDependents();
        this.state.resolveBundle(bundle.getBundle(), false, null, null, null, null, null);
        int i2 = 0;
        while (i2 < dependents.length) {
            this.unresolveBundle((ResolverBundle)this.bundleMapping.get(dependents[i2]), false);
            ++i2;
        }
    }

    public void bundleUpdated(BundleDescription newDescription, BundleDescription existingDescription, boolean pending) {
        this.internalBundleRemoved(existingDescription, pending);
        this.bundleAdded(newDescription);
    }

    public void flush() {
        this.resolverExports = null;
        this.resolverBundles = null;
        this.resolverGenerics = null;
        this.unresolvedBundles = null;
        this.bundleMapping = null;
        Object[] removed = this.removalPending.getAllValues();
        int i = 0;
        while (i < removed.length) {
            this.state.removeBundleComplete((BundleDescription)removed[i]);
            ++i;
        }
        this.removalPending.clear();
        this.initialized = false;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State newState) {
        if (this.state != null) {
            throw new IllegalStateException("Cannot change the State of a Resolver");
        }
        this.state = newState;
        this.flush();
    }

    private void setDebugOptions() {
        FrameworkDebugOptions options = FrameworkDebugOptions.getDefault();
        if (options == null) {
            return;
        }
        DEBUG = options.getBooleanOption(OPTION_DEBUG, false);
        DEBUG_WIRING = options.getBooleanOption(OPTION_WIRING, false);
        DEBUG_IMPORTS = options.getBooleanOption(OPTION_IMPORTS, false);
        DEBUG_REQUIRES = options.getBooleanOption(OPTION_REQUIRES, false);
        DEBUG_GENERICS = options.getBooleanOption(OPTION_GENERICS, false);
        DEBUG_USES = options.getBooleanOption(OPTION_USES, false);
        DEBUG_CYCLES = options.getBooleanOption(OPTION_CYCLES, false);
    }

    private void printWirings() {
        ResolverImpl.log("****** Result Wirings ******");
        Object[] bundles = this.resolverBundles.getAllValues();
        int j = 0;
        while (j < bundles.length) {
            ResolverBundle rb = (ResolverBundle)bundles[j];
            if (!rb.getBundle().isResolved()) {
                ResolverImport[] imports;
                int i;
                VersionSupplier[] hosts;
                ResolverImpl.log("    * WIRING for " + rb);
                BundleConstraint[] requireBundles = rb.getRequires();
                if (requireBundles.length == 0) {
                    ResolverImpl.log("        (r) no requires");
                } else {
                    int i2 = 0;
                    while (i2 < requireBundles.length) {
                        if (requireBundles[i2].getSelectedSupplier() == null) {
                            ResolverImpl.log("        (r) " + rb.getBundle() + " -> NULL!!!");
                        } else {
                            ResolverImpl.log("        (r) " + rb.getBundle() + " -> " + requireBundles[i2].getSelectedSupplier());
                        }
                        ++i2;
                    }
                }
                BundleConstraint hostSpec = rb.getHost();
                if (hostSpec != null && (hosts = hostSpec.getPossibleSuppliers()) != null) {
                    i = 0;
                    while (i < hosts.length) {
                        ResolverImpl.log("        (h) " + rb.getBundle() + " -> " + hosts[i].getBundle());
                        ++i;
                    }
                }
                if ((imports = rb.getImportPackages()).length == 0) {
                    ResolverImpl.log("        (w) no imports");
                } else {
                    i = 0;
                    while (i < imports.length) {
                        if (imports[i].isDynamic() && imports[i].getSelectedSupplier() == null) {
                            ResolverImpl.log("        (w) " + imports[i].getBundle() + ":" + imports[i].getName() + " -> DYNAMIC");
                        } else if (imports[i].isOptional() && imports[i].getSelectedSupplier() == null) {
                            ResolverImpl.log("        (w) " + imports[i].getBundle() + ":" + imports[i].getName() + " -> OPTIONAL (could not be wired)");
                        } else if (imports[i].getSelectedSupplier() == null) {
                            ResolverImpl.log("        (w) " + imports[i].getBundle() + ":" + imports[i].getName() + " -> NULL!!!");
                        } else {
                            ResolverImpl.log("        (w) " + imports[i].getBundle() + ":" + imports[i].getName() + " -> " + ((ResolverExport)imports[i].getSelectedSupplier()).getExporter() + ":" + imports[i].getSelectedSupplier().getName());
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
    }

    static void log(String message) {
        Debug.println(message);
    }

    VersionHashMap getResolverExports() {
        return this.resolverExports;
    }

    public void setSelectionPolicy(Comparator selectionPolicy) {
        this.selectionPolicy = selectionPolicy;
    }

    public Comparator getSelectionPolicy() {
        return this.selectionPolicy;
    }

    public void setCompositeResolveHelperRegistry(CompositeResolveHelperRegistry compositeHelpers) {
        this.compositeHelpers = compositeHelpers;
    }

    CompositeResolveHelperRegistry getCompositeHelpers() {
        return this.compositeHelpers;
    }
}

