/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.Reader;
import java.io.StringReader;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class GroovyScanner {
    private TokenStream stream;
    private GroovyLexer lexer;
    private boolean whiteSpaceIncluded;

    public GroovyScanner(Reader input) {
        this(input, false);
    }

    public GroovyScanner(Reader input, boolean whiteSpaceIncluded) {
        this.init(input, whiteSpaceIncluded);
    }

    private void init(Reader input, boolean whiteSpaceIncluded) {
        this.whiteSpaceIncluded = whiteSpaceIncluded;
        this.lexer = new GroovyLexer(input);
        this.lexer.setWhitespaceIncluded(whiteSpaceIncluded);
        this.stream = this.lexer.plumb();
    }

    public GroovyScanner(String text) {
        this(new StringReader(text), false);
    }

    public Token nextToken() throws TokenStreamException {
        return this.stream.nextToken();
    }

    public void recover(IDocument document) throws BadLocationException {
        int line = this.lexer.getInputState().getLine();
        int col = this.lexer.getInputState().getColumn();
        int offset = GroovyScanner.getOffset(document, line, col) + 1;
        line = document.getLineOfOffset(offset);
        int lineStart = document.getLineOffset(line);
        col = offset - lineStart + 1;
        String remainingInput = document.get(offset, document.getLength() - offset);
        this.init(new StringReader(remainingInput), this.whiteSpaceIncluded);
        this.lexer.setLine(++line);
        this.lexer.setColumn(col);
    }

    public static int getOffset(IDocument document, int line, int col) throws BadLocationException {
        return document.getLineOffset(line - 1) + col - 1;
    }
}

