/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;

public class GenericsType
extends ASTNode {
    protected ClassNode[] upperBounds;
    protected ClassNode lowerBound;
    protected ClassNode type;
    protected String name;
    protected boolean placeholder;
    private boolean resolved;
    private boolean wildcard;

    public GenericsType(ClassNode type, ClassNode[] upperBounds, ClassNode lowerBound) {
        this.type = type;
        this.name = type.isGenericsPlaceHolder() ? type.getUnresolvedName() : type.getName();
        this.upperBounds = upperBounds;
        this.lowerBound = lowerBound;
        this.placeholder = type.isGenericsPlaceHolder();
        this.resolved = false;
    }

    public GenericsType() {
    }

    public String toDetailsString() {
        StringBuilder s = new StringBuilder();
        s.append("GenericsType[name=").append(this.name).append(",placeholder=").append(this.placeholder);
        s.append(",resolved=").append(this.resolved).append(",wildcard=").append(this.wildcard);
        s.append(",type=").append(this.type);
        if (this.lowerBound != null) {
            s.append(",lowerBound=").append(this.lowerBound);
        }
        if (this.upperBounds != null) {
            s.append(",upperBounds=[");
            int i = 0;
            while (i < this.upperBounds.length) {
                if (i > 0) {
                    s.append(",");
                }
                s.append(this.upperBounds[i]);
                ++i;
            }
        }
        s.append("]]");
        s.append(this.getClass().getName());
        return s.toString();
    }

    public GenericsType(ClassNode basicType) {
        this(basicType, null, null);
    }

    public ClassNode getType() {
        return this.type;
    }

    public void setType(ClassNode type) {
        this.type = type;
    }

    public String toString() {
        String ret;
        String string = ret = this.type == null || this.placeholder || this.wildcard ? this.name : this.genericsBounds(this.type);
        if (this.upperBounds != null) {
            ret = String.valueOf(ret) + " extends ";
            int i = 0;
            while (i < this.upperBounds.length) {
                ret = String.valueOf(ret) + this.genericsBounds(this.upperBounds[i]);
                if (i + 1 < this.upperBounds.length) {
                    ret = String.valueOf(ret) + " & ";
                }
                ++i;
            }
        } else if (this.lowerBound != null) {
            ret = String.valueOf(ret) + " super " + this.genericsBounds(this.lowerBound);
        }
        return ret;
    }

    private String genericsBounds(ClassNode theType) {
        String ret = theType.getName();
        GenericsType[] genericsTypes = theType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length == 0) {
            return ret;
        }
        ret = String.valueOf(ret) + "<";
        int i = 0;
        while (i < genericsTypes.length) {
            if (i != 0) {
                ret = String.valueOf(ret) + ", ";
            }
            ret = String.valueOf(ret) + genericsTypes[i].toString();
            ++i;
        }
        ret = String.valueOf(ret) + ">";
        return ret;
    }

    public ClassNode[] getUpperBounds() {
        return this.upperBounds;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
        this.type.setGenericsPlaceHolder(placeholder);
    }

    public boolean isResolved() {
        return this.resolved || this.placeholder;
    }

    public void setResolved(boolean res) {
        this.resolved = res;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }

    public ClassNode getLowerBound() {
        return this.lowerBound;
    }

    public void setUpperBounds(ClassNode[] bounds) {
        this.upperBounds = bounds;
    }

    public void setLowerBound(ClassNode bound) {
        this.lowerBound = bound;
    }
}

