/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.jdt.groovy.internal.compiler.ast.AbortResolutionException;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyEclipseBug;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class JDTResolver
extends ResolveVisitor {
    private static final int BOOLEAN_LENGTH = "boolean".length();
    private static final boolean debug = false;
    private static Map<String, ClassNode> commonTypes = new HashMap<String, ClassNode>();
    public static boolean recordInstances = false;
    public static List<JDTResolver> instances = null;
    private Stack<GenericsType[]> memberGenericsCurrentlyActive = new Stack();
    private Stack<GenericsType[]> typeGenericsCurrentlyActive = new Stack();
    private Map<TypeBinding, JDTClassNode> inProgress = new HashMap<TypeBinding, JDTClassNode>();
    private Stack<JDTClassNode> inProgressStack = new Stack();
    private GroovyCompilationUnitScope activeScope = null;
    private Map<ClassNode, GroovyTypeDeclaration> scopes = new HashMap<ClassNode, GroovyTypeDeclaration>();
    private List<ClassNode> haveBeenResolved = new ArrayList<ClassNode>();
    private Map<Binding, JDTClassNode> nodeCache = Collections.synchronizedMap(new HashMap());
    private Set<String> unresolvables = new HashSet<String>();

    static {
        commonTypes.put("java.lang.Object", ClassHelper.OBJECT_TYPE);
        commonTypes.put("java.lang.String", ClassHelper.STRING_TYPE);
        commonTypes.put("java.lang.Class", ClassHelper.CLASS_Type);
        commonTypes.put("java.lang.Boolean", ClassHelper.Boolean_TYPE);
        commonTypes.put("java.lang.Byte", ClassHelper.Byte_TYPE);
        commonTypes.put("java.lang.Character", ClassHelper.Character_TYPE);
        commonTypes.put("java.lang.Double", ClassHelper.Double_TYPE);
        commonTypes.put("java.lang.Float", ClassHelper.Float_TYPE);
        commonTypes.put("java.lang.Integer", ClassHelper.Integer_TYPE);
        commonTypes.put("java.lang.Long", ClassHelper.Long_TYPE);
        commonTypes.put("java.lang.Short", ClassHelper.Short_TYPE);
        commonTypes.put("boolean", ClassHelper.boolean_TYPE);
        commonTypes.put("byte", ClassHelper.byte_TYPE);
        commonTypes.put("char", ClassHelper.char_TYPE);
        commonTypes.put("double", ClassHelper.double_TYPE);
        commonTypes.put("float", ClassHelper.float_TYPE);
        commonTypes.put("int", ClassHelper.int_TYPE);
        commonTypes.put("long", ClassHelper.long_TYPE);
        commonTypes.put("short", ClassHelper.short_TYPE);
    }

    void pushMemberGenerics(GenericsType[] generics) {
        this.memberGenericsCurrentlyActive.push(generics);
    }

    void popMemberGenerics() {
        this.memberGenericsCurrentlyActive.pop();
    }

    public void pushTypeGenerics(GenericsType[] genericsTypes) {
        this.typeGenericsCurrentlyActive.push(genericsTypes);
    }

    public void popTypeGenerics() {
        this.typeGenericsCurrentlyActive.pop();
    }

    public JDTResolver(CompilationUnit groovyCompilationUnit) {
        super(groovyCompilationUnit);
        if (recordInstances) {
            if (instances == null) {
                instances = new ArrayList<JDTResolver>();
            }
            instances.add(this);
        }
    }

    public JDTClassNode getCachedNode(String name) {
        for (Map.Entry<Binding, JDTClassNode> nodeFromCache : this.nodeCache.entrySet()) {
            String nodename = new String(nodeFromCache.getKey().readableName());
            if (!nodename.equals(name)) continue;
            return nodeFromCache.getValue();
        }
        return null;
    }

    protected boolean resolveFromModule(ClassNode type, boolean testModuleImports) {
        boolean foundit = super.resolveFromModule(type, testModuleImports);
        this.recordDependency(type.getName());
        return foundit;
    }

    protected boolean resolveFromCompileUnit(ClassNode type) {
        boolean foundit = super.resolveFromCompileUnit(type);
        this.recordDependency(type.getName());
        if (foundit) {
            return true;
        }
        String typename = type.getName();
        ClassNode node = this.getScope().lookupClassNodeForSource(typename, this);
        if (node != null) {
            type.setRedirect(node);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean resolveFromDefaultImports(ClassNode type, boolean testDefaultImports) {
        boolean foundit = super.resolveFromDefaultImports(type, testDefaultImports);
        if (this.activeScope != null) {
            String extraImports;
            boolean b = testDefaultImports & !type.hasPackageName();
            if ((b &= !(type instanceof ResolveVisitor.LowerCaseClass)) && (extraImports = this.activeScope.compilerOptions().groovyExtraImports) != null) {
                try {
                    String filename = new String(this.activeScope.referenceContext.getFileName());
                    StringTokenizer st = new StringTokenizer(extraImports, ";");
                    while (st.hasMoreTokens()) {
                        String onesuffix = st.nextToken();
                        int equals = onesuffix.indexOf(61);
                        boolean shouldApply = false;
                        String imports = null;
                        if (equals == -1) {
                            shouldApply = true;
                            imports = onesuffix;
                        } else {
                            String suffix = onesuffix.substring(0, equals);
                            shouldApply = filename.endsWith(suffix);
                            imports = onesuffix.substring(equals + 1);
                        }
                        StringTokenizer st2 = new StringTokenizer(imports, ",");
                        while (st2.hasMoreTokens()) {
                            int lastdot;
                            String importTypeNameChopped;
                            ResolveVisitor.ConstructedClassWithPackage tmp;
                            String nextElement = st2.nextToken();
                            if (nextElement.endsWith(".*")) {
                                String withoutStar = nextElement.substring(0, nextElement.length() - 1);
                                ResolveVisitor.ConstructedClassWithPackage tmp2 = new ResolveVisitor.ConstructedClassWithPackage(withoutStar, type.getName());
                                if (!this.resolve(tmp2, false, false, false)) continue;
                                type.setRedirect(tmp2.redirect());
                                return true;
                            }
                            String importedTypeName = nextElement;
                            if (!importedTypeName.endsWith(type.getName()) || !this.resolve(tmp = new ResolveVisitor.ConstructedClassWithPackage(importTypeNameChopped = importedTypeName.substring(0, (lastdot = importedTypeName.lastIndexOf(46)) + 1), type.getName()), false, false, false)) continue;
                            type.setRedirect(tmp.redirect());
                            return true;
                        }
                    }
                }
                catch (Exception e) {
                    new RuntimeException("Problem processing extraImports: " + extraImports, e).printStackTrace();
                }
            }
        }
        this.recordDependency(type.getName());
        return foundit;
    }

    protected boolean resolveFromStaticInnerClasses(ClassNode type, boolean testStaticInnerClasses) {
        boolean foundit = super.resolveFromStaticInnerClasses(type, testStaticInnerClasses);
        this.recordDependency(type.getName());
        return foundit;
    }

    protected boolean resolveFromClassCache(ClassNode type) {
        return false;
    }

    protected boolean resolveToClass(ClassNode type) {
        String typename = type.getName();
        ClassNode node = this.getScope().lookupClassNodeForBinary(typename, this);
        if (node != null) {
            type.setRedirect(node);
            return true;
        }
        GroovyClassLoader loader = this.compilationUnit.getClassLoader();
        if (loader instanceof GroovyParser.GrapeAwareGroovyClassLoader) {
            GroovyParser.GrapeAwareGroovyClassLoader gagc = (GroovyParser.GrapeAwareGroovyClassLoader)loader;
            if (gagc.grabbed) {
                Class cls;
                try {
                    cls = loader.loadClass(type.getName(), false, true);
                }
                catch (ClassNotFoundException cnfe) {
                    return false;
                }
                catch (CompilationFailedException cfe) {
                    return false;
                }
                if (cls == null) {
                    return false;
                }
                node = ClassHelper.make(cls);
                type.setRedirect(node);
                return true;
            }
        }
        return false;
    }

    protected boolean resolveToScript(ClassNode type) {
        return false;
    }

    protected boolean resolve(ClassNode type, boolean testModuleImports, boolean testDefaultImports, boolean testStaticInnerClasses) {
        ClassNode commonRedirect;
        String name = type.getName();
        if ((name.charAt(0) == 'j' || name.length() <= BOOLEAN_LENGTH) && (commonRedirect = commonTypes.get(type.getName())) != null) {
            type.setRedirect(commonRedirect);
            return true;
        }
        if (this.unresolvables.contains(name)) {
            return false;
        }
        boolean b = super.resolve(type, testModuleImports, testDefaultImports, testStaticInnerClasses);
        if (!b) {
            this.unresolvables.add(name);
        }
        return b;
    }

    public ClassNode resolve(String qualifiedName) {
        ClassNode type = ClassHelper.makeWithoutCaching(qualifiedName);
        if (super.resolve(type)) {
            return type.redirect();
        }
        return ClassHelper.DYNAMIC_TYPE;
    }

    private void recordDependency(String typename) {
        GroovyCompilationUnitScope gcuScope = this.getScope();
        if (typename.indexOf(".") != -1) {
            gcuScope.recordQualifiedReference(CharOperation.splitOn('.', typename.toCharArray()));
        } else {
            gcuScope.recordSimpleReference(typename.toCharArray());
        }
    }

    ClassNode convertToClassNode(TypeBinding jdtBinding) {
        if (this.inProgress.containsKey(jdtBinding)) {
            return this.inProgress.get(jdtBinding);
        }
        JDTClassNode existingNode = this.nodeCache.get(jdtBinding);
        if (existingNode != null) {
            return existingNode;
        }
        ClassNode jdtNode = this.createJDTClassNode(jdtBinding);
        return jdtNode;
    }

    private ClassNode createJDTClassNode(TypeBinding jdtBinding) {
        ClassNode classNode = this.createClassNode(jdtBinding);
        if (classNode instanceof JDTClassNode) {
            JDTClassNode jdtNode = (JDTClassNode)classNode;
            this.inProgress.put(jdtBinding, jdtNode);
            this.inProgressStack.push(jdtNode);
            jdtNode.setupGenerics();
            this.inProgressStack.pop();
            this.inProgress.remove(jdtBinding);
            this.nodeCache.put(jdtBinding, jdtNode);
        }
        return classNode;
    }

    private ClassNode createClassNode(TypeBinding jdtTypeBinding) {
        if (jdtTypeBinding instanceof WildcardBinding) {
            return this.createClassNodeForWildcardBinding((WildcardBinding)jdtTypeBinding);
        }
        if (jdtTypeBinding instanceof BaseTypeBinding) {
            return this.createClassNodeForPrimitiveBinding((BaseTypeBinding)jdtTypeBinding);
        }
        if (jdtTypeBinding instanceof ArrayBinding) {
            return this.createClassNodeForArrayBinding((ArrayBinding)jdtTypeBinding);
        }
        if (jdtTypeBinding instanceof TypeVariableBinding) {
            String typeVariableName = new String(jdtTypeBinding.sourceName());
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)jdtTypeBinding;
            if (typeVariableBinding.declaringElement instanceof SourceTypeBinding) {
                GenericsType[] genericTypes = this.typeGenericsCurrentlyActive.peek();
                GenericsType matchingGenericType = this.findMatchingGenericType(genericTypes, typeVariableName);
                if (matchingGenericType != null) {
                    ClassNode newNode = ClassHelper.makeWithoutCaching(typeVariableName);
                    newNode.setRedirect(matchingGenericType.getType());
                    newNode.setGenericsTypes(new GenericsType[]{matchingGenericType});
                    newNode.setGenericsPlaceHolder(true);
                    return newNode;
                }
                if (typeVariableBinding.firstBound == null) {
                    return ClassHelper.OBJECT_TYPE;
                }
                return this.convertToClassNode(typeVariableBinding.firstBound);
            }
            if (typeVariableBinding.declaringElement instanceof BinaryTypeBinding) {
                GenericsType[] genericTypes = this.convertToClassNode((BinaryTypeBinding)typeVariableBinding.declaringElement).getGenericsTypes();
                GenericsType matchingGenericType = this.findMatchingGenericType(genericTypes, typeVariableName);
                if (matchingGenericType != null) {
                    ClassNode newNode = ClassHelper.makeWithoutCaching(typeVariableName);
                    ClassNode[] upper = matchingGenericType.getUpperBounds();
                    if (upper != null && upper.length > 0) {
                        newNode.setRedirect(upper[0]);
                    } else {
                        newNode.setRedirect(matchingGenericType.getType());
                    }
                    newNode.setGenericsTypes(new GenericsType[]{matchingGenericType});
                    newNode.setGenericsPlaceHolder(true);
                    return newNode;
                }
                throw new GroovyEclipseBug("Cannot find type variable on type declaring element " + typeVariableBinding.declaringElement);
            }
            if (typeVariableBinding.declaringElement instanceof ParameterizedMethodBinding || typeVariableBinding.declaringElement instanceof MethodBinding) {
                GenericsType[] genericTypes = this.memberGenericsCurrentlyActive.peek();
                GenericsType matchingGenericType = this.findMatchingGenericType(genericTypes, typeVariableName);
                if (matchingGenericType != null) {
                    ClassNode newNode = ClassHelper.makeWithoutCaching(typeVariableName);
                    newNode.setRedirect(matchingGenericType.getType());
                    newNode.setGenericsTypes(new GenericsType[]{matchingGenericType});
                    newNode.setGenericsPlaceHolder(true);
                    return newNode;
                }
                throw new GroovyEclipseBug("Cannot find type variable on method declaring element " + typeVariableBinding.declaringElement);
            }
            throw new GroovyEclipseBug("Unexpected type variable reference.  Declaring element is " + typeVariableBinding.declaringElement);
        }
        if (jdtTypeBinding instanceof ReferenceBinding) {
            if (jdtTypeBinding.id == 1) {
                return ClassHelper.OBJECT_TYPE;
            }
            return new JDTClassNode((ReferenceBinding)jdtTypeBinding, this);
        }
        throw new GroovyEclipseBug("Unable to convert this binding: " + jdtTypeBinding.getClass());
    }

    private GenericsType findMatchingGenericType(GenericsType[] genericTypes, String typeVariableName) {
        if (genericTypes != null) {
            GenericsType[] genericsTypeArray = genericTypes;
            int n = genericTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericType = genericsTypeArray[n2];
                if (genericType.getName().equals(typeVariableName)) {
                    return genericType;
                }
                ++n2;
            }
        }
        return null;
    }

    ClassNode createClassNodeForArrayBinding(ArrayBinding arrayBinding) {
        int dims = arrayBinding.dimensions;
        ClassNode classNode = this.convertToClassNode(arrayBinding.leafComponentType);
        while (dims > 0) {
            classNode = new ClassNode(classNode);
            --dims;
        }
        return classNode;
    }

    ClassNode createClassNodeForPrimitiveBinding(BaseTypeBinding jdtBinding) {
        switch (jdtBinding.id) {
            case 5: {
                return ClassHelper.boolean_TYPE;
            }
            case 2: {
                return ClassHelper.char_TYPE;
            }
            case 3: {
                return ClassHelper.byte_TYPE;
            }
            case 4: {
                return ClassHelper.short_TYPE;
            }
            case 10: {
                return ClassHelper.int_TYPE;
            }
            case 7: {
                return ClassHelper.long_TYPE;
            }
            case 8: {
                return ClassHelper.double_TYPE;
            }
            case 9: {
                return ClassHelper.float_TYPE;
            }
            case 6: {
                return ClassHelper.VOID_TYPE;
            }
        }
        throw new GroovyEclipseBug("Don't know what this is: " + jdtBinding);
    }

    private ClassNode[] convertToClassNodes(TypeBinding[] typeBindings) {
        if (typeBindings.length == 0) {
            return null;
        }
        ClassNode[] nodes = new ClassNode[typeBindings.length];
        int i = 0;
        while (i < typeBindings.length) {
            nodes[i] = this.convertToClassNode(typeBindings[i]);
            ++i;
        }
        return nodes;
    }

    private ClassNode createClassNodeForWildcardBinding(WildcardBinding wildcardBinding) {
        ClassNode base = ClassHelper.makeWithoutCaching("?");
        ClassNode lowerBound = null;
        ClassNode[] allUppers = null;
        if (wildcardBinding.boundKind == 1) {
            ClassNode[] otherUppers;
            ClassNode firstUpper = this.convertToClassNode(wildcardBinding.bound);
            ClassNode[] classNodeArray = otherUppers = wildcardBinding.otherBounds == null ? null : this.convertToClassNodes(wildcardBinding.otherBounds);
            if (otherUppers == null) {
                allUppers = new ClassNode[]{firstUpper};
            } else {
                allUppers = new ClassNode[otherUppers.length + 1];
                System.arraycopy(otherUppers, 0, allUppers, 1, otherUppers.length);
                allUppers[0] = firstUpper;
            }
        } else if (wildcardBinding.boundKind == 2) {
            lowerBound = this.convertToClassNode(wildcardBinding.bound);
        } else {
            assert (wildcardBinding.boundKind == 0);
            return JDTClassNode.unboundWildcard;
        }
        GenericsType t = new GenericsType(base, allUppers, lowerBound);
        t.setWildcard(true);
        ClassNode ref = ClassHelper.makeWithoutCaching(Object.class, false);
        ref.setGenericsTypes(new GenericsType[]{t});
        return ref;
    }

    protected boolean commencingResolution() {
        GroovyTypeDeclaration gtDeclaration = this.scopes.get(this.currentClass);
        if (gtDeclaration == null) {
            if (this.haveBeenResolved.contains(this.currentClass)) {
                return false;
            }
            GroovyEclipseBug geb = new GroovyEclipseBug("commencingResolution failed: no declaration found for class " + this.currentClass);
            geb.printStackTrace();
            throw geb;
        }
        this.activeScope = null;
        if (gtDeclaration.scope == null) {
            if (gtDeclaration.hasErrors()) {
                return false;
            }
            GroovyEclipseBug geb = new GroovyEclipseBug("commencingResolution failed: declaration found, but unexpectedly found no scope for " + this.currentClass.getName());
            geb.printStackTrace();
            throw geb;
        }
        this.activeScope = (GroovyCompilationUnitScope)gtDeclaration.scope.compilationUnitScope();
        return true;
    }

    protected void finishedResolution() {
        this.scopes.remove(this.currentClass);
        this.haveBeenResolved.add(this.currentClass);
        this.unresolvables.clear();
    }

    private GroovyCompilationUnitScope getScope() {
        return this.activeScope;
    }

    private void log(String string) {
        System.err.println("Resolver: " + string);
    }

    public void record(GroovyTypeDeclaration gtDeclaration) {
        this.scopes.put(gtDeclaration.getClassNode(), gtDeclaration);
        if (gtDeclaration.memberTypes != null) {
            TypeDeclaration[] members = gtDeclaration.memberTypes;
            int m = 0;
            while (m < members.length) {
                this.record((GroovyTypeDeclaration)members[m]);
                ++m;
            }
        }
    }

    private void log(String string, ClassNode type, boolean foundit) {
        System.err.println("Resolver: " + string + " " + type.getName() + "  ?" + foundit);
    }

    public void startResolving(ClassNode node, SourceUnit source) {
        try {
            super.startResolving(node, source);
            this.unresolvables.clear();
        }
        catch (AbortResolutionException abortResolutionException) {
            // empty catch block
        }
    }
}

