/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsType
extends ASTNode {
    protected ClassNode[] upperBounds;
    protected ClassNode lowerBound;
    protected ClassNode type;
    protected String name;
    protected boolean placeholder;
    private boolean resolved;
    private boolean wildcard;

    public GenericsType(ClassNode type, ClassNode[] upperBounds, ClassNode lowerBound) {
        this.type = type;
        this.name = type.isGenericsPlaceHolder() ? type.getUnresolvedName() : type.getName();
        this.upperBounds = upperBounds;
        this.lowerBound = lowerBound;
        this.placeholder = type.isGenericsPlaceHolder();
        this.resolved = false;
    }

    public GenericsType() {
    }

    public String toDetailsString() {
        StringBuilder s = new StringBuilder();
        s.append("GenericsType[name=").append(this.name).append(",placeholder=").append(this.placeholder);
        s.append(",resolved=").append(this.resolved).append(",wildcard=").append(this.wildcard);
        s.append(",type=").append(this.type);
        if (this.lowerBound != null) {
            s.append(",lowerBound=").append(this.lowerBound);
        }
        if (this.upperBounds != null) {
            s.append(",upperBounds=[");
            int i = 0;
            while (i < this.upperBounds.length) {
                if (i > 0) {
                    s.append(",");
                }
                s.append(this.upperBounds[i]);
                ++i;
            }
        }
        s.append("]]");
        s.append(this.getClass().getName());
        return s.toString();
    }

    public GenericsType(ClassNode basicType) {
        this(basicType, null, null);
    }

    public ClassNode getType() {
        return this.type;
    }

    public void setType(ClassNode type) {
        this.type = type;
    }

    public String toString() {
        HashSet<String> visited = new HashSet<String>();
        return this.toString(visited);
    }

    private String toString(Set<String> visited) {
        String ret;
        if (this.placeholder) {
            visited.add(this.name);
        }
        String string = ret = this.type == null || this.placeholder || this.wildcard ? this.name : this.genericsBounds(this.type, visited);
        if (this.upperBounds != null) {
            ret = String.valueOf(ret) + " extends ";
            int i = 0;
            while (i < this.upperBounds.length) {
                ret = String.valueOf(ret) + this.genericsBounds(this.upperBounds[i], visited);
                if (i + 1 < this.upperBounds.length) {
                    ret = String.valueOf(ret) + " & ";
                }
                ++i;
            }
        } else if (this.lowerBound != null) {
            ret = String.valueOf(ret) + " super " + this.genericsBounds(this.lowerBound, visited);
        }
        return ret;
    }

    private String genericsBounds(ClassNode theType, Set<String> visited) {
        StringBuilder ret = new StringBuilder();
        if (theType.isArray()) {
            ret.append(theType.getComponentType().getName());
            ret.append("[]");
        } else if (theType.redirect() instanceof InnerClassNode) {
            InnerClassNode innerClassNode = (InnerClassNode)theType.redirect();
            String parentClassNodeName = innerClassNode.getOuterClass().getName();
            ret.append(this.genericsBounds(innerClassNode.getOuterClass(), new HashSet<String>()));
            ret.append(".");
            String typeName = theType.getName();
            ret.append(typeName.substring(parentClassNodeName.length() + 1));
        } else {
            ret.append(theType.getName());
        }
        GenericsType[] genericsTypes = theType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length == 0) {
            return ret.toString();
        }
        if (genericsTypes.length == 1 && genericsTypes[0].isPlaceholder() && theType.getName().equals("java.lang.Object")) {
            return genericsTypes[0].getName();
        }
        ret.append("<");
        int i = 0;
        while (i < genericsTypes.length) {
            GenericsType type;
            if (i != 0) {
                ret.append(", ");
            }
            if ((type = genericsTypes[i]).isPlaceholder() && visited.contains(type.getName())) {
                ret.append(type.getName());
            } else {
                ret.append(type.toString(visited));
            }
            ++i;
        }
        ret.append(">");
        return ret.toString();
    }

    public ClassNode[] getUpperBounds() {
        return this.upperBounds;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
        this.type.setGenericsPlaceHolder(placeholder);
    }

    public boolean isResolved() {
        return this.resolved || this.placeholder;
    }

    public void setResolved(boolean res) {
        this.resolved = res;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }

    public ClassNode getLowerBound() {
        return this.lowerBound;
    }

    public boolean isCompatibleWith(ClassNode classNode) {
        return new GenericsTypeMatcher().matches(classNode);
    }

    private static ClassNode getParameterizedSuperClass(ClassNode classNode) {
        if (ClassHelper.OBJECT_TYPE.equals(classNode)) {
            return null;
        }
        ClassNode superClass = classNode.getUnresolvedSuperClass();
        if (superClass == null) {
            return ClassHelper.OBJECT_TYPE;
        }
        if (!classNode.isUsingGenerics() || !superClass.isUsingGenerics()) {
            return superClass;
        }
        GenericsType[] genericsTypes = classNode.getGenericsTypes();
        GenericsType[] redirectGenericTypes = classNode.redirect().getGenericsTypes();
        superClass = superClass.getPlainNodeReference();
        if (genericsTypes == null || redirectGenericTypes == null || superClass.getGenericsTypes() == null) {
            return superClass;
        }
        int i = 0;
        int genericsTypesLength = genericsTypes.length;
        while (i < genericsTypesLength) {
            if (redirectGenericTypes[i].isPlaceholder()) {
                GenericsType genericsType = genericsTypes[i];
                GenericsType[] superGenericTypes = superClass.getGenericsTypes();
                int j = 0;
                int superGenericTypesLength = superGenericTypes.length;
                while (j < superGenericTypesLength) {
                    GenericsType superGenericType = superGenericTypes[j];
                    if (superGenericType.isPlaceholder() && superGenericType.getName().equals(redirectGenericTypes[i].getName())) {
                        superGenericTypes[j] = genericsType;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return superClass;
    }

    public void setUpperBounds(ClassNode[] bounds) {
        this.upperBounds = bounds;
    }

    public void setLowerBound(ClassNode bound) {
        this.lowerBound = bound;
    }

    private class GenericsTypeMatcher {
        private GenericsTypeMatcher() {
        }

        public boolean implementsInterfaceOrIsSubclassOf(ClassNode type, ClassNode superOrInterface) {
            boolean result;
            boolean bl = result = type.equals(superOrInterface) || type.isDerivedFrom(superOrInterface) || type.implementsInterface(superOrInterface);
            if (result) {
                return true;
            }
            if (superOrInterface instanceof WideningCategories.LowestUpperBoundClassNode) {
                WideningCategories.LowestUpperBoundClassNode cn = (WideningCategories.LowestUpperBoundClassNode)superOrInterface;
                result = this.implementsInterfaceOrIsSubclassOf(type, cn.getSuperClass());
                if (result) {
                    ClassNode[] classNodeArray = cn.getInterfaces();
                    int n = classNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ClassNode interfaceNode = classNodeArray[n2];
                        result = this.implementsInterfaceOrIsSubclassOf(type, interfaceNode);
                        if (!result) break;
                        ++n2;
                    }
                }
                if (result) {
                    return true;
                }
            }
            if (type.isArray() && superOrInterface.isArray()) {
                return this.implementsInterfaceOrIsSubclassOf(type.getComponentType(), superOrInterface.getComponentType());
            }
            return false;
        }

        public boolean matches(ClassNode classNode) {
            if (classNode.isGenericsPlaceHolder()) {
                GenericsType[] genericsTypes = classNode.getGenericsTypes();
                if (genericsTypes == null) {
                    return true;
                }
                if (GenericsType.this.isWildcard()) {
                    if (GenericsType.this.lowerBound != null) {
                        return genericsTypes[0].getName().equals(GenericsType.this.lowerBound.getUnresolvedName());
                    }
                    if (GenericsType.this.upperBounds != null) {
                        ClassNode[] classNodeArray = GenericsType.this.upperBounds;
                        int n = GenericsType.this.upperBounds.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ClassNode upperBound = classNodeArray[n2];
                            if (genericsTypes[0].getName().equals(upperBound.getUnresolvedName())) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }
                }
                return genericsTypes[0].getName().equals(GenericsType.this.name);
            }
            if (GenericsType.this.wildcard || GenericsType.this.placeholder) {
                if (GenericsType.this.upperBounds != null) {
                    boolean upIsOk = true;
                    int i = 0;
                    int upperBoundsLength = GenericsType.this.upperBounds.length;
                    while (i < upperBoundsLength && upIsOk) {
                        ClassNode upperBound = GenericsType.this.upperBounds[i];
                        upIsOk = this.implementsInterfaceOrIsSubclassOf(classNode, upperBound);
                        ++i;
                    }
                    upIsOk = upIsOk && this.checkGenerics(classNode);
                    return upIsOk;
                }
                if (GenericsType.this.lowerBound != null) {
                    return this.implementsInterfaceOrIsSubclassOf(GenericsType.this.lowerBound, classNode) && this.checkGenerics(classNode);
                }
            }
            if (GenericsType.this.type != null && !GenericsType.this.type.equals(classNode)) {
                return false;
            }
            return GenericsType.this.type == null || this.compareGenericsWithBound(classNode, GenericsType.this.type);
        }

        private boolean checkGenerics(ClassNode classNode) {
            if (GenericsType.this.upperBounds != null) {
                ClassNode[] classNodeArray = GenericsType.this.upperBounds;
                int n = GenericsType.this.upperBounds.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode upperBound = classNodeArray[n2];
                    if (!this.compareGenericsWithBound(classNode, upperBound)) {
                        return false;
                    }
                    ++n2;
                }
            }
            return GenericsType.this.lowerBound == null || GenericsType.this.lowerBound.redirect().isUsingGenerics() || this.compareGenericsWithBound(classNode, GenericsType.this.lowerBound);
        }

        private boolean compareGenericsWithBound(ClassNode classNode, ClassNode bound) {
            if (classNode == null) {
                return false;
            }
            if (!bound.isUsingGenerics()) {
                return true;
            }
            if (!classNode.equals(bound)) {
                if (bound.isInterface()) {
                    Set<ClassNode> interfaces = classNode.getAllInterfaces();
                    for (ClassNode anInterface : interfaces) {
                        if (!anInterface.equals(bound)) continue;
                        ClassNode node = GenericsUtils.parameterizeType(classNode, anInterface);
                        return this.compareGenericsWithBound(node, bound);
                    }
                }
                if (bound instanceof WideningCategories.LowestUpperBoundClassNode) {
                    boolean success = this.compareGenericsWithBound(classNode, bound.getSuperClass());
                    if (success) {
                        ClassNode[] interfaces;
                        ClassNode[] classNodeArray = interfaces = bound.getInterfaces();
                        int n = interfaces.length;
                        int node = 0;
                        while (node < n) {
                            ClassNode anInterface = classNodeArray[node];
                            success &= this.compareGenericsWithBound(classNode, anInterface);
                            ++node;
                        }
                    }
                    if (success) {
                        return true;
                    }
                }
                return this.compareGenericsWithBound(GenericsType.getParameterizedSuperClass(classNode), bound);
            }
            GenericsType[] cnTypes = classNode.getGenericsTypes();
            if (cnTypes == null && classNode.isRedirectNode()) {
                cnTypes = classNode.redirect().getGenericsTypes();
            }
            if (cnTypes == null) {
                return true;
            }
            GenericsType[] redirectBoundGenericTypes = bound.redirect().getGenericsTypes();
            Map<String, GenericsType> classNodePlaceholders = GenericsUtils.extractPlaceholders(classNode);
            Map<String, GenericsType> boundPlaceHolders = GenericsUtils.extractPlaceholders(bound);
            boolean match = true;
            int i = 0;
            while (redirectBoundGenericTypes != null && i < redirectBoundGenericTypes.length && match) {
                String name;
                GenericsType redirectBoundType = redirectBoundGenericTypes[i];
                GenericsType classNodeType = cnTypes[i];
                if (classNodeType.isPlaceholder()) {
                    if (redirectBoundType.isPlaceholder()) {
                        match = classNodeType.getName().equals(redirectBoundType.getName());
                    } else {
                        name = classNodeType.getName();
                        if (classNodePlaceholders.containsKey(name)) {
                            classNodeType = classNodePlaceholders.get(name);
                        }
                        match = classNodeType.isCompatibleWith(redirectBoundType.getType());
                    }
                } else if (redirectBoundType.isPlaceholder()) {
                    if (classNodeType.isPlaceholder()) {
                        match = classNodeType.getName().equals(redirectBoundType.getName());
                    } else {
                        name = redirectBoundType.getName();
                        if (boundPlaceHolders.containsKey(name)) {
                            redirectBoundType = boundPlaceHolders.get(name);
                            boolean wildcard = redirectBoundType.isWildcard();
                            boolean placeholder = redirectBoundType.isPlaceholder();
                            if (placeholder || wildcard) {
                                if (wildcard) {
                                    if (redirectBoundType.lowerBound != null) {
                                        GenericsType gt = new GenericsType(redirectBoundType.lowerBound);
                                        if (gt.isPlaceholder() && classNodePlaceholders.containsKey(gt.getName())) {
                                            gt = classNodePlaceholders.get(gt.getName());
                                        }
                                        match = this.implementsInterfaceOrIsSubclassOf(gt.getType(), classNodeType.getType());
                                    }
                                    if (match && redirectBoundType.upperBounds != null) {
                                        ClassNode[] classNodeArray = redirectBoundType.upperBounds;
                                        int n = redirectBoundType.upperBounds.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            ClassNode upperBound = classNodeArray[n2];
                                            GenericsType gt = new GenericsType(upperBound);
                                            if (gt.isPlaceholder() && classNodePlaceholders.containsKey(gt.getName())) {
                                                gt = classNodePlaceholders.get(gt.getName());
                                            }
                                            match = match && this.implementsInterfaceOrIsSubclassOf(classNodeType.getType(), gt.getType());
                                            ++n2;
                                        }
                                    }
                                    return match;
                                }
                                redirectBoundType = classNodePlaceholders.get(name);
                            }
                        }
                        match = redirectBoundType.isCompatibleWith(classNodeType.getType());
                    }
                } else {
                    match = classNodeType.isCompatibleWith(redirectBoundType.getType());
                }
                ++i;
            }
            return match;
        }
    }
}

