/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Stack;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.util.Util;

public class GenericsMapper {
    private Stack<Map<String, ClassNode>> allGenerics = new Stack();

    public static GenericsMapper gatherGenerics(ClassNode resolvedType, ClassNode declaringType) {
        ClassNode ucandidate = resolvedType.redirect();
        ClassNode rcandidate = resolvedType;
        GenericsMapper mapper = new GenericsMapper();
        LinkedHashSet<ClassNode> uHierarchy = new LinkedHashSet<ClassNode>();
        VariableScope.createTypeHierarchy(ucandidate, uHierarchy, false);
        Iterator uIter = uHierarchy.iterator();
        LinkedHashSet<ClassNode> rHierarchy = new LinkedHashSet<ClassNode>();
        VariableScope.createTypeHierarchy(rcandidate, rHierarchy, true);
        Iterator rIter = rHierarchy.iterator();
        while (uIter.hasNext() && rIter.hasNext()) {
            ucandidate = (ClassNode)uIter.next();
            rcandidate = (ClassNode)rIter.next();
            GenericsType[] ugts = ucandidate.getGenericsTypes();
            ugts = ugts == null ? VariableScope.NO_GENERICS : ugts;
            GenericsType[] rgts = rcandidate.getGenericsTypes();
            rgts = rgts == null ? VariableScope.NO_GENERICS : rgts;
            HashMap<String, ClassNode> resolved = new HashMap<String, ClassNode>(2, 1.0f);
            int i = 0;
            while (i < rgts.length && i < ugts.length) {
                resolved.put(ugts[i].getName(), mapper.resolveParameter(rgts[i], 0));
                ++i;
            }
            mapper.allGenerics.push(resolved);
            if (rcandidate.getName().equals(declaringType.getName())) break;
        }
        return mapper;
    }

    boolean hasGenerics() {
        return !this.allGenerics.isEmpty() && this.allGenerics.peek().size() > 0;
    }

    public ClassNode resolveParameter(GenericsType topGT, int depth) {
        if (depth > 10) {
            Util.log(new Status(2, "org.eclipse.jdt.groovy.core", "GRECLIPSE-1040: prevent infinite recursion when resolving type parameters on generics type: " + topGT));
            return topGT.getType();
        }
        if (this.allGenerics.isEmpty()) {
            return topGT.getType();
        }
        ClassNode origType = this.findParameter(topGT.getName(), topGT.getType());
        if (origType.getGenericsTypes() != null) {
            GenericsType[] genericsTypes;
            origType = VariableScope.clone(origType);
            GenericsType[] genericsTypeArray = genericsTypes = origType.getGenericsTypes();
            int n = genericsTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericsType = genericsTypeArray[n2];
                if (!genericsType.getName().equals(topGT.getName())) {
                    genericsType.setType(this.findParameter(genericsType.getName(), this.resolveParameter(genericsType, depth + 1)));
                    genericsType.setLowerBound(null);
                    genericsType.setUpperBounds(null);
                    genericsType.setName(genericsType.getType().getName());
                }
                ++n2;
            }
        }
        return origType;
    }

    ClassNode findParameter(String parameterName, ClassNode defaultType) {
        if (this.allGenerics.isEmpty()) {
            return defaultType;
        }
        ClassNode type = this.allGenerics.peek().get(parameterName);
        if (type == null) {
            return defaultType;
        }
        return type;
    }
}

