/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jdt.internal.core.util.Util;

public class ContentTypeUtils {
    private static char[][] GROOVY_LIKE_EXTENSIONS;
    private static char[][] JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS;
    public static String GROOVY_SOURCE_CONTENT_TYPE;

    static {
        Platform.getContentTypeManager().addContentTypeChangeListener(new ChangeListener());
        GROOVY_SOURCE_CONTENT_TYPE = "org.eclipse.jdt.groovy.core.groovySource";
    }

    private ContentTypeUtils() {
    }

    public static boolean isGroovyLikeFileName(String name) {
        if (name == null) {
            return false;
        }
        return ContentTypeUtils.indexOfGroovyLikeExtension(name) != -1;
    }

    public static final boolean isGroovyLikeFileName(char[] fileName) {
        if (fileName == null) {
            return false;
        }
        int fileNameLength = fileName.length;
        char[][] javaLikeExtensions = ContentTypeUtils.getGroovyLikeExtensions();
        int i = 0;
        int length = javaLikeExtensions.length;
        while (i < length) {
            block5: {
                char[] extension = javaLikeExtensions[i];
                int extensionLength = extension.length;
                int extensionStart = fileNameLength - extensionLength;
                if (extensionStart - 1 >= 0 && fileName[extensionStart - 1] == '.') {
                    int j = 0;
                    while (j < extensionLength) {
                        if (fileName[extensionStart + j] == extension[j]) {
                            ++j;
                            continue;
                        }
                        break block5;
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static int indexOfGroovyLikeExtension(String fileName) {
        int fileNameLength = fileName.length();
        char[][] groovyLikeExtensions = ContentTypeUtils.getGroovyLikeExtensions();
        int i = 0;
        int length = groovyLikeExtensions.length;
        while (i < length) {
            block4: {
                char[] extension = groovyLikeExtensions[i];
                int extensionLength = extension.length;
                int extensionStart = fileNameLength - extensionLength;
                int dotIndex = extensionStart - 1;
                if (dotIndex >= 0 && fileName.charAt(dotIndex) == '.') {
                    int j = 0;
                    while (j < extensionLength) {
                        if (fileName.charAt(extensionStart + j) == extension[j]) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return dotIndex;
                }
            }
            ++i;
        }
        return -1;
    }

    public static char[][] getGroovyLikeExtensions() {
        if (GROOVY_LIKE_EXTENSIONS == null) {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            if (contentTypeManager == null) {
                GROOVY_LIKE_EXTENSIONS = new char[][]{"groovy".toCharArray()};
                return GROOVY_LIKE_EXTENSIONS;
            }
            IContentType groovyContentType = contentTypeManager.getContentType(GROOVY_SOURCE_CONTENT_TYPE);
            HashSet<String> fileExtensions = new HashSet<String>();
            IContentType[] contentTypes = Platform.getContentTypeManager().getAllContentTypes();
            int i = 0;
            int length = contentTypes.length;
            while (i < length) {
                if (contentTypes[i].isKindOf(groovyContentType)) {
                    String[] fileExtension = contentTypes[i].getFileSpecs(8);
                    int j = 0;
                    int length2 = fileExtension.length;
                    while (j < length2) {
                        fileExtensions.add(fileExtension[j]);
                        ++j;
                    }
                }
                ++i;
            }
            int length2 = fileExtensions.size();
            char[][] extensions = new char[length2][];
            extensions[0] = "groovy".toCharArray();
            int index = 1;
            for (String fileExtension : fileExtensions) {
                if ("groovy".equals(fileExtension)) continue;
                extensions[index++] = fileExtension.toCharArray();
            }
            GROOVY_LIKE_EXTENSIONS = extensions;
        }
        return GROOVY_LIKE_EXTENSIONS;
    }

    public static boolean isJavaLikeButNotGroovyLikeExtension(String fileName) {
        if (JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS == null) {
            ContentTypeUtils.initJavaLikeButNotGroovyLikeExtensions();
        }
        int fileNameLength = fileName.length();
        int i = 0;
        int length = JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS.length;
        while (i < length) {
            block5: {
                char[] extension = JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS[i];
                int extensionLength = extension.length;
                int extensionStart = fileNameLength - extensionLength;
                int dotIndex = extensionStart - 1;
                if (dotIndex >= 0 && fileName.charAt(dotIndex) == '.') {
                    int j = 0;
                    while (j < extensionLength) {
                        if (fileName.charAt(extensionStart + j) == extension[j]) {
                            ++j;
                            continue;
                        }
                        break block5;
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static void initJavaLikeButNotGroovyLikeExtensions() {
        char[][] javaLikeExtensions = Util.getJavaLikeExtensions();
        char[][] groovyLikeExtensiosn = ContentTypeUtils.getGroovyLikeExtensions();
        ArrayList<char[]> interestingExtensions = new ArrayList<char[]>();
        char[][] cArray = javaLikeExtensions;
        int n = javaLikeExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            char[] javaLike = cArray[n2];
            boolean found = false;
            char[][] cArray2 = groovyLikeExtensiosn;
            int n3 = groovyLikeExtensiosn.length;
            int n4 = 0;
            while (n4 < n3) {
                char[] groovyLike = cArray2[n4];
                if (Arrays.equals(javaLike, groovyLike)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                interestingExtensions.add(javaLike);
            }
            ++n2;
        }
        JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS = (char[][])interestingExtensions.toArray((T[])new char[interestingExtensions.size()][]);
        int javaIndex = 0;
        char[] javaArr = "java".toCharArray();
        while (javaIndex < JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS.length) {
            if (Arrays.equals(javaArr, JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS[javaIndex])) break;
            ++javaIndex;
        }
        if (javaIndex < JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS.length) {
            ContentTypeUtils.JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS[javaIndex] = JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS[0];
            ContentTypeUtils.JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS[0] = javaArr;
        } else {
            Util.log(null, "'java' not registered as a java-like extension");
        }
    }

    public static char[][] getJavaButNotGroovyLikeExtensions() {
        if (JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS == null) {
            ContentTypeUtils.initJavaLikeButNotGroovyLikeExtensions();
        }
        return JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS;
    }

    static class ChangeListener
    implements IContentTypeManager.IContentTypeChangeListener {
        ChangeListener() {
        }

        public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent event) {
            GROOVY_LIKE_EXTENSIONS = null;
            JAVA_LIKE_BUT_NOT_GROOVY_LIKE_EXTENSIONS = null;
        }
    }
}

