/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.ITypeLookupExtension;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTypeLookup
implements ITypeLookupExtension {
    private GroovyCompilationUnit unit;

    @Override
    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
        this.unit = unit;
    }

    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        return this.lookupType(node, scope, objectExpressionType, false);
    }

    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType, boolean isStaticObjectExpression) {
        TypeLookupResult.TypeConfidence[] confidence = new TypeLookupResult.TypeConfidence[]{TypeLookupResult.TypeConfidence.EXACT};
        if (ClassHelper.isPrimitiveType(objectExpressionType)) {
            objectExpressionType = ClassHelper.getWrapper(objectExpressionType);
        }
        ClassNode declaringType = objectExpressionType != null ? objectExpressionType : this.findDeclaringType(node, scope, confidence);
        TypeLookupResult result = this.findType(node, declaringType, scope, confidence[0], isStaticObjectExpression || objectExpressionType == null && scope.isStatic(), objectExpressionType == null);
        return result;
    }

    @Override
    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        return new TypeLookupResult(node.getType(), node.getDeclaringClass(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        return new TypeLookupResult(node.getReturnType(), node.getDeclaringClass(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(AnnotationNode node, VariableScope scope) {
        ClassNode baseType = node.getClassNode();
        return new TypeLookupResult(baseType, baseType, baseType, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(ImportNode node, VariableScope scope) {
        ClassNode baseType = node.getType();
        if (baseType != null) {
            return new TypeLookupResult(baseType, baseType, baseType, TypeLookupResult.TypeConfidence.EXACT, scope);
        }
        return new TypeLookupResult(VariableScope.OBJECT_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE, TypeLookupResult.TypeConfidence.INFERRED, scope);
    }

    @Override
    public TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        ClassNode resultType;
        if (node instanceof InnerClassNode && !node.isRedirectNode()) {
            resultType = node.getSuperClass();
            if (resultType.getName().equals(VariableScope.OBJECT_CLASS_NODE.getName()) && node.getInterfaces().length > 0) {
                resultType = node.getInterfaces()[0];
            }
        } else {
            resultType = node;
        }
        return new TypeLookupResult(resultType, resultType, node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        VariableScope.VariableInfo info = scope.lookupNameInCurrentScope(node.getName());
        ClassNode type = info != null ? info.type : node.getType();
        return new TypeLookupResult(type, scope.getEnclosingTypeDeclaration(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public void lookupInBlock(BlockStatement node, VariableScope scope) {
    }

    private ClassNode findDeclaringType(Expression node, VariableScope scope, TypeLookupResult.TypeConfidence[] confidence) {
        if (node instanceof ClassExpression || node instanceof ConstructorCallExpression) {
            return node.getType();
        }
        if (node instanceof FieldExpression) {
            return ((FieldExpression)node).getField().getDeclaringClass();
        }
        if (node instanceof StaticMethodCallExpression) {
            return ((StaticMethodCallExpression)node).getOwnerType();
        }
        if (node instanceof ConstantExpression) {
            if (scope.isMethodCall()) {
                return scope.getDelegateOrThis();
            }
        } else if (node instanceof VariableExpression) {
            Variable var = ((VariableExpression)node).getAccessedVariable();
            if (var instanceof DynamicVariable) {
                ClassNode thiz;
                ASTNode declaration = null;
                ClassNode delegate = scope.getDelegate();
                if (delegate != null) {
                    declaration = this.findDeclaration(var.getName(), delegate, scope.getMethodCallNumberOfArguments());
                }
                if ((thiz = scope.getThis()) == null) {
                    thiz = VariableScope.OBJECT_CLASS_NODE;
                }
                if (!(declaration != null || thiz == null || delegate != null && thiz.equals(delegate))) {
                    declaration = this.findDeclaration(var.getName(), thiz, scope.getMethodCallNumberOfArguments());
                }
                ClassNode type = declaration == null ? thiz : this.declaringTypeFromDeclaration(declaration, var.getType());
                confidence[0] = TypeLookupResult.TypeConfidence.findLessPrecise(confidence[0], TypeLookupResult.TypeConfidence.INFERRED);
                return type;
            }
            if (var instanceof FieldNode) {
                return ((FieldNode)var).getDeclaringClass();
            }
            if (var instanceof PropertyNode) {
                return ((PropertyNode)var).getDeclaringClass();
            }
            if (scope.isThisOrSuper((VariableExpression)node)) {
                return scope.lookupName((String)((VariableExpression)node).getName()).declaringType;
            }
        }
        return VariableScope.OBJECT_CLASS_NODE;
    }

    private TypeLookupResult findType(Expression node, ClassNode declaringType, VariableScope scope, TypeLookupResult.TypeConfidence confidence, boolean isStaticObjectExpression, boolean isPrimaryExpression) {
        if (node instanceof VariableExpression) {
            return this.findTypeForVariable((VariableExpression)node, scope, confidence, declaringType);
        }
        ClassNode nodeType = node.getType();
        if ((!isPrimaryExpression || scope.isMethodCall()) && node instanceof ConstantExpression) {
            return this.findTypeForNameWithKnownObjectExpression(node.getText(), nodeType, declaringType, scope, confidence, isStaticObjectExpression, isPrimaryExpression);
        }
        if (node instanceof ConstantExpression) {
            ConstantExpression constExpr = (ConstantExpression)node;
            if (constExpr.isTrueExpression() || constExpr.isFalseExpression()) {
                return new TypeLookupResult(VariableScope.BOOLEAN_CLASS_NODE, null, null, confidence, scope);
            }
            if (constExpr.isNullExpression()) {
                return new TypeLookupResult(VariableScope.VOID_CLASS_NODE, null, null, confidence, scope);
            }
            if (constExpr.isEmptyStringExpression()) {
                return new TypeLookupResult(VariableScope.STRING_CLASS_NODE, null, null, confidence, scope);
            }
            if (ClassHelper.isNumberType(nodeType) || nodeType == ClassHelper.BigDecimal_TYPE || nodeType == ClassHelper.BigInteger_TYPE) {
                return new TypeLookupResult(nodeType, null, null, confidence, scope);
            }
            if (nodeType.equals(VariableScope.STRING_CLASS_NODE)) {
                return new TypeLookupResult(nodeType, null, node, confidence, scope);
            }
            return new TypeLookupResult(nodeType, null, null, TypeLookupResult.TypeConfidence.UNKNOWN, scope);
        }
        if (node instanceof BooleanExpression || node instanceof NotExpression) {
            return new TypeLookupResult(VariableScope.BOOLEAN_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof GStringExpression) {
            return new TypeLookupResult(VariableScope.STRING_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof BitwiseNegationExpression) {
            ClassNode type = ((BitwiseNegationExpression)node).getExpression().getType();
            if (type.getName().equals(VariableScope.STRING_CLASS_NODE.getName())) {
                return new TypeLookupResult(VariableScope.PATTERN_CLASS_NODE, null, null, confidence, scope);
            }
            return new TypeLookupResult(type, null, null, confidence, scope);
        }
        if (node instanceof ClassExpression) {
            if (this.nodeIsDotClassReference(node)) {
                return new TypeLookupResult(VariableScope.CLASS_CLASS_NODE, VariableScope.CLASS_CLASS_NODE, VariableScope.CLASS_CLASS_NODE, TypeLookupResult.TypeConfidence.EXACT, scope);
            }
            return new TypeLookupResult(nodeType, declaringType, nodeType, confidence, scope);
        }
        if (node instanceof StaticMethodCallExpression) {
            StaticMethodCallExpression expr = (StaticMethodCallExpression)node;
            List<MethodNode> methods = expr.getOwnerType().getMethods(expr.getMethod());
            if (methods.size() > 0) {
                MethodNode method = methods.get(0);
                return new TypeLookupResult(method.getReturnType(), method.getDeclaringClass(), method, confidence, scope);
            }
        } else if (node instanceof ConstructorCallExpression) {
            List<ConstructorNode> declaredConstructors = declaringType.getDeclaredConstructors();
            if (declaredConstructors != null && declaredConstructors.size() > 0) {
                return new TypeLookupResult(nodeType, declaringType, declaredConstructors.get(0), confidence, scope);
            }
            return new TypeLookupResult(nodeType, declaringType, declaringType, confidence, scope);
        }
        if (!(node instanceof TupleExpression) && nodeType.equals(VariableScope.OBJECT_CLASS_NODE)) {
            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
        }
        return new TypeLookupResult(nodeType, declaringType, null, confidence, scope);
    }

    private boolean nodeIsDotClassReference(Expression node) {
        char[] contents;
        int end = node.getEnd();
        int start = node.getStart();
        if (this.unit.exists() && (contents = this.unit.getContents()).length >= end) {
            char[] realText = new char[end - start];
            System.arraycopy(contents, start, realText, 0, end - start);
            String realTextStr = String.valueOf(realText).trim();
            return realTextStr.endsWith(".class") || realTextStr.endsWith(".class.");
        }
        return false;
    }

    private TypeLookupResult findTypeForNameWithKnownObjectExpression(String name, ClassNode type, ClassNode declaringType, VariableScope scope, TypeLookupResult.TypeConfidence confidence, boolean isStaticObjectExpression, boolean isPrimaryExpression) {
        VariableScope.VariableInfo varInfo;
        ClassNode realDeclaringType;
        ClassNode thiz;
        TypeLookupResult.TypeConfidence origConfidence = confidence;
        ASTNode declaration = this.findDeclaration(name, declaringType, scope.getMethodCallNumberOfArguments());
        if (declaration == null && isPrimaryExpression && (thiz = scope.getThis()) != null && !thiz.equals(declaringType)) {
            declaration = this.findDeclaration(name, thiz, scope.getMethodCallNumberOfArguments());
        }
        if (declaration == null && isStaticObjectExpression) {
            declaration = this.findDeclaration(name, VariableScope.CLASS_CLASS_NODE, scope.getMethodCallNumberOfArguments());
        }
        if (declaration != null) {
            type = this.typeFromDeclaration(declaration, declaringType);
            realDeclaringType = this.declaringTypeFromDeclaration(declaration, declaringType);
        } else if (isPrimaryExpression && (varInfo = scope.lookupName(name)) != null) {
            type = varInfo.type;
            realDeclaringType = varInfo.declaringType;
            declaration = this.findDeclaration(name, realDeclaringType, scope.getMethodCallNumberOfArguments());
            if (declaration == null) {
                declaration = varInfo.declaringType;
            }
        } else if (name.equals("call")) {
            realDeclaringType = VariableScope.CLOSURE_CLASS;
            declaration = realDeclaringType.getMethods("call").get(0);
        } else {
            realDeclaringType = declaringType;
            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
        }
        if (declaration != null && !realDeclaringType.equals(VariableScope.CLASS_CLASS_NODE)) {
            if (declaration instanceof FieldNode) {
                if (isStaticObjectExpression && !((FieldNode)declaration).isStatic()) {
                    confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                }
            } else if (declaration instanceof PropertyNode) {
                FieldNode underlyingField = ((PropertyNode)declaration).getField();
                if (underlyingField != null) {
                    if (isStaticObjectExpression && !underlyingField.isStatic()) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    }
                } else if (isStaticObjectExpression && !((PropertyNode)declaration).isStatic()) {
                    confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                }
            } else if (declaration instanceof MethodNode && isStaticObjectExpression && !((MethodNode)declaration).isStatic()) {
                confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
            }
        }
        if (confidence == TypeLookupResult.TypeConfidence.UNKNOWN && realDeclaringType.getName().equals(VariableScope.CLASS_CLASS_NODE.getName())) {
            ClassNode typeParam;
            GenericsType[] classTypeParams = realDeclaringType.getGenericsTypes();
            ClassNode classNode = typeParam = classTypeParams != null && classTypeParams.length == 1 ? classTypeParams[0].getType() : null;
            if (typeParam != null && !typeParam.getName().equals(VariableScope.CLASS_CLASS_NODE.getName()) && !typeParam.getName().equals(VariableScope.OBJECT_CLASS_NODE.getName())) {
                return this.findTypeForNameWithKnownObjectExpression(name, type, typeParam, scope, origConfidence, isStaticObjectExpression, isPrimaryExpression);
            }
        }
        return new TypeLookupResult(type, realDeclaringType, declaration, confidence, scope);
    }

    private TypeLookupResult findTypeForVariable(VariableExpression var, VariableScope scope, TypeLookupResult.TypeConfidence confidence, ClassNode declaringType) {
        ClassNode type;
        ASTNode declaration = var;
        Variable accessedVar = var.getAccessedVariable();
        if (accessedVar instanceof ASTNode) {
            declaration = (ASTNode)((Object)accessedVar);
        }
        VariableScope.VariableInfo info = scope.lookupName(var.getName());
        TypeLookupResult.TypeConfidence origConfidence = confidence;
        if (accessedVar instanceof DynamicVariable) {
            ASTNode maybeDeclaration = this.findDeclaration(accessedVar.getName(), this.getMorePreciseType(declaringType, info), scope.getMethodCallNumberOfArguments());
            if (maybeDeclaration != null) {
                declaration = maybeDeclaration;
                declaringType = this.declaringTypeFromDeclaration(declaration, info != null ? info.declaringType : VariableScope.OBJECT_CLASS_NODE);
            } else {
                confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
            }
        }
        if (info != null) {
            confidence = TypeLookupResult.TypeConfidence.findLessPrecise(origConfidence, TypeLookupResult.TypeConfidence.INFERRED);
            type = info.type;
            declaringType = this.getMorePreciseType(declaringType, info);
            if (scope.isThisOrSuper(var)) {
                declaration = type;
            }
        } else {
            type = accessedVar instanceof DynamicVariable ? this.typeFromDeclaration(declaration, declaringType) : var.getType();
        }
        return new TypeLookupResult(type, declaringType, declaration, confidence, scope);
    }

    private ClassNode getMorePreciseType(ClassNode declaringType, VariableScope.VariableInfo info) {
        ClassNode maybeDeclaringType;
        ClassNode classNode = maybeDeclaringType = info != null ? info.declaringType : VariableScope.OBJECT_CLASS_NODE;
        if (maybeDeclaringType.equals(VariableScope.OBJECT_CLASS_NODE) && !VariableScope.OBJECT_CLASS_NODE.equals(declaringType)) {
            return declaringType;
        }
        return maybeDeclaringType;
    }

    private ClassNode declaringTypeFromDeclaration(ASTNode declaration, ClassNode resolvedTypeOfDeclaration) {
        ClassNode typeOfDeclaration = declaration instanceof FieldNode ? ((FieldNode)declaration).getDeclaringClass() : (declaration instanceof MethodNode ? ((MethodNode)declaration).getDeclaringClass() : (declaration instanceof PropertyNode ? ((PropertyNode)declaration).getDeclaringClass() : VariableScope.OBJECT_CLASS_NODE));
        if (typeOfDeclaration.getName().equals(resolvedTypeOfDeclaration.getName())) {
            return resolvedTypeOfDeclaration;
        }
        return typeOfDeclaration;
    }

    private ClassNode typeFromDeclaration(ASTNode declaration, ClassNode resolvedType) {
        ClassNode typeOfDeclaration;
        FieldNode field;
        ClassNode declaringType = this.declaringTypeFromDeclaration(declaration, resolvedType);
        if (declaration instanceof PropertyNode && (field = ((PropertyNode)declaration).getField()) != null) {
            declaration = field;
        }
        if (declaration instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)declaration;
            typeOfDeclaration = fieldNode.getType();
            if (VariableScope.OBJECT_CLASS_NODE.equals(typeOfDeclaration) && fieldNode.hasInitialExpression()) {
                typeOfDeclaration = fieldNode.getInitialExpression().getType();
            }
        } else {
            typeOfDeclaration = declaration instanceof MethodNode ? ((MethodNode)declaration).getReturnType() : (declaration instanceof Expression ? ((Expression)declaration).getType() : VariableScope.OBJECT_CLASS_NODE);
        }
        GenericsMapper mapper = GenericsMapper.gatherGenerics(resolvedType, declaringType.redirect());
        ClassNode resolvedTypeOfDeclaration = VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(typeOfDeclaration));
        return resolvedTypeOfDeclaration;
    }

    protected GenericsType[] unresolvedGenericsForType(ClassNode unresolvedType) {
        ClassNode candidate = unresolvedType;
        GenericsType[] gts = candidate.getGenericsTypes();
        gts = gts == null ? VariableScope.NO_GENERICS : gts;
        ArrayList<GenericsType> allGs = new ArrayList<GenericsType>(2);
        while (candidate != null) {
            gts = candidate.getGenericsTypes();
            GenericsType[] genericsTypeArray = gts = gts == null ? VariableScope.NO_GENERICS : gts;
            int n = gts.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gt = genericsTypeArray[n2];
                allGs.add(gt);
                ++n2;
            }
            candidate = candidate.getSuperClass();
        }
        return allGs.toArray(VariableScope.NO_GENERICS);
    }

    private ASTNode findDeclaration(String name, ClassNode declaringType, int numOfArgs) {
        if (declaringType.isArray()) {
            if (name.equals("length")) {
                return this.createLengthField(declaringType);
            }
            return this.findDeclaration(name, VariableScope.OBJECT_CLASS_NODE, numOfArgs);
        }
        AnnotatedNode maybe = null;
        if (numOfArgs >= 0 && (maybe = this.findMethodDeclaration(name, declaringType, numOfArgs, true)) != null) {
            return maybe;
        }
        LinkedHashSet<ClassNode> allClasses = new LinkedHashSet<ClassNode>();
        VariableScope.createTypeHierarchy(declaringType, allClasses, true);
        maybe = this.findPropertyInClass(name, allClasses);
        if (maybe != null) {
            return maybe;
        }
        maybe = declaringType.getField(name);
        if (maybe != null) {
            return maybe;
        }
        FieldNode constantFromSuper = this.findConstantInClass(name, allClasses);
        if (constantFromSuper != null) {
            return constantFromSuper;
        }
        if (numOfArgs < 0 && (maybe = this.findMethodDeclaration(name, declaringType, numOfArgs, true)) != null) {
            return maybe;
        }
        return null;
    }

    private AnnotatedNode findMethodDeclaration(String name, ClassNode declaringType, int numOfArgs, boolean checkSuperInterfaces) {
        if (checkSuperInterfaces && declaringType.isInterface()) {
            LinkedHashSet<ClassNode> allInterfaces = new LinkedHashSet<ClassNode>();
            VariableScope.findAllInterfaces(declaringType, allInterfaces, true);
            for (ClassNode interf : allInterfaces) {
                AnnotatedNode candidate = this.findMethodDeclaration(name, interf, numOfArgs, false);
                if (candidate == null) continue;
                return candidate;
            }
            return null;
        }
        List<MethodNode> maybeMethods = declaringType.getMethods(name);
        if (maybeMethods != null && maybeMethods.size() > 0) {
            if (numOfArgs >= 0) {
                for (MethodNode maybeMethod : maybeMethods) {
                    Parameter[] parameters = maybeMethod.getParameters();
                    if ((parameters == null || parameters.length != numOfArgs) && (parameters != null || numOfArgs != 0)) continue;
                    return maybeMethod.getOriginal();
                }
            }
            return maybeMethods.get(0);
        }
        if (numOfArgs < 0) {
            return AccessorSupport.findAccessorMethodForPropertyName(name, declaringType, false);
        }
        return null;
    }

    private ASTNode createLengthField(ClassNode declaringType) {
        FieldNode lengthField = new FieldNode("length", 1, VariableScope.INTEGER_CLASS_NODE, declaringType, null);
        lengthField.setType(VariableScope.INTEGER_CLASS_NODE);
        lengthField.setDeclaringClass(declaringType);
        return lengthField;
    }

    private PropertyNode findPropertyInClass(String name, Set<ClassNode> allClasses) {
        for (ClassNode clazz : allClasses) {
            PropertyNode prop = clazz.getProperty(name);
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    private FieldNode findConstantInClass(String name, Set<ClassNode> allClasses) {
        for (ClassNode clazz : allClasses) {
            FieldNode field = clazz.getField(name);
            if (field == null || !Flags.isFinal(field.getModifiers()) || !field.isStatic()) continue;
            return field;
        }
        return null;
    }
}

