/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.util.Util;

public class ModuleNodeMapper {
    private static final ModuleNodeMapper INSTANCE = new ModuleNodeMapper();
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Map<JavaModelManager.PerWorkingCopyInfo, ModuleNodeInfo> infoToModuleMap = new HashMap<JavaModelManager.PerWorkingCopyInfo, ModuleNodeInfo>();
    private static final boolean DSL_BUNDLE_INSTALLED;

    static {
        boolean result = false;
        try {
            result = Platform.getBundle("org.codehaus.groovy.eclipse.dsl") != null;
        }
        catch (Exception e) {
            Util.log(e);
        }
        DSL_BUNDLE_INSTALLED = result;
    }

    static ModuleNodeMapper getInstance() {
        return INSTANCE;
    }

    void store(JavaModelManager.PerWorkingCopyInfo info, ModuleNode module, JDTResolver resolver) {
        this.lock.lock();
        try {
            this.sweepAndPurgeModuleNodes();
            this.infoToModuleMap.put(info, new ModuleNodeInfo(module, ModuleNodeMapper.shouldStoreResovler() ? resolver : null));
        }
        finally {
            this.lock.unlock();
        }
    }

    public static boolean shouldStoreResovler() {
        return DSL_BUNDLE_INSTALLED;
    }

    ModuleNode getModule(JavaModelManager.PerWorkingCopyInfo info) {
        this.lock.lock();
        try {
            ModuleNodeInfo moduleNodeInfo = this.get(info);
            ModuleNode moduleNode = moduleNodeInfo != null ? moduleNodeInfo.module : null;
            return moduleNode;
        }
        finally {
            this.lock.unlock();
        }
    }

    ModuleNodeInfo get(JavaModelManager.PerWorkingCopyInfo info) {
        this.lock.lock();
        try {
            this.sweepAndPurgeModuleNodes();
            ModuleNodeInfo moduleNodeInfo = this.infoToModuleMap.get(info);
            return moduleNodeInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    JDTResolver getResolver(JavaModelManager.PerWorkingCopyInfo info) {
        this.lock.lock();
        try {
            ModuleNodeInfo moduleNodeInfo = this.get(info);
            JDTResolver jDTResolver = moduleNodeInfo != null ? moduleNodeInfo.resolver : null;
            return jDTResolver;
        }
        finally {
            this.lock.unlock();
        }
    }

    ModuleNode remove(JavaModelManager.PerWorkingCopyInfo info) {
        this.lock.lock();
        try {
            this.sweepAndPurgeModuleNodes();
            ModuleNodeInfo removed = this.infoToModuleMap.remove(info);
            ModuleNode moduleNode = removed != null ? removed.module : null;
            return moduleNode;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void maybeCacheModuleNode(final JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo, final GroovyCompilationUnitDeclaration compilationUnitDeclaration) {
        if (this.lock.tryLock()) {
            try {
                ModuleNode module;
                if (perWorkingCopyInfo == null || compilationUnitDeclaration == null || (module = compilationUnitDeclaration.getModuleNode()) == null) return;
                JDTResolver resolver = ModuleNodeMapper.shouldStoreResovler() ? (JDTResolver)compilationUnitDeclaration.getCompilationUnit().getResolveVisitor() : null;
                this.store(perWorkingCopyInfo, module, resolver);
                return;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            new Job("Cache module node"){

                protected IStatus run(IProgressMonitor monitor) {
                    ModuleNodeMapper.this.maybeCacheModuleNode(perWorkingCopyInfo, compilationUnitDeclaration);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public static boolean isEmpty() {
        return ModuleNodeMapper.INSTANCE.infoToModuleMap.isEmpty();
    }

    public static int size() {
        return ModuleNodeMapper.INSTANCE.infoToModuleMap.size();
    }

    void sweepAndPurgeModuleNodes() {
        this.lock.lock();
        try {
            if (System.getProperty("groovy.eclipse.model.purge") == null) {
                return;
            }
            ArrayList<JavaModelManager.PerWorkingCopyInfo> toPurge = new ArrayList<JavaModelManager.PerWorkingCopyInfo>();
            for (JavaModelManager.PerWorkingCopyInfo info : this.infoToModuleMap.keySet()) {
                int useCount = (Integer)ReflectionUtils.getPrivateField(JavaModelManager.PerWorkingCopyInfo.class, "useCount", info);
                if (useCount <= 0) {
                    String message = "Bad module node map entry: " + info.getWorkingCopy().getElementName();
                    System.out.println(message);
                    Util.log(new RuntimeException(message), message);
                    toPurge.add(info);
                    continue;
                }
                if (useCount <= 1) continue;
                System.out.println(String.valueOf(info.getWorkingCopy().getElementName()) + " : useCount : " + useCount);
            }
            if (toPurge.size() > 0) {
                for (JavaModelManager.PerWorkingCopyInfo info : toPurge) {
                    this.infoToModuleMap.remove(info);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public static class ModuleNodeInfo {
        public final ModuleNode module;
        public final JDTResolver resolver;

        public ModuleNodeInfo(ModuleNode module, JDTResolver resolver) {
            this.module = module;
            this.resolver = resolver;
        }
    }
}

